/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.item.enchant;

import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LeveledEnchant;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public record LootEnchantments(Map<LootEnchantList, Integer> possibleEnchants) {
    public void applyEnchantments(ItemStack item, AuraSkills plugin, LootTable table) {
        LootEnchantList list = this.selectEnchantList();
        if (list == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List<LeveledEnchant> enchants = list.rollEnchants(plugin, table);
        for (LeveledEnchant enchant : enchants) {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                esm.addStoredEnchant(enchant.enchant(), enchant.level(), true);
                continue;
            }
            meta.addEnchant(enchant.enchant(), enchant.level(), true);
        }
        item.setItemMeta(meta);
    }

    @Nullable
    private LootEnchantList selectEnchantList() {
        if (this.possibleEnchants.isEmpty()) {
            return null;
        }
        int totalWeight = this.possibleEnchants.values().stream().reduce(Integer::sum).orElse(0);
        if (totalWeight == 0) {
            return null;
        }
        Random random = new Random();
        int selected = random.nextInt(totalWeight);
        int currentWeight = 0;
        LootEnchantList selectedList = null;
        for (LootEnchantList list : this.possibleEnchants.keySet()) {
            int listWeight = this.possibleEnchants.getOrDefault(list, 0);
            if (selected >= currentWeight && selected < currentWeight + listWeight) {
                selectedList = list;
                break;
            }
            currentWeight += listWeight;
        }
        return selectedList;
    }
}

