/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.item.enchant;

import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LeveledEnchant;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;

public record LootEnchantList(List<LootEnchantEntry> entries) {
    public List<LeveledEnchant> rollEnchants(AuraSkills plugin, LootTable table) {
        ArrayList<LeveledEnchant> rolled = new ArrayList<LeveledEnchant>();
        for (LootEnchantEntry entry : this.entries) {
            Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)entry.enchantName().toLowerCase(Locale.ROOT)));
            if (enchantment != null) {
                int rolledLevel = ThreadLocalRandom.current().nextInt(entry.minLevel(), entry.maxLevel() + 1);
                rolled.add(new LeveledEnchant(enchantment, rolledLevel));
                continue;
            }
            plugin.logger().warn("Error while rolling enchant in loot table " + table.getId() + ": Could not find enchantment in Minecraft registry with key " + entry.enchantName());
        }
        return rolled;
    }
}

