/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.handler;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardFlags;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.loot.context.MobContext;
import dev.aurelium.auraskills.bukkit.loot.context.SourceContext;
import dev.aurelium.auraskills.bukkit.loot.type.CommandLoot;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.commands.CommandExecutor;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootHandler {
    protected final AuraSkills plugin;
    private final TextFormatter tf = new TextFormatter();

    public LootHandler(AuraSkills plugin) {
        this.plugin = plugin;
    }

    protected void giveCommandLoot(Player player, CommandLoot loot, @Nullable XpSource source, Skill skill) {
        CommandExecutor executor;
        String finalCommand = TextUtil.replace(loot.getCommand(), "{player}", player.getName());
        User user = this.plugin.getUser(player);
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
            finalCommand = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, finalCommand);
        }
        if ((executor = loot.getExecutor()) == CommandExecutor.CONSOLE) {
            Bukkit.dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)finalCommand);
        } else if (executor == CommandExecutor.PLAYER) {
            Bukkit.dispatchCommand((CommandSender)player, (String)finalCommand);
        }
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source, skill);
    }

    protected void giveBlockItemLoot(Player player, ItemLoot loot, BlockBreakEvent breakEvent, Skill skill, LootDropEvent.Cause cause, LootTable table) {
        Block block = breakEvent.getBlock();
        ItemStack drop = loot.getItem().supplyItem(this.plugin, table);
        drop.setAmount(this.generateAmount(loot.getMinAmount(), loot.getMaxAmount()));
        Location location = block.getLocation().add(0.5, 0.5, 0.5);
        this.giveDropItemLoot(player, location, cause, drop);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, null, skill);
    }

    protected void giveMobItemLoot(Player player, ItemLoot loot, Location location, Skill skill, LootDropEvent.Cause cause, LootTable table) {
        ItemStack drop = loot.getItem().supplyItem(this.plugin, table);
        drop.setAmount(this.generateAmount(loot.getMinAmount(), loot.getMaxAmount()));
        this.giveDropItemLoot(player, location, cause, drop);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, null, skill);
    }

    private void giveDropItemLoot(Player player, Location location, LootDropEvent.Cause cause, ItemStack drop) {
        boolean toInventory = this.plugin.getLootTableManager().toInventory(player.getInventory().getItemInMainHand());
        LootDropEvent dropEvent = new LootDropEvent(player, this.plugin.getUser(player).toApi(), drop, location, cause, toInventory);
        Bukkit.getPluginManager().callEvent((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            return;
        }
        ItemUtils.giveBlockLoot(player, dropEvent);
    }

    protected void giveFishingItemLoot(Player player, ItemLoot loot, PlayerFishEvent event, @Nullable XpSource source, Skill skill, LootDropEvent.Cause cause, LootTable table) {
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)entity;
        int amount = this.generateAmount(loot.getMinAmount(), loot.getMaxAmount());
        if (amount == 0) {
            return;
        }
        ItemStack drop = loot.getItem().supplyItem(this.plugin, table);
        drop.setAmount(amount);
        LootDropEvent dropEvent = new LootDropEvent(player, this.plugin.getUser(player).toApi(), drop, event.getHook().getLocation(), cause, false);
        Bukkit.getPluginManager().callEvent((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            return;
        }
        itemEntity.setItemStack(dropEvent.getItem());
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source, skill);
    }

    @Nullable
    protected Loot selectLoot(LootPool pool, @NotNull LootContext providedContext) {
        return pool.rollLoot(loot -> {
            if (providedContext instanceof SourceContext) {
                SourceContext sourceContext = (SourceContext)providedContext;
                Set<LootContext> lootContexts = loot.getValues().getContexts().get("sources");
                if (lootContexts != null && sourceContext.source() != null) {
                    boolean matched = false;
                    for (LootContext context : lootContexts) {
                        SourceContext sourceLootContext;
                        if (!(context instanceof SourceContext) || !(sourceLootContext = (SourceContext)context).source().equals(sourceContext.source())) continue;
                        matched = true;
                        break;
                    }
                    return matched;
                }
            } else if (providedContext instanceof MobContext) {
                MobContext mobContext = (MobContext)providedContext;
                Set<LootContext> lootContexts = loot.getValues().getContexts().get("mobs");
                if (lootContexts != null && mobContext.entityType() != null) {
                    boolean matched = false;
                    for (LootContext context : lootContexts) {
                        MobContext mobLootContext;
                        if (!(context instanceof MobContext) || !(mobLootContext = (MobContext)context).entityType().equals((Object)mobContext.entityType())) continue;
                        matched = true;
                    }
                    return matched;
                }
            }
            return true;
        }).orElse(null);
    }

    private void giveXp(Player player, Loot loot, @Nullable XpSource source, Skill skill) {
        User user = this.plugin.getUser(player);
        Object xpObj = loot.getValues().getOptions().get("xp");
        double xp = xpObj instanceof Integer ? (double)((Integer)xpObj).intValue() : (xpObj instanceof Double ? (Double)xpObj : -1.0);
        if (xp == -1.0 && source != null) {
            this.plugin.getLevelManager().addXp(user, skill, source, source.getXp());
        } else if (xp > 0.0) {
            this.plugin.getLevelManager().addXp(user, skill, source, xp);
        }
    }

    private int generateAmount(int minAmount, int maxAmount) {
        return new Random().nextInt(maxAmount - minAmount + 1) + minAmount;
    }

    private void attemptSendMessage(Player player, Loot loot) {
        String message = loot.getValues().getMessage();
        if (message == null || message.isEmpty()) {
            return;
        }
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        MessageKey messageKey = MessageKey.of(message);
        String finalMessage = this.plugin.getMsg(messageKey, locale);
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
            finalMessage = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, finalMessage);
        }
        user.sendMessage(this.tf.toComponent(finalMessage));
    }

    public double getCommonChance(LootPool pool, User user) {
        double chancePerLuck = pool.getOption("chance_per_luck", Double.class, 0.0) / 100.0;
        return pool.getBaseChance() + chancePerLuck * user.getStatLevel(Stats.LUCK);
    }

    public double getAbilityModifiedChance(double chance, Ability ability, User user) {
        chance = ability.optionBoolean("scale_base_chance", false) ? (chance *= 1.0 + ability.getValue(user.getAbilityLevel(ability)) / 100.0) : (chance += ability.getValue(user.getAbilityLevel(ability)) / 100.0);
        return chance;
    }

    protected boolean failsChecks(Player player, Location location) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(location)) {
            return true;
        }
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class)) {
            return this.plugin.getHookManager().getHook(WorldGuardHook.class).isBlocked(location, player, WorldGuardFlags.FlagKey.CUSTOM_LOOT);
        }
        return false;
    }

    protected boolean isPoolUnobtainable(LootPool pool, XpSource source) {
        for (Loot loot : pool.getLoot()) {
            Set contexts = loot.getValues().getContexts().getOrDefault("sources", new HashSet());
            if (contexts.isEmpty()) {
                return false;
            }
            for (LootContext context : contexts) {
                SourceContext sourceContext;
                if (!(context instanceof SourceContext) || !(sourceContext = (SourceContext)context).source().equals(source)) continue;
                return false;
            }
        }
        return true;
    }
}

