/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.context;

import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.context.ContextProvider;
import dev.aurelium.auraskills.bukkit.loot.context.SourceContext;
import dev.aurelium.auraskills.common.source.SourceTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class SourceContextProvider
extends ContextProvider {
    private final AuraSkills plugin;

    public SourceContextProvider(AuraSkills plugin) {
        super("sources");
        this.plugin = plugin;
    }

    @Override
    @Nullable
    public Set<LootContext> parseContext(ConfigurationNode config) throws SerializationException {
        HashSet<LootContext> contexts = new HashSet<LootContext>();
        if (config.node("sources").virtual()) {
            return contexts;
        }
        List<String> sourcesList = config.node("sources").getList(String.class, new ArrayList());
        for (String name : sourcesList) {
            NamespacedId sourceId = NamespacedId.fromDefault(name);
            XpSource source = this.plugin.getSkillManager().getSourceById(sourceId);
            if (source != null) {
                contexts.add(new SourceContext(source));
                continue;
            }
            try {
                SourceTag tag = SourceTag.valueOf(name.toUpperCase(Locale.ROOT));
                List<XpSource> sourceList = this.plugin.getSkillManager().getSourcesWithTag(tag);
                for (XpSource tagSource : sourceList) {
                    contexts.add(new SourceContext(tagSource));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return contexts;
    }
}

