/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot;

import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.ItemKeyParser;
import dev.aurelium.auraskills.bukkit.loot.LootManager;
import dev.aurelium.auraskills.bukkit.loot.context.MobContextProvider;
import dev.aurelium.auraskills.bukkit.loot.context.SourceContextProvider;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.api.ApiAuraSkills;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class LootTableManager {
    private final AuraSkills plugin;
    private final LootManager lootManager;
    private final Map<NamespacedId, LootTable> lootTables;

    public LootTableManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.lootManager = new LootManager(plugin);
        this.lootTables = new HashMap<NamespacedId, LootTable>();
        this.initLootManager();
    }

    public void initLootManager() {
        this.lootManager.registerContextProvider(new SourceContextProvider(this.plugin));
        this.lootManager.registerContextProvider(new MobContextProvider());
        this.lootManager.registerCustomItemParser(new ItemKeyParser(this.plugin));
        this.lootManager.addLootOptionKeys("xp");
        this.lootManager.addPoolOptionKeys("chance_per_luck", "require_open_water");
    }

    public LootManager getLootManager() {
        return this.lootManager;
    }

    @Nullable
    public LootTable getLootTable(Skill skill) {
        return this.lootTables.get(skill.getId());
    }

    @Nullable
    public LootTable getLootTable(NamespacedId id) {
        return this.lootTables.get(id);
    }

    public void generateDefaultLootTables() {
        File excavationFile;
        File fishingFile = new File(this.plugin.getDataFolder() + "/loot", "fishing.yml");
        if (!fishingFile.exists()) {
            this.plugin.saveResource("loot/fishing.yml", false);
        }
        if (!(excavationFile = new File(this.plugin.getDataFolder() + "/loot", "excavation.yml")).exists()) {
            this.plugin.saveResource("loot/excavation.yml", false);
        }
    }

    public void loadLootTables() {
        boolean convertFishing = !new File(this.plugin.getDataFolder() + "/loot", "fishing.yml").exists();
        boolean convertExcavation = !new File(this.plugin.getDataFolder() + "/loot", "excavation.yml").exists();
        File lootDirectory = new File(this.plugin.getDataFolder() + "/loot");
        if (!lootDirectory.exists() || convertFishing || convertExcavation) {
            this.generateDefaultLootTables();
        }
        if (!lootDirectory.isDirectory()) {
            return;
        }
        this.lootTables.clear();
        File[] files = lootDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File lootTableFile : files) {
            if (!lootTableFile.isFile() || !lootTableFile.getName().endsWith(".yml")) continue;
            ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
            try {
                ConfigurationNode user;
                ConfigurationNode config = user = loader.loadUserFile(lootTableFile);
                String path = this.plugin.getPluginFolder().toPath().relativize(lootTableFile.toPath()).toString();
                ConfigurationNode embedded = null;
                if (this.plugin.getResource(path) != null) {
                    embedded = loader.loadEmbeddedFile(path);
                    if (this.plugin.configBoolean(Option.LOOT_UPDATE_LOOT_TABLES)) {
                        config = loader.mergeNodes(embedded, user);
                    }
                }
                String fileName = lootTableFile.getName().replace(".yml", "");
                NamespacedId id = NamespacedId.fromDefault(fileName);
                LootTable lootTable = this.lootManager.getLootLoader().loadLootTable(id, lootTableFile, config);
                if (lootTable == null) continue;
                this.lootTables.put(id, lootTable);
                if (embedded == null) continue;
                loader.saveConfigIfUpdated(lootTableFile, embedded, user, config);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadCustomLootTables();
        int tablesLoaded = 0;
        int poolsLoaded = 0;
        int lootLoaded = 0;
        for (LootTable table : this.lootTables.values()) {
            for (LootPool pool : table.getPools()) {
                ++poolsLoaded;
                lootLoaded += pool.getLoot().size();
            }
            ++tablesLoaded;
        }
        this.plugin.getLogger().info("Loaded " + lootLoaded + " loot entries in " + poolsLoaded + " pools and " + tablesLoaded + " tables");
    }

    private void loadCustomLootTables() {
        ApiAuraSkills api = (ApiAuraSkills)this.plugin.getApi();
        for (NamespacedRegistry registry : api.getNamespacedRegistryMap().values()) {
            registry.getLootDirectory().ifPresent(dir -> this.loadExternalLootDir((File)dir, registry));
        }
    }

    private void loadExternalLootDir(File dir, NamespacedRegistry registry) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File lootTableFile : files) {
            if (!lootTableFile.isFile() || !lootTableFile.getName().endsWith(".yml")) continue;
            ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
            try {
                ConfigurationNode config = loader.loadUserFile(lootTableFile);
                String fileName = lootTableFile.getName().replace(".yml", "");
                NamespacedId id = NamespacedId.of(registry.getNamespace(), fileName);
                LootTable lootTable = this.lootManager.getLootLoader().loadLootTable(id, lootTableFile, config);
                if (lootTable == null) continue;
                this.lootTables.put(id, lootTable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void matchConfig(FileConfiguration config, File file) {
        config.options().copyDefaults(true);
        try {
            YamlConfiguration defConfig;
            ConfigurationSection configurationSection;
            boolean changesMade = false;
            InputStream is = this.plugin.getResource("loot/" + file.getName());
            if (is != null && (configurationSection = (defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is))).getConfigurationSection("")) != null) {
                for (String key : configurationSection.getKeys(true)) {
                    if (config.contains(key)) continue;
                    config.set(key, defConfig.get(key));
                    if (changesMade) continue;
                    changesMade = true;
                }
                if (changesMade) {
                    config.save(file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean toInventory(ItemStack held) {
        if (ItemUtils.hasTelekinesis(held)) {
            return true;
        }
        return this.plugin.configBoolean(Option.LOOT_DIRECTLY_TO_INVENTORY);
    }
}

