/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot;

import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.LootLoader;
import dev.aurelium.auraskills.bukkit.loot.context.ContextProvider;
import dev.aurelium.auraskills.bukkit.loot.parser.CustomItemParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class LootManager {
    private final AuraSkills plugin;
    private final LootLoader lootLoader;
    private final Map<String, ContextProvider> contextProviders;
    private final Set<String> lootOptionKeys;
    private final Set<String> poolOptionKeys;
    private final List<CustomItemParser> customItemParsers;
    private final Map<String, LootParser> customLootParsers;

    public LootManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.lootLoader = new LootLoader(this);
        this.contextProviders = new HashMap<String, ContextProvider>();
        this.lootOptionKeys = new HashSet<String>();
        this.poolOptionKeys = new HashSet<String>();
        this.customItemParsers = new ArrayList<CustomItemParser>();
        this.customLootParsers = new HashMap<String, LootParser>();
    }

    public AuraSkills getPlugin() {
        return this.plugin;
    }

    public LootLoader getLootLoader() {
        return this.lootLoader;
    }

    public Set<String> getContextKeySet() {
        return this.contextProviders.keySet();
    }

    @Nullable
    public ContextProvider getContextProvider(String contextKey) {
        return this.contextProviders.get(contextKey);
    }

    public void registerContextProvider(ContextProvider contextProvider) {
        this.contextProviders.put(contextProvider.getContextKey(), contextProvider);
    }

    public Set<String> getLootOptionKeys() {
        return this.lootOptionKeys;
    }

    public void addLootOptionKey(String key) {
        this.lootOptionKeys.add(key);
    }

    public void addLootOptionKeys(String ... keys) {
        this.lootOptionKeys.addAll(Arrays.asList(keys));
    }

    public Set<String> getPoolOptionKeys() {
        return this.poolOptionKeys;
    }

    public void addPoolOptionKey(String key) {
        this.poolOptionKeys.add(key);
    }

    public void addPoolOptionKeys(String ... keys) {
        this.poolOptionKeys.addAll(Arrays.asList(keys));
    }

    public List<CustomItemParser> getCustomItemParsers() {
        return this.customItemParsers;
    }

    public void registerCustomItemParser(CustomItemParser customItemParser) {
        this.customItemParsers.add(customItemParser);
    }

    public Map<String, LootParser> getCustomLootParsers() {
        return this.customLootParsers;
    }

    public void registerCustomLootParser(String name, LootParser parser) {
        this.customLootParsers.put(name, parser);
    }
}

