/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot;

import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.loot.LootTableType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.bukkit.loot.LootManager;
import dev.aurelium.auraskills.bukkit.loot.parser.CommandLootParser;
import dev.aurelium.auraskills.bukkit.loot.parser.ItemLootParser;
import dev.aurelium.auraskills.bukkit.loot.parser.LootParsingContextImpl;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.util.data.Parser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import org.spongepowered.configurate.ConfigurationNode;

public class LootLoader
extends Parser {
    private final LootManager manager;

    public LootLoader(LootManager manager) {
        this.manager = manager;
    }

    public LootTable loadLootTable(NamespacedId id, File file, ConfigurationNode config) {
        ConfigurationNode poolsNode;
        String typeString = config.node("type").getString();
        LootTableType type = LootTableType.BLOCK;
        if (typeString != null) {
            type = LootTableType.valueOf(typeString.toUpperCase(Locale.ROOT));
        }
        if ((poolsNode = config.node("pools")).virtual()) {
            return null;
        }
        ArrayList<LootPool> pools = new ArrayList<LootPool>();
        for (ConfigurationNode configurationNode : poolsNode.childrenMap().values()) {
            String poolName = (String)configurationNode.key();
            double baseChance = configurationNode.node("base_chance").getDouble(0.0) / 100.0;
            int selectionPriority = configurationNode.node("selection_priority").getInt(1);
            boolean overrideVanillaLoot = configurationNode.node("override_vanilla_loot").getBoolean(false);
            HashMap<String, Object> options = new HashMap<String, Object>();
            for (String optionKey : this.manager.getPoolOptionKeys()) {
                if (!configurationNode.hasChild(optionKey)) continue;
                Object option = configurationNode.node(optionKey).raw();
                options.put(optionKey, option);
            }
            ArrayList<Loot> lootList = new ArrayList<Loot>();
            int index = 0;
            for (ConfigurationNode configurationNode2 : configurationNode.node("loot").childrenList()) {
                Loot loot = null;
                try {
                    String lootType = configurationNode2.node("type").getString("");
                    LootParsingContextImpl context = new LootParsingContextImpl(this.manager);
                    if (lootType.equalsIgnoreCase("item")) {
                        int ignoreBelow = configurationNode2.node("ignore_below").getInt(-1);
                        if (ignoreBelow != -1 && !VersionUtils.isAtLeastVersion(ignoreBelow)) {
                            ++index;
                            continue;
                        }
                        loot = new ItemLootParser(this.manager).parse(context, configurationNode2);
                    } else if (lootType.equalsIgnoreCase("command")) {
                        loot = new CommandLootParser().parse(context, configurationNode2);
                    } else {
                        LootParser customParser = this.manager.getCustomLootParsers().get(lootType);
                        if (customParser == null) {
                            throw new IllegalArgumentException("Unknown loot type: " + lootType);
                        }
                        loot = customParser.parse(context, configurationNode2);
                    }
                }
                catch (Exception e) {
                    this.manager.getPlugin().getLogger().warning("Error parsing loot in file loot/" + file.getName() + " at path pools." + poolName + ".loot." + index + ", see below for error:");
                    e.printStackTrace();
                }
                if (loot != null) {
                    lootList.add(loot);
                }
                ++index;
            }
            LootPool pool = new LootPool(poolName, lootList, baseChance, selectionPriority, overrideVanillaLoot, options);
            pools.add(pool);
        }
        pools.sort((pool1, pool2) -> pool2.getSelectionPriority() - pool1.getSelectionPriority());
        return new LootTable(id, UUID.randomUUID(), type, pools);
    }
}

