/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.message.type.MenuMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.slate.inv.ClickableItem;
import dev.aurelium.auraskills.slate.inv.SmartInventory;
import dev.aurelium.auraskills.slate.inv.content.InventoryContents;
import dev.aurelium.auraskills.slate.inv.content.InventoryProvider;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnclaimedItemsMenu
implements InventoryProvider {
    private final AuraSkills plugin;
    private final User user;

    public UnclaimedItemsMenu(AuraSkills plugin, User user) {
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        for (int slot = 0; slot < 54; ++slot) {
            int row = slot / 9;
            int column = slot % 9;
            if (this.user.getUnclaimedItems().size() <= slot) {
                contents.set(row, column, ClickableItem.empty(new ItemStack(Material.AIR)));
                continue;
            }
            KeyIntPair keyIntPair = this.user.getUnclaimedItems().get(slot);
            String itemKey = keyIntPair.getKey();
            int amount = keyIntPair.getValue();
            ItemStack item = this.plugin.getItemRegistry().getItem(NamespacedId.fromDefault(itemKey));
            if (item == null) {
                this.plugin.getLogger().warning("Could not find a registered item with key " + itemKey + " when claiming unclaimed item rewards");
                continue;
            }
            item.setAmount(amount);
            contents.set(row, column, ClickableItem.from(this.getDisplayItem(item), data -> {
                ItemStack leftoverItem = ItemUtils.addItemToInventory(player, item);
                if (leftoverItem == null) {
                    this.user.getUnclaimedItems().remove(keyIntPair);
                    if (!this.user.getUnclaimedItems().isEmpty()) {
                        this.init(player, contents);
                    } else {
                        player.closeInventory();
                    }
                } else if (leftoverItem.getAmount() != item.getAmount()) {
                    keyIntPair.setValue(leftoverItem.getAmount());
                    this.init(player, contents);
                } else {
                    player.sendMessage(ChatColor.YELLOW + this.plugin.getMsg(MenuMessage.INVENTORY_FULL, this.user.getLocale()));
                    player.closeInventory();
                }
            }));
        }
    }

    public static SmartInventory getInventory(AuraSkills plugin, User user) {
        return SmartInventory.builder().manager(plugin.getInventoryManager()).provider(new UnclaimedItemsMenu(plugin, user)).size(6, 9).title(plugin.getMsg(MenuMessage.UNCLAIMED_ITEMS_TITLE, user.getLocale())).build();
    }

    private ItemStack getDisplayItem(ItemStack baseItem) {
        ItemStack displayItem = baseItem.clone();
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            } else {
                lore.add(" ");
            }
            lore.add(ChatColor.YELLOW + this.plugin.getMsg(MenuMessage.CLICK_TO_CLAIM, this.user.getLocale()));
            meta.setLore(lore);
        }
        displayItem.setItemMeta(meta);
        return displayItem;
    }
}

