/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.item.ItemFilter;
import dev.aurelium.auraskills.api.item.ItemManager;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ApiItemManager
implements ItemManager {
    private final AuraSkills plugin;
    private final ConfigurateItemParser itemParser;

    public ApiItemManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.itemParser = new ConfigurateItemParser(plugin);
    }

    @Override
    public ItemStack addModifier(ItemStack item, ModifierType type, Stat stat, double value, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addModifier(SkillsItem.MetaType.MODIFIER, type, stat, value);
        if (lore) {
            skillsItem.addModifierLore(type, stat, value, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public List<StatModifier> getModifiers(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getStatModifiers(type);
    }

    @Override
    public ItemStack removeModifier(ItemStack item, ModifierType type, Stat stat) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeModifier(SkillsItem.MetaType.MODIFIER, type, stat);
        return skillsItem.getItem();
    }

    @Override
    public ItemStack addMultiplier(ItemStack item, ModifierType type, Skill skill, double value, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addMultiplier(type, skill, value);
        if (lore) {
            skillsItem.addMultiplierLore(type, skill, value, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public List<Multiplier> getMultipliers(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getMultipliers(type);
    }

    @Override
    public ItemStack removeMultiplier(ItemStack item, ModifierType type, Skill skill) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeMultiplier(type, skill);
        return skillsItem.getItem();
    }

    @Override
    public ItemStack addRequirement(ItemStack item, ModifierType type, Skill skill, int level, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addRequirement(type, skill, level);
        if (lore) {
            skillsItem.addRequirementLore(type, skill, level, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public Map<Skill, Integer> getRequirements(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getRequirements(type);
    }

    @Override
    public ItemStack removeRequirement(ItemStack item, ModifierType type, Skill skill) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeRequirement(type, skill);
        return skillsItem.getItem();
    }

    @Override
    public boolean passesFilter(ItemStack item, ItemFilter filter) {
        return this.plugin.getItemRegistry().passesFilter(item, filter);
    }

    @Override
    public ItemStack parseItem(ConfigurationNode config) {
        return this.itemParser.parseItem(config);
    }

    @Override
    public List<ItemStack> parseMultipleItems(ConfigurationNode config) {
        try {
            return this.itemParser.parseMultipleItems(config);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }
}

