/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.ui.ActionBarManager;
import dev.aurelium.auraskills.common.user.User;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.spongepowered.configurate.ConfigurationNode;

public class ProtocolLibHook
extends Hook {
    private static final int PAUSE_MILLIS = 2500;
    private final AuraSkills skillsPlugin;
    private final ProtocolManager protocolManager;

    public ProtocolLibHook(AuraSkills plugin, ConfigurationNode config) {
        super(plugin, config);
        this.skillsPlugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.registerListeners();
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return ProtocolLibHook.class;
    }

    public void sendActionBar(Player player, String message) {
        if (VersionUtils.isAtLeastVersion(17)) {
            this.sendActionBarTextPacket(player, message);
        } else {
            this.sendTitlePacket(player, message);
        }
    }

    private void sendActionBarTextPacket(Player player, String message) {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.SET_ACTION_BAR_TEXT);
        packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        packet.setMeta("AuraSkills", (Object)true);
        this.protocolManager.sendServerPacket(player, packet);
    }

    private void sendTitlePacket(Player player, String message) {
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.TITLE);
        packet.getEnumModifier(EnumWrappers.TitleAction.class, 0).write(0, (Object)EnumWrappers.TitleAction.ACTIONBAR);
        packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        packet.setMeta("AuraSkills", (Object)true);
        this.protocolManager.sendServerPacket(player, packet);
    }

    public void registerListeners() {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        if (VersionUtils.isAtLeastVersion(17)) {
            this.registerNewListener(manager);
        } else {
            this.registerLegacyListener(manager);
        }
        if (VersionUtils.isAtLeastVersion(19)) {
            this.registerSystemChatListener(manager);
        }
        this.registerChatListener(manager);
    }

    private User getUser(Player player) {
        return this.skillsPlugin.getUser(player);
    }

    private ActionBarManager getActionBar() {
        return this.skillsPlugin.getUiProvider().getActionBarManager();
    }

    private void registerNewListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.skillsPlugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.SET_ACTION_BAR_TEXT}){

            public void onPacketSending(PacketEvent event) {
                if (event.isPlayerTemporary()) {
                    return;
                }
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getMeta("AuraSkills").isPresent()) {
                    return;
                }
                ProtocolLibHook.this.getActionBar().setPaused(ProtocolLibHook.this.getUser(player), 2500, TimeUnit.MILLISECONDS);
            }
        });
    }

    private void registerSystemChatListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.skillsPlugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.SYSTEM_CHAT}){

            public void onPacketSending(PacketEvent event) {
                if (event.isPlayerTemporary()) {
                    return;
                }
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getMeta("AuraSkills").isPresent()) {
                    return;
                }
                StructureModifier integers = packet.getIntegers();
                if (integers.size() == 1) {
                    if (((Integer)integers.read(0)).intValue() == EnumWrappers.ChatType.GAME_INFO.getId()) {
                        ProtocolLibHook.this.getActionBar().setPaused(ProtocolLibHook.this.getUser(player), 2500, TimeUnit.MILLISECONDS);
                    }
                } else if (((Boolean)packet.getBooleans().read(0)).booleanValue()) {
                    ProtocolLibHook.this.getActionBar().setPaused(ProtocolLibHook.this.getUser(player), 2500, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    private void registerLegacyListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.skillsPlugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.TITLE}){

            public void onPacketSending(PacketEvent event) {
                if (event.isPlayerTemporary()) {
                    return;
                }
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getEnumModifier(EnumWrappers.TitleAction.class, 0).read(0) != EnumWrappers.TitleAction.ACTIONBAR) {
                    return;
                }
                if (packet.getMeta("AuraSkills").isPresent()) {
                    return;
                }
                ProtocolLibHook.this.getActionBar().setPaused(ProtocolLibHook.this.getUser(player), 2500, TimeUnit.MILLISECONDS);
            }
        });
    }

    private void registerChatListener(ProtocolManager manager) {
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.skillsPlugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.CHAT}){

            public void onPacketSending(PacketEvent event) {
                if (event.isPlayerTemporary()) {
                    return;
                }
                Player player = event.getPlayer();
                PacketContainer packet = event.getPacket();
                if (packet.getChatTypes().read(0) != EnumWrappers.ChatType.GAME_INFO) {
                    return;
                }
                if (packet.getMeta("AuraSkills").isPresent()) {
                    return;
                }
                ProtocolLibHook.this.getActionBar().setPaused(ProtocolLibHook.this.getUser(player), 2500, TimeUnit.MILLISECONDS);
            }
        });
    }
}

