/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.bukkit.BukkitTraitHandler;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillItem;
import dev.aurelium.auraskills.common.leaderboard.SkillValue;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.math.BigNumber;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderApiProvider
extends PlaceholderExpansion {
    private final AuraSkills plugin;
    private final String identifier;
    private final String[] xpIdentifiers = new String[]{"xp_required_formatted_", "xp_required_", "xp_progress_int_", "xp_progress_1_", "xp_progress_", "xp_int_", "xp_formatted_", "xp_bar_", "xp_"};

    public PlaceholderApiProvider(AuraSkills plugin, String identifier) {
        this.plugin = plugin;
        this.identifier = identifier;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        User user;
        if (identifier.startsWith("lb_")) {
            return this.checkLeaderboardPlaceholders(identifier);
        }
        if (player == null) {
            return "";
        }
        if (identifier.equals("power")) {
            User user2 = this.plugin.getUser(player);
            return String.valueOf(user2.getPowerLevel());
        }
        if (identifier.equals("average")) {
            User user3 = this.plugin.getUser(player);
            return String.valueOf(user3.getSkillAverage());
        }
        if (identifier.equals("average_int")) {
            User user4 = this.plugin.getUser(player);
            return String.valueOf(Math.round(user4.getSkillAverage()));
        }
        if (identifier.equals("average_1")) {
            User user5 = this.plugin.getUser(player);
            return NumberUtil.format1(user5.getSkillAverage());
        }
        if (identifier.equals("hp")) {
            return String.valueOf(Math.round(player.getHealth() * Traits.HP.optionDouble("action_bar_scaling")));
        }
        if (identifier.equals("hp_1")) {
            return NumberUtil.format1(player.getHealth() * Traits.HP.optionDouble("action_bar_scaling"));
        }
        if (identifier.equals("hp_max")) {
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attributeInstance != null) {
                return String.valueOf(Math.round(attributeInstance.getValue() * Traits.HP.optionDouble("action_bar_scaling")));
            }
            return "";
        }
        if (identifier.equals("hp_2")) {
            return NumberUtil.format2(player.getHealth() * Traits.HP.optionDouble("action_bar_scaling"));
        }
        if (identifier.equals("hp_percent")) {
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attributeInstance != null) {
                return String.valueOf(Math.round(player.getHealth() / attributeInstance.getValue()));
            }
            return "";
        }
        if (identifier.equals("mana")) {
            User user6 = this.plugin.getUser(player);
            return String.valueOf(user6.getMana());
        }
        if (identifier.equals("mana_int")) {
            User user7 = this.plugin.getUser(player);
            return String.valueOf(Math.round(user7.getMana()));
        }
        if (identifier.equals("mana_max")) {
            User user8 = this.plugin.getUser(player);
            return String.valueOf(user8.getMaxMana());
        }
        if (identifier.equals("mana_max_int")) {
            User user9 = this.plugin.getUser(player);
            return String.valueOf(Math.round(user9.getMaxMana()));
        }
        if (identifier.startsWith("mability_")) {
            NamespacedId namespacedId = NamespacedId.fromDefault(identifier.replace("mability_", "").replace("_active", "").replace("_value", ""));
            ManaAbility manaAbility = (ManaAbility)this.plugin.getManaAbilityRegistry().getOrNull(namespacedId);
            if (manaAbility == null) {
                return null;
            }
            User user2 = this.plugin.getUser(player);
            if (manaAbility.isEnabled()) {
                if (identifier.endsWith("value")) {
                    return String.valueOf(manaAbility.getValue(user2.getManaAbilityLevel(manaAbility)));
                }
                if (identifier.endsWith("active")) {
                    return String.valueOf(user2.getManaAbilityData(manaAbility).isActivated());
                }
                if (identifier.endsWith(manaAbility.name().toLowerCase(Locale.ROOT))) {
                    return String.valueOf(user2.getManaAbilityLevel(manaAbility));
                }
            }
        }
        if (identifier.startsWith("trait_")) {
            BukkitTraitHandler handler;
            String string = identifier.replace("trait_", "").replace("_bonus", "").replace("_menu", "");
            NamespacedId id = NamespacedId.fromDefault(string);
            Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(id);
            if (trait == null || !trait.isEnabled()) {
                return null;
            }
            User user11 = this.plugin.getUser(player);
            if (identifier.endsWith(string)) {
                return NumberUtil.format2(user11.getEffectiveTraitLevel(trait));
            }
            if (identifier.endsWith("bonus")) {
                return NumberUtil.format2(user11.getBonusTraitLevel(trait));
            }
            if (identifier.endsWith("menu") && (handler = this.plugin.getTraitManager().getTraitImpl(trait)) != null) {
                return handler.getMenuDisplay(user11.getEffectiveTraitLevel(trait), trait, user11.getLocale());
            }
        }
        for (Stat stat : this.plugin.getStatRegistry().getValues()) {
            if (identifier.equals(stat.name().toLowerCase(Locale.ROOT))) {
                user = this.plugin.getUser(player);
                return String.valueOf(user.getStatLevel(stat));
            }
            if (!identifier.equals(stat.name().toLowerCase(Locale.ROOT) + "_int")) continue;
            user = this.plugin.getUser(player);
            return String.valueOf(Math.round(user.getStatLevel(stat)));
        }
        for (Skill skill : this.plugin.getSkillRegistry().getValues()) {
            if (identifier.equals(skill.name().toLowerCase(Locale.ROOT))) {
                user = this.plugin.getUser(player);
                return String.valueOf(user.getSkillLevel(skill));
            }
            if (!identifier.equals(skill.name().toLowerCase(Locale.ROOT) + "_roman")) continue;
            user = this.plugin.getUser(player);
            return RomanNumber.toRoman(user.getSkillLevel(skill), this.plugin);
        }
        for (Ability ability : this.plugin.getAbilityRegistry().getValues()) {
            if (identifier.equals(ability.name().toLowerCase(Locale.ROOT))) {
                user = this.plugin.getUser(player);
                return String.valueOf(user.getAbilityLevel(ability));
            }
            if (identifier.equals(ability.name().toLowerCase(Locale.ROOT) + "_value")) {
                user = this.plugin.getUser(player);
                return String.valueOf(ability.getValue(user.getAbilityLevel(ability)));
            }
            if (!identifier.equals(ability.name().toLowerCase(Locale.ROOT) + "_value_2") || !ability.hasSecondaryValue()) continue;
            user = this.plugin.getUser(player);
            return String.valueOf(ability.getSecondaryValue(user.getAbilityLevel(ability)));
        }
        if (identifier.equals("rank")) {
            return String.valueOf(this.plugin.getLeaderboardManager().getPowerRank(player.getUniqueId()));
        }
        if (identifier.startsWith("rank_")) {
            Skill skill;
            String string = TextUtil.replace(identifier, "rank_", "");
            skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(string));
            if (skill != null) {
                return String.valueOf(this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId()));
            }
        }
        for (String id : this.xpIdentifiers) {
            if (!identifier.startsWith(id)) continue;
            String skillName = TextUtil.replace(identifier, id, "");
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(skillName));
            if (skill == null) continue;
            User user12 = this.plugin.getUser(player);
            switch (id) {
                case "xp_required_formatted_": {
                    return BigNumber.withSuffix(this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1));
                }
                case "xp_required_": {
                    return String.valueOf(this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1));
                }
                case "xp_progress_int_": {
                    return String.valueOf(Math.round(user12.getSkillXp(skill) / (double)this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1) * 100.0));
                }
                case "xp_progress_1_": {
                    return NumberUtil.format1(user12.getSkillXp(skill) / (double)this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1) * 100.0);
                }
                case "xp_progress_": {
                    return String.valueOf(user12.getSkillXp(skill) / (double)this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1) * 100.0);
                }
                case "xp_int_": {
                    return String.valueOf(Math.round(user12.getSkillXp(skill)));
                }
                case "xp_formatted_": {
                    return BigNumber.withSuffix(Math.round(user12.getSkillXp(skill)));
                }
                case "xp_bar_": {
                    int xpRequired = this.plugin.getXpRequirements().getXpRequired(skill, user12.getSkillLevel(skill) + 1);
                    return this.plugin.getMessageProvider().applyFormatting(SkillItem.getBar(this.plugin, user12.getSkillXp(skill), xpRequired));
                }
                case "xp_": {
                    return String.valueOf(user12.getSkillXp(skill));
                }
            }
        }
        if (identifier.startsWith("multiplier")) {
            User user10 = this.plugin.getUser(player);
            if (identifier.equals("multiplier")) {
                return NumberUtil.format2(this.plugin.getLevelManager().getGenericMultiplier(user10));
            }
            String skillName = TextUtil.replace(identifier, "multiplier_", "");
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(skillName));
            if (skill != null) {
                return NumberUtil.format2(this.plugin.getLevelManager().calculateMultiplier(user10, skill));
            }
        }
        if (identifier.startsWith("multiplier_percent")) {
            User user11 = this.plugin.getUser(player);
            if (identifier.equals("multiplier_percent")) {
                return String.valueOf(Math.round((this.plugin.getLevelManager().getGenericMultiplier(user11) - 1.0) * 100.0));
            }
            String skillName = TextUtil.replace(identifier, "multiplier_percent_", "");
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(skillName));
            if (skill != null) {
                return String.valueOf(Math.round((this.plugin.getLevelManager().calculateMultiplier(user11, skill) - 1.0) * 100.0));
            }
        }
        if (identifier.startsWith("actionbar_status") && identifier.equals("actionbar_status")) {
            User user12 = this.plugin.getUser(player);
            if (user12.isActionBarEnabled(ActionBarType.IDLE)) {
                return "true";
            }
            return "false";
        }
        if (identifier.startsWith("jobs_")) {
            User user13 = this.plugin.getUser(player);
            switch (identifier) {
                case "jobs_list": {
                    return String.join((CharSequence)",", user13.getJobs().stream().map(s -> s.getId().getKey()).toList());
                }
                case "jobs_list_formatted": {
                    return String.join((CharSequence)(ChatColor.RESET + ", "), user13.getJobs().stream().map(s -> s.getDisplayName(this.plugin.getDefaultLanguage())).toList());
                }
                case "jobs_count": {
                    return String.valueOf(user13.getJobs().size());
                }
                case "jobs_limit": {
                    return String.valueOf(user13.getJobLimit());
                }
            }
        }
        return null;
    }

    private String checkLeaderboardPlaceholders(String identifier) {
        String leaderboardType = TextUtil.replace(identifier, "lb_", "");
        if (leaderboardType.startsWith("power_")) {
            int valuePlace;
            int place = NumberUtil.toInt(TextUtil.replace(leaderboardType, "power_", ""));
            if (place > 0) {
                List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(place, 1);
                if (!list.isEmpty()) {
                    SkillValue skillValue = list.get(0);
                    String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                    return (name != null ? name : "?") + " - " + skillValue.level();
                }
                return "";
            }
            if (identifier.endsWith("name")) {
                int namePlace = NumberUtil.toInt(TextUtil.replace(leaderboardType, "power_", "", "_name", ""));
                if (namePlace > 0) {
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(namePlace, 1);
                    if (!list.isEmpty()) {
                        SkillValue skillValue = list.get(0);
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                        return name != null ? name : "?";
                    }
                    return "";
                }
            } else if (identifier.endsWith("value") && (valuePlace = NumberUtil.toInt(TextUtil.replace(leaderboardType, "power_", "", "_value", ""))) > 0) {
                List<SkillValue> list = this.plugin.getLeaderboardManager().getPowerLeaderboard(valuePlace, 1);
                if (!list.isEmpty()) {
                    SkillValue playerSkill = list.get(0);
                    return String.valueOf(playerSkill.level());
                }
                return "";
            }
        } else {
            for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
                int valuePlace;
                if (!leaderboardType.startsWith(skill.name().toLowerCase(Locale.ROOT) + "_")) continue;
                int place = NumberUtil.toInt(TextUtil.replace(leaderboardType, skill.name().toLowerCase(Locale.ROOT) + "_", ""));
                if (place > 0) {
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, place, 1);
                    if (!list.isEmpty()) {
                        SkillValue skillValue = list.get(0);
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                        return (name != null ? name : "?") + " - " + skillValue.level();
                    }
                    return "";
                }
                if (identifier.endsWith("name")) {
                    int namePlace = NumberUtil.toInt(TextUtil.replace(leaderboardType, skill.name().toLowerCase(Locale.ROOT) + "_", "", "_name", ""));
                    if (namePlace <= 0) continue;
                    List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, namePlace, 1);
                    if (!list.isEmpty()) {
                        SkillValue skillValue = list.get(0);
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                        return name != null ? name : "?";
                    }
                    return "";
                }
                if (!identifier.endsWith("value") || (valuePlace = NumberUtil.toInt(TextUtil.replace(leaderboardType, skill.name().toLowerCase(Locale.ROOT) + "_", "", "_value", ""))) <= 0) continue;
                List<SkillValue> list = this.plugin.getLeaderboardManager().getLeaderboard(skill, valuePlace, 1);
                if (!list.isEmpty()) {
                    SkillValue skillValue = list.get(0);
                    return String.valueOf(skillValue.level());
                }
                return "";
            }
        }
        return "";
    }

    @NotNull
    public List<String> getPlaceholders() {
        return List.of("%auraskills_power%", "%auraskills_[skill]%", "%auraskills_[skill]_roman%", "%auraskills_[stat]%", "%auraskills_[stat]_int%", "%auraskills_[ability]%", "%auraskills_[ability]_value%", "%auraskills_[ability]_value_2%", "%auraskills_mability_[ability]%", "%auraskills_mability_[ability]_active%", "%auraskills_mability_[ability]_value%", "%auraskills_trait_[trait]", "%auraskills_trait_[trait]_bonus", "%auraskills_trait_[trait]_menu", "%auraskills_average%", "%auraskills_average_int%", "%auraskills_average_1%", "%auraskills_hp%", "%auraskills_hp_1%", "%auraskills_hp_2%", "%auraskills_hp_max%", "%auraskills_hp_percent%", "%auraskills_mana%", "%auraskills_mana_int%", "%auraskills_mana_max%", "%auraskills_mana_max_int%", "%auraskills_lb_power_[place]%", "%auraskills_lb_power_[place]_name%", "%auraskills_lb_power_[place]_value%", "%auraskills_lb_[skill]_[place]_name%", "%auraskills_lb_[skill]_[place]_value%", "%auraskills_rank", "%auraskills_rank_[skill]", "%auraskills_xp_required_formatted_[skill]%", "%auraskills_xp_required_[skill]%", "%auraskills_xp_progress_int_[skill]%", "%auraskills_xp_progress_1_[skill]%", "%auraskills_xp_progress_[skill]%", "%auraskills_xp_int_[skill]%", "%auraskills_xp_formatted_[skill]%", "%auraskills_xp_bar_[skill]", "%auraskills_xp_[skill]%", "%auraskills_multiplier%", "%auraskills_multiplier_[skill]%", "%auraskills_multiplier_percent%", "%auraskills_multiplier_percent_[skill]%", "%auraskills_actionbar_status%", "%auraskills_jobs_list", "%auraskills_jobs_list_formatted", "%auraskills_jobs_count", "%auraskills_jobs_limit");
    }
}

