/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.Hooks;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.hooks.HookManager;
import dev.aurelium.auraskills.common.hooks.HookRegistrationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.spongepowered.configurate.ConfigurationNode;

public class HookRegistrar {
    private final AuraSkills plugin;
    private final HookManager manager;

    public HookRegistrar(AuraSkills plugin, HookManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public void registerHooks(ConfigurationNode config) {
        for (Hooks hookType : Hooks.values()) {
            if (this.manager.isRegistered(hookType.getHookClass()) || !this.plugin.getServer().getPluginManager().isPluginEnabled(hookType.getPluginName())) continue;
            try {
                ConfigurationNode hookConfig = config.node(hookType.getPluginName());
                if (!hookConfig.node("enabled").getBoolean(false)) continue;
                Hook hook = this.createHook(hookType, hookConfig);
                if (hook instanceof Listener) {
                    this.plugin.getServer().getPluginManager().registerEvents((Listener)hook, (Plugin)this.plugin);
                }
                this.manager.registerHook(hook.getClass(), hook);
                this.plugin.logger().info("Successfully registered hook " + hookType.getPluginName());
            }
            catch (HookRegistrationException e) {
                this.plugin.logger().warn("Failed to register hook " + hookType.getPluginName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private Hook createHook(Hooks type, ConfigurationNode config) {
        Class<? extends Hook> hookClass = type.getHookClass();
        Constructor<?> constructor = hookClass.getDeclaredConstructors()[0];
        if (constructor == null) {
            throw new HookRegistrationException("Hook does not have a declared constructor");
        }
        try {
            return (Hook)constructor.newInstance(this.plugin, config);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new HookRegistrationException("Failed to construct hook using reflection: " + e.getMessage());
        }
    }
}

