/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.hooks.LuckPermsHook;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.spongepowered.configurate.ConfigurationNode;

public class BukkitLuckPermsHook
extends LuckPermsHook
implements Listener {
    private final String prefix = "auraskills.multiplier.";
    private final Map<UUID, Set<String>> permissionCache = new ConcurrentHashMap<UUID, Set<String>>();

    public BukkitLuckPermsHook(AuraSkillsPlugin plugin, ConfigurationNode config) {
        super(plugin, config);
        this.luckPerms.getEventBus().subscribe(NodeAddEvent.class, event -> this.handleEvent(event.getNode(), event.getTarget()));
        this.luckPerms.getEventBus().subscribe(NodeRemoveEvent.class, event -> this.handleEvent(event.getNode(), event.getTarget()));
    }

    private void handleEvent(Node node, PermissionHolder target) {
        if (!(node instanceof PermissionNode) && !(node instanceof InheritanceNode)) {
            return;
        }
        if (node instanceof PermissionNode) {
            PermissionNode permissionNode = (PermissionNode)node;
            if (!permissionNode.getValue()) {
                return;
            }
            if (!permissionNode.getPermission().startsWith("auraskills.multiplier.")) {
                return;
            }
        }
        if (target instanceof User) {
            User user = (User)target;
            this.plugin.getScheduler().scheduleAsync(() -> {
                Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
                if (player == null || !player.isOnline()) {
                    return;
                }
                this.permissionCache.put(user.getUniqueId(), this.getMultiplierPermissions(user.getUniqueId()));
            }, 500L, TimeUnit.MILLISECONDS);
        } else if (target instanceof Group) {
            Group group = (Group)target;
            ArrayList<UUID> affectedPlayers = new ArrayList<UUID>(this.permissionCache.keySet().size());
            if (node instanceof InheritanceNode) {
                affectedPlayers.addAll(this.permissionCache.keySet());
            } else {
                this.permissionCache.keySet().forEach(key -> {
                    User user = this.luckPerms.getUserManager().getUser(key);
                    if (user == null) {
                        return;
                    }
                    if (user.getInheritedGroups(QueryOptions.builder((QueryMode)QueryMode.CONTEXTUAL).context((ContextSet)QueryOptions.defaultContextualOptions().context()).flag(Flag.RESOLVE_INHERITANCE, true).build()).stream().anyMatch(g -> group.getName().equals(g.getName()))) {
                        affectedPlayers.add(user.getUniqueId());
                    }
                });
            }
            this.plugin.getScheduler().scheduleAsync(() -> {
                for (UUID uuid : affectedPlayers) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || !player.isOnline()) continue;
                    this.permissionCache.put(uuid, this.getMultiplierPermissions(uuid));
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public Set<String> getMultiplierPermissions(Player player) {
        return this.permissionCache.computeIfAbsent(player.getUniqueId(), this::getMultiplierPermissions);
    }

    private Set<String> getMultiplierPermissions(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return new HashSet<String>();
        }
        return player.getEffectivePermissions().stream().filter(PermissionAttachmentInfo::getValue).map(PermissionAttachmentInfo::getPermission).filter(p -> p.startsWith("auraskills.multiplier.")).collect(Collectors.toSet());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.plugin.getScheduler().executeAsync(() -> {
            if (!event.getPlayer().isOnline()) {
                return;
            }
            this.permissionCache.put(uuid, this.getMultiplierPermissions(uuid));
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.permissionCache.remove(event.getPlayer().getUniqueId());
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return BukkitLuckPermsHook.class;
    }
}

