/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.config;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.HookRegistrar;
import dev.aurelium.auraskills.common.config.ConfigProvider;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.config.OptionType;
import dev.aurelium.auraskills.common.config.OptionValue;
import dev.aurelium.auraskills.common.hooks.EconomyHook;
import dev.aurelium.auraskills.common.message.PlatformLogger;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.ChatColor;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class BukkitConfigProvider
implements ConfigProvider {
    private final AuraSkills plugin;
    private final Map<Option, OptionValue> options = new HashMap<Option, OptionValue>();

    public BukkitConfigProvider(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void loadOptions() {
        PlatformLogger logger = this.plugin.logger();
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        try {
            ConfigurationNode embedded = loader.loadEmbeddedFile("config.yml");
            ConfigurationNode user = loader.loadUserFile("config.yml");
            ConfigurationNode config = loader.mergeNodes(embedded, user);
            int loaded = 0;
            long start = System.currentTimeMillis();
            for (Option option : Option.values()) {
                Object value = config.node(this.toPath(option.getPath())).raw();
                if (value == null) {
                    logger.warn("Missing value in config.yml: Option " + option.name() + " with path " + option.getPath() + " was not found, using default value instead!");
                    continue;
                }
                if ((value instanceof Integer || value instanceof Double) && option.getType() == OptionType.INT) {
                    this.options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if ((value instanceof Double || value instanceof Integer) && option.getType() == OptionType.DOUBLE) {
                    this.options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if (value instanceof Boolean && option.getType() == OptionType.BOOLEAN) {
                    this.options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if ((value instanceof String || value instanceof Integer || value instanceof Double || value instanceof Boolean) && option.getType() == OptionType.STRING) {
                    this.options.put(option, new OptionValue(String.valueOf(value)));
                    ++loaded;
                    continue;
                }
                if (value instanceof List && option.getType() == OptionType.LIST) {
                    this.options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if (value instanceof String && option.getType() == OptionType.COLOR) {
                    this.options.put(option, new OptionValue(ChatColor.valueOf((String)String.valueOf(value).toUpperCase(Locale.ROOT))));
                    ++loaded;
                    continue;
                }
                logger.warn("Incorrect type in config.yml: Option " + option.name() + " with path " + option.getPath() + " should be of type " + option.getType().name() + ", using default value instead!");
            }
            HookRegistrar hookRegistrar = new HookRegistrar(this.plugin, this.plugin.getHookManager());
            hookRegistrar.registerHooks(config.node("hooks"));
            File file = new File(this.plugin.getPluginFolder(), "config.yml");
            loader.saveConfigIfUpdated(file, embedded, user, config);
            long end = System.currentTimeMillis();
            logger.info("Loaded " + loaded + " config options in " + (end - start) + " ms");
        }
        catch (IOException e) {
            this.plugin.logger().severe("Failed to load config.yml: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private NodePath toPath(String path) {
        Object[] split = path.split("\\.");
        return NodePath.of(split);
    }

    @Override
    public boolean getBoolean(Option option) {
        return this.options.get((Object)option).asBoolean();
    }

    @Override
    public int getInt(Option option) {
        return this.options.get((Object)option).asInt();
    }

    @Override
    public double getDouble(Option option) {
        return this.options.get((Object)option).asDouble();
    }

    @Override
    public String getString(Option option) {
        return this.options.get((Object)option).asString();
    }

    @Override
    public List<String> getStringList(Option option) {
        return this.options.get((Object)option).asList();
    }

    @Override
    public boolean isEnabled(Skill skill) {
        return skill.isEnabled();
    }

    @Override
    public int getMaxLevel(Skill skill) {
        if (!skill.isEnabled()) {
            return 0;
        }
        return this.plugin.getSkillManager().getSkill(skill).options().maxLevel();
    }

    @Override
    public int getHighestMaxLevel() {
        int highest = 0;
        for (LoadedSkill skill : this.plugin.getSkillManager().getSkills()) {
            int maxLevel = skill.options().maxLevel();
            if (maxLevel <= highest) continue;
            highest = maxLevel;
        }
        return highest;
    }

    @Override
    public int getStartLevel() {
        return this.options.get((Object)Option.START_LEVEL).asInt();
    }

    @Override
    public boolean jobSelectionEnabled() {
        boolean economyEnabled = this.plugin.getHookManager().isRegistered(EconomyHook.class);
        boolean selectionEnabled = this.plugin.configBoolean(Option.JOBS_SELECTION_REQUIRE_SELECTION);
        return this.plugin.configBoolean(Option.JOBS_ENABLED) && economyEnabled && selectionEnabled;
    }
}

