/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.CommandHelp;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.acf.annotation.Syntax;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.commands.ReloadExecutor;
import dev.aurelium.auraskills.bukkit.item.UnclaimedItemsMenu;
import dev.aurelium.auraskills.bukkit.menus.SourcesMenu;
import dev.aurelium.auraskills.bukkit.util.UpdateChecker;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.leaderboard.SkillValue;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.nbtapi.NBTCompoundList;
import dev.aurelium.auraskills.nbtapi.NBTFile;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBT;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBTCompoundList;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@CommandAlias(value="%skills_alias")
public class SkillsRootCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public SkillsRootCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Default
    @CommandPermission(value="auraskills.command.skills")
    @Description(value="Opens the Skills menu, where you can browse skills, progress, and abilities.")
    public void onSkills(Player player) {
        if (this.plugin.getUserManager().hasUser(player.getUniqueId())) {
            this.plugin.getSlate().openMenu(player, "skills");
        } else {
            player.sendMessage(this.plugin.getMsg(CommandMessage.NO_PROFILE, this.plugin.getDefaultLanguage()));
        }
    }

    @Subcommand(value="reload")
    @CommandPermission(value="auraskills.command.reload")
    @Description(value="Reloads the config, messages, menus, loot tables, action bars, boss bars, and health and luck stats.")
    public void reload(CommandSender sender) {
        new ReloadExecutor(this.plugin).reload(sender);
    }

    @Subcommand(value="help")
    @CommandPermission(value="auraskills.command.help")
    public void onHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="top")
    @CommandAlias(value="skilltop")
    @CommandCompletion(value="@skill_top")
    @CommandPermission(value="auraskills.command.top")
    @Description(value="Shows the top players in a skill")
    @Syntax(value="Usage: /sk top <page> or /sk top [skill] <page>")
    public void onTop(CommandSender sender, String[] args) {
        Locale locale = this.plugin.getLocale(sender);
        if (args.length == 0) {
            List<SkillValue> lb = this.plugin.getLeaderboardManager().getPowerLeaderboard(1, 10);
            sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_POWER_HEADER, locale));
            for (SkillValue skillValue : lb) {
                String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_POWER_ENTRY, locale).replace("{rank}", String.valueOf(lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.level())));
            }
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("average")) {
                List<SkillValue> lb = this.plugin.getLeaderboardManager().getAverageLeaderboard(1, 10);
                sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_AVERAGE_HEADER, locale));
                this.sendLeaderboardEntries(sender, locale, lb);
            } else {
                try {
                    int page = Integer.parseInt(args[0]);
                    List<SkillValue> lb = this.plugin.getLeaderboardManager().getPowerLeaderboard(page, 10);
                    sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_POWER_HEADER_PAGE, locale).replace("{page}", String.valueOf(page)));
                    for (SkillValue skillValue : lb) {
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                        sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_POWER_ENTRY, locale).replace("{rank}", String.valueOf((page - 1) * 10 + lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.level())));
                    }
                }
                catch (Exception e) {
                    Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(args[0]));
                    if (skill != null) {
                        List<SkillValue> lb = this.plugin.getLeaderboardManager().getLeaderboard(skill, 1, 10);
                        sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_SKILL_HEADER, locale).replace("{skill}", skill.getDisplayName(locale)));
                        for (SkillValue skillValue : lb) {
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                            sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_SKILL_ENTRY, locale).replace("{rank}", String.valueOf(lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.level())));
                        }
                    }
                    sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_USAGE, locale));
                }
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("average")) {
                try {
                    int page = Integer.parseInt(args[1]);
                    List<SkillValue> lb = this.plugin.getLeaderboardManager().getAverageLeaderboard(page, 10);
                    sender.sendMessage(TextUtil.replace(this.plugin.getMsg(CommandMessage.TOP_AVERAGE_HEADER_PAGE, locale), "{page}", String.valueOf(page)));
                    this.sendLeaderboardEntries(sender, locale, lb);
                }
                catch (Exception e) {
                    sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_USAGE, locale));
                }
            } else {
                Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(args[0]));
                if (skill != null) {
                    try {
                        int page = Integer.parseInt(args[1]);
                        List<SkillValue> lb = this.plugin.getLeaderboardManager().getLeaderboard(skill, page, 10);
                        sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_SKILL_HEADER_PAGE, locale).replace("{page}", String.valueOf(page)).replace("{skill}", skill.getDisplayName(locale)));
                        for (SkillValue skillValue : lb) {
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
                            sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_SKILL_ENTRY, locale).replace("{rank}", String.valueOf((page - 1) * 10 + lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.level())));
                        }
                    }
                    catch (Exception e) {
                        sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_USAGE, locale));
                    }
                } else {
                    sender.sendMessage(this.plugin.getMsg(CommandMessage.TOP_USAGE, locale));
                }
            }
        }
    }

    private void sendLeaderboardEntries(CommandSender sender, Locale locale, List<SkillValue> lb) {
        for (SkillValue skillValue : lb) {
            String name = Bukkit.getOfflinePlayer((UUID)skillValue.id()).getName();
            sender.sendMessage(TextUtil.replace(this.plugin.getMsg(CommandMessage.TOP_AVERAGE_ENTRY, locale), "{rank}", String.valueOf(lb.indexOf(skillValue) + 1), "{player}", name != null ? name : "?", "{level}", NumberUtil.format2(skillValue.xp())));
        }
    }

    @Subcommand(value="save")
    @CommandPermission(value="auraskills.command.save")
    @Description(value="Saves skill data")
    public void onSave(CommandSender sender) {
        this.plugin.getScheduler().executeAsync(() -> {
            Locale locale = this.plugin.getLocale(sender);
            for (User user : this.plugin.getUserManager().getOnlineUsers()) {
                try {
                    this.plugin.getStorageProvider().save(user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.plugin.getScheduler().executeSync(() -> sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.SAVE_SAVED, locale)));
        });
    }

    @Subcommand(value="updateleaderboards")
    @CommandPermission(value="auraskills.command.updateleaderboards")
    @Description(value="Updates and sorts the leaderboards")
    public void onUpdateLeaderboards(CommandSender sender) {
        Locale locale = this.plugin.getLocale(sender);
        if (this.plugin.getLeaderboardManager().isNotSorting()) {
            this.plugin.getScheduler().executeAsync(() -> {
                this.plugin.getLeaderboardManager().updateLeaderboards();
                this.plugin.getScheduler().executeSync(() -> sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UPDATELEADERBOARDS_UPDATED, locale)));
            });
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UPDATELEADERBOARDS_ALREADY_UPDATING, locale));
        }
    }

    @Subcommand(value="toggle")
    @CommandAlias(value="abtoggle")
    @CommandPermission(value="auraskills.command.abtoggle")
    @Description(value="Toggle your own action bar")
    public void onActionBarToggle(Player player) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (this.plugin.configBoolean(Option.ACTION_BAR_ENABLED)) {
            if (!user.isActionBarEnabled(ActionBarType.IDLE)) {
                user.setActionBarSetting(ActionBarType.IDLE, true);
                player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.TOGGLE_ENABLED, locale));
            } else {
                user.setActionBarSetting(ActionBarType.IDLE, false);
                player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.TOGGLE_DISABLED, locale));
            }
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.TOGGLE_NOT_ENABLED, locale));
        }
    }

    @Subcommand(value="rank")
    @CommandAlias(value="skillrank")
    @CommandPermission(value="auraskills.command.rank")
    @Description(value="Shows your skill rankings")
    public void onRank(Player player) {
        Locale locale = this.plugin.getLocale((CommandSender)player);
        player.sendMessage(this.plugin.getMsg(CommandMessage.RANK_HEADER, locale));
        player.sendMessage(this.plugin.getMsg(CommandMessage.RANK_POWER, locale).replace("{rank}", String.valueOf(this.plugin.getLeaderboardManager().getPowerRank(player.getUniqueId()))).replace("{total}", String.valueOf(this.plugin.getLeaderboardManager().getPowerLeaderboard().size())));
        for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
            player.sendMessage(this.plugin.getMsg(CommandMessage.RANK_ENTRY, locale).replace("{skill}", String.valueOf(skill.getDisplayName(locale))).replace("{rank}", String.valueOf(this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId()))).replace("{total}", String.valueOf(this.plugin.getLeaderboardManager().getLeaderboard(skill).size())));
        }
    }

    @Subcommand(value="lang")
    @CommandCompletion(value="@lang")
    @CommandPermission(value="auraskills.command.lang")
    @Description(value="Changes your player language")
    public void onLanguage(Player player, String language) {
        Locale locale = new Locale(language.toLowerCase(Locale.ROOT));
        if (this.plugin.getMessageProvider().hasLocale(locale)) {
            User user = this.plugin.getUser(player);
            user.setLocale(locale);
            this.plugin.getCommandManager().setPlayerLocale(player, locale);
            String code = this.plugin.getMessageProvider().getLanguageCode(locale);
            player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.LANG_SET, locale).replace("{lang}", code));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.LANG_NOT_FOUND, this.plugin.getLocale((CommandSender)player)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subcommand(value="multiplier")
    @CommandCompletion(value="@players")
    @CommandPermission(value="auraskills.command.multiplier")
    @Description(value="Shows a player's current XP multiplier based on their permissions.")
    public void onMultiplier(CommandSender sender, @Optional @Flags(value="other") Player player) {
        Player target;
        if (player == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getPrefix(this.plugin.getDefaultLanguage()) + this.plugin.getMsg(CommandMessage.MULTIPLIER_PLAYERS_ONLY, this.plugin.getDefaultLanguage()));
                return;
            }
            target = (Player)sender;
        } else {
            target = player;
        }
        User user = this.plugin.getUser(target);
        Locale locale = user.getLocale();
        double multiplier = this.plugin.getLevelManager().getPermissionMultiplier(user, null);
        sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.MULTIPLIER_LIST, locale), "{player}", target.getName(), "{multiplier}", NumberUtil.format2(1.0 + multiplier), "{percent}", NumberUtil.format2(multiplier * 100.0)));
        Iterator<Skill> iterator = this.plugin.getSkillManager().getEnabledSkills().iterator();
        while (iterator.hasNext()) {
            Skill skill = iterator.next();
            double skillMultiplier = this.plugin.getLevelManager().getPermissionMultiplier(user, skill);
            if (skillMultiplier == multiplier) continue;
            sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.MULTIPLIER_SKILL_ENTRY, locale), "{skill}", skill.getDisplayName(locale), "{multiplier}", NumberUtil.format2(1.0 + skillMultiplier), "{percent}", NumberUtil.format2(skillMultiplier * 100.0)));
        }
        return;
    }

    @Subcommand(value="resethealth")
    @CommandPermission(value="auraskills.command.resethealth")
    @Description(value="Removes all attribute modifiers by Aurelium Skills for easy uninstalling. This only works on offline players.")
    public void onResetHealth(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender) {
            File playerDataFolder = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), "playerdata");
            int successful = 0;
            int error = 0;
            int total = 0;
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player.isOnline()) continue;
                ++total;
                File playerFile = new File(playerDataFolder, player.getUniqueId() + ".dat");
                if (!playerFile.exists() || !playerFile.canWrite()) continue;
                try {
                    NBTFile nbtFile = new NBTFile(playerFile);
                    NBTCompoundList compoundList = nbtFile.getCompoundList("Attributes");
                    if (compoundList == null) continue;
                    AtomicBoolean save = new AtomicBoolean(false);
                    block16: for (ReadWriteNBT listCompound : compoundList.subList(0, compoundList.size())) {
                        switch (listCompound.getString("Name")) {
                            case "generic.maxHealth": 
                            case "minecraft:generic.max_health": {
                                ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) continue block16;
                                modifierList.removeIf(modifier -> {
                                    if (modifier.getString("Name").equals("skillsHealth")) {
                                        save.set(true);
                                        return true;
                                    }
                                    return false;
                                });
                                if (!modifierList.isEmpty()) continue block16;
                                listCompound.removeKey("Modifiers");
                                break;
                            }
                            case "generic.luck": 
                            case "minecraft:generic.luck": {
                                ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) continue block16;
                                modifierList.removeIf(modifier -> {
                                    if (modifier.getString("Name").equals("AureliumSkills-Luck")) {
                                        save.set(true);
                                        return true;
                                    }
                                    return false;
                                });
                                if (!modifierList.isEmpty()) continue block16;
                                listCompound.removeKey("Modifiers");
                                break;
                            }
                            case "generic.attackSpeed": 
                            case "minecraft:generic.attack_speed": {
                                ReadWriteNBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) break;
                                modifierList.removeIf(modifier -> {
                                    if (modifier.getString("Name").equals("AureliumSkills-LightningBlade")) {
                                        save.set(true);
                                        return true;
                                    }
                                    return false;
                                });
                                if (!modifierList.isEmpty()) break;
                                listCompound.removeKey("Modifiers");
                            }
                        }
                    }
                    if (!save.get()) continue;
                    nbtFile.save();
                    ++successful;
                }
                catch (Exception e) {
                    ++error;
                }
            }
            sender.sendMessage("Searched " + total + " offline players. Successfully removed attributes from " + successful + " players. Failed to remove on " + error + " players.");
        } else {
            sender.sendMessage(ChatColor.RED + "Only console may execute this command!");
        }
    }

    @Subcommand(value="claimitems")
    @CommandPermission(value="auraskills.command.claimitems")
    public void onClaimItems(Player player) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (user.getUnclaimedItems().isEmpty()) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.CLAIMITEMS_NO_ITEMS, locale));
            return;
        }
        UnclaimedItemsMenu.getInventory(this.plugin, user).open(player);
    }

    @Subcommand(value="version")
    @CommandPermission(value="auraskills.command.version")
    public void onVersion(CommandSender sender) {
        Locale locale = this.plugin.getLocale(sender);
        new UpdateChecker((Plugin)this.plugin, this.plugin.getResourceId()).getVersion(latestVersion -> sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.VERSION, locale), "{current_version}", this.plugin.getDescription().getVersion(), "{latest_version}", latestVersion)));
    }

    @Subcommand(value="sources")
    @CommandPermission(value="auraskills.command.sources")
    @CommandCompletion(value="@skills @sort_types")
    public void onSources(Player player, Skill skill, @Optional SourcesMenu.SortType sortType) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("skill", skill);
        properties.put("items_per_page", 28);
        if (sortType == null) {
            sortType = SourcesMenu.SortType.ASCENDING;
        }
        properties.put("sort_type", (Object)sortType);
        this.plugin.getSlate().openMenu(player, "sources", properties);
    }

    @Subcommand(value="transfer")
    @CommandPermission(value="auraskills.command.transfer")
    public void onTransfer(CommandSender sender, UUID playerFrom, UUID playerTo) {
        OfflinePlayer offPlayerFrom = Bukkit.getOfflinePlayer((UUID)playerFrom);
        OfflinePlayer offPlayerTo = Bukkit.getOfflinePlayer((UUID)playerTo);
        Locale locale = this.plugin.getLocale(sender);
        CompletableFuture<UserState> future = this.getPlayerDataState(offPlayerFrom);
        future.thenAcceptAsync(oldState -> {
            if (oldState == null) {
                Bukkit.getLogger().warning("Error transferring player data: Player data not found for player " + playerFrom);
                sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.TRANSFER_SUCCESS, locale), "{from}", playerFrom.toString(), "{to}", playerTo.toString()));
                return;
            }
            UserState newState = new UserState(playerTo, oldState.skillLevels(), oldState.skillXp(), oldState.statModifiers(), oldState.traitModifiers(), oldState.mana());
            if (offPlayerTo.isOnline()) {
                User user = this.plugin.getUserManager().getUser(playerTo);
                if (user != null) {
                    user.applyState(newState);
                    sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.TRANSFER_SUCCESS, locale), "{from}", playerFrom.toString(), "{to}", playerTo.toString()));
                } else {
                    this.plugin.logger().warn("Error transferring player data: Player data not found for player " + playerTo);
                    sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.TRANSFER_ERROR, locale));
                }
            } else {
                try {
                    this.plugin.getStorageProvider().applyState(newState);
                    sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.TRANSFER_SUCCESS, locale), "{from}", playerFrom.toString(), "{to}", playerTo.toString()));
                }
                catch (Exception e) {
                    sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.TRANSFER_ERROR, locale));
                }
            }
        });
    }

    private CompletableFuture<UserState> getPlayerDataState(final OfflinePlayer player) {
        final CompletableFuture<UserState> future = new CompletableFuture<UserState>();
        if (player.isOnline()) {
            User user = this.plugin.getUserManager().getUser(player.getUniqueId());
            if (user != null) {
                future.complete(user.getState());
            } else {
                future.complete(null);
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    try {
                        future.complete(SkillsRootCommand.this.plugin.getStorageProvider().loadState(player.getUniqueId()));
                    }
                    catch (Exception e) {
                        future.complete(null);
                        e.printStackTrace();
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
        return future;
    }
}

