/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.HologramsHook;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.trait.DamageReductionTrait;
import dev.aurelium.auraskills.bukkit.trait.HpTrait;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReloadExecutor {
    private final AuraSkills plugin;

    public ReloadExecutor(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void reload(CommandSender sender) {
        Locale locale = this.plugin.getLocale(sender);
        this.plugin.getMessageProvider().loadMessages();
        this.plugin.getMessageProvider().setACFMessages(this.plugin.getCommandManager());
        this.plugin.config().loadOptions();
        this.plugin.getMessageProvider().loadDefaultLanguageOption();
        this.plugin.getWorldManager().loadWorlds(this.plugin.getConfig());
        this.plugin.loadSkills();
        this.plugin.getLevelManager().loadXpRequirements();
        this.plugin.getUiProvider().getBossBarManager().loadOptions();
        this.plugin.getRewardManager().loadRewards();
        this.plugin.getLootTableManager().loadLootTables();
        this.plugin.getTraitManager().getTraitImpl(DamageReductionTrait.class).resetFormula();
        this.plugin.getLevelManager().getLeveler(BlockLeveler.class).clearSourceCache();
        this.plugin.getMenuFileManager().generateDefaultFiles();
        this.plugin.getMenuFileManager().loadMenus();
        this.plugin.getUiProvider().getActionBarManager().resetActionBars();
        if (this.plugin.getHookManager().isRegistered(HologramsHook.class)) {
            this.plugin.getHookManager().getHook(HologramsHook.class).loadConfig();
        }
        this.reloadPlayers();
        sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.RELOAD, locale));
    }

    private void reloadPlayers() {
        HpTrait hpTrait = this.plugin.getTraitManager().getTraitImpl(HpTrait.class);
        for (Player player : Bukkit.getOnlinePlayers()) {
            User user = this.plugin.getUser(player);
            this.plugin.getStatManager().updateStats(user);
            hpTrait.reload(player, Traits.HP);
        }
    }
}

