/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.MessageType;
import dev.aurelium.auraskills.acf.MinecraftMessageKeys;
import dev.aurelium.auraskills.acf.PaperCommandManager;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@CommandAlias(value="%skills_alias")
@Subcommand(value="profile")
public class ProfileCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public ProfileCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="skills")
    @CommandPermission(value="auraskills.command.profile")
    @CommandCompletion(value="@players")
    public void onSkills(final CommandSender sender, final String player) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)player);
        PaperCommandManager manager = this.plugin.getCommandManager();
        if (!offlinePlayer.hasPlayedBefore()) {
            sender.sendMessage(manager.formatMessage(manager.getCommandIssuer(sender), MessageType.ERROR, MinecraftMessageKeys.NO_PLAYER_FOUND, "{search}", player));
            return;
        }
        final UUID uuid = offlinePlayer.getUniqueId();
        if (offlinePlayer.isOnline()) {
            User user = this.plugin.getUser(Bukkit.getPlayer((UUID)uuid));
            this.sendSkillsMessage(sender, player, uuid, user.getSkillLevelMap(), user.getSkillXpMap());
        } else {
            this.plugin.getScheduler().executeAsync(() -> {
                try {
                    final UserState userState = this.plugin.getStorageProvider().loadState(uuid);
                    new BukkitRunnable(){

                        public void run() {
                            ProfileCommand.this.sendSkillsMessage(sender, player, uuid, userState.skillLevels(), userState.skillXp());
                        }
                    }.runTask((Plugin)this.plugin);
                }
                catch (Exception ignored) {
                    sender.sendMessage(manager.formatMessage(manager.getCommandIssuer(sender), MessageType.ERROR, MinecraftMessageKeys.NO_PLAYER_FOUND, "{search}", player));
                }
            });
        }
    }

    @Subcommand(value="stats")
    @CommandPermission(value="auraskills.command.profile")
    @CommandCompletion(value="@players")
    public void onStats(final CommandSender sender, final String player) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)player);
        PaperCommandManager manager = this.plugin.getCommandManager();
        if (!offlinePlayer.hasPlayedBefore()) {
            sender.sendMessage(manager.formatMessage(manager.getCommandIssuer(sender), MessageType.ERROR, MinecraftMessageKeys.NO_PLAYER_FOUND, "{search}", player));
            return;
        }
        final UUID uuid = offlinePlayer.getUniqueId();
        if (offlinePlayer.isOnline()) {
            User playerData = this.plugin.getUser(Bukkit.getPlayer((UUID)uuid));
            this.sendStatsMessage(sender, player, uuid, playerData.getSkillLevelMap(), playerData.getStatModifiers());
        } else {
            this.plugin.getScheduler().executeAsync(() -> {
                try {
                    final UserState userState = this.plugin.getStorageProvider().loadState(uuid);
                    new BukkitRunnable(){

                        public void run() {
                            ProfileCommand.this.sendStatsMessage(sender, player, uuid, userState.skillLevels(), userState.statModifiers());
                        }
                    }.runTask((Plugin)this.plugin);
                }
                catch (Exception ignored) {
                    sender.sendMessage(manager.formatMessage(manager.getCommandIssuer(sender), MessageType.ERROR, MinecraftMessageKeys.NO_PLAYER_FOUND, "{search}", player));
                }
            });
        }
    }

    private void sendSkillsMessage(CommandSender sender, String username, UUID uuid, Map<Skill, Integer> skillLevels, Map<Skill, Double> skillXp) {
        Locale locale = this.plugin.getLocale(sender);
        String message = this.plugin.getMsg(CommandMessage.PROFILE_SKILLS, locale);
        message = TextUtil.replace(message, "{name}", username, "{uuid}", uuid.toString());
        StringBuilder skillEntries = new StringBuilder();
        ArrayList<Skill> skillList = new ArrayList<Skill>(List.copyOf(skillLevels.keySet()));
        skillList.sort(Comparator.comparing(Skill::name));
        for (Skill skill : skillList) {
            skillEntries.append(TextUtil.replace(this.plugin.getMsg(CommandMessage.PROFILE_SKILL_ENTRY, locale), "{skill}", TextUtil.capitalize(skill.name().toLowerCase(Locale.ROOT)), "{level}", String.valueOf(skillLevels.get(skill)), "{xp}", NumberUtil.format1(skillXp.get(skill))));
        }
        message = TextUtil.replace(message, "{skill_entries}", skillEntries.toString());
        sender.sendMessage(message.replaceAll("(\\u005C\\u006E)|(\\n)", "\n"));
    }

    private void sendStatsMessage(CommandSender sender, String username, UUID uuid, Map<Skill, Integer> skillLevels, Map<String, StatModifier> statModifiers) {
        Locale locale = this.plugin.getLocale(sender);
        String message = this.plugin.getMsg(CommandMessage.PROFILE_STATS, locale);
        message = TextUtil.replace(message, "{name}", username, "{uuid}", uuid.toString());
        HashMap<Stat, Double> baseStats = new HashMap<Stat, Double>();
        for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
            Map<Stat, Double> map = this.plugin.getRewardManager().getRewardTable(skill).applyStats(skillLevels.getOrDefault(skill, 1));
            for (Map.Entry<Stat, Double> entry : map.entrySet()) {
                double existing = baseStats.getOrDefault(entry.getKey(), 0.0);
                baseStats.put(entry.getKey(), existing + entry.getValue());
            }
        }
        HashMap<Stat, Double> modifiedStats = new HashMap<Stat, Double>();
        for (StatModifier statModifier : statModifiers.values()) {
            double existing = modifiedStats.getOrDefault(statModifier.stat(), 0.0);
            modifiedStats.put(statModifier.stat(), existing + statModifier.value());
        }
        HashMap<Stat, Double> hashMap = new HashMap<Stat, Double>();
        for (Stat stat : this.plugin.getStatManager().getEnabledStats()) {
            double base = baseStats.getOrDefault(stat, 0.0);
            double modified = modifiedStats.getOrDefault(stat, 0.0);
            hashMap.put(stat, base + modified);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList statList = new ArrayList(List.copyOf(hashMap.keySet()));
        statList.sort(Comparator.comparing(Stat::name));
        for (Stat stat : statList) {
            stringBuilder.append(TextUtil.replace(this.plugin.getMsg(CommandMessage.PROFILE_STAT_ENTRY, locale), "{stat}", TextUtil.capitalize(stat.name().toLowerCase(Locale.ROOT)), "{total_level}", NumberUtil.format1(hashMap.getOrDefault(stat, 0.0)), "{base_level}", NumberUtil.format1(baseStats.getOrDefault(stat, 0.0)), "{modified_level}", NumberUtil.format1(modifiedStats.getOrDefault(stat, 0.0))));
        }
        message = TextUtil.replace(message, "{stat_entries}", stringBuilder.toString());
        sender.sendMessage(message.replaceAll("(\\u005C\\u006E)|(\\n)", "\n"));
    }
}

