/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.stat.StatFormat;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="modifier")
public class ModifierCommand
extends BaseCommand {
    private final AuraSkills plugin;
    private final StatFormat format;

    public ModifierCommand(AuraSkills plugin) {
        this.plugin = plugin;
        this.format = new StatFormat(plugin);
    }

    @Subcommand(value="add")
    @CommandPermission(value="auraskills.command.modifier")
    @CommandCompletion(value="@players @stats @nothing @nothing true true")
    @Description(value="Adds a stat modifier to a player.")
    public void onAdd(CommandSender sender, @Flags(value="other") Player player, Stat stat, String name, double value, @Default(value="false") boolean silent, @Default(value="false") boolean stack) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        StatModifier modifier = new StatModifier(name, stat, value);
        if (!user.getStatModifiers().containsKey(name)) {
            user.addStatModifier(modifier);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_ADD_ADDED, locale), modifier, player, locale));
            }
        } else if (stack) {
            String newModifierName = ModifierCommand.getStackedName(user.getStatModifiers().keySet(), name);
            StatModifier newModifier = new StatModifier(newModifierName, stat, value);
            user.addStatModifier(newModifier);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_ADD_ADDED, locale), newModifier, player, locale));
            }
        } else if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_ADD_ALREADY_EXISTS, locale), modifier, player, locale));
        }
    }

    public static String getStackedName(Set<String> modifierNames, String name) {
        int lastStackNumber = 1;
        for (String modifierName : modifierNames) {
            String numberString;
            int stackNumber;
            String endName;
            if (!modifierName.startsWith(name) || !(endName = modifierName.substring(name.length())).startsWith("(") || !endName.endsWith(")") || (stackNumber = NumberUtil.toInt(numberString = endName.substring(1, endName.length() - 1))) <= lastStackNumber) continue;
            lastStackNumber = stackNumber;
        }
        int newStackNumber = lastStackNumber + 1;
        return name + "(" + newStackNumber + ")";
    }

    @Subcommand(value="remove")
    @CommandPermission(value="auraskills.command.modifier")
    @CommandCompletion(value="@players @modifiers true")
    @Description(value="Removes a specific stat modifier from a player.")
    public void onRemove(CommandSender sender, @Flags(value="other") Player player, String name, @Default(value="false") boolean silent) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (user.removeStatModifier(name)) {
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVE_REMOVED, locale), name, player));
            }
        } else if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVE_NOT_FOUND, locale), name, player));
        }
    }

    @Subcommand(value="list")
    @CommandCompletion(value="@players @stats")
    @CommandPermission(value="auraskills.command.modifier")
    @Description(value="Lists all or a specific stat's modifiers for a player.")
    public void onList(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Stat stat) {
        Locale locale = this.plugin.getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                this.listModifiers(sender, target, stat, locale);
            } else {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.MODIFIER_LIST_PLAYERS_ONLY, locale));
            }
        } else {
            this.listModifiers(sender, player, stat, locale);
        }
    }

    private void listModifiers(CommandSender sender, @Optional @Flags(value="other") Player player, @Optional Stat stat, Locale locale) {
        StringBuilder message;
        User user = this.plugin.getUser(player);
        if (stat == null) {
            message = new StringBuilder(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_LIST_ALL_STATS_HEADER, locale), player));
            for (String key : user.getStatModifiers().keySet()) {
                StatModifier modifier = user.getStatModifiers().get(key);
                message.append("\n").append(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.MODIFIER_LIST_ALL_STATS_ENTRY, locale), modifier, player, locale));
            }
        } else {
            message = new StringBuilder(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.MODIFIER_LIST_ONE_STAT_HEADER, locale), stat, player, locale));
            for (String key : user.getStatModifiers().keySet()) {
                StatModifier modifier = user.getStatModifiers().get(key);
                if (modifier.stat() != stat) continue;
                message.append("\n").append(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.MODIFIER_LIST_ONE_STAT_ENTRY, locale), modifier, player, locale));
            }
        }
        sender.sendMessage(message.toString());
    }

    @Subcommand(value="removeall")
    @CommandCompletion(value="@players @stats")
    @CommandPermission(value="auraskills.command.modifier")
    @Description(value="Removes all stat modifiers from a player.")
    public void onRemoveAll(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Stat stat, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                this.removeAllModifiers(sender, stat, silent, locale, target, this.plugin.getUser(target));
            } else if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.MODIFIER_REMOVEALL_PLAYERS_ONLY, locale));
            }
        } else {
            this.removeAllModifiers(sender, stat, silent, locale, player, this.plugin.getUser(player));
        }
    }

    private void removeAllModifiers(CommandSender sender, @Optional Stat stat, @Default(value="false") boolean silent, Locale locale, Player target, User playerData) {
        if (playerData != null) {
            int removed = 0;
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : playerData.getStatModifiers().keySet()) {
                if (stat == null) {
                    toRemove.add(key);
                    ++removed;
                    continue;
                }
                if (playerData.getStatModifiers().get(key).stat() != stat) continue;
                toRemove.add(key);
                ++removed;
            }
            for (String key : toRemove) {
                playerData.removeStatModifier(key);
            }
            if (!silent) {
                if (stat == null) {
                    sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVEALL_REMOVED_ALL_STATS, locale), target).replace("{num}", String.valueOf(removed)));
                } else {
                    sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVEALL_REMOVED_ONE_STAT, locale), stat, target, locale).replace("{num}", String.valueOf(removed)));
                }
            }
        } else if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.NO_PROFILE, locale));
        }
    }
}

