/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BukkitCommandCompletionContext;
import dev.aurelium.auraskills.acf.BukkitCommandExecutionContext;
import dev.aurelium.auraskills.acf.CommandCompletions;
import dev.aurelium.auraskills.acf.CommandContexts;
import dev.aurelium.auraskills.acf.InvalidCommandArgument;
import dev.aurelium.auraskills.acf.MinecraftMessageKeys;
import dev.aurelium.auraskills.acf.PaperCommandManager;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.CustomStat;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.CustomTrait;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.commands.ArmorCommand;
import dev.aurelium.auraskills.bukkit.commands.BackupCommand;
import dev.aurelium.auraskills.bukkit.commands.ItemCommand;
import dev.aurelium.auraskills.bukkit.commands.JobsCommand;
import dev.aurelium.auraskills.bukkit.commands.JsonArg;
import dev.aurelium.auraskills.bukkit.commands.ManaAbilityCommand;
import dev.aurelium.auraskills.bukkit.commands.ModifierCommand;
import dev.aurelium.auraskills.bukkit.commands.OpenMenuCommand;
import dev.aurelium.auraskills.bukkit.commands.PresetCommand;
import dev.aurelium.auraskills.bukkit.commands.ProfileCommand;
import dev.aurelium.auraskills.bukkit.commands.SkillCommand;
import dev.aurelium.auraskills.bukkit.commands.SkillCommands;
import dev.aurelium.auraskills.bukkit.commands.SkillsRootCommand;
import dev.aurelium.auraskills.bukkit.commands.StatsCommand;
import dev.aurelium.auraskills.bukkit.commands.StorageCommand;
import dev.aurelium.auraskills.bukkit.commands.TraitCommand;
import dev.aurelium.auraskills.bukkit.commands.XpCommand;
import dev.aurelium.auraskills.bukkit.menus.SourcesMenu;
import dev.aurelium.auraskills.common.commands.ManaCommand;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.locales.MessageKeyProvider;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandRegistrar {
    private final AuraSkills plugin;

    public CommandRegistrar(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public PaperCommandManager registerCommands() {
        PaperCommandManager manager = new PaperCommandManager((Plugin)this.plugin);
        manager.enableUnstableAPI("help");
        manager.usePerIssuerLocale(true, false);
        manager.getCommandReplacements().addReplacement("skills_alias", "skills|sk|skill");
        this.registerContexts(manager);
        this.registerCompletions(manager);
        this.registerBaseCommands(manager);
        this.registerSkillCommands(manager);
        return manager;
    }

    private void registerContexts(PaperCommandManager manager) {
        CommandContexts<BukkitCommandExecutionContext> contexts = manager.getCommandContexts();
        contexts.registerContext(User.class, c -> {
            String username = c.popFirstArg();
            Player player = Bukkit.getPlayerExact((String)username);
            if (player != null) {
                return this.plugin.getUser(player);
            }
            throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", username);
        });
        contexts.registerContext(Skill.class, c -> {
            String arg = c.popFirstArg();
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(arg));
            if (skill == null || !skill.isEnabled()) {
                Locale locale = this.plugin.getLocale(c.getSender());
                throw new InvalidCommandArgument(this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
            }
            return skill;
        });
        contexts.registerContext(ManaAbility.class, c -> {
            String arg = c.popFirstArg();
            ManaAbility manaAbility = (ManaAbility)this.plugin.getManaAbilityRegistry().getOrNull(NamespacedId.fromDefault(arg));
            if (manaAbility == null || !manaAbility.isEnabled()) {
                Locale locale = this.plugin.getLocale(c.getSender());
                throw new InvalidCommandArgument(this.plugin.getMsg(CommandMessage.UNKNOWN_MANA_ABILITY, locale));
            }
            return manaAbility;
        });
        contexts.registerContext(Stat.class, c -> {
            String arg = c.popFirstArg();
            Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(arg));
            if (stat == null || !stat.isEnabled()) {
                Locale locale = this.plugin.getLocale(c.getSender());
                throw new InvalidCommandArgument(this.plugin.getMsg(CommandMessage.UNKNOWN_STAT, locale));
            }
            return stat;
        });
        contexts.registerContext(Trait.class, c -> {
            String arg = c.popFirstArg();
            Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromDefault(arg));
            if (trait == null || !trait.isEnabled()) {
                Locale locale = this.plugin.getLocale(c.getSender());
                throw new InvalidCommandArgument(this.plugin.getMsg(CommandMessage.UNKNOWN_TRAIT, locale));
            }
            return trait;
        });
        contexts.registerContext(UUID.class, c -> {
            String input = c.popFirstArg();
            try {
                return UUID.fromString(input);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCommandArgument(input + "is not a valid UUID!");
            }
        });
        contexts.registerContext(JsonArg.class, c -> {
            if (c.getArgs().isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int toAppend = 0;
            for (String arg : c.getArgs()) {
                ++toAppend;
                if (!arg.endsWith("}")) continue;
                break;
            }
            for (int i = 0; i < toAppend; ++i) {
                sb.append(c.popFirstArg());
            }
            return new JsonArg(sb.toString());
        });
    }

    private String getSkillName(Skill skill) {
        if (skill instanceof CustomSkill) {
            return skill.getId().toString();
        }
        return skill.name().toLowerCase(Locale.ROOT);
    }

    private void registerCompletions(PaperCommandManager manager) {
        CommandCompletions<BukkitCommandCompletionContext> completions = manager.getCommandCompletions();
        completions.registerAsyncCompletion("skills", c -> {
            ArrayList<String> skills = new ArrayList<String>();
            for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
                skills.add(this.getSkillName(skill));
            }
            return skills;
        });
        completions.registerAsyncCompletion("mana_abilities", c -> {
            ArrayList<String> abilities = new ArrayList<String>();
            for (ManaAbility manaAbility : this.plugin.getManaAbilityManager().getEnabledManaAbilities()) {
                abilities.add(manaAbility.name().toLowerCase(Locale.ROOT));
            }
            return abilities;
        });
        completions.registerAsyncCompletion("skills_global", c -> {
            ArrayList<String> skills = new ArrayList<String>();
            skills.add("global");
            for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
                skills.add(this.getSkillName(skill));
            }
            return skills;
        });
        completions.registerAsyncCompletion("stats", c -> {
            ArrayList<String> stats = new ArrayList<String>();
            for (Stat stat : this.plugin.getStatManager().getEnabledStats()) {
                if (stat instanceof CustomStat) {
                    stats.add(stat.getId().toString());
                    continue;
                }
                stats.add(stat.name().toLowerCase(Locale.ROOT));
            }
            return stats;
        });
        completions.registerAsyncCompletion("traits", c -> this.plugin.getTraitManager().getEnabledTraits().stream().map(t -> t instanceof CustomTrait ? t.getId().toString() : t.name().toLowerCase(Locale.ROOT)).toList());
        completions.registerAsyncCompletion("modifiers", c -> {
            Player player = c.getPlayer();
            User user = this.plugin.getUser(player);
            return user.getStatModifiers().keySet();
        });
        completions.registerAsyncCompletion("skill_top", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Skill skill : this.plugin.getSkillManager().getEnabledSkills()) {
                values.add(this.getSkillName(skill));
            }
            values.add("average");
            return values;
        });
        completions.registerAsyncCompletion("lang", c -> this.plugin.getMessageProvider().getLanguageCodes());
        completions.registerAsyncCompletion("item_keys", c -> {
            ArrayList<String> keys = new ArrayList<String>();
            for (NamespacedId id : this.plugin.getItemRegistry().getIds()) {
                if (id.getNamespace().equals("auraskills")) {
                    keys.add(id.getKey());
                    continue;
                }
                keys.add(id.toString());
            }
            return keys;
        });
        completions.registerAsyncCompletion("sort_types", c -> {
            SourcesMenu.SortType[] sortTypes = SourcesMenu.SortType.values();
            ArrayList<String> typeNames = new ArrayList<String>();
            for (SourcesMenu.SortType sortType : sortTypes) {
                typeNames.add(sortType.toString().toLowerCase(Locale.ROOT));
            }
            return typeNames;
        });
        completions.registerAsyncCompletion("menu_names", c -> this.plugin.getSlate().getLoadedMenus().keySet());
    }

    private void registerBaseCommands(PaperCommandManager manager) {
        manager.registerCommand(new SkillsRootCommand(this.plugin));
        manager.registerCommand(new StatsCommand(this.plugin));
        manager.registerCommand(new SkillCommand(this.plugin));
        manager.registerCommand(new ManaCommand(this.plugin));
        manager.registerCommand(new ModifierCommand(this.plugin));
        manager.registerCommand(new ItemCommand(this.plugin));
        manager.registerCommand(new ArmorCommand(this.plugin));
        manager.registerCommand(new ProfileCommand(this.plugin));
        manager.registerCommand(new BackupCommand(this.plugin));
        manager.registerCommand(new XpCommand(this.plugin));
        manager.registerCommand(new PresetCommand(this.plugin));
        manager.registerCommand(new StorageCommand(this.plugin));
        manager.registerCommand(new OpenMenuCommand(this.plugin));
        manager.registerCommand(new ManaAbilityCommand(this.plugin));
        manager.registerCommand(new TraitCommand(this.plugin));
        manager.registerCommand(new JobsCommand(this.plugin));
    }

    public void registerSkillCommands(PaperCommandManager manager) {
        if (this.plugin.configBoolean(Option.ENABLE_SKILL_COMMANDS)) {
            Map<Skill, Boolean> map = this.plugin.getSkillManager().loadConfigEnabledMap();
            this.registerSkillCommand(new SkillCommands.FarmingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.ForagingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.MiningCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.FishingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.ExcavationCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.ArcheryCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.DefenseCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.FightingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.EnduranceCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.AgilityCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.AlchemyCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.EnchantingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.SorceryCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.HealingCommand(this.plugin), map, manager);
            this.registerSkillCommand(new SkillCommands.ForgingCommand(this.plugin), map, manager);
        }
    }

    private void registerSkillCommand(SkillCommands.SkillCommand command, Map<Skill, Boolean> enabled, PaperCommandManager manager) {
        if (enabled.getOrDefault(command.skill, false).booleanValue()) {
            manager.registerCommand(command);
        }
    }
}

