/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.InvalidCommandArgument;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.stat.StatFormat;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@CommandAlias(value="%skills_alias")
@Subcommand(value="armor")
public class ArmorCommand
extends BaseCommand {
    private final AuraSkills plugin;
    private final StatFormat format;

    public ArmorCommand(AuraSkills plugin) {
        this.plugin = plugin;
        this.format = new StatFormat(plugin);
    }

    @Subcommand(value="modifier add")
    @CommandCompletion(value="@stats @nothing false|true")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Adds an armor stat modifier to the item held, along with lore by default.")
    public void onArmorModifierAdd(@Flags(value="itemheld") Player player, Stat stat, int value, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
            if (statModifier.stat() != stat) continue;
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_ADD_ALREADY_EXISTS, locale), stat, locale));
            return;
        }
        if (lore) {
            skillsItem.addModifierLore(ModifierType.ARMOR, stat, value, locale);
        }
        skillsItem.addModifier(SkillsItem.MetaType.MODIFIER, ModifierType.ARMOR, stat, value);
        ItemStack newItem = skillsItem.getItem();
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_ADD_ADDED, locale), stat, (double)value, locale));
    }

    @Subcommand(value="modifier remove")
    @CommandCompletion(value="@stats false|true")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Removes an armor stat modifier from the item held, and the lore associated with it by default.")
    public void onArmorModifierRemove(@Flags(value="itemheld") Player player, Stat stat, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
            if (modifier.stat() != stat) continue;
            skillsItem.removeModifier(SkillsItem.MetaType.MODIFIER, ModifierType.ARMOR, stat);
            removed = true;
            break;
        }
        if (lore) {
            skillsItem.removeModifierLore(stat, locale);
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVE_REMOVED, locale), stat, locale));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), stat, locale));
        }
    }

    @Subcommand(value="modifier list")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Lists all armor stat modifiers on the item held.")
    public void onArmorModifierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ARMOR)) {
            message.append("\n").append(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="modifier removeall")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Removes all armor stat modifiers from the item held.")
    public void onArmorModifierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        SkillsItem skillsItem = new SkillsItem(player.getInventory().getItemInMainHand(), this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.MODIFIER, ModifierType.ARMOR);
        ItemStack item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="trait add")
    @CommandCompletion(value="@traits @nothing false|true")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Adds an armor trait modifier to the item held, along with lore by default.")
    public void onItemTraitAdd(@Flags(value="itemheld") Player player, Trait trait, double value, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
            if (!modifier.trait().equals(trait)) continue;
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_TRAIT_ADD_ALREADY_EXISTS, locale), trait, locale));
            return;
        }
        if (lore) {
            skillsItem.addModifierLore(ModifierType.ARMOR, trait, value, locale);
        }
        skillsItem.addModifier(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ARMOR, trait, value);
        ItemStack newItem = skillsItem.getItem();
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_ADD_ADDED, locale), trait, value, locale));
    }

    @Subcommand(value="trait remove")
    @CommandCompletion(value="@traits")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Removes an armor trait modifier from the item held.")
    public void onItemTraitRemove(@Flags(value="itemheld") Player player, Trait trait) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
            if (!modifier.trait().equals(trait)) continue;
            skillsItem.removeModifier(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ARMOR, trait);
            removed = true;
            break;
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVE_REMOVED, locale), trait, locale));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), trait, locale));
        }
    }

    @Subcommand(value="trait list")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Lists all item trait modifiers on the item held.")
    public void onItemTraitList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ARMOR)) {
            message.append("\n").append(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="trait removeall")
    @CommandPermission(value="auraskills.command.armor.modifier")
    @Description(value="Removes all armor trait modifiers from the item held.")
    public void onItemTraitRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ARMOR);
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ARMOR_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="requirement add")
    @CommandPermission(value="auraskills.command.armor.requirement")
    @CommandCompletion(value="@skills @nothing false|true")
    @Description(value="Adds an armor requirement to the item held, along with lore by default")
    public void onArmorRequirementAdd(@Flags(value="itemheld") Player player, Skill skill, int level, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skillsItem.getRequirements(ModifierType.ARMOR).containsKey(skill)) {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_ADD_ALREADY_EXISTS, locale), "{skill}", skill.getDisplayName(locale)));
            return;
        }
        skillsItem.addRequirement(ModifierType.ARMOR, skill, level);
        if (lore) {
            skillsItem.addRequirementLore(ModifierType.ARMOR, skill, level, locale);
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_ADD_ADDED, locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level)));
    }

    @Subcommand(value="requirement remove")
    @CommandPermission(value="auraskills.command.armor.requirement")
    @CommandCompletion(value="@skills false|true")
    @Description(value="Removes an armor requirement from the item held, along with the lore associated it by default.")
    public void onArmorRequirementRemove(@Flags(value="itemheld") Player player, Skill skill, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skillsItem.getRequirements(ModifierType.ARMOR).containsKey(skill)) {
            skillsItem.removeRequirement(ModifierType.ARMOR, skill);
            if (lore) {
                skillsItem.removeRequirementLore(skill);
            }
            item = skillsItem.getItem();
            player.getInventory().setItemInMainHand(item);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_REMOVE_REMOVED, locale), "{skill}", skill.getDisplayName(locale)));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_REMOVE_DOES_NOT_EXIST, locale), "{skill}", skill.getDisplayName(locale)));
        }
    }

    @Subcommand(value="requirement list")
    @CommandPermission(value="auraskills.command.armor.requirement")
    @Description(value="Lists the armor requirements on the item held.")
    public void onArmorRequirementList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        player.sendMessage(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(player.getInventory().getItemInMainHand(), this.plugin);
        for (Map.Entry<Skill, Integer> entry : skillsItem.getRequirements(ModifierType.ARMOR).entrySet()) {
            player.sendMessage(TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_LIST_ENTRY, locale), "{skill}", entry.getKey().getDisplayName(locale), "{level}", String.valueOf(entry.getValue())));
        }
    }

    @Subcommand(value="requirement removeall")
    @CommandPermission(value="auraskills.command.armor.requirement")
    @Description(value="Removes all armor requirements from the item held.")
    public void onArmorRequirementRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        SkillsItem skillsItem = new SkillsItem(player.getInventory().getItemInMainHand(), this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.REQUIREMENT, ModifierType.ARMOR);
        ItemStack item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ARMOR_REQUIREMENT_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="multiplier add")
    @CommandCompletion(value="@skills_global @nothing true|false")
    @CommandPermission(value="auraskills.command.armor.multiplier")
    @Description(value="Adds an armor multiplier to the held item to global or a specific skill where value is the percent more XP gained.")
    public void onArmorMultiplierAdd(@Flags(value="itemheld") Player player, String target, double value, @Default(value="true") boolean lore) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(target));
        Locale locale = this.plugin.getUser(player).getLocale();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skill != null) {
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                if (multiplier.skill() != skill) continue;
                player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", skill.getDisplayName(locale)));
                return;
            }
            if (lore) {
                skillsItem.addMultiplierLore(ModifierType.ARMOR, skill, value, locale);
            }
            skillsItem.addMultiplier(ModifierType.ARMOR, skill, value);
            ItemStack newItem = skillsItem.getItem();
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_ADD_ADDED, locale), "{target}", skill.getDisplayName(locale), "{value}", String.valueOf(value)));
        } else if (target.equalsIgnoreCase("global")) {
            String global = this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
                if (multiplier.skill() != null) continue;
                player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", global));
                return;
            }
            if (lore) {
                skillsItem.addMultiplierLore(ModifierType.ARMOR, null, value, locale);
            }
            skillsItem.addMultiplier(ModifierType.ARMOR, null, value);
            ItemStack newItem = skillsItem.getItem();
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_ADD_ADDED, locale), "{target}", global, "{value}", String.valueOf(value)));
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
    }

    @Subcommand(value="multiplier remove")
    @CommandCompletion(value="@skills_global")
    @CommandPermission(value="auraskills.command.armor.multiplier")
    @Description(value="Removes an armor multiplier of a the specified skill or global from the held item.")
    public void onArmorMultiplierRemove(@Flags(value="itemheld") Player player, String target) {
        String targetName;
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(target));
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
            if (multiplier.skill() != skill) continue;
            skillsItem.removeMultiplier(ModifierType.ARMOR, skill);
            removed = true;
            break;
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (skill != null) {
            targetName = skill.getDisplayName(locale);
        } else if (target.equalsIgnoreCase("global")) {
            targetName = this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_REMOVE_REMOVED, locale), "{target}", targetName));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_REMOVE_DOES_NOT_EXIST, locale), "{target}", targetName));
        }
    }

    @Subcommand(value="multiplier list")
    @CommandPermission(value="auraskills.command.armor.multiplier")
    @Description(value="Lists all armor multipliers on the held item.")
    public void onArmorMultiplierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ARMOR)) {
            String targetName = multiplier.skill() != null ? multiplier.skill().getDisplayName(locale) : this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
            message.append("\n").append(TextUtil.replace(this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_LIST_ENTRY, locale), "{target}", targetName, "{value}", String.valueOf(multiplier.value())));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="multiplier removeall")
    @CommandPermission(value="auraskills.command.armor.multiplier")
    @Description(value="Removes all armor multipliers from the item held.")
    public void onArmorMultiplierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        SkillsItem skillsItem = new SkillsItem(player.getInventory().getItemInMainHand(), this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.MULTIPLIER, ModifierType.ARMOR);
        player.getInventory().setItemInMainHand(skillsItem.getItem());
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ARMOR_MULTIPLIER_REMOVEALL_REMOVED, locale));
    }
}

