/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.ability;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.AbilityImpl;
import dev.aurelium.auraskills.bukkit.skills.agility.AgilityAbilities;
import dev.aurelium.auraskills.bukkit.skills.alchemy.AlchemyAbilities;
import dev.aurelium.auraskills.bukkit.skills.archery.ArcheryAbilities;
import dev.aurelium.auraskills.bukkit.skills.defense.DefenseAbilities;
import dev.aurelium.auraskills.bukkit.skills.enchanting.EnchantingAbilities;
import dev.aurelium.auraskills.bukkit.skills.endurance.EnduranceAbilities;
import dev.aurelium.auraskills.bukkit.skills.excavation.ExcavationAbilities;
import dev.aurelium.auraskills.bukkit.skills.farming.FarmingAbilities;
import dev.aurelium.auraskills.bukkit.skills.fighting.FightingAbilities;
import dev.aurelium.auraskills.bukkit.skills.fishing.FishingAbilities;
import dev.aurelium.auraskills.bukkit.skills.foraging.ForagingAbilities;
import dev.aurelium.auraskills.bukkit.skills.forging.ForgingAbilities;
import dev.aurelium.auraskills.bukkit.skills.healing.HealingAbilities;
import dev.aurelium.auraskills.bukkit.skills.mining.MiningAbilities;
import dev.aurelium.auraskills.common.ability.AbilityManager;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BukkitAbilityManager
extends AbilityManager {
    private final AuraSkills plugin;
    private final Map<Class<?>, AbilityImpl> abilityImpls = new HashMap();

    public BukkitAbilityManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void registerAbilityImplementations() {
        this.registerAbilityImpl(new FishingAbilities(this.plugin));
        this.registerAbilityImpl(new EnduranceAbilities(this.plugin));
        this.registerAbilityImpl(new AgilityAbilities(this.plugin));
        this.registerAbilityImpl(new AlchemyAbilities(this.plugin));
        this.registerAbilityImpl(new EnchantingAbilities(this.plugin));
        this.registerAbilityImpl(new HealingAbilities(this.plugin));
        this.registerAbilityImpl(new ForgingAbilities(this.plugin));
        this.registerAbilityImpl(new FightingAbilities(this.plugin));
        this.registerAbilityImpl(new ArcheryAbilities(this.plugin));
        this.registerAbilityImpl(new FarmingAbilities(this.plugin));
        this.registerAbilityImpl(new ForagingAbilities(this.plugin));
        this.registerAbilityImpl(new MiningAbilities(this.plugin));
        this.registerAbilityImpl(new ExcavationAbilities(this.plugin));
        this.registerAbilityImpl(new DefenseAbilities(this.plugin));
    }

    public void registerAbilityImpl(AbilityImpl abilityImpl) {
        this.abilityImpls.put(abilityImpl.getClass(), abilityImpl);
        Bukkit.getPluginManager().registerEvents((Listener)abilityImpl, (Plugin)this.plugin);
    }

    public <T extends AbilityImpl> T getAbilityImpl(Class<T> clazz) {
        AbilityImpl abilityImpl = this.abilityImpls.get(clazz);
        if (abilityImpl != null) {
            return (T)((AbilityImpl)clazz.cast(abilityImpl));
        }
        throw new IllegalArgumentException("Ability implementation of type " + clazz.getSimpleName() + " not found!");
    }

    @Nullable
    public AbilityImpl getAbilityImpl(Ability ability) {
        for (AbilityImpl impl : this.abilityImpls.values()) {
            if (!impl.getAbilities().contains(ability)) continue;
            return impl;
        }
        return null;
    }

    public void sendMessage(Player player, String message) {
        User user = this.plugin.getUser(player);
        if (this.plugin.configBoolean(Option.ACTION_BAR_ABILITY) && this.plugin.configBoolean(Option.ACTION_BAR_ENABLED)) {
            this.plugin.getUiProvider().getActionBarManager().sendAbilityActionBar(user, message);
        } else {
            if (message == null || message.isEmpty()) {
                return;
            }
            player.sendMessage(this.plugin.getPrefix(user.getLocale()) + message);
        }
    }

    @Override
    public String getBaseDescription(Ability ability, User user, boolean formatted) {
        String desc = ability.getDescription(user.getLocale(), formatted);
        AbilityImpl impl = this.plugin.getAbilityManager().getAbilityImpl(ability);
        if (impl != null) {
            desc = impl.replaceDescPlaceholders(desc, ability, user);
        }
        return desc;
    }
}

