/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.acf.PaperCommandManager;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.AuraSkillsBukkit;
import dev.aurelium.auraskills.api.event.skill.SkillsLoadEvent;
import dev.aurelium.auraskills.api.item.ItemManager;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.bstats.bukkit.Metrics;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityManager;
import dev.aurelium.auraskills.bukkit.api.ApiAuraSkillsBukkit;
import dev.aurelium.auraskills.bukkit.api.ApiBukkitRegistrationUtil;
import dev.aurelium.auraskills.bukkit.api.implementation.BukkitApiProvider;
import dev.aurelium.auraskills.bukkit.commands.CommandRegistrar;
import dev.aurelium.auraskills.bukkit.commands.ConfirmManager;
import dev.aurelium.auraskills.bukkit.config.BukkitConfigProvider;
import dev.aurelium.auraskills.bukkit.event.BukkitEventHandler;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardFlags;
import dev.aurelium.auraskills.bukkit.item.ApiItemManager;
import dev.aurelium.auraskills.bukkit.item.BukkitItemRegistry;
import dev.aurelium.auraskills.bukkit.jobs.JobsListener;
import dev.aurelium.auraskills.bukkit.level.BukkitLevelManager;
import dev.aurelium.auraskills.bukkit.listeners.CriticalHandler;
import dev.aurelium.auraskills.bukkit.listeners.DamageListener;
import dev.aurelium.auraskills.bukkit.listeners.PlayerDeath;
import dev.aurelium.auraskills.bukkit.listeners.PlayerJoinQuit;
import dev.aurelium.auraskills.bukkit.logging.BukkitLogger;
import dev.aurelium.auraskills.bukkit.loot.LootTableManager;
import dev.aurelium.auraskills.bukkit.loot.handler.BlockLootHandler;
import dev.aurelium.auraskills.bukkit.loot.handler.FishingLootHandler;
import dev.aurelium.auraskills.bukkit.loot.handler.MobLootHandler;
import dev.aurelium.auraskills.bukkit.mana.BukkitManaAbilityManager;
import dev.aurelium.auraskills.bukkit.menus.MenuFileManager;
import dev.aurelium.auraskills.bukkit.menus.MenuOptions;
import dev.aurelium.auraskills.bukkit.menus.MenuRegistrar;
import dev.aurelium.auraskills.bukkit.menus.util.SlateMenuHelper;
import dev.aurelium.auraskills.bukkit.message.BukkitMessageProvider;
import dev.aurelium.auraskills.bukkit.modifier.ArmorModifierListener;
import dev.aurelium.auraskills.bukkit.modifier.ItemListener;
import dev.aurelium.auraskills.bukkit.modifier.ModifierManager;
import dev.aurelium.auraskills.bukkit.region.BukkitRegionManager;
import dev.aurelium.auraskills.bukkit.region.BukkitWorldManager;
import dev.aurelium.auraskills.bukkit.region.RegionBlockListener;
import dev.aurelium.auraskills.bukkit.region.RegionListener;
import dev.aurelium.auraskills.bukkit.requirement.RequirementListener;
import dev.aurelium.auraskills.bukkit.requirement.RequirementManager;
import dev.aurelium.auraskills.bukkit.reward.BukkitRewardManager;
import dev.aurelium.auraskills.bukkit.scheduler.BukkitScheduler;
import dev.aurelium.auraskills.bukkit.stat.BukkitStatManager;
import dev.aurelium.auraskills.bukkit.storage.BukkitStorageFactory;
import dev.aurelium.auraskills.bukkit.trait.BukkitTraitManager;
import dev.aurelium.auraskills.bukkit.ui.BukkitUiProvider;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.user.BukkitUserManager;
import dev.aurelium.auraskills.bukkit.util.BukkitPlatformUtil;
import dev.aurelium.auraskills.bukkit.util.MetricsUtil;
import dev.aurelium.auraskills.bukkit.util.armor.ArmorListener;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityRegistry;
import dev.aurelium.auraskills.common.api.ApiAuraSkills;
import dev.aurelium.auraskills.common.api.ApiRegistrationUtil;
import dev.aurelium.auraskills.common.api.implementation.ApiProvider;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.config.preset.PresetManager;
import dev.aurelium.auraskills.common.event.EventHandler;
import dev.aurelium.auraskills.common.hooks.HookManager;
import dev.aurelium.auraskills.common.leaderboard.LeaderboardManager;
import dev.aurelium.auraskills.common.level.XpRequirements;
import dev.aurelium.auraskills.common.mana.ManaAbilityRegistry;
import dev.aurelium.auraskills.common.menu.MenuHelper;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.PlatformLogger;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.migration.MigrationManager;
import dev.aurelium.auraskills.common.reward.RewardManager;
import dev.aurelium.auraskills.common.scheduler.Scheduler;
import dev.aurelium.auraskills.common.skill.SkillLoader;
import dev.aurelium.auraskills.common.skill.SkillManager;
import dev.aurelium.auraskills.common.skill.SkillRegistry;
import dev.aurelium.auraskills.common.source.SourceTypeRegistry;
import dev.aurelium.auraskills.common.stat.StatLoader;
import dev.aurelium.auraskills.common.stat.StatManager;
import dev.aurelium.auraskills.common.stat.StatRegistry;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.StorageType;
import dev.aurelium.auraskills.common.storage.backup.BackupProvider;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.trait.TraitRegistry;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.PlatformUtil;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.kyori.adventure.platform.bukkit.BukkitAudiences;
import dev.aurelium.auraskills.nbtapi.utils.MinecraftVersion;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.inv.InventoryManager;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class AuraSkills
extends JavaPlugin
implements AuraSkillsPlugin {
    private AuraSkillsApi api;
    private AuraSkillsBukkit apiBukkit;
    private ApiProvider apiProvider;
    private SkillManager skillManager;
    private BukkitAbilityManager abilityManager;
    private BukkitManaAbilityManager manaAbilityManager;
    private StatManager statManager;
    private BukkitTraitManager traitManager;
    private SkillRegistry skillRegistry;
    private StatRegistry statRegistry;
    private TraitRegistry traitRegistry;
    private AbilityRegistry abilityRegistry;
    private ManaAbilityRegistry manaAbilityRegistry;
    private SourceTypeRegistry sourceTypeRegistry;
    private BukkitItemRegistry itemRegistry;
    private PlatformLogger logger;
    private BukkitMessageProvider messageProvider;
    private BukkitConfigProvider configProvider;
    private BukkitLevelManager levelManager;
    private BukkitUserManager userManager;
    private XpRequirements xpRequirements;
    private HookManager hookManager;
    private WorldGuardFlags worldGuardFlags;
    private LeaderboardManager leaderboardManager;
    private BukkitUiProvider uiProvider;
    private RewardManager rewardManager;
    private Scheduler scheduler;
    private StorageProvider storageProvider;
    private Slate slate;
    private MenuFileManager menuFileManager;
    private PaperCommandManager commandManager;
    private BukkitAudiences audiences;
    private BukkitRegionManager regionManager;
    private BukkitWorldManager worldManager;
    private LootTableManager lootTableManager;
    private ModifierManager modifierManager;
    private RequirementManager requirementManager;
    private BackupProvider backupProvider;
    private InventoryManager inventoryManager;
    private MenuHelper menuHelper;
    private EventHandler eventHandler;
    private ItemManager itemManager;
    private ConfirmManager confirmManager;
    private PresetManager presetManager;
    private PlatformUtil platformUtil;
    private boolean nbtApiEnabled;

    public void onEnable() {
        this.api = new ApiAuraSkills(this);
        this.apiProvider = new BukkitApiProvider(this);
        ApiRegistrationUtil.register(this.api);
        this.itemManager = new ApiItemManager(this);
        this.apiBukkit = new ApiAuraSkillsBukkit(this);
        ApiBukkitRegistrationUtil.register(this.apiBukkit);
        this.logger = new BukkitLogger(this);
        this.platformUtil = new BukkitPlatformUtil();
        this.messageProvider = new BukkitMessageProvider(this);
        this.messageProvider.loadMessages();
        this.skillManager = new SkillManager(this);
        this.abilityManager = new BukkitAbilityManager(this);
        this.manaAbilityManager = new BukkitManaAbilityManager(this);
        this.statManager = new BukkitStatManager(this);
        this.traitManager = new BukkitTraitManager(this);
        this.skillRegistry = new SkillRegistry(this);
        this.statRegistry = new StatRegistry(this);
        this.traitRegistry = new TraitRegistry(this);
        this.abilityRegistry = new AbilityRegistry(this);
        this.manaAbilityRegistry = new ManaAbilityRegistry(this);
        this.sourceTypeRegistry = new SourceTypeRegistry(this);
        this.sourceTypeRegistry.registerDefaults();
        this.itemRegistry = new BukkitItemRegistry(this);
        this.itemRegistry.getStorage().load();
        this.scheduler = new BukkitScheduler(this);
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.eventHandler = new BukkitEventHandler(this);
        this.hookManager = new HookManager();
        this.userManager = new BukkitUserManager(this);
        this.presetManager = new PresetManager(this);
        this.generateConfigs();
        this.generateDefaultMenuFiles();
        MigrationManager migrationManager = new MigrationManager(this);
        migrationManager.attemptConfigMigration();
        this.configProvider = new BukkitConfigProvider(this);
        this.configProvider.loadOptions();
        this.initializeNbtApi();
        this.initializeMenus();
        this.initStorageProvider();
        migrationManager.attemptUserMigration();
        this.worldManager = new BukkitWorldManager(this);
        this.worldManager.loadWorlds(this.getConfig());
        this.regionManager = new BukkitRegionManager(this);
        this.backupProvider = new BackupProvider(this);
        this.xpRequirements = new XpRequirements(this);
        this.leaderboardManager = new LeaderboardManager(this);
        this.uiProvider = new BukkitUiProvider(this);
        this.modifierManager = new ModifierManager(this);
        this.inventoryManager = new InventoryManager(this);
        this.inventoryManager.init();
        this.rewardManager = new BukkitRewardManager(this);
        this.lootTableManager = new LootTableManager(this);
        this.confirmManager = new ConfirmManager(this);
        CommandRegistrar commandRegistrar = new CommandRegistrar(this);
        this.commandManager = commandRegistrar.registerCommands();
        this.messageProvider.setACFMessages(this.commandManager);
        this.levelManager = new BukkitLevelManager(this);
        this.registerPriorityEvents();
        Metrics metrics = new Metrics(this, 21318);
        this.scheduler.executeSync(() -> {
            this.loadSkills();
            this.levelManager.registerLevelers();
            this.levelManager.loadXpRequirements();
            this.uiProvider.getBossBarManager().loadOptions();
            this.requirementManager = new RequirementManager(this);
            this.rewardManager.loadRewards();
            this.lootTableManager.loadLootTables();
            this.traitManager.registerTraitImplementations();
            this.abilityManager.registerAbilityImplementations();
            this.manaAbilityManager.registerProviders();
            this.registerEvents();
            this.registerAndLoadMenus();
            SkillsLoadEvent event = new SkillsLoadEvent(this.skillManager.getSkillValues());
            Bukkit.getPluginManager().callEvent((Event)event);
            this.leaderboardManager.updateLeaderboards();
            this.leaderboardManager.startLeaderboardUpdater();
            new MetricsUtil(this.getInstance()).registerCustomCharts(metrics);
        });
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null && WorldGuardPlugin.inst().getDescription().getVersion().startsWith("7.")) {
            this.worldGuardFlags = new WorldGuardFlags(this);
            this.worldGuardFlags.register();
        }
    }

    public void onDisable() {
        this.scheduler.shutdown();
        for (User user : this.userManager.getUserMap().values()) {
            user.cleanUp();
            try {
                this.storageProvider.save(user);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.userManager.getUserMap().clear();
        this.regionManager.saveAllRegions(false, true);
        this.regionManager.clearRegionMap();
        try {
            this.backupAutomatically();
        }
        catch (Exception e) {
            this.logger.warn("Error creating automatic backup");
            e.printStackTrace();
        }
        StorageProvider storageProvider = this.storageProvider;
        if (storageProvider instanceof SqlStorageProvider) {
            SqlStorageProvider sqlStorageProvider = (SqlStorageProvider)storageProvider;
            sqlStorageProvider.getPool().disable();
        }
        this.itemRegistry.getStorage().save();
    }

    private void backupAutomatically() throws Exception {
        if (!this.configBoolean(Option.AUTOMATIC_BACKUPS_ENABLED)) {
            return;
        }
        File metaFile = new File(this.getDataFolder(), "/backups/meta.yml");
        ConfigurationNode metaConfig = FileUtil.loadYamlFile(metaFile);
        long lastBackup = metaConfig.node("last_automatic_backup").getLong(0L);
        if (lastBackup + (long)(this.configDouble(Option.AUTOMATIC_BACKUPS_MINIMUM_INTERVAL_HOURS) * 3600000.0) <= System.currentTimeMillis()) {
            if (this.backupProvider == null) {
                return;
            }
            metaConfig.node("last_automatic_backup").set(System.currentTimeMillis());
            FileUtil.saveYamlFile(metaFile, metaConfig);
            this.backupProvider.saveBackup(false);
        }
    }

    public void generateConfigs() {
        ConfigurateLoader loader = new ConfigurateLoader(this, null);
        loader.generateUserFile("config.yml");
        loader.generateUserFile("skills.yml");
        loader.generateUserFile("stats.yml");
        loader.generateUserFile("abilities.yml");
        loader.generateUserFile("mana_abilities.yml");
        loader.generateUserFile("xp_requirements.yml");
        for (Skills skill : Skills.values()) {
            String sources = "sources/" + skill.name().toLowerCase(Locale.ROOT) + ".yml";
            loader.generateUserFile(sources);
        }
        File legacyPreset = new File(this.getPluginFolder(), "presets/legacy.zip");
        if (!legacyPreset.exists()) {
            this.saveResource("presets/legacy.zip", false);
        }
    }

    public void loadSkills() {
        SkillLoader skillLoader = new SkillLoader(this);
        skillLoader.loadSkills();
        StatLoader statLoader = new StatLoader(this);
        statLoader.loadStats();
    }

    private void generateDefaultMenuFiles() {
        this.menuFileManager = new MenuFileManager(this);
        this.menuFileManager.generateDefaultFiles();
        this.menuFileManager.updateMenus();
    }

    private void initializeMenus() {
        this.slate = new Slate(this, new MenuOptions(this).getBaseOptions());
        this.menuHelper = new SlateMenuHelper(this.slate);
    }

    private void initializeNbtApi() {
        if (MinecraftVersion.getVersion() == MinecraftVersion.UNKNOWN) {
            this.getLogger().warning("NBT API is not yet supported for your Minecraft version, item modifier, requirement, and some other functionality is disabled!");
            this.nbtApiEnabled = false;
        } else {
            this.nbtApiEnabled = true;
        }
    }

    private void registerAndLoadMenus() {
        new MenuRegistrar(this).register();
        this.menuFileManager.loadMenus();
    }

    private void initStorageProvider() {
        StorageType type = this.configBoolean(Option.SQL_ENABLED) ? StorageType.MYSQL : StorageType.YAML;
        BukkitStorageFactory storageFactory = new BukkitStorageFactory(this);
        this.storageProvider = storageFactory.createStorageProvider(type);
        this.storageProvider.startAutoSaving();
    }

    private void registerPriorityEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerJoinQuit(this), (Plugin)this);
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new DamageListener(this), (Plugin)this);
        pm.registerEvents((Listener)new CriticalHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new BlockLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new FishingLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new MobLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new RequirementListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ItemListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ArmorListener(this.configStringList(Option.MODIFIER_ARMOR_EQUIP_BLOCKED_MATERIALS)), (Plugin)this);
        pm.registerEvents((Listener)new ArmorModifierListener(this), (Plugin)this);
        pm.registerEvents((Listener)new RegionListener(this), (Plugin)this);
        pm.registerEvents((Listener)new RegionBlockListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerDeath(this), (Plugin)this);
        pm.registerEvents((Listener)new JobsListener(this), (Plugin)this);
    }

    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    public Slate getSlate() {
        return this.slate;
    }

    public MenuFileManager getMenuFileManager() {
        return this.menuFileManager;
    }

    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    public BukkitRegionManager getRegionManager() {
        return this.regionManager;
    }

    public LootTableManager getLootTableManager() {
        return this.lootTableManager;
    }

    public ModifierManager getModifierManager() {
        return this.modifierManager;
    }

    public RequirementManager getRequirementManager() {
        return this.requirementManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public ConfirmManager getConfirmManager() {
        return this.confirmManager;
    }

    public int getResourceId() {
        return 81069;
    }

    public AuraSkillsBukkit getApiBukkit() {
        return this.apiBukkit;
    }

    @Nullable
    public WorldGuardFlags getWorldGuardFlags() {
        return this.worldGuardFlags;
    }

    @Override
    public AuraSkillsApi getApi() {
        return this.api;
    }

    @Override
    public BukkitMessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @Override
    public BukkitConfigProvider config() {
        return this.configProvider;
    }

    @Override
    public BukkitAbilityManager getAbilityManager() {
        return this.abilityManager;
    }

    @Override
    public BukkitManaAbilityManager getManaAbilityManager() {
        return this.manaAbilityManager;
    }

    @Override
    public StatManager getStatManager() {
        return this.statManager;
    }

    @Override
    public BukkitItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    @Override
    public BukkitLevelManager getLevelManager() {
        return this.levelManager;
    }

    @Override
    public BukkitUserManager getUserManager() {
        return this.userManager;
    }

    @NotNull
    public User getUser(Player player) {
        return this.userManager.getUser(player);
    }

    @Override
    public XpRequirements getXpRequirements() {
        return this.xpRequirements;
    }

    @Override
    public PlatformLogger logger() {
        return this.logger;
    }

    @Override
    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    @Override
    public SkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    @Override
    public StatRegistry getStatRegistry() {
        return this.statRegistry;
    }

    @Override
    public TraitRegistry getTraitRegistry() {
        return this.traitRegistry;
    }

    @Override
    public BukkitTraitManager getTraitManager() {
        return this.traitManager;
    }

    @Override
    public AbilityRegistry getAbilityRegistry() {
        return this.abilityRegistry;
    }

    @Override
    public ManaAbilityRegistry getManaAbilityRegistry() {
        return this.manaAbilityRegistry;
    }

    @Override
    public SourceTypeRegistry getSourceTypeRegistry() {
        return this.sourceTypeRegistry;
    }

    @Override
    public HookManager getHookManager() {
        return this.hookManager;
    }

    @Override
    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    @Override
    public BukkitUiProvider getUiProvider() {
        return this.uiProvider;
    }

    @Override
    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    @Override
    public BackupProvider getBackupProvider() {
        return this.backupProvider;
    }

    @Override
    public BukkitWorldManager getWorldManager() {
        return this.worldManager;
    }

    @Override
    public MenuHelper getMenuHelper() {
        return this.menuHelper;
    }

    @Override
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public PresetManager getPresetManager() {
        return this.presetManager;
    }

    @Override
    public PlatformUtil getPlatformUtil() {
        return this.platformUtil;
    }

    @Override
    public ApiProvider getApiProvider() {
        return this.apiProvider;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    @Override
    public String getMsg(MessageKey key, Locale locale) {
        return this.messageProvider.get(key, locale);
    }

    public String getRawMsg(MessageKey key, Locale locale) {
        return this.messageProvider.getRaw(key, locale);
    }

    @Override
    public String getPrefix(Locale locale) {
        return this.messageProvider.get(CommandMessage.PREFIX, locale);
    }

    @Override
    public void runConsoleCommand(String command) {
        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
    }

    @Override
    public void runPlayerCommand(User user, String command) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player != null) {
            this.getServer().dispatchCommand((CommandSender)player, command);
        }
    }

    @Override
    public InputStream getResource(@NotNull String path) {
        return super.getResource(path);
    }

    @Override
    public void saveResource(@NotNull String path, boolean replace) {
        super.saveResource(path, replace);
    }

    @Override
    public File getPluginFolder() {
        return this.getDataFolder();
    }

    public Locale getLocale(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.getUser(player).getLocale();
        }
        return this.messageProvider.getDefaultLanguage();
    }

    public Locale getLocale(CommandIssuer issuer) {
        if (issuer.isPlayer()) {
            User user = this.userManager.getUser(issuer.getUniqueId());
            return user != null ? user.getLocale() : this.messageProvider.getDefaultLanguage();
        }
        return this.messageProvider.getDefaultLanguage();
    }

    public boolean isNbtApiDisabled() {
        return !this.nbtApiEnabled;
    }

    private AuraSkills getInstance() {
        return this;
    }
}

