/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.source;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import java.lang.reflect.Array;
import java.util.List;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class BaseContext {
    protected final AuraSkillsApi api;

    public BaseContext(AuraSkillsApi api) {
        this.api = api;
    }

    public AuraSkillsApi getApi() {
        return this.api;
    }

    public ConfigurationNode required(ConfigurationNode node, String path) {
        if (!node.hasChild(path)) {
            throw new IllegalArgumentException("Missing required field: " + path);
        }
        return node.node(path);
    }

    public <V> V[] requiredPluralizedArray(String key, ConfigurationNode source, Class<V> type) {
        V[] array = this.pluralizedArray(key, source, type);
        if (array == null) {
            throw new IllegalArgumentException("Missing required field '" + key + "' or list '" + key + "s' of type " + type.getName());
        }
        return array;
    }

    public <V> V[] pluralizedArray(String key, ConfigurationNode source, Class<V> type) {
        Object array;
        String pluralKey = this.api.getMessageManager().toPluralForm(key);
        if (source.hasChild(pluralKey)) {
            List<V> list;
            try {
                list = source.node(pluralKey).getList(type);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException("Failed to convert value of key " + pluralKey + " to a list of type " + type.getName());
            }
            array = list != null ? list.toArray((Object[])Array.newInstance(type, list.size())) : null;
        } else if (source.hasChild(key)) {
            array = (Object[])Array.newInstance(type, 1);
            try {
                array[0] = source.node(key).get(type);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException("Failed to convert value of key " + key + " to type " + type.getName());
            }
        } else {
            array = null;
        }
        return array;
    }
}

