/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.skill;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.SkillProvider;
import dev.aurelium.auraskills.api.source.XpSource;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Skills implements Skill
{
    FARMING(Abilities.FARMER),
    FORAGING(Abilities.FORAGER),
    MINING(Abilities.MINER),
    FISHING(Abilities.FISHER),
    EXCAVATION(Abilities.EXCAVATOR),
    ARCHERY(Abilities.ARCHER),
    FIGHTING(Abilities.FIGHTER),
    DEFENSE(Abilities.DEFENDER),
    AGILITY(Abilities.RUNNER),
    ENDURANCE(Abilities.JUMPER),
    ALCHEMY(Abilities.BREWER),
    ENCHANTING(Abilities.ENCHANTER),
    SORCERY(Abilities.SORCERER),
    HEALING(Abilities.HEALER),
    FORGING(Abilities.FORGER);

    @Inject
    private SkillProvider provider;
    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));
    private final Ability xpMultiplierAbility;

    private Skills(Ability xpMultiplierAbility) {
        this.xpMultiplierAbility = xpMultiplierAbility;
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return this.getId().toString();
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    @NotNull
    public List<Ability> getAbilities() {
        return this.provider.getAbilities(this);
    }

    @Override
    public Ability getXpMultiplierAbility() {
        return this.xpMultiplierAbility.isEnabled() ? this.xpMultiplierAbility : null;
    }

    @Override
    @Nullable
    public ManaAbility getManaAbility() {
        return this.provider.getManaAbility(this);
    }

    @Override
    @NotNull
    public List<XpSource> getSources() {
        return this.provider.getSources(this);
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        return this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.provider.getDescription(this, locale, true);
    }

    @Override
    public String getDescription(Locale locale, boolean formatted) {
        return this.provider.getDescription(this, locale, formatted);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }
}

