/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.skill;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.item.ItemContext;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.SkillProvider;
import dev.aurelium.auraskills.api.source.XpSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSkill
implements Skill {
    @Inject
    private SkillProvider provider;
    private final NamespacedId id;
    private final Defined defined;
    @Nullable
    private final Ability xpMultiplierAbility;

    private CustomSkill(NamespacedId id, Defined defined, @Nullable Ability xpMultiplierAbility) {
        this.id = id;
        this.defined = defined;
        this.xpMultiplierAbility = xpMultiplierAbility;
    }

    public static CustomSkillBuilder builder(NamespacedId id) {
        return new CustomSkillBuilder(id);
    }

    public Defined getDefined() {
        return this.defined;
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    @NotNull
    public List<Ability> getAbilities() {
        return this.provider.getAbilities(this);
    }

    @Override
    @Nullable
    public Ability getXpMultiplierAbility() {
        return this.xpMultiplierAbility;
    }

    @Override
    @Nullable
    public ManaAbility getManaAbility() {
        return this.provider.getManaAbility(this);
    }

    @Override
    @NotNull
    public List<XpSource> getSources() {
        return this.provider.getSources(this);
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale, true);
    }

    @Override
    public String getDescription(Locale locale, boolean formatted) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale, formatted);
    }

    @Override
    public String name() {
        return this.id.getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    public static class Defined {
        private ItemContext item;
        private final List<Ability> abilities = new ArrayList<Ability>();
        private ManaAbility manaAbility;
        private String displayName;
        private String description;

        private Defined() {
        }

        public ItemContext getItem() {
            return this.item;
        }

        public void setItem(ItemContext item) {
            this.item = item;
        }

        public List<Ability> getAbilities() {
            return this.abilities;
        }

        public ManaAbility getManaAbility() {
            return this.manaAbility;
        }

        public void setManaAbility(ManaAbility manaAbility) {
            this.manaAbility = manaAbility;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CustomSkillBuilder {
        private final NamespacedId id;
        private final Defined defined = new Defined();
        private Ability xpMultiplierAbility;

        private CustomSkillBuilder(NamespacedId id) {
            this.id = id;
            this.defined.setItem(ItemContext.builder().material("stone").group("third_row").order(6).build());
        }

        public CustomSkillBuilder item(ItemContext item) {
            this.defined.setItem(item);
            return this;
        }

        public CustomSkillBuilder abilities(Ability ... abilities) {
            this.defined.getAbilities().addAll(Arrays.asList(abilities));
            return this;
        }

        public CustomSkillBuilder ability(Ability ability) {
            this.defined.getAbilities().add(ability);
            return this;
        }

        public CustomSkillBuilder manaAbility(ManaAbility manaAbility) {
            this.defined.setManaAbility(manaAbility);
            return this;
        }

        public CustomSkillBuilder displayName(String displayName) {
            this.defined.setDisplayName(displayName);
            return this;
        }

        public CustomSkillBuilder description(String description) {
            this.defined.setDescription(description);
            return this;
        }

        public CustomSkillBuilder xpMultiplierAbility(Ability xpMultiplierAbility) {
            this.xpMultiplierAbility = xpMultiplierAbility;
            return this;
        }

        public CustomSkill build() {
            return new CustomSkill(this.id, this.defined, this.xpMultiplierAbility);
        }
    }
}

