/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.parser;

import com.ezylang.evalex.parser.Token;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ASTNode {
    private final List<ASTNode> parameters;
    private final Token token;

    public ASTNode(Token token, ASTNode ... parameters) {
        this.token = token;
        this.parameters = Arrays.asList(parameters);
    }

    public String toJSON() {
        if (this.parameters.isEmpty()) {
            return String.format("{\"type\":\"%s\",\"value\":\"%s\"}", new Object[]{this.token.getType(), this.token.getValue()});
        }
        String childrenJson = this.parameters.stream().map(ASTNode::toJSON).collect(Collectors.joining(","));
        return String.format("{\"type\":\"%s\",\"value\":\"%s\",\"children\":[%s]}", new Object[]{this.token.getType(), this.token.getValue(), childrenJson});
    }

    @Generated
    public List<ASTNode> getParameters() {
        return this.parameters;
    }

    @Generated
    public Token getToken() {
        return this.token;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ASTNode)) {
            return false;
        }
        ASTNode other = (ASTNode)o;
        List<ASTNode> this$parameters = this.getParameters();
        List<ASTNode> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Token this$token = this.getToken();
        Token other$token = other.getToken();
        return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ASTNode> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Token $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ASTNode(parameters=" + this.getParameters() + ", token=" + this.getToken() + ")";
    }
}

