/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.polyglot.lang;

import com.archyx.polyglot.Polyglot;
import com.archyx.polyglot.lang.FileUpdater;
import com.archyx.polyglot.lang.LangMessages;
import com.archyx.polyglot.lang.MessageKey;
import com.archyx.polyglot.lang.MessageLoader;
import com.archyx.polyglot.lang.MessageUpdate;
import com.archyx.polyglot.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageManager {
    private final Polyglot polyglot;
    private final MessageLoader messageLoader;
    private final FileUpdater fileUpdater;
    private final Map<Locale, LangMessages> langMessagesMap;
    private LangMessages embeddedMessages;
    private final Locale defaultLanguage;
    private final String defaultLanguageCode;
    private final List<MessageUpdate> messageUpdates;

    public MessageManager(Polyglot polyglot) {
        this.polyglot = polyglot;
        this.messageLoader = new MessageLoader(polyglot);
        this.fileUpdater = new FileUpdater(polyglot, this.messageLoader);
        this.defaultLanguageCode = polyglot.getConfig().getDefaultLanguage();
        this.defaultLanguage = new Locale(this.defaultLanguageCode);
        this.langMessagesMap = new HashMap<Locale, LangMessages>();
        this.messageUpdates = new ArrayList<MessageUpdate>();
    }

    @Nullable
    public LangMessages getLangMessages(Locale locale) {
        return this.langMessagesMap.get(locale);
    }

    public String get(Locale language, MessageKey messageKey) {
        String message;
        LangMessages langMessages = this.getLangMessages(language);
        if (langMessages != null && !language.equals(Locale.ROOT) && (message = langMessages.getMessage(messageKey)) != null) {
            return message;
        }
        return this.getDefaultMessage(messageKey, language);
    }

    public String getDefaultMessage(MessageKey key, Locale locale) {
        String message;
        if (this.defaultLanguage == null) {
            throw new IllegalStateException("Default language has not been set");
        }
        LangMessages langMessages = this.getLangMessages(this.defaultLanguage);
        if (langMessages == null) {
            langMessages = this.embeddedMessages;
        }
        if ((message = langMessages.getMessage(key)) != null) {
            return message;
        }
        message = this.embeddedMessages.getMessage(key);
        if (message != null) {
            return message;
        }
        LangMessages global = this.getLangMessages(Locale.ROOT);
        if (global != null && (message = global.getMessage(key)) != null) {
            message = this.replaceMessagePlaceholders(message, locale, true);
        }
        return message != null ? message : key.getPath();
    }

    private String replaceMessagePlaceholders(@NotNull String message, Locale locale, boolean allowGlobal) {
        String[] placeholders = TextUtil.substringsBetween(message, "{", "}");
        if (placeholders == null) {
            return message;
        }
        for (String placeholder : placeholders) {
            String globalMsg;
            if (!placeholder.startsWith("{") && !placeholder.endsWith("}")) continue;
            String path = TextUtil.replace(placeholder, "{", "", "}", "");
            String replacedMsg = this.getLangMessage(path, locale);
            if (replacedMsg != null) {
                message = TextUtil.replace(message, "{" + placeholder + "}", replacedMsg);
                continue;
            }
            if (!allowGlobal || (globalMsg = this.getLangMessage(path, Locale.ROOT)) == null) continue;
            globalMsg = this.replaceMessagePlaceholders(globalMsg, locale, false);
            message = TextUtil.replace(message, "{" + placeholder + "}", globalMsg);
        }
        return message;
    }

    @Nullable
    private String getLangMessage(String path, Locale locale) {
        LangMessages lang = this.getLangMessages(locale);
        if (lang != null) {
            return lang.getMessage(MessageKey.of(path));
        }
        return null;
    }

    public Set<Locale> getLoadedLanguages() {
        return this.langMessagesMap.keySet().stream().filter(locale -> !locale.equals(Locale.ROOT)).collect(Collectors.toSet());
    }

    public List<String> getLanguageCodes() {
        return this.langMessagesMap.values().stream().map(LangMessages::getLanguageCode).collect(Collectors.toList());
    }

    public void registerMessageUpdate(MessageUpdate messageUpdate) {
        this.messageUpdates.add(messageUpdate);
    }

    public void loadMessages() {
        try {
            this.embeddedMessages = this.messageLoader.loadEmbeddedMessages(this.defaultLanguageCode);
        }
        catch (Exception e) {
            this.polyglot.getProvider().logSevere("Error loading embedded message file, some messages may be missing!");
            e.printStackTrace();
        }
        File messagesDir = new File(this.polyglot.getProvider().getDataFolder() + "/" + this.polyglot.getConfig().getMessageDirectory());
        this.generateMessageFiles();
        File[] messageFiles = messagesDir.listFiles();
        if (messageFiles == null) {
            return;
        }
        int numLoaded = 0;
        for (File file : messageFiles) {
            String fileName;
            if (!file.getName().endsWith(".yml")) continue;
            if (file.getName().equals("global.yml")) {
                fileName = "global.yml";
            } else {
                String language = file.getName().substring(file.getName().indexOf("_") + 1, file.getName().lastIndexOf("."));
                fileName = TextUtil.replace(this.polyglot.getConfig().getMessageFileName(), "{language}", language);
            }
            this.attemptFileUpdate(file, fileName);
            try {
                LangMessages langMessages = this.messageLoader.loadMessageFile(file);
                this.langMessagesMap.put(langMessages.getLocale(), langMessages);
                ++numLoaded;
            }
            catch (Exception e) {
                this.polyglot.getProvider().logWarn("Error loading message file " + file.getName());
                e.printStackTrace();
            }
        }
        this.polyglot.getProvider().logInfo("Loaded " + numLoaded + " message files");
    }

    private void attemptFileUpdate(File file, String fileName) {
        this.fileUpdater.updateFile(file, fileName, this.messageUpdates);
    }

    private void generateMessageFiles() {
        for (String code : this.polyglot.getConfig().getProvidedLanguages()) {
            String fileName = code.equals("global") ? "global.yml" : TextUtil.replace(this.polyglot.getConfig().getMessageFileName(), "{language}", code);
            File file = new File(this.polyglot.getProvider().getDataFolder(), this.polyglot.getConfig().getMessageDirectory() + "/" + fileName);
            if (file.exists()) continue;
            this.polyglot.getProvider().saveResource(this.polyglot.getConfig().getMessageDirectory() + "/" + fileName, false);
        }
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }
}

