/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u0000H\u0002J\n\u0010(\u001a\u00020)H\u0096\u0080\u0004J \u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0006H\u0016J\u0018\u0010/\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020\u001eH\u0002J\b\u00101\u001a\u00020\u0000H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/YDistanceStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "startingYLevel", "", "getStartingYLevel", "()Ljava/lang/Integer;", "setStartingYLevel", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "endingYLevel", "getEndingYLevel", "setEndingYLevel", "yPeriod", "getYPeriod", "setYPeriod", "increasePerLevel", "", "getIncreasePerLevel", "()Ljava/lang/Float;", "setIncreasePerLevel", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "shouldMerge", "", "getShouldMerge", "()Z", "setShouldMerge", "(Z)V", "mergeRule", "", "levellingStrategy", "mergeYDistanceStrategy", "yds", "toString", "", "generateNumber", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "maxLevel", "getVariance", "isAtMaxLevel", "cloneItem", "levelledmobs-plugin"})
public final class YDistanceStrategy
implements LevellingStrategy,
Cloneable {
    @Nullable
    private Integer startingYLevel;
    @Nullable
    private Integer endingYLevel;
    @Nullable
    private Integer yPeriod;
    @Nullable
    private Float increasePerLevel;
    @NotNull
    private final StrategyType strategyType = StrategyType.Y_COORDINATE;
    private boolean shouldMerge;

    @Nullable
    public final Integer getStartingYLevel() {
        return this.startingYLevel;
    }

    public final void setStartingYLevel(@Nullable Integer n) {
        this.startingYLevel = n;
    }

    @Nullable
    public final Integer getEndingYLevel() {
        return this.endingYLevel;
    }

    public final void setEndingYLevel(@Nullable Integer n) {
        this.endingYLevel = n;
    }

    @Nullable
    public final Integer getYPeriod() {
        return this.yPeriod;
    }

    public final void setYPeriod(@Nullable Integer n) {
        this.yPeriod = n;
    }

    @Nullable
    public final Float getIncreasePerLevel() {
        return this.increasePerLevel;
    }

    public final void setIncreasePerLevel(@Nullable Float f) {
        this.increasePerLevel = f;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    @Override
    public boolean getShouldMerge() {
        return this.shouldMerge;
    }

    @Override
    public void setShouldMerge(boolean bl) {
        this.shouldMerge = bl;
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (levellingStrategy instanceof YDistanceStrategy) {
            this.mergeYDistanceStrategy((YDistanceStrategy)levellingStrategy);
        }
    }

    private final void mergeYDistanceStrategy(YDistanceStrategy yds) {
        if (yds == null) {
            return;
        }
        if (yds.startingYLevel != null) {
            this.startingYLevel = yds.startingYLevel;
        }
        if (yds.endingYLevel != null) {
            this.endingYLevel = yds.endingYLevel;
        }
        if (yds.yPeriod != null) {
            this.yPeriod = yds.yPeriod;
        }
        if (yds.increasePerLevel != null) {
            this.increasePerLevel = yds.increasePerLevel;
        }
    }

    @NotNull
    public String toString() {
        String string = "y coord, start: %s, end: %s, yPeriod: %s, increasePerLvl: %s";
        Object[] objectArray = new Object[]{this.startingYLevel == null ? Integer.valueOf(0) : this.startingYLevel, this.endingYLevel == null ? Integer.valueOf(0) : this.endingYLevel, this.yPeriod == null ? Integer.valueOf(0) : this.yPeriod, this.increasePerLevel == null ? (Number)0 : (Number)this.increasePerLevel};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        float distanceBelow;
        float diff;
        float f;
        float yEnd;
        float yStart;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        float mobYLocation = lmEntity.getLivingEntity().getLocation().getBlockY();
        if (this.startingYLevel == null) {
            v0 = 0.0f;
        } else {
            Integer n = this.startingYLevel;
            Intrinsics.checkNotNull(n);
            v0 = yStart = (float)n.intValue();
        }
        if (this.endingYLevel == null) {
            v2 = 0.0f;
        } else {
            Integer n = this.endingYLevel;
            Intrinsics.checkNotNull(n);
            v2 = yEnd = (float)n.intValue();
        }
        if (this.yPeriod == null) {
            f = 0.0f;
        } else {
            Integer n = this.yPeriod;
            Intrinsics.checkNotNull(n);
            f = n.intValue();
        }
        float yPeriod = f;
        float useLevel = 0.0f;
        boolean isDescending = yStart > yEnd;
        float highest = isDescending ? yStart : yEnd;
        float lowest = isDescending ? yEnd : yStart;
        float f2 = diff = isDescending ? yStart - yEnd : yEnd - yStart;
        if (isDescending && yPeriod == 0.0f && this.increasePerLevel == null) {
            mobYLocation = RangesKt.coerceAtMost(mobYLocation, highest);
        }
        if (yPeriod == 0.0f && this.increasePerLevel == null) {
            mobYLocation = RangesKt.coerceAtLeast(mobYLocation, lowest);
        }
        float f3 = distanceBelow = isDescending ? highest - mobYLocation : mobYLocation - lowest;
        if (this.increasePerLevel != null) {
            float firstStep = isDescending ? yStart - mobYLocation : mobYLocation - yStart;
            Float f4 = this.increasePerLevel;
            Intrinsics.checkNotNull(f4);
            useLevel = (float)Math.floor(firstStep / f4.floatValue());
        } else if (!(yPeriod == 0.0f)) {
            float lvlPerPeriod = (float)(maxLevel - minLevel) / yPeriod;
            float periodBelow = distanceBelow / yPeriod;
            useLevel = (float)minLevel + lvlPerPeriod * periodBelow;
        } else {
            double useMobYLocation = distanceBelow;
            float percent = (float)(useMobYLocation / (double)diff);
            useLevel = (float)minLevel + (float)(maxLevel - minLevel) * percent;
        }
        return useLevel;
    }

    private final int getVariance(LivingEntityWrapper lmEntity, boolean isAtMaxLevel) {
        Integer variance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        if (variance == null || variance == 0) {
            return 0;
        }
        int change = ThreadLocalRandom.current().nextInt(0, variance + 1);
        return !isAtMaxLevel || ThreadLocalRandom.current().nextBoolean() ? change : -change;
    }

    @Override
    @NotNull
    public YDistanceStrategy cloneItem() {
        YDistanceStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.YDistanceStrategy");
            copy = (YDistanceStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YDistanceStrategy yDistanceStrategy = copy;
        Intrinsics.checkNotNull(yDistanceStrategy);
        return yDistanceStrategy;
    }
}

