/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.bukkit.Location;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u00101\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\u0012\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010<\u001a\u00020:2\b\u0010=\u001a\u0004\u0018\u00010\u0000H\u0002J\n\u0010>\u001a\u00020?H\u0096\u0080\u0004J\u0018\u0010@\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u0010A\u001a\u00020\u0006H\u0002J\b\u0010B\u001a\u00020\u0000H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\nR\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR\u001e\u0010\"\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR\u001e\u0010%\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00107\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010.\u00a8\u0006C"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/SpawnDistanceStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "bufferDistance", "", "getBufferDistance", "()Ljava/lang/Float;", "setBufferDistance", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "ringedTiers", "getRingedTiers", "setRingedTiers", "originCoordX", "getOriginCoordX", "setOriginCoordX", "originCoordZ", "getOriginCoordZ", "setOriginCoordZ", "enableHeightMod", "", "getEnableHeightMod", "()Ljava/lang/Boolean;", "setEnableHeightMod", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "transitionYheight", "getTransitionYheight", "setTransitionYheight", "yHeightPeriod", "getYHeightPeriod", "setYHeightPeriod", "lvlMultiplier", "getLvlMultiplier", "setLvlMultiplier", "scaleDownward", "getScaleDownward", "setScaleDownward", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "shouldMerge", "getShouldMerge", "()Z", "setShouldMerge", "(Z)V", "generateNumber", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "", "maxLevel", "heightModIsEnabled", "getHeightModIsEnabled", "mergeRule", "", "levellingStrategy", "mergeSpawnDistanceStrategy", "sds", "toString", "", "generateBlendedLevel", "spawnDistanceLevelAssignment", "cloneItem", "levelledmobs-plugin"})
public final class SpawnDistanceStrategy
implements LevellingStrategy,
Cloneable {
    @Nullable
    private Float bufferDistance;
    @Nullable
    private Float ringedTiers;
    @Nullable
    private Float originCoordX;
    @Nullable
    private Float originCoordZ;
    @Nullable
    private Boolean enableHeightMod;
    @Nullable
    private Float transitionYheight;
    @Nullable
    private Float yHeightPeriod;
    @Nullable
    private Float lvlMultiplier;
    @Nullable
    private Boolean scaleDownward;
    @NotNull
    private final StrategyType strategyType = StrategyType.SPAWN_DISTANCE;
    private boolean shouldMerge;

    @Nullable
    public final Float getBufferDistance() {
        return this.bufferDistance;
    }

    public final void setBufferDistance(@Nullable Float f) {
        this.bufferDistance = f;
    }

    @Nullable
    public final Float getRingedTiers() {
        return this.ringedTiers;
    }

    public final void setRingedTiers(@Nullable Float f) {
        this.ringedTiers = f;
    }

    @Nullable
    public final Float getOriginCoordX() {
        return this.originCoordX;
    }

    public final void setOriginCoordX(@Nullable Float f) {
        this.originCoordX = f;
    }

    @Nullable
    public final Float getOriginCoordZ() {
        return this.originCoordZ;
    }

    public final void setOriginCoordZ(@Nullable Float f) {
        this.originCoordZ = f;
    }

    @Nullable
    public final Boolean getEnableHeightMod() {
        return this.enableHeightMod;
    }

    public final void setEnableHeightMod(@Nullable Boolean bl) {
        this.enableHeightMod = bl;
    }

    @Nullable
    public final Float getTransitionYheight() {
        return this.transitionYheight;
    }

    public final void setTransitionYheight(@Nullable Float f) {
        this.transitionYheight = f;
    }

    @Nullable
    public final Float getYHeightPeriod() {
        return this.yHeightPeriod;
    }

    public final void setYHeightPeriod(@Nullable Float f) {
        this.yHeightPeriod = f;
    }

    @Nullable
    public final Float getLvlMultiplier() {
        return this.lvlMultiplier;
    }

    public final void setLvlMultiplier(@Nullable Float f) {
        this.lvlMultiplier = f;
    }

    @Nullable
    public final Boolean getScaleDownward() {
        return this.scaleDownward;
    }

    public final void setScaleDownward(@Nullable Boolean bl) {
        this.scaleDownward = bl;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    @Override
    public boolean getShouldMerge() {
        return this.shouldMerge;
    }

    @Override
    public void setShouldMerge(boolean bl) {
        this.shouldMerge = bl;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        float spawnDistanceAssignment;
        float f;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Location location = lmEntity.getWorld().getSpawnLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
        Location spawnLocation = location;
        if (this.originCoordZ != null || this.originCoordX != null) {
            double d;
            double useX;
            if (this.originCoordX == null) {
                v1 = spawnLocation.getX();
            } else {
                Float f2 = this.originCoordX;
                Intrinsics.checkNotNull(f2);
                v1 = useX = (double)f2.floatValue();
            }
            if (this.originCoordZ == null) {
                d = spawnLocation.getX();
            } else {
                Float f3 = this.originCoordZ;
                Intrinsics.checkNotNull(f3);
                d = f3.floatValue();
            }
            double useZ = d;
            spawnLocation = new Location(lmEntity.getLivingEntity().getWorld(), useX, spawnLocation.getY(), useZ);
        }
        if (!Intrinsics.areEqual(spawnLocation.getWorld(), lmEntity.getLocation().getWorld())) {
            return minLevel;
        }
        if (this.bufferDistance == null) {
            f = 0.0f;
        } else {
            Float f4 = this.bufferDistance;
            Intrinsics.checkNotNull(f4);
            f = f4.floatValue();
        }
        float bufferDistance = f;
        float distanceFromSpawn = (float)spawnLocation.distance(lmEntity.getLocation());
        float levelDistance = RangesKt.coerceAtLeast(distanceFromSpawn - bufferDistance, 0.0f);
        Integer variance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        int varianceAdded = 0;
        if (variance != null) {
            varianceAdded = ThreadLocalRandom.current().nextInt(0, variance + 1);
        }
        Ref.FloatRef ringedTiers = new Ref.FloatRef();
        if (this.ringedTiers == null) {
            v7 = 1.0f;
        } else {
            Float f5 = this.ringedTiers;
            Intrinsics.checkNotNull(f5);
            v7 = ringedTiers.element = f5.floatValue();
        }
        if (ringedTiers.element == 0.0f) {
            ringedTiers.element = 1.0f;
        }
        if (Float.isNaN(spawnDistanceAssignment = levelDistance / ringedTiers.element + (float)varianceAdded)) {
            DebugManager.Companion.log(DebugType.STRATEGY_RESULT, lmEntity, () -> SpawnDistanceStrategy.generateNumber$lambda$0(levelDistance, ringedTiers));
            spawnDistanceAssignment = 0.0f;
        }
        if (!this.getHeightModIsEnabled()) {
            return spawnDistanceAssignment;
        }
        return this.generateBlendedLevel(lmEntity, spawnDistanceAssignment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHeightModIsEnabled() {
        if (this.enableHeightMod == null) return false;
        Boolean bl = this.enableHeightMod;
        Intrinsics.checkNotNull(bl);
        if (bl == false) return false;
        return true;
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (levellingStrategy == null) {
            return;
        }
        if (levellingStrategy instanceof SpawnDistanceStrategy) {
            this.mergeSpawnDistanceStrategy((SpawnDistanceStrategy)levellingStrategy);
        }
    }

    private final void mergeSpawnDistanceStrategy(SpawnDistanceStrategy sds) {
        if (sds == null) {
            return;
        }
        try {
            Field[] fieldArray = sds.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue(fieldArray, "getDeclaredFields(...)");
            for (Field f : fieldArray) {
                if (Intrinsics.areEqual(f.getName(), "strategyType") || f.get(sds) == null) continue;
                this.getClass().getDeclaredField(f.getName()).set(this, f.get(sds));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public String toString() {
        block5: {
            block4: {
                sb = new StringBuilder();
                if (!this.getHeightModIsEnabled()) break block4;
                v0 /* !! */  = this.bufferDistance == null ? Integer.valueOf(0) : this.bufferDistance;
                v1 /* !! */  = this.ringedTiers == null ? Integer.valueOf(0) : this.ringedTiers;
                v2 /* !! */  = this.transitionYheight == null ? Integer.valueOf(0) : this.transitionYheight;
                v3 /* !! */  = this.yHeightPeriod == null ? Integer.valueOf(0) : this.yHeightPeriod;
                v4 /* !! */  = this.lvlMultiplier == null ? Double.valueOf(0.0) : this.lvlMultiplier;
                if (this.scaleDownward == null) ** GOTO lbl-1000
                v5 = this.scaleDownward;
                Intrinsics.checkNotNull(v5);
                if (v5.booleanValue()) lbl-1000:
                // 2 sources

                {
                    v6 = true;
                } else {
                    v6 = false;
                }
                v7 = sb.append("blended, dro: " + v0 /* !! */  + ", rt: " + v1 /* !! */  + ", t_yHght: " + v2 /* !! */  + ", yhp: " + v3 /* !! */  + ", lvlMlp: " + v4 /* !! */  + ", scdown: " + v6);
                break block5;
            }
            v7 = sb.append("spawn distance, dro: " + (this.bufferDistance == null ? Integer.valueOf(0) : this.bufferDistance) + ", rt: " + (this.ringedTiers == null ? Integer.valueOf(0) : this.ringedTiers));
        }
        if (this.originCoordX != null) {
            sb.append(" x: ").append(this.originCoordX);
        }
        if (this.originCoordZ != null) {
            sb.append(" z: ").append(this.originCoordZ);
        }
        v8 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(v8, "toString(...)");
        return v8;
    }

    /*
     * Unable to fully structure code
     */
    private final float generateBlendedLevel(LivingEntityWrapper lmEntity, float spawnDistanceLevelAssignment) {
        currentYPos = lmEntity.getLocation().getBlockY();
        result = 0.0f;
        if (this.transitionYheight == null) {
            v0 = 0.0f;
        } else {
            v1 = this.transitionYheight;
            Intrinsics.checkNotNull(v1);
            v0 = transitionYHeight = v1.floatValue();
        }
        if (this.yHeightPeriod == null) {
            v2 = 0.0f;
        } else {
            v3 = this.yHeightPeriod;
            Intrinsics.checkNotNull(v3);
            v2 = yHeightPeriod = v3.floatValue();
        }
        if (this.lvlMultiplier == null) {
            v4 = 0.0f;
        } else {
            v5 = this.lvlMultiplier;
            Intrinsics.checkNotNull(v5);
            v4 = lvlMultiplier = v5.floatValue();
        }
        if (this.scaleDownward == null) ** GOTO lbl-1000
        v6 = this.scaleDownward;
        Intrinsics.checkNotNull(v6);
        if (v6.booleanValue()) lbl-1000:
        // 2 sources

        {
            v7 = (transitionYHeight - currentYPos) / yHeightPeriod * lvlMultiplier * spawnDistanceLevelAssignment;
        } else {
            v7 = result = (transitionYHeight - currentYPos) / yHeightPeriod * (lvlMultiplier * -1.0f) * spawnDistanceLevelAssignment;
        }
        if (Float.isNaN(result)) {
            DebugManager.Companion.log(DebugType.STRATEGY_RESULT, lmEntity, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, generateBlendedLevel$lambda$0(float float float float float ), ()Ljava/lang/String;)((float)transitionYHeight, (float)currentYPos, (float)yHeightPeriod, (float)lvlMultiplier, (float)spawnDistanceLevelAssignment));
            result = 0.0f;
        }
        result += spawnDistanceLevelAssignment;
        variance = RulesManager.Companion.getInstance().getRuleMaxRandomVariance(lmEntity);
        if (variance != null && variance > 0) {
            result += (float)ThreadLocalRandom.current().nextInt(0, variance + 1);
        }
        return result;
    }

    @Override
    @NotNull
    public SpawnDistanceStrategy cloneItem() {
        SpawnDistanceStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.SpawnDistanceStrategy");
            copy = (SpawnDistanceStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SpawnDistanceStrategy spawnDistanceStrategy = copy;
        Intrinsics.checkNotNull(spawnDistanceStrategy);
        return spawnDistanceStrategy;
    }

    private static final String generateNumber$lambda$0(float $levelDistance, Ref.FloatRef $ringedTiers) {
        return "SpawnDistanceStrategy generated NaN, levelDistance: " + $levelDistance + ", increaseLevelDistance: " + $ringedTiers.element;
    }

    private static final String generateBlendedLevel$lambda$0(float $transitionYHeight, float $currentYPos, float $yHeightPeriod, float $lvlMultiplier, float $spawnDistanceLevelAssignment) {
        return "BlendedLevel generated NaN, returning 0. transitionYHeight: " + $transitionYHeight + ", yPos: " + $currentYPos + ", yHeightPeriod: " + $yHeightPeriod + ", lvlMultiplier: " + $lvlMultiplier + ", sda: " + $spawnDistanceLevelAssignment;
    }
}

