/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.MobCustomNameStatus;
import io.github.arcaneplugins.levelledmobs.enums.MobTamedStatus;
import io.github.arcaneplugins.levelledmobs.enums.ModalListParsingTypes;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.enums.VanillaBonusEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.TypeIntrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.CustomUniversalGroups;
import io.github.arcaneplugins.levelledmobs.misc.LMSpawnReason;
import io.github.arcaneplugins.levelledmobs.misc.YmlParsingHelper;
import io.github.arcaneplugins.levelledmobs.rules.ChunkKillOptions;
import io.github.arcaneplugins.levelledmobs.rules.DeathMessages;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningParseResult;
import io.github.arcaneplugins.levelledmobs.rules.HealthIndicator;
import io.github.arcaneplugins.levelledmobs.rules.KeyValidation;
import io.github.arcaneplugins.levelledmobs.rules.LMMultiplier;
import io.github.arcaneplugins.levelledmobs.rules.LevelTierMatching;
import io.github.arcaneplugins.levelledmobs.rules.MergeableStringList;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.ModalListParsingInfo;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.rules.TieredColoringInfo;
import io.github.arcaneplugins.levelledmobs.rules.WithinCoordinates;
import io.github.arcaneplugins.levelledmobs.rules.strategies.CustomStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.RandomLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.SpawnDistanceStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.rules.strategies.YDistanceStrategy;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.structure.Structure;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010#\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010$\u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010,\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010-\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\"\u0010.\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u00100\u001a\u00020\bH\u0002J\u0012\u00101\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u00102\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\"H\u0002J\u0012\u00105\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u00107\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00108\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u00109\u001a\u00020\u0019H\u0002J\u0012\u0010:\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010;\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010<\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010=\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u00020\bH\u0002J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J*\u0010?\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@H\u0002J\u0014\u0010C\u001a\u0004\u0018\u00010A2\b\u0010D\u001a\u0004\u0018\u00010\bH\u0002J$\u0010C\u001a\b\u0012\u0004\u0012\u00020A0E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010G\u001a\u00020\bH\u0002J\u0012\u0010H\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010I\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010J\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010K\u001a\u00020LH\u0002J\u0012\u0010M\u001a\u00020\u00192\b\u0010N\u001a\u0004\u0018\u00010\"H\u0002J0\u0010O\u001a\u00020P2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0014\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020S\u0018\u00010\u00072\u0006\u0010T\u001a\u00020\u001fH\u0002J*\u0010U\u001a\u0004\u0018\u00010S2\u0006\u0010!\u001a\u00020\"2\u0006\u0010V\u001a\u00020R2\u0006\u0010W\u001a\u00020\b2\u0006\u0010T\u001a\u00020\u001fH\u0002J\b\u0010X\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0017\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/RulesParser;", "", "<init>", "()V", "parsingInfo", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "rulePresets", "", "", "getRulePresets", "()Ljava/util/Map;", "customRules", "", "getCustomRules", "()Ljava/util/List;", "setCustomRules", "(Ljava/util/List;)V", "defaultRule", "getDefaultRule", "()Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "setDefaultRule", "(Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;)V", "customBiomeGroups", "", "parseRulesMain", "", "config", "Lorg/bukkit/configuration/file/YamlConfiguration;", "checkCustomRules", "getAllRules", "includePresets", "", "parseCustomMobGroups", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "parseCustomBiomeGroups", "parseDefaults", "parsePresets", "parseCustomRules", "rulesSection", "parseValues", "ymlHelper", "Lio/github/arcaneplugins/levelledmobs/misc/YmlParsingHelper;", "mergePreset", "parseTieredColoring", "parseEntityNameOverride", "parseNumberRange", "Lio/github/arcaneplugins/levelledmobs/rules/LevelTierMatching;", "keyName", "parseApplySettings", "parseChunkKillOptions", "parseDeathMessages", "csParent", "parseSpawnerParticle", "particle", "parseNBTData", "parseConditions", "checkExternalPlugins", "parseWithinCoordinates", "parseStrategies", "parseModifiers", "parseCustomStrategy", "parseWeightedRandom", "parseWorldTimeTicks", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "Lio/github/arcaneplugins/levelledmobs/rules/MinAndMax;", "existingList", "parseMinMaxValue", "numberPair", "", "numberPairs", "configName", "parseHealthIndicator", "parsePlayerLevellingOptions", "parseOptionalSpawnCoordinate", "sds", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/SpawnDistanceStrategy;", "parseFineTuning", "csBase", "parseFineTuningValues", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningParseResult;", "defaults", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "isBaseModifier", "parseFineTuningValues2", "addition", "item", "autoGenerateWeightedRandom", "Companion", "levelledmobs-plugin"})
public final class RulesParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private RuleInfo parsingInfo = new RuleInfo(null, 1, null);
    @NotNull
    private final Map<String, RuleInfo> rulePresets = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private List<RuleInfo> customRules = new ArrayList();
    @Nullable
    private RuleInfo defaultRule;
    @Nullable
    private Map<String, Set<String>> customBiomeGroups;
    @NotNull
    private static final String MLINCLUDEDLIST = "included-list";
    @NotNull
    private static final String MLINCLUDEDGROUPS = "included-groups";
    @NotNull
    private static final String MLEXCLUDEDITEMS = "excluded-list";
    @NotNull
    private static final String MLEXCLUDEDGROUPS = "excluded-groups";
    @NotNull
    private static final List<String> validModalListOptions = new ArrayList();
    private static final Pattern emptyArrayPattern = Pattern.compile("\\[\\s+?]|\\[]");

    @NotNull
    public final Map<String, RuleInfo> getRulePresets() {
        return this.rulePresets;
    }

    @NotNull
    public final List<RuleInfo> getCustomRules() {
        return this.customRules;
    }

    public final void setCustomRules(@NotNull List<RuleInfo> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.customRules = list;
    }

    @Nullable
    public final RuleInfo getDefaultRule() {
        return this.defaultRule;
    }

    public final void setDefaultRule(@Nullable RuleInfo ruleInfo) {
        this.defaultRule = ruleInfo;
    }

    /*
     * Unable to fully structure code
     */
    public final void parseRulesMain(@Nullable YamlConfiguration config) {
        if (config == null) {
            Log.INSTANCE.war("rules config was null");
            return;
        }
        main = LevelledMobs.Companion.getInstance();
        this.rulePresets.clear();
        main.getRulesManager().getRulesInEffect().clear();
        main.getCustomMobGroups().clear();
        main.getRulesManager().getAllCustomStrategyPlaceholders().clear();
        this.parseCustomMobGroups(YmlParsingHelper.Companion.objToCS((ConfigurationSection)config, "mob-groups"));
        this.parseCustomBiomeGroups(YmlParsingHelper.Companion.objToCS((ConfigurationSection)config, "biome-groups"));
        presets = this.parsePresets(YmlParsingHelper.Companion.objToCS((ConfigurationSection)config, "presets"));
        for (RuleInfo ri : presets) {
            v0 = ri.getPresetName();
            Intrinsics.checkNotNull(v0);
            this.rulePresets.put(v0, ri);
        }
        this.defaultRule = this.parseDefaults(YmlParsingHelper.Companion.objToCS((ConfigurationSection)config, "default-rule"));
        v1 = main.getRulesManager().getRulesInEffect();
        v2 = this.defaultRule;
        Intrinsics.checkNotNull(v2);
        v1.add(v2);
        v3 = main.getRulesManager();
        v4 = this.defaultRule;
        Intrinsics.checkNotNull(v4);
        v3.setAnyRuleHasChance(v4.getConditionsChance() != null);
        v5 = main.getRulesManager();
        v6 = this.defaultRule;
        Intrinsics.checkNotNull(v6);
        if (v6.getConditionsWGregions() != null) ** GOTO lbl-1000
        v7 = this.defaultRule;
        Intrinsics.checkNotNull(v7);
        if (v7.getConditionsWGregionOwners() != null) lbl-1000:
        // 2 sources

        {
            v8 = true;
        } else {
            v8 = false;
        }
        v5.setHasAnyWGCondition(v8);
        main.getRulesManager().buildBiomeGroupMappings(this.customBiomeGroups);
        this.customRules = this.parseCustomRules(config.get(YmlParsingHelper.Companion.getKeyNameFromConfig((ConfigurationSection)config, "custom-rules")));
        this.checkCustomRules();
        this.autoGenerateWeightedRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkCustomRules() {
        Map ruleMappings = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        for (RuleInfo ruleInfo : this.customRules) {
            LevelledMobs.Companion.getInstance().getRulesManager().getRulesInEffect().add(ruleInfo);
            ruleMappings.put(ruleInfo.getRuleName$levelledmobs_plugin(), ruleInfo);
            if (ruleInfo.getConditionsChance() != null) {
                main.getRulesManager().setAnyRuleHasChance(true);
            }
            if (ruleInfo.getConditionsWGregions() == null && ruleInfo.getConditionsWGregionOwners() == null) continue;
            main.getRulesManager().setHasAnyWGCondition(true);
        }
        Object object = RulesManager.Companion.getRuleLocker();
        synchronized (object) {
            boolean bl = false;
            main.getRulesManager().getRuleNameMappings().clear();
            main.getRulesManager().getRuleNameMappings().putAll(ruleMappings);
            main.getRulesManager().getRulesCooldown().clear();
            Unit unit = Unit.INSTANCE;
        }
        main.getRulesManager().updateRulesHash();
        Log.INSTANCE.inf("Current rules hash: " + main.getRulesManager().getCurrentRulesHash());
    }

    @NotNull
    public final List<RuleInfo> getAllRules() {
        return this.getAllRules(true);
    }

    @NotNull
    public final List<RuleInfo> getAllRules(boolean includePresets) {
        List results = new ArrayList();
        if (this.defaultRule != null) {
            RuleInfo ruleInfo = this.defaultRule;
            Intrinsics.checkNotNull(ruleInfo);
            results.add(ruleInfo);
        }
        if (includePresets) {
            results.addAll(this.rulePresets.values());
        }
        results.addAll((Collection)this.customRules);
        return results;
    }

    private final void parseCustomMobGroups(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        for (String groupName : cs.getKeys(false)) {
            List names;
            Intrinsics.checkNotNullExpressionValue(cs.getStringList(groupName), "getStringList(...)");
            Set groupMembers = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            groupMembers.addAll(names);
            LevelledMobs.Companion.getInstance().getCustomMobGroups().put(groupName, groupMembers);
        }
    }

    private final void parseCustomBiomeGroups(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        this.customBiomeGroups = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        for (String groupName : cs.getKeys(false)) {
            List names;
            Intrinsics.checkNotNullExpressionValue(cs.getStringList(groupName), "getStringList(...)");
            Set groupMembers = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            groupMembers.addAll(names);
            Map<String, Set<String>> map = this.customBiomeGroups;
            Intrinsics.checkNotNull(map);
            map.put(groupName, groupMembers);
        }
    }

    private final RuleInfo parseDefaults(ConfigurationSection cs) {
        this.parsingInfo = new RuleInfo("defaults");
        this.parsingInfo.setRestrictionsMinLevel(0);
        this.parsingInfo.setRestrictionsMaxLevel(0);
        this.parsingInfo.setConditionsMobCustomnameStatus(MobCustomNameStatus.EITHER);
        this.parsingInfo.setConditionsMobTamedStatus(MobTamedStatus.EITHER);
        this.parsingInfo.setBabyMobsInheritAdultSetting(true);
        this.parsingInfo.setMobLevelInheritance(true);
        this.parsingInfo.setCreeperMaxDamageRadius(5);
        this.parsingInfo.setNametagVisibleTime(1000L);
        if (cs == null) {
            Log.INSTANCE.war("default-rule section was null");
            return this.parsingInfo;
        }
        this.parseValues(new YmlParsingHelper(cs));
        return this.parsingInfo;
    }

    private final List<RuleInfo> parsePresets(ConfigurationSection cs) {
        List results = new ArrayList();
        if (cs == null) {
            return results;
        }
        int count = -1;
        for (String key : cs.getKeys(false)) {
            ++count;
            Intrinsics.checkNotNull(key);
            ConfigurationSection csKey = YmlParsingHelper.Companion.objToCS(cs, key);
            if (csKey == null) {
                Log.INSTANCE.war("nothing was specified for preset: " + key);
                continue;
            }
            this.parsingInfo = new RuleInfo("preset " + count);
            this.parsingInfo.setPresetName(key);
            this.parseValues(new YmlParsingHelper(csKey));
            results.add(this.parsingInfo);
        }
        return results;
    }

    private final List<RuleInfo> parseCustomRules(Object rulesSection) {
        List results = new ArrayList();
        if (rulesSection == null) {
            return results;
        }
        for (Map hashMap : TypeIntrinsics.asMutableList(rulesSection)) {
            ConfigurationSection cs = YmlParsingHelper.Companion.objToCS2(hashMap);
            if (cs == null) {
                Log.INSTANCE.war("cs was null (parsing custom-rules)");
                continue;
            }
            this.parsingInfo = new RuleInfo("rule " + results.size());
            this.parseValues(new YmlParsingHelper(cs));
            results.add(this.parsingInfo);
        }
        return results;
    }

    private final void parseValues(YmlParsingHelper ymlHelper) {
        String ruleName = ymlHelper.getString("name");
        if (ruleName == null) {
            ruleName = String.valueOf(ymlHelper.getCs().get("custom-rule"));
        }
        if (!Intrinsics.areEqual(this.parsingInfo.getRuleName$levelledmobs_plugin(), "defaults")) {
            this.parsingInfo.setRuleName$levelledmobs_plugin(ruleName);
        }
        this.mergePreset(ymlHelper);
        this.parsingInfo.setRuleIsEnabled(ymlHelper.getBoolean("is-enabled", true));
        this.parseStrategies(YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), "strategies"));
        this.parseConditions(YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), "conditions"));
        this.parseApplySettings(YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), "settings"));
        this.parseModifiers(YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), "modifiers"));
        for (String key : ymlHelper.getCs().getKeys(false)) {
            if (KeyValidation.INSTANCE.getMainRuleSection().contains(key)) continue;
            Log.INSTANCE.war("Invalid option '" + key + "', in rule: " + ruleName);
        }
    }

    private final void mergePreset(YmlParsingHelper ymlHelper) {
        List<String> presets = ymlHelper.getStringOrList("use-preset");
        if (presets.isEmpty()) {
            return;
        }
        for (String checkName : presets) {
            String checkNameTrimmed = ((Object)StringsKt.trim((CharSequence)checkName)).toString();
            if (!this.rulePresets.containsKey(checkNameTrimmed)) {
                String string = this.parsingInfo.getPresetName();
                if (string == null) {
                    string = this.parsingInfo.getRuleName$levelledmobs_plugin();
                }
                String ruleName = string;
                Log.INSTANCE.war("Rule: '" + ruleName + "' specified preset name '" + checkNameTrimmed + "' but none was found");
                continue;
            }
            this.parsingInfo.mergePresetRules(this.rulePresets.get(checkNameTrimmed));
        }
    }

    private final void parseTieredColoring(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        for (String name : cs.getKeys(false)) {
            TieredColoringInfo coloringInfo;
            String value = cs.getString(name);
            CharSequence charSequence = name;
            if (charSequence == null || charSequence.length() == 0 || value == null || (coloringInfo = StringsKt.equals("default", name, true) ? TieredColoringInfo.Companion.createDefault(value) : TieredColoringInfo.Companion.createFromString(name, value)) == null) continue;
            if (this.parsingInfo.getTieredColoringInfos() == null) {
                this.parsingInfo.setTieredColoringInfos(new ArrayList());
            }
            List<TieredColoringInfo> list = this.parsingInfo.getTieredColoringInfos();
            Intrinsics.checkNotNull(list);
            list.add(coloringInfo);
        }
    }

    private final void parseEntityNameOverride(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        Map levelTiers = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        Map entityNames = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        for (String name : cs.getKeys(false)) {
            List<String> names2;
            LevelTierMatching mobNames;
            List names;
            if (StringsKt.equals("merge", name, true) && cs.getBoolean(name)) {
                this.parsingInfo.setMergeEntityNameOverrides(cs.getBoolean(name));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(cs.getStringList(name), "getStringList(...)");
            if (!((Collection)names).isEmpty()) {
                mobNames = new LevelTierMatching();
                mobNames.setMobName(name);
                mobNames.setNames(names);
                names2 = new ArrayList();
                for (String nameFromList : names) {
                    Intrinsics.checkNotNull(nameFromList);
                    if (!(((CharSequence)nameFromList).length() > 0)) continue;
                    names2.add(nameFromList);
                }
                if (!(!((Collection)names2).isEmpty())) continue;
                entityNames.put(name, mobNames);
                continue;
            }
            if (cs.getString(name) == null) continue;
            if (StringsKt.equals("merge", name, true)) {
                this.parsingInfo.setMergeEntityNameOverrides(cs.getBoolean(name));
                continue;
            }
            if (cs.get(name) instanceof String) {
                mobNames = new LevelTierMatching();
                String[] stringArray = new String[1];
                Intrinsics.checkNotNull(cs.getString(name));
                names2 = CollectionsKt.mutableListOf(stringArray);
                mobNames.setMobName(name);
                mobNames.setNames(names2);
                entityNames.put(name, mobNames);
                continue;
            }
            if (!(cs.get(name) instanceof MemorySection) && !(cs.get(name) instanceof LinkedHashMap)) continue;
            Intrinsics.checkNotNull(name);
            List<LevelTierMatching> tiers = this.parseNumberRange(YmlParsingHelper.Companion.objToCS(cs, name), name);
            Collection collection = tiers;
            if (collection == null || collection.isEmpty()) continue;
            levelTiers.put(name, tiers);
        }
        if (!entityNames.isEmpty()) {
            this.parsingInfo.setEntityNameOverrides(entityNames);
        }
        if (!levelTiers.isEmpty()) {
            this.parsingInfo.setEntityNameOverridesLevel(levelTiers);
        }
    }

    private final List<LevelTierMatching> parseNumberRange(ConfigurationSection cs, String keyName) {
        if (cs == null) {
            return null;
        }
        List levelTiers = new ArrayList();
        for (String name : cs.getKeys(false)) {
            List names;
            Intrinsics.checkNotNullExpressionValue(cs.getStringList(name), "getStringList(...)");
            LevelTierMatching tier = new LevelTierMatching();
            if (StringsKt.equals("merge", name, true)) continue;
            tier.setMobName(name);
            if (!((Collection)names).isEmpty()) {
                tier.setNames(names);
            } else if (cs.getString(name) != null) {
                String[] stringArray = new String[1];
                Intrinsics.checkNotNull(cs.getString(name));
                tier.setNames(CollectionsKt.mutableListOf(stringArray));
            }
            if (!tier.setRangeFromString(keyName)) {
                Log.INSTANCE.war("Invalid number range: " + keyName);
                continue;
            }
            List<String> list = tier.getNames();
            Intrinsics.checkNotNull(list);
            if (!(!((Collection)list).isEmpty())) continue;
            levelTiers.add(tier);
        }
        return levelTiers;
    }

    private final void parseApplySettings(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        this.parseFineTuning(cs);
        this.parseEntityNameOverride(YmlParsingHelper.Companion.objToCS(cs, "entity-name-override"));
        this.parseTieredColoring(YmlParsingHelper.Companion.objToCS(cs, "tiered-coloring"));
        this.parseHealthIndicator(YmlParsingHelper.Companion.objToCS(cs, "health-indicator"));
        this.parsingInfo.setConstructLevel(ymlHelper.getString("construct-level", this.parsingInfo.getConstructLevel()));
        this.parsingInfo.setRestrictionsMinLevel(ymlHelper.getInt2("minlevel", this.parsingInfo.getRestrictionsMinLevel()));
        this.parsingInfo.setRestrictionsMaxLevel(ymlHelper.getInt2("maxlevel", this.parsingInfo.getRestrictionsMaxLevel()));
        this.parsingInfo.setInvalidPlaceholderReplacement(ymlHelper.getString("invalid-placeholder-replacement", this.parsingInfo.getInvalidPlaceholderReplacement()));
        this.parsingInfo.setConditionsNoDropEntities(Companion.buildCachedModalListOfString(cs, "no-drop-multipler-entities", this.parsingInfo.getConditionsNoDropEntities(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setBabyMobsInheritAdultSetting(ymlHelper.getBoolean2("baby-mobs-inherit-adult-setting", this.parsingInfo.getBabyMobsInheritAdultSetting()));
        this.parsingInfo.setMobLevelInheritance(ymlHelper.getBoolean2("level-inheritance", this.parsingInfo.getMobLevelInheritance()));
        this.parsingInfo.setCreeperMaxDamageRadius(ymlHelper.getInt2("creeper-max-damage-radius", this.parsingInfo.getCreeperMaxDamageRadius()));
        this.parsingInfo.setCustomDropsUseForMobs(ymlHelper.getBoolean2("use-custom-item-drops-for-mobs", this.parsingInfo.getCustomDropsUseForMobs()));
        this.parseChunkKillOptions(ymlHelper);
        this.parsingInfo.getCustomDropDropTableIds().addAll((Collection<String>)ymlHelper.getListFromConfigItem("use-droptable-id"));
        this.parsingInfo.setNametag(ymlHelper.getString("nametag", this.parsingInfo.getNametag()));
        this.parsingInfo.setNametagCreatureDeath(ymlHelper.getString("creature-death-nametag", this.parsingInfo.getNametagCreatureDeath()));
        this.parsingInfo.setNametagPlaceholderLevelled(ymlHelper.getString("nametag-placeholder-levelled", this.parsingInfo.getNametagPlaceholderLevelled()));
        this.parsingInfo.setNametagPlaceholderUnlevelled(ymlHelper.getString("nametag-placeholder-unlevelled", this.parsingInfo.getNametagPlaceholderUnlevelled()));
        this.parsingInfo.setSunlightBurnAmount(ymlHelper.getDouble2("sunlight-intensity", this.parsingInfo.getSunlightBurnAmount()));
        this.parsingInfo.setLockEntity(ymlHelper.getBoolean2("lock-entity", this.parsingInfo.getLockEntity()));
        this.parseNBTData(ymlHelper);
        this.parsingInfo.setPassengerMatchLevel(ymlHelper.getBoolean2("passenger-match-level", this.parsingInfo.getPassengerMatchLevel()));
        this.parsingInfo.setNametagVisibleTime(ymlHelper.getIntTimeUnitMS("nametag-visible-time", this.parsingInfo.getNametagVisibleTime()));
        this.parsingInfo.setMaximumDeathInChunkThreshold(ymlHelper.getInt2("maximum-death-in-chunk-threshold", this.parsingInfo.getMaximumDeathInChunkThreshold()));
        this.parsingInfo.setChunkMaxCoolDownTime(ymlHelper.getIntTimeUnit("chunk-max-cooldown-seconds", this.parsingInfo.getChunkMaxCoolDownTime()));
        this.parsingInfo.setSpawnerParticlesCount(ymlHelper.getInt2("spawner-particles-count", this.parsingInfo.getSpawnerParticlesCount()));
        this.parsingInfo.setMaxAdjacentChunks(ymlHelper.getInt2("max-adjacent-chunks", this.parsingInfo.getMaxAdjacentChunks()));
        if (this.parsingInfo.getMaxAdjacentChunks() != null) {
            Integer n = this.parsingInfo.getMaxAdjacentChunks();
            Intrinsics.checkNotNull(n);
            if (n > 10) {
                this.parsingInfo.setMaxAdjacentChunks(10);
            }
        }
        this.parseSpawnerParticle(ymlHelper.getString("spawner-particles"));
        this.parseDeathMessages(cs);
        Set<String> nametagVisibility = ymlHelper.getStringSet("nametag-visibility-method");
        List nametagVisibilityEnums = new ArrayList();
        for (String nametagVisEnum : nametagVisibility) {
            try {
                String string = nametagVisEnum.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                NametagVisibilityEnum nametagVisibilityEnum = NametagVisibilityEnum.valueOf(string);
                nametagVisibilityEnums.add(nametagVisibilityEnum);
            }
            catch (Exception exception) {
                Log.INSTANCE.war("Invalid value in nametag-visibility-method: " + nametagVisibility + ", in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
            }
        }
        if (!((Collection)nametagVisibilityEnums).isEmpty()) {
            this.parsingInfo.setNametagVisibilityEnum(nametagVisibilityEnums);
        }
        for (String key : ymlHelper.getCs().getKeys(false)) {
            if (KeyValidation.INSTANCE.getSettings().contains(key)) continue;
            Log.INSTANCE.war("Invalid setting '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
    }

    private final void parseChunkKillOptions(YmlParsingHelper ymlHelper) {
        ChunkKillOptions opts = new ChunkKillOptions();
        opts.setDisableVanillaDrops(ymlHelper.getBoolean2("disable-vanilla-drops-on-chunk-max", null));
        opts.setDisableItemBoost(ymlHelper.getBoolean2("disable-item-boost-on-chunk-max", null));
        opts.setDisableXpDrops(ymlHelper.getBoolean2("disable-xp-boost-on-chunk-max", null));
        if (!opts.isDefault()) {
            this.parsingInfo.setChunkKillOptions(opts);
        }
    }

    private final void parseDeathMessages(ConfigurationSection csParent) {
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(csParent, "death-messages");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection cs = configurationSection;
        DeathMessages deathMessages = new DeathMessages();
        for (String weightStr : cs.getKeys(false)) {
            String temp;
            CharSequence charSequence;
            List messages;
            Intrinsics.checkNotNullExpressionValue(cs.getStringList(weightStr), "getStringList(...)");
            if (messages.isEmpty() && !((charSequence = (CharSequence)(temp = cs.getString(weightStr))) == null || charSequence.length() == 0)) {
                messages.add(temp);
            }
            for (String message : messages) {
                if (!Utils.INSTANCE.isInteger(weightStr)) {
                    Log.INSTANCE.war("Invalid number in DeathMessages section: " + weightStr);
                    continue;
                }
                Intrinsics.checkNotNull(weightStr);
                int weight = Integer.parseInt(weightStr);
                if (weight > 100) {
                    Log.INSTANCE.war("value of " + weight + " is over the limit of 100 for death message weight");
                    weight = 100;
                }
                Intrinsics.checkNotNull(message);
                deathMessages.addEntry(weight, message);
            }
        }
        if (!deathMessages.isEmpty()) {
            this.parsingInfo.setDeathMessages(deathMessages);
        }
    }

    private final void parseSpawnerParticle(String particle) {
        if (particle == null) {
            return;
        }
        if (StringsKt.equals("none", particle, true)) {
            this.parsingInfo.setSpawnerParticle(null);
            this.parsingInfo.setUseNoSpawnerParticles(true);
            return;
        }
        try {
            String string = particle.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            this.parsingInfo.setSpawnerParticle(Particle.valueOf((String)string));
        }
        catch (Exception exception) {
            Log.INSTANCE.war("Invalid value in spawner-particles: " + particle + ", in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
    }

    private final void parseNBTData(YmlParsingHelper ymlHelper) {
        String keyName = ymlHelper.getKeyNameFromConfig("nbt-data");
        Object object = ymlHelper.getCs().get(keyName);
        if (object == null) {
            return;
        }
        Object temp = object;
        if (temp instanceof MemorySection || temp instanceof LinkedHashMap) {
            ConfigurationSection configurationSection = ymlHelper.objToCS(keyName);
            if (configurationSection == null) {
                return;
            }
            ConfigurationSection cs2 = configurationSection;
            String nbt = YmlParsingHelper.Companion.getString(cs2, "data", null);
            Set<String> nbtList = YmlParsingHelper.Companion.getStringSet(cs2, "data");
            if (nbt == null && nbtList.isEmpty()) {
                return;
            }
            boolean doMerge = YmlParsingHelper.Companion.getBoolean(cs2, "merge", false);
            if (!((Collection)nbtList).isEmpty()) {
                this.parsingInfo.setMobNBTData(new MergeableStringList());
                MergeableStringList mergeableStringList = this.parsingInfo.getMobNBTData();
                Intrinsics.checkNotNull(mergeableStringList);
                mergeableStringList.setItemFromList((Collection<String>)nbtList);
                MergeableStringList mergeableStringList2 = this.parsingInfo.getMobNBTData();
                Intrinsics.checkNotNull(mergeableStringList2);
                mergeableStringList2.setDoMerge(doMerge);
            } else {
                this.parsingInfo.setMobNBTData(new MergeableStringList(nbt, doMerge));
            }
        } else if (temp instanceof Collection) {
            this.parsingInfo.setMobNBTData(new MergeableStringList());
            MergeableStringList mergeableStringList = this.parsingInfo.getMobNBTData();
            Intrinsics.checkNotNull(mergeableStringList);
            mergeableStringList.setItemFromList((Collection)temp);
        } else if (temp instanceof String) {
            this.parsingInfo.setMobNBTData(new MergeableStringList((String)temp));
        }
    }

    private final void parseConditions(ConfigurationSection cs) {
        String mobTamedStatus;
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        this.parsingInfo.setConditionsWorlds(Companion.buildCachedModalListOfString(cs, "worlds", this.parsingInfo.getConditionsWorlds(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsMinLevel(ymlHelper.getInt2("minlevel", this.parsingInfo.getConditionsMinLevel()));
        this.parsingInfo.setConditionsMaxLevel(ymlHelper.getInt2("maxlevel", this.parsingInfo.getConditionsMaxLevel()));
        this.parsingInfo.setStopProcessingRules(ymlHelper.getBoolean2("stop-processing", this.parsingInfo.getStopProcessingRules()));
        this.parsingInfo.setConditionsChance(ymlHelper.getFloat2("chance", this.parsingInfo.getConditionsChance()));
        this.parsingInfo.setConditionsStructure(RulesParser.Companion.buildCachedModalOfType(cs, this.parsingInfo.getConditionsStructure(), ModalListParsingTypes.STRUCTURE, this.parsingInfo));
        String mobCustomNameStatus = ymlHelper.getString("mob-customname-status");
        if (mobCustomNameStatus != null) {
            try {
                String string = mobCustomNameStatus.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                this.parsingInfo.setConditionsMobCustomnameStatus(MobCustomNameStatus.valueOf(string));
            }
            catch (Exception exception) {
                Log.INSTANCE.war("Invalid value for " + mobCustomNameStatus);
            }
        }
        if ((mobTamedStatus = ymlHelper.getString("mob-tamed-status")) != null) {
            try {
                String string = mobTamedStatus.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                this.parsingInfo.setConditionsMobTamedStatus(MobTamedStatus.valueOf(string));
            }
            catch (Exception exception) {
                Log.INSTANCE.war("Invalid value for " + mobTamedStatus);
            }
        }
        this.parsingInfo.setConditionsApplyAboveY(ymlHelper.getInt2("apply-above-y", this.parsingInfo.getConditionsApplyAboveY()));
        this.parsingInfo.setConditionsApplyBelowY(ymlHelper.getInt2("apply-below-y", this.parsingInfo.getConditionsApplyBelowY()));
        this.parsingInfo.setConditionsMinDistanceFromSpawn(ymlHelper.getInt2("min-distance-from-spawn", this.parsingInfo.getConditionsMinDistanceFromSpawn()));
        this.parsingInfo.setConditionsMaxDistanceFromSpawn(ymlHelper.getInt2("max-distance-from-spawn", this.parsingInfo.getConditionsMaxDistanceFromSpawn()));
        this.parsingInfo.setConditionsCooldownTime(ymlHelper.getIntTimeUnitMS("cooldown-duration", this.parsingInfo.getConditionsCooldownTime()));
        this.parsingInfo.setConditionsTimesToCooldownActivation(ymlHelper.getInt2("cooldown-limit", this.parsingInfo.getConditionsTimesToCooldownActivation()));
        this.parseWithinCoordinates(YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), "within-coordinates"));
        this.parsingInfo.setConditionsWGregions(Companion.buildCachedModalListOfString(cs, "worldguard-regions", this.parsingInfo.getConditionsWGregions(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsWGregionOwners(Companion.buildCachedModalListOfString(cs, "worldguard-region-owners", this.parsingInfo.getConditionsWGregionOwners(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsSpawnReasons(RulesParser.Companion.buildCachedModalOfType(cs, this.parsingInfo.getConditionsSpawnReasons(), ModalListParsingTypes.SPAWN_REASON, this.parsingInfo));
        this.parsingInfo.setConditionsCustomNames(Companion.buildCachedModalListOfString(cs, "custom-names", this.parsingInfo.getConditionsCustomNames(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsEntities(Companion.buildCachedModalListOfString(cs, "entities", this.parsingInfo.getConditionsEntities(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsBiomes(RulesParser.Companion.buildCachedModalOfType(cs, this.parsingInfo.getConditionsBiomes(), ModalListParsingTypes.BIOME, this.parsingInfo));
        this.parsingInfo.setConditionsExternalPlugins(Companion.buildCachedModalListOfString(cs, "external-plugins", this.parsingInfo.getConditionsExternalPlugins(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsMMnames(Companion.buildCachedModalListOfString(cs, "mythicmobs-internal-names", this.parsingInfo.getConditionsMMnames(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsSpawnerNames(Companion.buildCachedModalListOfString(cs, "spawner-names", this.parsingInfo.getConditionsSpawnerNames(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsSpawnegEggNames(Companion.buildCachedModalListOfString(cs, "spawner-egg-names", this.parsingInfo.getConditionsSpawnegEggNames(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsWorldTickTime(this.parseWorldTimeTicks(cs, this.parsingInfo.getConditionsWorldTickTime()));
        this.parsingInfo.setConditionsPermission(Companion.buildCachedModalListOfString(cs, "permission", this.parsingInfo.getConditionsPermission(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsPlayerNames(Companion.buildCachedModalListOfString(cs, "player-names", this.parsingInfo.getConditionsPlayerNames(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsGamemode(Companion.buildCachedModalListOfString(cs, "gamemode", this.parsingInfo.getConditionsGamemode(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsScoreboardTags(Companion.buildCachedModalListOfString(cs, "scoreboard-tags", this.parsingInfo.getConditionsScoreboardTags(), this.parsingInfo.getRuleName$levelledmobs_plugin()));
        this.parsingInfo.setConditionsSkyLightLevel(this.parseMinMaxValue(ymlHelper.getString("skylight-level")));
        this.checkExternalPlugins();
        for (String key : ymlHelper.getCs().getKeys(false)) {
            if (KeyValidation.INSTANCE.getConditions().contains(key)) continue;
            Log.INSTANCE.war("Invalid condition '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
    }

    private final void checkExternalPlugins() {
        String checkName;
        CachedModalList<String> compats = this.parsingInfo.getConditionsExternalPlugins();
        if (compats == null || compats.isEmpty()) {
            return;
        }
        for (String pluginName : compats.getIncludedList()) {
            checkName = StringsKt.replace$default(pluginName, "_", "-", false, 4, null);
            if (ExternalCompatibilityManager.Companion.getInstance().getExternalPluginDefinitions().containsKey(checkName)) continue;
            Log.INSTANCE.war("no external plugin definition found for: '" + checkName + "'");
        }
        for (String pluginName : compats.getExcludedList()) {
            checkName = StringsKt.replace$default(pluginName, "_", "-", false, 4, null);
            if (ExternalCompatibilityManager.Companion.getInstance().getExternalPluginDefinitions().containsKey(checkName)) continue;
            Log.INSTANCE.war("no external plugin definition found for: '" + checkName + "'");
        }
    }

    private final void parseWithinCoordinates(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        WithinCoordinates mdr = new WithinCoordinates();
        WithinCoordinates.Axis[] axisArray = new WithinCoordinates.Axis[]{WithinCoordinates.Axis.X, WithinCoordinates.Axis.Y, WithinCoordinates.Axis.Z};
        for (WithinCoordinates.Axis axis : CollectionsKt.mutableListOf(axisArray)) {
            String[] stringArray = new String[]{"start-", "end-"};
            for (String keyStart : CollectionsKt.mutableListOf(stringArray)) {
                String string = axis.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String key = keyStart + string;
                boolean isStart = Intrinsics.areEqual("start-", keyStart);
                String value = YmlParsingHelper.Companion.getString(cs, key);
                if (mdr.parseAxis(value, axis, isStart)) continue;
                Log.INSTANCE.war("rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin() + ", invalid value for " + key + ": " + value);
            }
        }
        if (mdr.isEmpty()) {
            return;
        }
        this.parsingInfo.setConditionsWithinCoords(mdr);
    }

    private final void parseStrategies(ConfigurationSection cs) {
        ConfigurationSection csSpawnDistance;
        ConfigurationSection csYDistance;
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        if (ymlHelper.getBoolean("random")) {
            this.parsingInfo.getLevellingStrategy().put(StrategyType.RANDOM, new RandomLevellingStrategy());
        }
        if ((csYDistance = YmlParsingHelper.Companion.objToCS(cs, "y-coordinate")) != null) {
            YmlParsingHelper ymlHelper2 = new YmlParsingHelper(csYDistance);
            YDistanceStrategy yDistanceStrategy = new YDistanceStrategy();
            for (String key : csYDistance.getKeys(false)) {
                if (KeyValidation.INSTANCE.getStrategyYCoordinate().contains(key)) continue;
                Log.INSTANCE.war("Invalid y-coordinate option '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
            }
            yDistanceStrategy.setShouldMerge(ymlHelper2.getBoolean("merge"));
            yDistanceStrategy.setStartingYLevel(ymlHelper2.getInt2("start-height", yDistanceStrategy.getStartingYLevel()));
            yDistanceStrategy.setEndingYLevel(ymlHelper2.getInt2("end-height", yDistanceStrategy.getEndingYLevel()));
            yDistanceStrategy.setYPeriod(ymlHelper2.getInt2("period", yDistanceStrategy.getYPeriod()));
            yDistanceStrategy.setIncreasePerLevel(ymlHelper2.getFloat2("increase-per-level", yDistanceStrategy.getIncreasePerLevel()));
            if (this.parsingInfo.getLevellingStrategy().containsKey((Object)StrategyType.Y_COORDINATE)) {
                LevellingStrategy levellingStrategy = this.parsingInfo.getLevellingStrategy().get((Object)StrategyType.Y_COORDINATE);
                Intrinsics.checkNotNull(levellingStrategy);
                levellingStrategy.mergeRule(yDistanceStrategy);
            } else {
                this.parsingInfo.getLevellingStrategy().put(StrategyType.Y_COORDINATE, yDistanceStrategy);
            }
        }
        if ((csSpawnDistance = YmlParsingHelper.Companion.objToCS(cs, "distance-from-origin")) != null) {
            YmlParsingHelper ymlHelper2 = new YmlParsingHelper(csSpawnDistance);
            SpawnDistanceStrategy spawnDistanceStrategy = new SpawnDistanceStrategy();
            for (String key : csSpawnDistance.getKeys(false)) {
                if (KeyValidation.INSTANCE.getStrategySpawnDistance().contains(key)) continue;
                Log.INSTANCE.war("Invalid distance-from-origin option '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
            }
            spawnDistanceStrategy.setShouldMerge(ymlHelper2.getBoolean("merge"));
            spawnDistanceStrategy.setRingedTiers(ymlHelper2.getFloat2("ringed-tiers", spawnDistanceStrategy.getRingedTiers()));
            spawnDistanceStrategy.setBufferDistance(ymlHelper2.getFloat2("buffer-distance", spawnDistanceStrategy.getBufferDistance()));
            spawnDistanceStrategy.setEnableHeightMod(ymlHelper2.getBoolean2("enable-height-modifier", spawnDistanceStrategy.getEnableHeightMod()));
            spawnDistanceStrategy.setTransitionYheight(ymlHelper2.getFloat2("transition-y-height", spawnDistanceStrategy.getTransitionYheight()));
            spawnDistanceStrategy.setLvlMultiplier(ymlHelper2.getFloat2("level-multiplier", spawnDistanceStrategy.getLvlMultiplier()));
            spawnDistanceStrategy.setYHeightPeriod(ymlHelper2.getFloat2("y-height-period", spawnDistanceStrategy.getYHeightPeriod()));
            spawnDistanceStrategy.setScaleDownward(ymlHelper2.getBoolean2("scale-increase-downward", spawnDistanceStrategy.getScaleDownward()));
            this.parseOptionalSpawnCoordinate(csSpawnDistance, spawnDistanceStrategy);
            if (this.parsingInfo.getLevellingStrategy().containsKey((Object)StrategyType.SPAWN_DISTANCE)) {
                LevellingStrategy levellingStrategy = this.parsingInfo.getLevellingStrategy().get((Object)StrategyType.SPAWN_DISTANCE);
                Intrinsics.checkNotNull(levellingStrategy);
                levellingStrategy.mergeRule(spawnDistanceStrategy);
            } else {
                this.parsingInfo.getLevellingStrategy().put(StrategyType.SPAWN_DISTANCE, spawnDistanceStrategy);
            }
        }
        this.parseWeightedRandom(cs);
        for (String key : ymlHelper.getCs().getKeys(false)) {
            if (KeyValidation.INSTANCE.getStrategies().contains(key)) continue;
            Log.INSTANCE.war("Invalid strategy '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
    }

    private final void parseModifiers(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        this.parsingInfo.setMaxRandomVariance(ymlHelper.getInt2("max-random-variance", this.parsingInfo.getMaxRandomVariance()));
        this.parsePlayerLevellingOptions(YmlParsingHelper.Companion.objToCS(cs, "player-variable-mod"));
        for (String key : cs.getKeys(false)) {
            Intrinsics.checkNotNull(key);
            if (!StringsKt.startsWith(key, "custom", true)) continue;
            this.parseCustomStrategy(cs, key);
        }
        for (String key : ymlHelper.getCs().getKeys(false)) {
            if (KeyValidation.INSTANCE.getModifiers().contains(key)) continue;
            Intrinsics.checkNotNull(key);
            if (StringsKt.startsWith(key, "custom", true)) continue;
            Log.INSTANCE.war("Invalid modifier '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
    }

    private final void parseCustomStrategy(ConfigurationSection cs, String keyName) {
        String string;
        int underScore = StringsKt.indexOf$default((CharSequence)keyName, "_", 0, false, 6, null);
        if (StringsKt.equals("custom", keyName, true)) {
            string = null;
        } else {
            if (underScore <= 0 || underScore == keyName.length() - 1 || StringsKt.equals("custom", keyName, true)) {
                Log.INSTANCE.war("Modifier '" + keyName + "' must have a unique name specified");
                return;
            }
            String string2 = keyName.substring(underScore + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        }
        String customName = string;
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, keyName);
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection csCustom = configurationSection;
        CustomStrategy customStrategy = new CustomStrategy(customName);
        customStrategy.setFormula(csCustom.getString("formula"));
        CharSequence charSequence = customStrategy.getFormula();
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.parsingInfo.getCustomStrategy().put(customStrategy.getPlaceholderName(), customStrategy);
            RulesManager.Companion.getInstance().getAllCustomStrategyPlaceholders().add(customStrategy.getPlaceholderName());
        }
    }

    private final void parseWeightedRandom(ConfigurationSection cs) {
        String useWeightedRandom = cs.getString("weighted-random");
        boolean isDisabled = StringsKt.equals("false", useWeightedRandom, true);
        if (isDisabled || StringsKt.equals("true", useWeightedRandom, true)) {
            RandomLevellingStrategy randomLevelling = new RandomLevellingStrategy();
            if (isDisabled) {
                randomLevelling.setEnabled(false);
            } else {
                randomLevelling.setAutoGenerate(true);
            }
            this.parsingInfo.getLevellingStrategy().put(StrategyType.WEIGHTED_RANDOM, randomLevelling);
            return;
        }
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, "weighted-random");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection csRandom = configurationSection;
        Map randomMap = new LinkedHashMap();
        RandomLevellingStrategy randomLevelling = new RandomLevellingStrategy();
        randomLevelling.setShouldMerge(YmlParsingHelper.Companion.getBoolean(csRandom, "merge"));
        for (String range : csRandom.getKeys(false)) {
            if (StringsKt.equals("merge", range, true)) continue;
            int value = csRandom.getInt(range);
            randomMap.put(range, value);
        }
        if (!randomMap.isEmpty()) {
            randomLevelling.getWeightedRandomMap().putAll(randomMap);
        }
        if (this.parsingInfo.getLevellingStrategy().containsKey((Object)StrategyType.WEIGHTED_RANDOM)) {
            if (randomLevelling.getShouldMerge()) {
                LevellingStrategy levellingStrategy = this.parsingInfo.getLevellingStrategy().get((Object)StrategyType.WEIGHTED_RANDOM);
                Intrinsics.checkNotNull(levellingStrategy);
                levellingStrategy.mergeRule(randomLevelling);
            } else {
                this.parsingInfo.getLevellingStrategy().put(StrategyType.WEIGHTED_RANDOM, randomLevelling);
            }
        } else {
            this.parsingInfo.getLevellingStrategy().put(StrategyType.WEIGHTED_RANDOM, randomLevelling);
        }
    }

    private final CachedModalList<MinAndMax> parseWorldTimeTicks(ConfigurationSection cs, CachedModalList<MinAndMax> existingList) {
        if (cs == null) {
            return existingList;
        }
        String configName = "world-time-tick";
        CachedModalList<String> cachedModalList = Companion.buildCachedModalListOfString(cs, configName, null, this.parsingInfo.getRuleName$levelledmobs_plugin());
        if (cachedModalList == null) {
            return existingList;
        }
        CachedModalList<String> temp = cachedModalList;
        CachedModalList<MinAndMax> result = new CachedModalList<MinAndMax>();
        result.setIncludeAll(temp.getIncludeAll());
        result.setExcludeAll(temp.getExcludeAll());
        result.getExcludedList().addAll((Collection)this.parseMinMaxValue(temp.getExcludedList(), configName));
        result.getIncludedList().addAll((Collection)this.parseMinMaxValue(temp.getIncludedList(), configName));
        return result;
    }

    private final MinAndMax parseMinMaxValue(String numberPair) {
        if (numberPair == null) {
            return null;
        }
        String[] stringArray = new String[]{numberPair};
        Set<MinAndMax> result = this.parseMinMaxValue(SetsKt.mutableSetOf(stringArray), "skylight-level");
        return result.isEmpty() ? null : result.iterator().next();
    }

    private final Set<MinAndMax> parseMinMaxValue(Set<String> numberPairs, String configName) {
        Set result = new LinkedHashSet();
        for (String numberPair : numberPairs) {
            String[] stringArray = new String[]{"-"};
            List split = StringsKt.split$default((CharSequence)numberPair, stringArray, false, 0, 6, null);
            MinAndMax minAndMax = new MinAndMax();
            boolean hadInvalidValue = false;
            for (int i = 0; i < 2; ++i) {
                if (!Utils.INSTANCE.isInteger((String)split.get(i))) {
                    Log.INSTANCE.war("Invalid value for " + configName + ": '" + split.get(i) + "' in rule " + this.parsingInfo.getRuleName$levelledmobs_plugin());
                    hadInvalidValue = true;
                    break;
                }
                int parsedNum = Integer.parseInt((String)split.get(i));
                if (i == 0) {
                    minAndMax.setMin(parsedNum);
                    if (split.size() != 1) continue;
                    minAndMax.setMax(parsedNum);
                    continue;
                }
                minAndMax.setMax(parsedNum);
            }
            if (hadInvalidValue) continue;
            result.add(minAndMax);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void parseHealthIndicator(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        HealthIndicator indicator = new HealthIndicator();
        indicator.setIndicator(ymlHelper.getString("indicator", indicator.getIndicator()));
        indicator.setIndicatorHalf(ymlHelper.getString("indicator-half", indicator.getIndicatorHalf()));
        indicator.setMaxIndicators(ymlHelper.getInt2("max", indicator.getMaxIndicators()));
        indicator.setScale(ymlHelper.getDouble2("scale", indicator.getScale()));
        indicator.setMaintainSpace(ymlHelper.getBoolean2("maintain-space", indicator.getMaintainSpace()));
        indicator.setMerge(ymlHelper.getBoolean2("merge", indicator.getMerge()));
        ConfigurationSection csTiers = YmlParsingHelper.Companion.objToCS(cs, "colored-tiers");
        if (csTiers != null) {
            Map tiers = new LinkedHashMap();
            for (String name : csTiers.getKeys(false)) {
                Intrinsics.checkNotNull(name);
                String string = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String name2 = StringsKt.replace$default(string, "tier-", "", false, 4, null);
                if (StringsKt.equals("default", name, true)) {
                    CharSequence charSequence = csTiers.getString(name);
                    if (charSequence == null || charSequence.length() == 0) {
                        Log.INSTANCE.war("No value entered for colored tier: " + name);
                        continue;
                    }
                    Integer n = 0;
                    String string2 = csTiers.getString(name);
                    Intrinsics.checkNotNull(string2);
                    tiers.put(n, string2);
                    continue;
                }
                if (!Utils.INSTANCE.isInteger(name2)) {
                    Log.INSTANCE.war("Not a valid colored tier, missing number: " + name);
                    continue;
                }
                String tierValue = csTiers.getString(name);
                CharSequence charSequence = tierValue;
                if (charSequence == null || charSequence.length() == 0) {
                    Log.INSTANCE.war("No value entered for colored tier: " + name);
                    continue;
                }
                int tierNumber = Integer.parseInt(name2);
                if (tiers.containsKey(tierNumber)) {
                    Log.INSTANCE.war("Duplicate tier: " + name);
                    continue;
                }
                tiers.put(tierNumber, tierValue);
            }
            if (!tiers.isEmpty()) {
                indicator.setTiers(tiers);
            }
        }
        if (this.parsingInfo.getHealthIndicator() != null) {
            HealthIndicator healthIndicator = this.parsingInfo.getHealthIndicator();
            Intrinsics.checkNotNull(healthIndicator);
            if (healthIndicator.getDoMerge()) {
                HealthIndicator healthIndicator2 = this.parsingInfo.getHealthIndicator();
                Intrinsics.checkNotNull(healthIndicator2);
                healthIndicator2.merge(indicator);
                return;
            }
        }
        this.parsingInfo.setHealthIndicator(indicator);
    }

    private final void parsePlayerLevellingOptions(ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        PlayerLevellingStrategy options = new PlayerLevellingStrategy();
        options.setMatchVariable(ymlHelper.getBoolean2("match-variable", options.getMatchVariable()));
        options.setUsevariableAsMax(ymlHelper.getBoolean2("use-variable-as-max", options.getUsevariableAsMax()));
        options.setPlayerVariableScale(ymlHelper.getFloat2("player-variable-scale", options.getPlayerVariableScale()));
        options.setOutputCap(ymlHelper.getFloat2("output-cap", options.getOutputCap()));
        options.setEnabled(ymlHelper.getBoolean2("enabled", options.getEnabled()));
        options.setShouldMerge(ymlHelper.getBoolean("merge"));
        options.setVariable(ymlHelper.getString("player-variable", options.getVariable()));
        options.setDecreaseOutput(ymlHelper.getBoolean("decrease-output", true));
        options.setRecheckPlayers(ymlHelper.getBoolean2("recheck-players", options.getRecheckPlayers()));
        options.setPreserveEntityTime(ymlHelper.getIntTimeUnitMS("preserve-entity", options.getPreserveEntityTime()));
        this.parsingInfo.getLevellingStrategy().put(options.getStrategyType(), options);
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, "player-variable-tiers");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection csTiers = configurationSection;
        List levelTiers = new ArrayList();
        LevelTierMatching defaultTier = null;
        for (String key : csTiers.getKeys(true)) {
            boolean isDefault = false;
            if (StringsKt.equals("default", key, true)) {
                isDefault = true;
            }
            String value = csTiers.getString(key);
            LevelTierMatching info = new LevelTierMatching();
            if (value == null) {
                Log.INSTANCE.war("No value was specified for: " + key);
                continue;
            }
            Intrinsics.checkNotNull(key);
            if (!StringsKt.contains$default((CharSequence)key, "-", false, 2, null) && !Utils.INSTANCE.isInteger(key)) {
                info.setSourceTierName(key);
            } else if (!info.setRangeFromString(key)) {
                Log.INSTANCE.war("Invalid number range: " + key);
                continue;
            }
            MinAndMax levelRange = MinAndMax.Companion.setAmountRangeFromString(value);
            if (levelRange == null) {
                Log.INSTANCE.war("Invalid number range: " + value);
                continue;
            }
            info.setValueRanges(levelRange);
            if (isDefault) {
                defaultTier = info;
                continue;
            }
            levelTiers.add(info);
        }
        if (!((Collection)levelTiers).isEmpty()) {
            options.getLevelTiers().addAll(levelTiers);
        }
        options.setDefaultLevelTier(defaultTier);
    }

    private final void parseOptionalSpawnCoordinate(ConfigurationSection cs, SpawnDistanceStrategy sds) {
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, "origin-coordinates");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection spawnLocation = configurationSection;
        for (String key : spawnLocation.getKeys(false)) {
            if (KeyValidation.INSTANCE.getStrategySpawnDistanceCoords().contains(key)) continue;
            Log.INSTANCE.war("Invalid origin-coordinates option '" + key + "', in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
        }
        if (!StringsKt.equals("spawn", spawnLocation.getString("x"), true)) {
            sds.setOriginCoordX(Float.valueOf((float)spawnLocation.getDouble("x")));
        }
        if (!StringsKt.equals("spawn", spawnLocation.getString("z"), true)) {
            sds.setOriginCoordZ(Float.valueOf((float)spawnLocation.getDouble("z")));
        }
    }

    private final void parseFineTuning(ConfigurationSection csBase) {
        if (csBase == null) {
            return;
        }
        this.parsingInfo.setVanillaBonuses(RulesParser.Companion.buildCachedModalOfType(csBase, this.parsingInfo.getVanillaBonuses(), ModalListParsingTypes.VANILLA_BONUSES, this.parsingInfo));
        FineTuningAttributes fineTuning = null;
        String[] stringArray = new String[]{"base-attribute-modifier", "attribute-modifier"};
        List<String> namesList = CollectionsKt.mutableListOf(stringArray);
        Object object = new String[]{"custom-base-attribute-modifier", "custom-attribute-modifier"};
        List<String> namesList2 = CollectionsKt.mutableListOf(object);
        object = ((Iterable)namesList).iterator();
        int n = 0;
        while (object.hasNext()) {
            ConfigurationSection csCustom;
            ConfigurationSection cs;
            Map<Addition, FineTuningAttributes.Multiplier> useDefaults;
            int loopNum = n++;
            String useName = (String)object.next();
            boolean isBaseModifier = loopNum == 0;
            String useName2 = namesList2.get(loopNum);
            if (fineTuning == null) {
                fineTuning = new FineTuningAttributes();
            }
            Map<Addition, FineTuningAttributes.Multiplier> map = useDefaults = isBaseModifier ? fineTuning.getBaseAttributeModifiers() : fineTuning.getMultipliers();
            if (YmlParsingHelper.Companion.objToCS(csBase, useName) == null) continue;
            FineTuningParseResult parseResult = this.parseFineTuningValues(cs, useDefaults, isBaseModifier);
            if (isBaseModifier) {
                fineTuning.setBaseAttributeModifiers(parseResult.getResult());
                fineTuning.setDoNotMergeAllBaseMods(parseResult.getDoNotMerge());
            } else {
                fineTuning.setMultipliers(parseResult.getResult());
                fineTuning.setDoNotMergeAllMultipliers(parseResult.getDoNotMerge());
            }
            if (parseResult.getDoNotMergeAny()) {
                fineTuning.setDoNotMerge(true);
            }
            Map mobSpecificMultipliers = new LinkedHashMap();
            if (YmlParsingHelper.Companion.objToCS(cs, useName2) == null) continue;
            Iterator iterator2 = csCustom.getKeys(false).iterator();
            while (iterator2.hasNext()) {
                String mobName;
                String checkName = mobName = (String)iterator2.next();
                Boolean doNotMerge = null;
                String string = checkName;
                Intrinsics.checkNotNull(string);
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (StringsKt.startsWith$default(string2, "baby_", false, 2, null)) {
                    string = checkName;
                    Intrinsics.checkNotNull(string);
                    int n2 = 5;
                    String string3 = string.substring(n2);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    checkName = string3;
                }
                if (StringsKt.equals("merge", mobName, true)) {
                    doNotMerge = !csCustom.getBoolean(mobName);
                } else if (StringsKt.equals("do-not-merge", mobName, true)) {
                    doNotMerge = csCustom.getBoolean(mobName);
                }
                if (doNotMerge != null) {
                    if (isBaseModifier) {
                        fineTuning.setDoNotMergeMobSpecificBaseMods(doNotMerge);
                        continue;
                    }
                    fineTuning.setDoNotMergeMobSpecificMultipliers(doNotMerge);
                    continue;
                }
                try {
                    string = checkName;
                    Intrinsics.checkNotNull(string);
                    String string4 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                    EntityType.valueOf((String)string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.INSTANCE.war("Invalid entity type: " + mobName + " for fine-tuning in rule: " + this.parsingInfo.getRuleName$levelledmobs_plugin());
                    continue;
                }
                Intrinsics.checkNotNull(mobName);
                FineTuningParseResult parseResult2 = this.parseFineTuningValues(YmlParsingHelper.Companion.objToCS(csCustom, mobName), null, isBaseModifier);
                if (parseResult2.getDoNotMerge()) {
                    if (isBaseModifier) {
                        fineTuning.setDoNotMergeMobSpecificBaseMods(true);
                    } else {
                        fineTuning.setDoNotMergeMobSpecificMultipliers(true);
                    }
                }
                if (parseResult2.getResult() == null) continue;
                mobSpecificMultipliers.put(mobName, parseResult2.getResult());
            }
            if (mobSpecificMultipliers.isEmpty()) continue;
            if (isBaseModifier) {
                fineTuning.setMobSpecificBaseModifiers(mobSpecificMultipliers);
                continue;
            }
            fineTuning.setMobSpecificMultipliers(mobSpecificMultipliers);
        }
        if (fineTuning != null && !fineTuning.isEmpty()) {
            this.parsingInfo.setMobMultipliers(fineTuning);
        }
    }

    private final FineTuningParseResult parseFineTuningValues(ConfigurationSection cs, Map<Addition, FineTuningAttributes.Multiplier> defaults, boolean isBaseModifier) {
        if (cs == null) {
            return new FineTuningParseResult(false, false, defaults);
        }
        Boolean useStacked = null;
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        boolean doNotMerge = !ymlHelper.getBoolean("merge", true);
        boolean doNotMergeAny = ymlHelper.getBoolean("do-not-merge-any", false);
        Map results = new LinkedHashMap();
        block17: for (String item : cs.getKeys(false)) {
            String string;
            Intrinsics.checkNotNull(item);
            Intrinsics.checkNotNullExpressionValue(item.toLowerCase(Locale.ROOT), "toLowerCase(...)");
            int n = -1;
            switch (string.hashCode()) {
                case -1932675588: {
                    if (string.equals("do-not-merge")) {
                        n = 1;
                    }
                    break;
                }
                case -1149690616: {
                    if (string.equals("custom-base-attribute-modifier")) {
                        n = 2;
                    }
                    break;
                }
                case 1304587972: {
                    if (string.equals("custom-attribute-modifier")) {
                        n = 2;
                    }
                    break;
                }
                case 103785528: {
                    if (string.equals("merge")) {
                        n = 3;
                    }
                    break;
                }
                case -996784307: {
                    if (string.equals("vanilla-bonus")) {
                        n = 2;
                    }
                    break;
                }
                case 1658865307: {
                    if (string.equals("do-not-merge-any")) {
                        n = 2;
                    }
                    break;
                }
                case 435977953: {
                    if (string.equals("use-stacked")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    continue block17;
                }
                case 3: {
                    doNotMerge = !ymlHelper.getBoolean(item, true);
                    continue block17;
                }
                case 4: {
                    useStacked = ymlHelper.getBoolean2(item, useStacked);
                    continue block17;
                }
                case 1: {
                    doNotMerge = ymlHelper.getBoolean(item, false);
                    continue block17;
                }
            }
            LMMultiplier lmMultiplier = null;
            try {
                String string2 = StringsKt.replace$default(item, "-", "_", false, 4, null).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                lmMultiplier = LMMultiplier.valueOf(string2);
            }
            catch (Exception exception) {
                Log.INSTANCE.war("Invalid multiplier: " + item);
                continue;
            }
            Addition addition = FineTuningAttributes.Companion.getAdditionFromLMMultiplier(lmMultiplier);
            FineTuningAttributes.Multiplier multiplier = this.parseFineTuningValues2(cs, addition, item, isBaseModifier);
            if (multiplier == null) continue;
            results.put(addition, multiplier);
        }
        return results.isEmpty() ? new FineTuningParseResult(doNotMerge, doNotMergeAny, defaults) : new FineTuningParseResult(doNotMerge, doNotMergeAny, results);
    }

    private final FineTuningAttributes.Multiplier parseFineTuningValues2(ConfigurationSection cs, Addition addition, String item, boolean isBaseModifier) {
        List values = cs.getList(item);
        if (values == null) {
            String formula = YmlParsingHelper.Companion.getString(cs, item);
            Float value = YmlParsingHelper.Companion.getFloat2(cs, item, null);
            return value != null ? new FineTuningAttributes.Multiplier(addition, false, value, null, false, isBaseModifier) : (formula != null ? new FineTuningAttributes.Multiplier(addition, false, null, formula, true, isBaseModifier) : null);
        }
        String customFormula = null;
        boolean useStacked = false;
        float value = 0.0f;
        String valueStr = null;
        boolean isAddition = false;
        Object object = ((Iterable)values).iterator();
        int n = 0;
        while (object.hasNext()) {
            int count = n++;
            Object obj = object.next();
            if (count > 2) break;
            Object t = obj;
            if (t instanceof Float) {
                value = ((Number)obj).floatValue();
                customFormula = null;
                continue;
            }
            if (t instanceof Double) {
                value = (float)((Number)obj).doubleValue();
                customFormula = null;
                continue;
            }
            if (t instanceof Integer) {
                value = ((Number)obj).intValue();
                customFormula = null;
                continue;
            }
            if (!(t instanceof String)) continue;
            if (StringsKt.equals("formula", (String)obj, true) || StringsKt.equals("formula_add", (String)obj, true)) {
                customFormula = valueStr;
                isAddition = true;
                useStacked = false;
            } else if (StringsKt.equals("formula_mult", (String)obj, true)) {
                customFormula = valueStr;
                isAddition = false;
                useStacked = false;
            } else if (StringsKt.equals("stacked", (String)obj, true)) {
                useStacked = true;
            } else if (Utils.INSTANCE.isDouble((String)obj)) {
                value = Float.parseFloat((String)obj);
            }
            valueStr = (String)obj;
            if (!useStacked) continue;
            customFormula = null;
        }
        if (value > Float.MIN_VALUE || !((object = (CharSequence)customFormula) == null || object.length() == 0)) {
            return new FineTuningAttributes.Multiplier(addition, useStacked, Float.valueOf(value), customFormula, isAddition, false);
        }
        return null;
    }

    private final void autoGenerateWeightedRandom() {
        RandomLevellingStrategy rls = null;
        int minLevel = 1;
        int maxLevel = 1;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesManager().getRulesInEffect()) {
            if (!Intrinsics.areEqual("defaults", ruleInfo.getRuleName$levelledmobs_plugin())) continue;
            if (ruleInfo.getLevellingStrategy().get((Object)StrategyType.WEIGHTED_RANDOM) != null) {
                if (rls == null) {
                    LevellingStrategy levellingStrategy = ruleInfo.getLevellingStrategy().get((Object)StrategyType.WEIGHTED_RANDOM);
                    Intrinsics.checkNotNull(levellingStrategy);
                    LevellingStrategy levellingStrategy2 = levellingStrategy.cloneItem();
                    Intrinsics.checkNotNull(levellingStrategy2, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.RandomLevellingStrategy");
                    rls = (RandomLevellingStrategy)levellingStrategy2;
                } else {
                    rls.mergeRule(ruleInfo.getLevellingStrategy().get((Object)StrategyType.WEIGHTED_RANDOM));
                }
            }
            if (ruleInfo.getRestrictionsMinLevel() != null) {
                Integer n = ruleInfo.getRestrictionsMinLevel();
                Intrinsics.checkNotNull(n);
                minLevel = n;
            }
            if (ruleInfo.getRestrictionsMaxLevel() == null) continue;
            Integer n = ruleInfo.getRestrictionsMaxLevel();
            Intrinsics.checkNotNull(n);
            maxLevel = n;
        }
        if (rls == null || !rls.getAutoGenerate() || !rls.getWeightedRandomMap().isEmpty()) {
            return;
        }
        int i = minLevel;
        int n = maxLevel;
        if (i <= n) {
            while (true) {
                rls.getWeightedRandomMap().put(i + "-" + i, maxLevel - i + 1);
                if (i == n) break;
                ++i;
            }
        }
        rls.populateWeightedRandom(minLevel, maxLevel);
    }

    static {
        String[] stringArray = new String[]{MLINCLUDEDGROUPS, MLINCLUDEDLIST, MLEXCLUDEDITEMS, MLEXCLUDEDGROUPS, "merge"};
        validModalListOptions.addAll((Collection<String>)CollectionsKt.mutableListOf(stringArray));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J6\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J6\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/RulesParser$Companion;", "", "<init>", "()V", "MLINCLUDEDLIST", "", "MLINCLUDEDGROUPS", "MLEXCLUDEDITEMS", "MLEXCLUDEDGROUPS", "validModalListOptions", "", "emptyArrayPattern", "Ljava/util/regex/Pattern;", "io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.PlatformType", "buildCachedModalListOfString", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "name", "defaultValue", "ruleName", "getSetOfGroups", "", "key", "buildCachedModalOfType", "type", "Lio/github/arcaneplugins/levelledmobs/enums/ModalListParsingTypes;", "ruleInfo", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "buildCachedModal", "mlpi", "Lio/github/arcaneplugins/levelledmobs/rules/ModalListParsingInfo;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CachedModalList<String> buildCachedModalListOfString(@Nullable ConfigurationSection cs, @NotNull String name, @Nullable CachedModalList<String> defaultValue, @Nullable String ruleName) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return defaultValue;
            }
            CachedModalList<String> cachedModalList = new CachedModalList<String>((Set)new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE)), (Set)new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE)));
            String useKeyName = YmlParsingHelper.Companion.getKeyNameFromConfig(cs, name);
            Object simpleStringOrArray = cs.get(useKeyName);
            ConfigurationSection cs2 = null;
            List<Object> useList = null;
            if (simpleStringOrArray instanceof ArrayList) {
                useList = CollectionsKt.toMutableList((ArrayList)simpleStringOrArray);
            } else if (simpleStringOrArray instanceof String) {
                String[] stringArray = new String[]{simpleStringOrArray};
                useList = CollectionsKt.mutableListOf(stringArray);
            }
            if (useList == null) {
                cs2 = YmlParsingHelper.Companion.objToCS(cs, useKeyName);
            }
            if (cs2 == null && useList == null) {
                return defaultValue;
            }
            if (cs2 != null) {
                for (String string : cs2.getKeys(false)) {
                    if (validModalListOptions.contains(string)) continue;
                    if (ruleName == null) {
                        Log.INSTANCE.war("Invalid modal list option: '" + string + "'");
                        continue;
                    }
                    Log.INSTANCE.war("Invalid modal list option: '" + string + "' in rule: " + ruleName);
                }
            }
            cachedModalList.setDoMerge(YmlParsingHelper.Companion.getBoolean(cs2, "merge"));
            if (cs2 != null) {
                String allowedList = YmlParsingHelper.Companion.getKeyNameFromConfig(cs2, RulesParser.MLINCLUDEDLIST);
                useList = YmlParsingHelper.Companion.getListFromConfigItem(cs2, allowedList);
            }
            List<Object> list = useList;
            Intrinsics.checkNotNull(list);
            for (String string : list) {
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) continue;
                if (Intrinsics.areEqual("*", ((Object)StringsKt.trim((CharSequence)string)).toString())) {
                    cachedModalList.setIncludeAll(true);
                    continue;
                }
                if (emptyArrayPattern.matcher(string).matches()) continue;
                cachedModalList.getIncludedList().add(string);
            }
            if (cs2 == null) {
                return cachedModalList;
            }
            String allowedGroups = YmlParsingHelper.Companion.getKeyNameFromConfig(cs2, RulesParser.MLINCLUDEDGROUPS);
            String string = YmlParsingHelper.Companion.getKeyNameFromConfig(cs2, RulesParser.MLEXCLUDEDITEMS);
            String excludedGroups = YmlParsingHelper.Companion.getKeyNameFromConfig(cs2, RulesParser.MLEXCLUDEDGROUPS);
            cachedModalList.setIncludedGroups(this.getSetOfGroups(cs2, allowedGroups));
            for (String item : YmlParsingHelper.Companion.getListFromConfigItem(cs2, string)) {
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)item)).toString()).length() == 0) continue;
                if (Intrinsics.areEqual("*", ((Object)StringsKt.trim((CharSequence)item)).toString())) {
                    cachedModalList.setExcludeAll(true);
                    continue;
                }
                cachedModalList.getExcludedList().add(item);
            }
            cachedModalList.setExcludedGroups(this.getSetOfGroups(cs2, excludedGroups));
            if (cachedModalList.isEmpty() && !cachedModalList.getIncludeAll() && !cachedModalList.getExcludeAll()) {
                return defaultValue;
            }
            return cachedModalList;
        }

        private final Set<String> getSetOfGroups(ConfigurationSection cs, String key) {
            String foundKeyName = null;
            for (String enumeratedKey : cs.getKeys(false)) {
                if (!StringsKt.equals(key, enumeratedKey, true)) continue;
                foundKeyName = enumeratedKey;
                break;
            }
            Set results = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            if (foundKeyName == null) {
                return results;
            }
            List list = cs.getStringList(foundKeyName);
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List groups2 = list;
            if (groups2.isEmpty() && cs.getString(foundKeyName) != null) {
                groups2.add(cs.getString(foundKeyName));
            }
            Iterator iterator2 = groups2.iterator();
            while (iterator2.hasNext()) {
                String group;
                String string = group = (String)iterator2.next();
                Intrinsics.checkNotNull(string);
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) continue;
                boolean invalidGroup = false;
                String string2 = group.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (StringsKt.startsWith$default(string2, "all_", false, 2, null)) {
                    try {
                        String string3 = group.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                        CustomUniversalGroups customGroup = CustomUniversalGroups.valueOf(string3);
                        results.add(customGroup.toString());
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        invalidGroup = true;
                    }
                }
                if (LevelledMobs.Companion.getInstance().getCustomMobGroups().containsKey(group)) {
                    results.add(group);
                } else {
                    invalidGroup = true;
                }
                if (!invalidGroup) continue;
                Log.INSTANCE.war("Invalid group: " + group);
            }
            return results;
        }

        private final CachedModalList<?> buildCachedModalOfType(ConfigurationSection cs, CachedModalList<?> defaultValue, ModalListParsingTypes type, RuleInfo ruleInfo) {
            if (cs == null) {
                return defaultValue;
            }
            ModalListParsingInfo mlpi = new ModalListParsingInfo(type);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    mlpi.setConfigurationKey("biomes");
                    mlpi.setItemName("Biome");
                    mlpi.setSupportsGroups(true);
                    mlpi.setGroupMapping(LevelledMobs.Companion.getInstance().getRulesManager().getBiomeGroupMappings());
                    mlpi.setCachedModalList(new CachedModalList());
                    break;
                }
                case 2: {
                    mlpi.setConfigurationKey("spawn-reasons");
                    mlpi.setItemName("spawn reason");
                    mlpi.setCachedModalList(new CachedModalList());
                    break;
                }
                case 3: {
                    mlpi.setConfigurationKey("vanilla-bonus");
                    mlpi.setItemName("vanilla bonus");
                    mlpi.setCachedModalList(new CachedModalList());
                    break;
                }
                case 4: {
                    mlpi.setConfigurationKey("structures");
                    mlpi.setItemName("Structures");
                    mlpi.setCachedModalList(new CachedModalList());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return this.buildCachedModal(cs, defaultValue, mlpi, ruleInfo);
        }

        private final CachedModalList<?> buildCachedModal(ConfigurationSection cs, CachedModalList<?> defaultValue, ModalListParsingInfo mlpi, RuleInfo ruleInfo) {
            List<Object> useList;
            ConfigurationSection cs2;
            CachedModalList<?> cachedModalList;
            block35: {
                if (cs == null) {
                    return defaultValue;
                }
                String string = mlpi.getConfigurationKey();
                Intrinsics.checkNotNull(string);
                String useKeyName = YmlParsingHelper.Companion.getKeyNameFromConfig(cs, string);
                cachedModalList = mlpi.getCachedModalList();
                Object simpleStringOrArray = cs.get(useKeyName);
                cs2 = null;
                useList = null;
                if (simpleStringOrArray instanceof ArrayList) {
                    useList = CollectionsKt.toMutableList((ArrayList)simpleStringOrArray);
                } else if (simpleStringOrArray instanceof String) {
                    String[] stringArray = new String[]{simpleStringOrArray};
                    useList = CollectionsKt.mutableListOf(stringArray);
                }
                if (useList == null) {
                    cs2 = YmlParsingHelper.Companion.objToCS(cs, useKeyName);
                }
                if (cs2 == null && useList == null) {
                    return defaultValue;
                }
                if (cs2 != null) {
                    for (String key : cs2.getKeys(false)) {
                        if (validModalListOptions.contains(key)) continue;
                        Log.INSTANCE.war("Invalid modal list option: '" + key + "' in rule: " + ruleInfo.getRuleName$levelledmobs_plugin());
                    }
                }
                CachedModalList<?> cachedModalList2 = cachedModalList;
                Intrinsics.checkNotNull(cachedModalList2);
                cachedModalList2.setDoMerge(YmlParsingHelper.Companion.getBoolean(cs2, "merge"));
                if (cs2 == null || !mlpi.getSupportsGroups()) break block35;
                cachedModalList.setIncludedGroups((Set<String>)new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE)));
                cachedModalList.setExcludedGroups((Set<String>)new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE)));
                for (String group : YmlParsingHelper.Companion.getListFromConfigItem(cs2, RulesParser.MLINCLUDEDGROUPS)) {
                    block37: {
                        block36: {
                            if (((CharSequence)((Object)StringsKt.trim((CharSequence)group)).toString()).length() == 0) continue;
                            if (mlpi.getGroupMapping() == null) break block36;
                            Map<String, Set<String>> map = mlpi.getGroupMapping();
                            Intrinsics.checkNotNull(map);
                            if (map.containsKey(group)) break block37;
                        }
                        Log.INSTANCE.war("invalid " + mlpi.getItemName() + " group: " + group);
                        continue;
                    }
                    cachedModalList.getIncludedGroups().add(group);
                }
                for (String group : YmlParsingHelper.Companion.getListFromConfigItem(cs2, RulesParser.MLEXCLUDEDGROUPS)) {
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)group)).toString()).length() == 0) continue;
                    if (!LevelledMobs.Companion.getInstance().getRulesManager().getBiomeGroupMappings().containsKey(group)) {
                        Log.INSTANCE.war("invalid " + mlpi.getItemName() + " group: " + group);
                        continue;
                    }
                    cachedModalList.getExcludedGroups().add(group);
                }
            }
            for (int i = 0; i < 2; ++i) {
                String configKeyname;
                String invalidWord = i == 0 ? "included" : "excluded";
                String string = configKeyname = i == 0 ? RulesParser.MLINCLUDEDLIST : RulesParser.MLEXCLUDEDITEMS;
                if (i == 1 && cs2 == null) break;
                if (cs2 != null) {
                    useList = YmlParsingHelper.Companion.getListFromConfigItem(cs2, configKeyname);
                }
                List<Object> list = useList;
                Intrinsics.checkNotNull(list);
                block12: for (String string2 : list) {
                    if (((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString()).length() == 0) continue;
                    if (Intrinsics.areEqual("*", ((Object)StringsKt.trim((CharSequence)string2)).toString())) {
                        if (i == 0) {
                            cachedModalList.setIncludeAll(true);
                            continue;
                        }
                        cachedModalList.setExcludeAll(true);
                        continue;
                    }
                    if (emptyArrayPattern.matcher(string2).matches()) continue;
                    try {
                        switch (WhenMappings.$EnumSwitchMapping$0[mlpi.getType().ordinal()]) {
                            case 1: {
                                CachedModalList<?> biomeModalList = cachedModalList;
                                Set<?> modalList = i == 0 ? biomeModalList.getIncludedList() : biomeModalList.getExcludedList();
                                Biome biome = Utils.INSTANCE.getBiome(((Object)StringsKt.trim((CharSequence)string2)).toString());
                                if (biome != null) {
                                    modalList.add(biome);
                                    continue block12;
                                }
                                Log.INSTANCE.war("Invalid biome name: " + string2);
                                continue block12;
                            }
                            case 2: {
                                CachedModalList<?> spawnReasonModalList = cachedModalList;
                                Set<?> modalList = i == 0 ? spawnReasonModalList.getIncludedList() : spawnReasonModalList.getExcludedList();
                                String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString().toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                                if (LMSpawnReason.Companion.validateSpawnReason(string3)) {
                                    String string4 = ((Object)StringsKt.trim((CharSequence)string2)).toString().toUpperCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                                    modalList.add(string4);
                                    continue block12;
                                }
                                Log.INSTANCE.war("rule: " + ruleInfo.getRuleName$levelledmobs_plugin() + ", invalid spawn reason: " + string2);
                                continue block12;
                            }
                            case 3: {
                                CachedModalList<?> vanillaBonusModalList = cachedModalList;
                                Set<?> modalList = i == 0 ? vanillaBonusModalList.getIncludedList() : vanillaBonusModalList.getExcludedList();
                                String string5 = ((Object)StringsKt.trim((CharSequence)string2)).toString().toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                                VanillaBonusEnum vanillaBonus = VanillaBonusEnum.valueOf(string5);
                                modalList.add(vanillaBonus);
                                continue block12;
                            }
                            case 4: {
                                String string6;
                                String namespace;
                                if (!LevelledMobs.Companion.getInstance().getVer().getAllowStructureConditions()) {
                                    Log.INSTANCE.war("Structure conditions are not available on this server version");
                                    continue block12;
                                }
                                CachedModalList<?> structuresModalList = cachedModalList;
                                Set<?> modalList = i == 0 ? structuresModalList.getIncludedList() : structuresModalList.getExcludedList();
                                String[] stringArray = new String[]{":"};
                                List input = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), stringArray, false, 0, 6, null);
                                if (input.isEmpty()) continue block12;
                                String string7 = namespace = input.size() == 1 ? "minecraft" : (String)CollectionsKt.first(input);
                                if (input.size() == 1) {
                                    String string8 = ((String)CollectionsKt.first(input)).toLowerCase(Locale.ROOT);
                                    string6 = string8;
                                    Intrinsics.checkNotNullExpressionValue(string8, "toLowerCase(...)");
                                } else {
                                    String string9 = ((String)input.get(1)).toLowerCase(Locale.ROOT);
                                    string6 = string9;
                                    Intrinsics.checkNotNullExpressionValue(string9, "toLowerCase(...)");
                                }
                                String key = string6;
                                Structure structure = null;
                                if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper() && LevelledMobs.Companion.getInstance().getVer().getMinorVersion() >= 21) {
                                    Registry registry;
                                    Intrinsics.checkNotNullExpressionValue(RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE), "getRegistry(...)");
                                    String string10 = key.toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(string10, "toLowerCase(...)");
                                    structure = (Structure)registry.get(NamespacedKey.minecraft((String)string10));
                                } else {
                                    structure = (Structure)Registry.STRUCTURE.get(new NamespacedKey(namespace, key));
                                }
                                if (structure == null) {
                                    Log.INSTANCE.war("Invalid " + invalidWord + " " + mlpi.getItemName() + ": " + string2);
                                    continue block12;
                                }
                                modalList.add(structure);
                                continue block12;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.INSTANCE.war("Invalid " + invalidWord + " " + mlpi.getItemName() + ": " + string2);
                    }
                }
            }
            return cachedModalList.isEmpty() && defaultValue == null ? null : cachedModalList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ModalListParsingTypes.values().length];
                try {
                    nArray[ModalListParsingTypes.BIOME.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModalListParsingTypes.SPAWN_REASON.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModalListParsingTypes.VANILLA_BONUSES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ModalListParsingTypes.STRUCTURE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

