/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapperBase;
import java.util.List;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/LivingEntityPlaceholder;", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapperBase;", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "<init>", "()V", "populateEntityData", "", "entityType", "Lorg/bukkit/entity/EntityType;", "location", "Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "free", "clearEntityData", "getEntityType", "()Lorg/bukkit/entity/EntityType;", "setEntityType", "(Lorg/bukkit/entity/EntityType;)V", "getApplicableRules", "", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "typeName", "", "getTypeName", "()Ljava/lang/String;", "value", "", "spawnedTimeOfDay", "getSpawnedTimeOfDay", "()I", "setSpawnedTimeOfDay", "(I)V", "wasSummoned", "", "getWasSummoned", "()Z", "Companion", "levelledmobs-plugin"})
public final class LivingEntityPlaceholder
extends LivingEntityWrapperBase
implements LivingEntityInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EntityType entityType;
    @NotNull
    private static final Stack<LivingEntityPlaceholder> cache = new Stack();
    @NotNull
    private static final Object cachedplaceholdersLock = new Object();
    @Nullable
    private static Integer _spawnedTimeOfDay;

    private final void populateEntityData(EntityType entityType, Location location, World world) {
        this.setEntityType(entityType);
        super.populateData(world, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        if (this.getInUseCount().decrementAndGet() > 0) {
            return;
        }
        if (!this.isPopulated()) {
            return;
        }
        this.clearEntityData();
        Object object = cachedplaceholdersLock;
        synchronized (object) {
            boolean bl = false;
            LivingEntityPlaceholder livingEntityPlaceholder = cache.push(this);
        }
    }

    @Override
    public void clearEntityData() {
        this.setEntityType(null);
        super.clearEntityData();
    }

    @Override
    @Nullable
    public EntityType getEntityType() {
        EntityType entityType = this.entityType;
        Intrinsics.checkNotNull(entityType);
        return entityType;
    }

    public void setEntityType(@Nullable EntityType entityType) {
        this.entityType = entityType;
    }

    @Override
    @NotNull
    public List<RuleInfo> getApplicableRules() {
        return this.getMain().getRulesManager().getApplicableRules(this).getAllApplicableRules();
    }

    @Override
    @NotNull
    public String getTypeName() {
        EntityType entityType = this.getEntityType();
        Intrinsics.checkNotNull(entityType);
        return entityType.name();
    }

    @Override
    public int getSpawnedTimeOfDay() {
        if (_spawnedTimeOfDay == null) {
            _spawnedTimeOfDay = (int)this.getWorld().getTime();
        }
        Integer n = _spawnedTimeOfDay;
        Intrinsics.checkNotNull(n);
        return n;
    }

    @Override
    public void setSpawnedTimeOfDay(int value) {
        _spawnedTimeOfDay = value;
    }

    @Override
    public boolean getWasSummoned() {
        return this.getSummonedLevel() != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/LivingEntityPlaceholder$Companion;", "", "<init>", "()V", "cache", "Ljava/util/Stack;", "Lio/github/arcaneplugins/levelledmobs/misc/LivingEntityPlaceholder;", "cachedplaceholdersLock", "_spawnedTimeOfDay", "", "Ljava/lang/Integer;", "getInstance", "entityType", "Lorg/bukkit/entity/EntityType;", "location", "Lorg/bukkit/Location;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final LivingEntityPlaceholder getInstance(@NotNull EntityType entityType, @NotNull Location location) {
            Intrinsics.checkNotNullParameter(entityType, "entityType");
            Intrinsics.checkNotNullParameter(location, "location");
            LivingEntityPlaceholder leph = null;
            if (location.getWorld() == null) {
                throw new NullPointerException("World can't be null");
            }
            Object object = cachedplaceholdersLock;
            synchronized (object) {
                LivingEntityPlaceholder livingEntityPlaceholder;
                boolean bl = false;
                if (cache.empty()) {
                    livingEntityPlaceholder = new LivingEntityPlaceholder();
                } else {
                    Object e = cache.pop();
                    Intrinsics.checkNotNullExpressionValue(e, "pop(...)");
                    livingEntityPlaceholder = (LivingEntityPlaceholder)e;
                }
                leph = livingEntityPlaceholder;
                Unit unit = Unit.INSTANCE;
            }
            World world = location.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            leph.populateEntityData(entityType, location, world);
            leph.getInUseCount().set(1);
            return leph;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

