/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.commands.subcommands.RulesSubcommand;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.io.CloseableKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.FileMigrator;
import io.github.arcaneplugins.levelledmobs.misc.YmlParsingHelper;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.FileUtil;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/FileLoader;", "", "<init>", "()V", "SETTINGS_FILE_VERSION", "", "MESSAGES_FILE_VERSION", "CUSTOMDROPS_FILE_VERSION", "RULES_FILE_VERSION", "EXTERNALPLUGINS_FILE_VERSION", "loadFile", "Lorg/bukkit/configuration/file/YamlConfiguration;", "plugin", "Lorg/bukkit/plugin/Plugin;", "cfgName", "", "compatibleVersion", "getFileLoadErrorMessage", "saveResourceIfNotExists", "", "instance", "file", "Ljava/io/File;", "checkFileVersion", "installedVersion", "levelledmobs-plugin"})
public final class FileLoader {
    @NotNull
    public static final FileLoader INSTANCE = new FileLoader();
    public static final int SETTINGS_FILE_VERSION = 39;
    public static final int MESSAGES_FILE_VERSION = 9;
    public static final int CUSTOMDROPS_FILE_VERSION = 12;
    public static final int RULES_FILE_VERSION = 5;
    public static final int EXTERNALPLUGINS_FILE_VERSION = 1;

    private FileLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final YamlConfiguration loadFile(@NotNull Plugin plugin, @NotNull String cfgName, int compatibleVersion) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(cfgName, "cfgName");
        Object useCfgName = cfgName;
        useCfgName = (String)useCfgName + ".yml";
        Log.INSTANCE.inf("&fFile Loader: &7Loading file '&b" + (String)useCfgName + "&7'...");
        File file = new File(plugin.getDataFolder(), (String)useCfgName);
        this.saveResourceIfNotExists(plugin, file);
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                Object fs = (FileInputStream)closeable;
                boolean bl = false;
                fs = new Yaml().load((InputStream)fs);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            String parseErrorMessage = "LevelledMobs was unable to read file &b%s&r due to a user-caused YAML syntax error.\nCopy the contents of your file into a YAML Parser website, such as < https://tinyurl.com/yamlp >  to help locate the line of the mistake.\nFailure to resolve this issue will cause LevelledMobs to function improperly, or likely not at all.\nBelow represents where LevelledMobs became confused while attempting to read your file:\n&b---- START ERROR ----&r\n&4%s&r\n&b---- END ERROR ----&r\nIf an attempt to solve this error has come to no avail, you are welcome to ask for assistance in the ArcanePlugins Discord Guild.\n&bhttps://discord.io/arcaneplugins";
            Object[] objectArray = new Object[]{useCfgName, e};
            String string = String.format(parseErrorMessage, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            Log.INSTANCE.sev(string);
            return null;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration cfg = yamlConfiguration;
        cfg.options().copyDefaults(true);
        YmlParsingHelper ymlHelper = new YmlParsingHelper((ConfigurationSection)cfg);
        int fileVersion = ymlHelper.getInt("file-version");
        boolean isCustomDrops = Intrinsics.areEqual(useCfgName, "customdrops.yml");
        boolean isRules = Intrinsics.areEqual(useCfgName, "rules.yml");
        if (fileVersion < compatibleVersion) {
            File backedupFile = new File(plugin.getDataFolder(), (String)useCfgName + ".v" + fileVersion + ".old");
            FileUtil.copy((File)file, (File)backedupFile);
            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &b" + (String)useCfgName + " backed up to " + backedupFile.getName());
            if (!isRules) {
                plugin.saveResource(file.getName(), true);
            }
            if (!isRules) {
                Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Migrating &b" + (String)useCfgName + "&7 from old version to new version.");
            }
            if (isCustomDrops) {
                FileMigrator.INSTANCE.copyCustomDrops(backedupFile, file, fileVersion);
            } else if (!isRules) {
                FileMigrator.INSTANCE.copyYmlValues(backedupFile, file, fileVersion);
            } else {
                Log.INSTANCE.war("Your rules file is pre-4.0. A backup has been made and it will be reset to default.");
                RulesSubcommand.INSTANCE.resetRules(null, RulesSubcommand.ResetDifficulty.SILVER);
            }
            YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)file);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
            cfg = yamlConfiguration2;
        } else if (!isRules) {
            this.checkFileVersion(file, compatibleVersion, ymlHelper.getInt("file-version"));
        }
        return cfg;
    }

    @NotNull
    public final String getFileLoadErrorMessage() {
        return MessageUtils.INSTANCE.colorizeStandardCodes("&4An error occured&r whilst attempting to parse the file &brules.yml&r due to a user-caused YAML syntax error. Please see the console logs for more details.");
    }

    private final void saveResourceIfNotExists(Plugin instance, File file) {
        if (!file.exists()) {
            Log.INSTANCE.inf("&fFile Loader: &7File '&b" + file.getName() + "&7' doesn't exist, creating it now...");
            instance.saveResource(file.getName(), false);
        }
    }

    private final void checkFileVersion(File file, int compatibleVersion, int installedVersion) {
        if (compatibleVersion == installedVersion) {
            return;
        }
        String what = installedVersion < compatibleVersion ? "outdated" : "ahead of the compatible version of this file for this version of the plugin";
        Log.INSTANCE.sev("&fFile Loader: &7The version of &b" + file.getName() + "&7 you have installed is " + what + "! Fix this as soon as possible, else the plugin will most likely malfunction.");
        Log.INSTANCE.war("&fFile Loader: &8(&7You have &bv" + installedVersion + "&7 installed but you are meant to be running &bv" + compatibleVersion + "&8)");
    }
}

