/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.MessagesBase;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerBaseClass;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerSubcommand;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.misc.Cooldown;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.Point;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J,\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010!\u001a\u00060\"j\u0002`#H\u0002J$\u0010$\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010!\u001a\u00060\"j\u0002`#H\u0002J$\u0010%\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020&2\n\u0010!\u001a\u00060\"j\u0002`#H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/PlayerInteractEventListener;", "Lio/github/arcaneplugins/levelledmobs/commands/MessagesBase;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "cooldownMap", "", "Ljava/util/UUID;", "Lio/github/arcaneplugins/levelledmobs/misc/Cooldown;", "onPlayerInteractEvent", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "processLMSpawnEgg", "", "convertSpawner", "info", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass$CustomSpawnerInfo;", "updateKeyString", "key", "Lorg/bukkit/NamespacedKey;", "pdc", "Lorg/bukkit/persistence/PersistentDataContainer;", "value", "", "copySpawner", "player", "Lorg/bukkit/entity/Player;", "cs", "Lorg/bukkit/block/CreatureSpawner;", "showInfo", "addSpawnerAttributeFromPdcInt", "name", "sb", "Ljava/lang/StringBuilder;", "Lio/github/arcaneplugins/levelledmobs/libs/kotlin/text/StringBuilder;", "addSpawnerAttributeFromPdcStr", "addSpawnerAttribute", "", "levelledmobs-plugin"})
public final class PlayerInteractEventListener
extends MessagesBase
implements Listener {
    @NotNull
    private final Map<UUID, Cooldown> cooldownMap = new LinkedHashMap();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerInteractEvent(@NotNull PlayerInteractEvent event) {
        boolean doShowInfo;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter(event, "event");
                if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                this.setCommandSender((CommandSender)event.getPlayer());
                this.setMessageLabel("lm");
                String string = event.getMaterial().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (StringsKt.endsWith$default(string, "_spawn_egg", false, 2, null) && this.processLMSpawnEgg(event)) {
                    return;
                }
                LevelledMobs main = LevelledMobs.Companion.getInstance();
                if (main.getMainCompanion().getSpawnerInfoIds().isEmpty() && main.getMainCompanion().getSpawnerCopyIds().isEmpty()) {
                    return;
                }
                if (event.getHand() == null || event.getHand() != EquipmentSlot.HAND) {
                    return;
                }
                doShowInfo = main.getMainCompanion().getSpawnerInfoIds().contains(event.getPlayer().getUniqueId());
                boolean doCopy = main.getMainCompanion().getSpawnerCopyIds().contains(event.getPlayer().getUniqueId());
                if (!doCopy && !doShowInfo) {
                    return;
                }
                if (event.getClickedBlock() == null) break block14;
                Block block = event.getClickedBlock();
                Intrinsics.checkNotNull(block);
                if (block.getType() == Material.SPAWNER) break block15;
            }
            return;
        }
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull(block);
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Point point = new Point(location);
        if (this.cooldownMap.containsKey(uuid)) {
            Cooldown cooldown = this.cooldownMap.get(uuid);
            Intrinsics.checkNotNull(cooldown);
            if (cooldown.doesCooldownBelongToIdentifier(point.toString())) {
                Cooldown cooldown2 = this.cooldownMap.get(uuid);
                Intrinsics.checkNotNull(cooldown2);
                if (!cooldown2.hasCooldownExpired(2L)) {
                    return;
                }
            }
            this.cooldownMap.remove(uuid);
        }
        this.cooldownMap.put(uuid, new Cooldown(System.currentTimeMillis(), point.toString()));
        Block block2 = event.getClickedBlock();
        Intrinsics.checkNotNull(block2);
        BlockState blockState = block2.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.CreatureSpawner");
        CreatureSpawner cs = (CreatureSpawner)blockState;
        if (doShowInfo) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            this.showInfo(player, cs);
        } else if (event.getMaterial() == Material.AIR) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            this.copySpawner(player, cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processLMSpawnEgg(PlayerInteractEvent event) {
        PersistentDataContainer persistentDataContainer;
        CharSequence charSequence2;
        Object temp;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (!main.getVer().isRunningPaper()) {
            return false;
        }
        if (event.getItem() == null) {
            return false;
        }
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNull(itemStack);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        if (event.getClickedBlock() == null) {
            return false;
        }
        if (!meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getSpawnerEgg(), PersistentDataType.INTEGER)) {
            return false;
        }
        event.setCancelled(true);
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull(block);
        Location location = block.getLocation().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location location2 = location;
        int minLevel = 1;
        int maxLevel = 1;
        Object customDropId = null;
        EntityType spawnType = EntityType.ZOMBIE;
        if (meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER) && (temp = (Integer)meta.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER)) != null) {
            minLevel = (Integer)temp;
        }
        if (meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER) && (temp = (Integer)meta.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER)) != null) {
            maxLevel = (Integer)temp;
        }
        if (meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING)) {
            customDropId = meta.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING);
        }
        if (meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), PersistentDataType.STRING) && (temp = (String)meta.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), PersistentDataType.STRING)) != null) {
            try {
                spawnType = EntityType.valueOf((String)temp);
            }
            catch (Exception charSequence2) {
                Log.INSTANCE.war("Invalid spawn type on spawner egg: " + (String)temp);
            }
        }
        Object eggName = null;
        if (meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING)) {
            eggName = meta.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING);
        }
        if ((charSequence2 = (CharSequence)eggName) == null || charSequence2.length() == 0) {
            eggName = "LM Spawn Egg";
        }
        Block block2 = event.getClickedBlock();
        Intrinsics.checkNotNull(block2);
        if (block2.getBlockData().getMaterial() == Material.SPAWNER) {
            SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo(false);
            info.setMinLevel(minLevel);
            info.setMaxLevel(maxLevel);
            info.setSpawnType(spawnType);
            info.setCustomDropId((String)customDropId);
            SpawnerBaseClass.Companion.setMetaItems(meta, info, (String)eggName);
            this.convertSpawner(event, info);
            return true;
        }
        Entity entity = location2.getWorld().spawnEntity(location2, spawnType, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        Intrinsics.checkNotNullExpressionValue(entity, "spawnEntity(...)");
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return true;
        }
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity2);
        AdditionalLevelInformation[] additionalLevelInformationArray = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
        synchronized (additionalLevelInformationArray) {
            boolean bl = false;
            persistentDataContainer = main.getLevelManager().getSummonedOrSpawnEggs().put(lmEntity.getLivingEntity(), null);
        }
        int useLevel = minLevel;
        if (minLevel != maxLevel) {
            useLevel = ThreadLocalRandom.current().nextInt(minLevel, RangesKt.coerceAtLeast(maxLevel, minLevel) + 1);
        }
        PersistentDataContainer persistentDataContainer2 = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer2, "getPersistentDataContainer(...)");
        persistentDataContainer = persistentDataContainer2;
        synchronized (persistentDataContainer) {
            boolean bl = false;
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER, (Object)1);
            CharSequence charSequence3 = (CharSequence)customDropId;
            if (!(charSequence3 == null || charSequence3.length() == 0)) {
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING, customDropId);
            }
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getSpawnerEggName(), PersistentDataType.STRING, eggName);
            Unit unit = Unit.INSTANCE;
        }
        additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
        main.getLevelInterface().applyLevelToMob(lmEntity, useLevel, true, true, SetsKt.mutableSetOf(additionalLevelInformationArray));
        lmEntity.free();
        return true;
    }

    private final void convertSpawner(PlayerInteractEvent event, SpawnerBaseClass.CustomSpawnerInfo info) {
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getPlayer().hasPermission("levelledmobs.convert-spawner")) {
            this.showMessage("command.levelledmobs.spawner.permission-denied");
            return;
        }
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull(block);
        BlockState blockState = block.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.CreatureSpawner");
        CreatureSpawner cs = (CreatureSpawner)blockState;
        PersistentDataContainer persistentDataContainer = cs.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer pdc = persistentDataContainer;
        boolean wasLMSpawner = pdc.has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER);
        pdc.set(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER, (Object)1);
        pdc.set(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER, (Object)info.getMinLevel());
        pdc.set(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER, (Object)info.getMaxLevel());
        this.updateKeyString(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), pdc, info.getCustomDropId());
        this.updateKeyString(NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), pdc, info.getSpawnType().toString());
        this.updateKeyString(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), pdc, info.getCustomName());
        cs.setSpawnedType(info.getSpawnType());
        cs.update();
        CharSequence charSequence = info.getCustomName();
        if (charSequence == null || charSequence.length() == 0) {
            info.setCustomName("LM Spawner");
        }
        if (!wasLMSpawner) {
            String string = info.getCustomName();
            Intrinsics.checkNotNull(string);
            this.showMessage("command.levelledmobs.spawner.spawner-converted", "%spawnername%", string);
        } else {
            String string = info.getCustomName();
            Intrinsics.checkNotNull(string);
            this.showMessage("command.levelledmobs.spawner.spawner-updated", "%spawnername%", string);
        }
    }

    private final void updateKeyString(NamespacedKey key, PersistentDataContainer pdc, String value) {
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            pdc.set(key, PersistentDataType.STRING, (Object)value);
        } else if (pdc.has(key, PersistentDataType.STRING)) {
            pdc.remove(key);
        }
    }

    private final void copySpawner(Player player, CreatureSpawner cs) {
        Integer maxLevel;
        Integer minLevel;
        SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo(false);
        info.setPlayer(player);
        PersistentDataContainer persistentDataContainer = cs.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer pdc = persistentDataContainer;
        if (!pdc.has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER)) {
            this.showMessage("command.levelledmobs.spawner.copy.vanilla-spawner");
            return;
        }
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING)) {
            info.setCustomDropId((String)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING));
        }
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING)) {
            info.setCustomName((String)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING));
        }
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER) && (minLevel = (Integer)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER)) != null) {
            info.setMinLevel(minLevel);
        }
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER) && (maxLevel = (Integer)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER)) != null) {
            info.setMaxLevel(maxLevel);
        }
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerLore(), PersistentDataType.STRING)) {
            info.setLore((String)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerLore(), PersistentDataType.STRING));
        }
        EntityType entityType = cs.getSpawnedType();
        Intrinsics.checkNotNull(entityType);
        info.setSpawnType(entityType);
        info.setMinSpawnDelay(cs.getMinSpawnDelay());
        info.setMaxSpawnDelay(cs.getMaxSpawnDelay());
        info.setMaxNearbyEntities(cs.getMaxNearbyEntities());
        info.setDelay(cs.getDelay());
        info.setRequiredPlayerRange(cs.getRequiredPlayerRange());
        info.setSpawnCount(cs.getSpawnCount());
        info.setSpawnRange(cs.getSpawnRange());
        SpawnerSubcommand.INSTANCE.generateSpawner(info);
    }

    private final void showInfo(Player player, CreatureSpawner cs) {
        PersistentDataContainer persistentDataContainer = cs.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer pdc = persistentDataContainer;
        StringBuilder sb = new StringBuilder();
        if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER)) {
            sb.append("LM Spawner");
            if (pdc.has(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING)) {
                sb.append(": &7");
                sb.append((String)pdc.get(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING));
                sb.append("&r\n");
            }
        } else {
            sb.append("Vanilla Spawner\n");
        }
        this.addSpawnerAttributeFromPdcInt("min level", NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), pdc, sb);
        this.addSpawnerAttributeFromPdcInt("max level", NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), pdc, sb);
        sb.append('\n');
        this.addSpawnerAttribute("delay", cs.getDelay(), sb);
        this.addSpawnerAttribute("max nearby entities", cs.getMaxNearbyEntities(), sb);
        this.addSpawnerAttribute("min spawn delay", cs.getMinSpawnDelay(), sb);
        sb.append('\n');
        this.addSpawnerAttribute("max spawn delay", cs.getMaxSpawnDelay(), sb);
        this.addSpawnerAttribute("required player range", cs.getRequiredPlayerRange(), sb);
        this.addSpawnerAttribute("spawn count", cs.getSpawnCount(), sb);
        sb.append('\n');
        this.addSpawnerAttributeFromPdcStr(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), pdc, sb);
        if (cs.getSpawnedType() != null) {
            EntityType entityType = cs.getSpawnedType();
            Intrinsics.checkNotNull(entityType);
            this.addSpawnerAttribute("spawn type", entityType, sb);
        }
        player.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
    }

    private final void addSpawnerAttributeFromPdcInt(String name, NamespacedKey key, PersistentDataContainer pdc, StringBuilder sb) {
        if (!pdc.has(key, PersistentDataType.INTEGER)) {
            return;
        }
        if (!Intrinsics.areEqual(sb.substring(sb.length() - 1), "\n")) {
            sb.append(", ");
        }
        StringBuilder stringBuilder = sb.append("&7").append(name).append(": &b");
        Object object = pdc.get(key, PersistentDataType.INTEGER);
        Intrinsics.checkNotNull(object);
        stringBuilder.append(((Number)object).intValue()).append("&r");
    }

    private final void addSpawnerAttributeFromPdcStr(NamespacedKey key, PersistentDataContainer pdc, StringBuilder sb) {
        if (!pdc.has(key, PersistentDataType.STRING)) {
            return;
        }
        if (!Intrinsics.areEqual(sb.substring(sb.length() - 1), "\n")) {
            sb.append(", ");
        }
        sb.append("&7custom drop id: &b").append((String)pdc.get(key, PersistentDataType.STRING)).append("&r");
    }

    private final void addSpawnerAttribute(String name, Object value, StringBuilder sb) {
        if (!Intrinsics.areEqual(sb.substring(sb.length() - 1), "\n")) {
            sb.append(", ");
        }
        sb.append("&7").append(name).append(": &b").append(value).append("&r");
    }
}

