/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.MobTamedStatus;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTameEvent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityTameListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntityTameEvent", "", "event", "Lorg/bukkit/event/entity/EntityTameEvent;", "levelledmobs-plugin"})
public final class EntityTameListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private final void onEntityTameEvent(EntityTameEvent event) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
        LevellableState levellableState = main.getLevelInterface().getLevellableState(lmEntity);
        if (levellableState != LevellableState.ALLOWED) {
            DebugManager.Companion.log(DebugType.ENTITY_TAME, lmEntity, () -> EntityTameListener.onEntityTameEvent$lambda$0(levellableState));
            lmEntity.free();
            return;
        }
        if (main.getRulesManager().getRuleMobTamedStatus(lmEntity) == MobTamedStatus.NOT_TAMED) {
            DebugManager.Companion.log(DebugType.ENTITY_TAME, lmEntity, EntityTameListener::onEntityTameEvent$lambda$1);
            main.getLevelInterface().removeLevel(lmEntity);
            DebugManager.Companion.log(DebugType.ENTITY_TAME, lmEntity, EntityTameListener::onEntityTameEvent$lambda$2);
            lmEntity.free();
            return;
        }
        DebugManager.Companion.log(DebugType.ENTITY_TAME, lmEntity, EntityTameListener::onEntityTameEvent$lambda$3);
        int level = -1;
        if (lmEntity.isLevelled()) {
            level = lmEntity.getGetMobLevel();
        }
        if (level == -1) {
            level = main.getLevelInterface().generateLevel(lmEntity);
            lmEntity.invalidateCache();
        }
        AdditionalLevelInformation[] additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.FROM_TAME_LISTENER};
        main.getLevelInterface().applyLevelToMob(lmEntity, level, false, false, SetsKt.mutableSetOf(additionalLevelInformationArray));
        lmEntity.free();
    }

    private static final String onEntityTameEvent$lambda$0(LevellableState $levellableState) {
        return "Levelable state was " + $levellableState;
    }

    private static final String onEntityTameEvent$lambda$1() {
        return "no-level-conditions.tamed = &btrue";
    }

    private static final String onEntityTameEvent$lambda$2() {
        return "Removed level of tamed mob";
    }

    private static final String onEntityTameEvent$lambda$3() {
        return "Applying level to tamed mob";
    }
}

