/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.JvmStatic;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wither;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "updateMobsOnNonPlayerdamage", "", "getUpdateMobsOnNonPlayerdamage", "()Z", "setUpdateMobsOnNonPlayerdamage", "(Z)V", "lastPriority", "Lorg/bukkit/event/EventPriority;", "settingName", "", "load", "", "onEntityDamageEvent", "event", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onEntityDamageByEntityEvent", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "processRangedDamage", "processRangedDamage2", "shooter", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "processOtherRangedDamage", "Companion", "levelledmobs-plugin"})
public final class EntityDamageListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean updateMobsOnNonPlayerdamage = true;
    @Nullable
    private EventPriority lastPriority;
    @NotNull
    private final String settingName;
    private static EntityDamageListener instance;

    public EntityDamageListener() {
        this.settingName = "entity-damage-event";
        instance = this;
    }

    public final boolean getUpdateMobsOnNonPlayerdamage() {
        return this.updateMobsOnNonPlayerdamage;
    }

    public final void setUpdateMobsOnNonPlayerdamage(boolean bl) {
        this.updateMobsOnNonPlayerdamage = bl;
    }

    public final void load() {
        EventPriority priority = LevelledMobs.Companion.getInstance().getMainCompanion().getEventPriority(this.settingName, EventPriority.MONITOR);
        if (this.lastPriority != null) {
            if (priority == this.lastPriority) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
            Log.INSTANCE.inf("Changing event priority for " + this.settingName + " from " + this.lastPriority + " to " + priority);
        }
        Bukkit.getPluginManager().registerEvent(EntityDamageEvent.class, (Listener)this, priority, (arg_0, arg_1) -> EntityDamageListener.load$lambda$0(this, arg_0, arg_1), (Plugin)LevelledMobs.Companion.getInstance(), false);
        Bukkit.getPluginManager().registerEvent(EntityDamageByEntityEvent.class, (Listener)this, priority, (arg_0, arg_1) -> EntityDamageListener.load$lambda$1(this, arg_0, arg_1), (Plugin)LevelledMobs.Companion.getInstance(), false);
        this.lastPriority = priority;
    }

    private final void onEntityDamageEvent(EntityDamageEvent event) {
        boolean isCritical;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        boolean bl = isCritical = event.getFinalDamage() == 0.0;
        if (event instanceof EntityDamageByEntityEvent) {
            if (isCritical && ((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                Map<UUID, Player> map = LevelledMobs.Companion.getInstance().getEntityDeathListener().getDamageMappings();
                UUID uUID = event.getEntity().getUniqueId();
                Entity entity = ((EntityDamageByEntityEvent)event).getDamager();
                Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
                Player player = (Player)entity;
                map.put(uUID, player);
                return;
            }
            if (!(this.updateMobsOnNonPlayerdamage || isCritical || ((EntityDamageByEntityEvent)event).getEntity() instanceof Player || ((EntityDamageByEntityEvent)event).getDamager() instanceof Player)) {
                return;
            }
        } else if (!this.updateMobsOnNonPlayerdamage) {
            return;
        }
        if (isCritical) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!(event instanceof EntityDamageByEntityEvent)) {
                return;
            }
            if (!(((EntityDamageByEntityEvent)event).getDamager() instanceof LivingEntity) || ((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                return;
            }
            Entity entity = ((EntityDamageByEntityEvent)event).getDamager();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper theHitter = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            List<NametagVisibilityEnum> nametagVisibilityEnums = theHitter.getNametagVisibilityEnum();
            long nametagVisibleTime = theHitter.getNametagCooldownTime();
            if (nametagVisibleTime > 0L && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.ATTACKED)) {
                if (theHitter.getPlayersNeedingNametagCooldownUpdate() == null) {
                    theHitter.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = theHitter.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                Entity entity2 = event.getEntity();
                Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.Player");
                set.add((Player)entity2);
                LevelledMobs.Companion.getInstance().getLevelManager().updateNametagWithDelay(theHitter);
            }
            theHitter.free();
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity livingEntity = (LivingEntity)entity;
        Entity entity3 = event.getEntity();
        Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity3);
        if (!lmEntity.isLevelled()) {
            if (EntitySpawnListener.Companion.getInstance().getProcessMobSpawns()) {
                lmEntity.free();
                return;
            }
            if (lmEntity.getGetMobLevel() < 0) {
                lmEntity.setReEvaluateLevel(true);
            }
        }
        Ref.BooleanRef wasDamagedByEntity = new Ref.BooleanRef();
        if (event instanceof EntityDamageByEntityEvent) {
            wasDamagedByEntity.element = true;
            if (((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                Entity entity4 = ((EntityDamageByEntityEvent)event).getDamager();
                Intrinsics.checkNotNull(entity4, "null cannot be cast to non-null type org.bukkit.entity.Player");
                lmEntity.setAssociatedPlayer((Player)entity4);
            }
        }
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)livingEntity, () -> EntityDamageListener.onEntityDamageEvent$lambda$0(lmEntity, wasDamagedByEntity));
        lmEntity.getInUseCount().incrementAndGet();
        scheduler.setRunDirectlyInBukkit(true);
        SchedulerWrapper.run$default(scheduler, false, 1, null);
        lmEntity.free();
    }

    private final void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        if (event.getFinalDamage() == 0.0) {
            return;
        }
        SchedulerWrapper scheduler = new SchedulerWrapper(event.getEntity(), () -> EntityDamageListener.onEntityDamageByEntityEvent$lambda$0(this, event));
        scheduler.setRunDirectlyInBukkit(true);
        SchedulerWrapper.run$default(scheduler, false, 1, null);
    }

    private final void processRangedDamage(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() == EntityType.AREA_EFFECT_CLOUD) {
            Entity entity = event.getDamager();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.AreaEffectCloud");
            AreaEffectCloud aec = (AreaEffectCloud)entity;
            if (!(aec.getSource() instanceof EnderDragon)) {
                return;
            }
            ProjectileSource projectileSource = aec.getSource();
            Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)projectileSource);
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            this.processRangedDamage2(lmEntity, event);
            lmEntity.free();
            return;
        }
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Entity entity = event.getDamager();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Projectile");
        Projectile projectile = (Projectile)entity;
        if (projectile.getShooter() == null) {
            return;
        }
        if (projectile.getShooter() instanceof Player && event.getEntity() instanceof LivingEntity) {
            Entity entity2 = event.getEntity();
            Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity2);
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            if (lmEntity.isLevelled() && lmEntity.getNametagVisibilityEnum().contains((Object)NametagVisibilityEnum.ATTACKED)) {
                if (lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                    lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                ProjectileSource projectileSource = projectile.getShooter();
                Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.Player");
                set.add((Player)projectileSource);
                lmEntity.getMain().getLevelManager().updateNametagWithDelay(lmEntity);
            }
            lmEntity.free();
            return;
        }
        if (!(projectile.getShooter() instanceof LivingEntity)) {
            return;
        }
        ProjectileSource projectileSource = projectile.getShooter();
        Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper shooter = LivingEntityWrapper.Companion.getInstance((LivingEntity)projectileSource);
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)shooter.getLivingEntity(), () -> EntityDamageListener.processRangedDamage$lambda$0(shooter, this, event));
        scheduler.setRunDirectlyInBukkit(true);
        SchedulerWrapper.run$default(scheduler, false, 1, null);
    }

    private final void processRangedDamage2(LivingEntityWrapper shooter, EntityDamageByEntityEvent event) {
        if (!shooter.getLivingEntity().isValid()) {
            return;
        }
        if (!shooter.isLevelled()) {
            if (EntitySpawnListener.Companion.getInstance().getProcessMobSpawns()) {
                return;
            }
            shooter.getMain().getMobsQueueManager().addToQueue(new QueueItem(shooter, (Event)event));
        }
        shooter.setRangedDamage(Float.valueOf((float)event.getDamage()));
        float newDamage = (float)event.getDamage() + shooter.getMain().getMobDataManager().getAdditionsForLevel(shooter, Addition.CUSTOM_RANGED_ATTACK_DAMAGE, (float)event.getDamage()).getMultiplierAmount();
        DebugManager.Companion.log(DebugType.RANGED_DAMAGE_MODIFICATION, shooter, () -> EntityDamageListener.processRangedDamage2$lambda$0(event, newDamage));
        event.setDamage((double)newDamage);
    }

    private final void processOtherRangedDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        Entity entity = event.getDamager();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!(livingEntity instanceof Guardian || livingEntity instanceof Ghast || livingEntity instanceof Wither)) {
            return;
        }
        if (!((Entity)livingEntity).isValid()) {
            return;
        }
        if (!LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled(livingEntity)) {
            return;
        }
        double oldDamage = event.getDamage();
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        event.setDamage((double)lmEntity.getMain().getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_RANGED_ATTACK_DAMAGE, (float)event.getDamage()).getMultiplierAmount());
        DebugManager.Companion.log(DebugType.RANGED_DAMAGE_MODIFICATION, (Entity)livingEntity, () -> EntityDamageListener.processOtherRangedDamage$lambda$0(oldDamage, event));
        lmEntity.free();
    }

    private static final void load$lambda$0(EntityDamageListener this$0, Listener listener, Event event) {
        Intrinsics.checkNotNullParameter(listener, "<unused var>");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntityDamageEvent) {
            this$0.onEntityDamageEvent((EntityDamageEvent)event);
        }
    }

    private static final void load$lambda$1(EntityDamageListener this$0, Listener listener, Event event) {
        Intrinsics.checkNotNullParameter(listener, "<unused var>");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntityDamageByEntityEvent) {
            this$0.onEntityDamageByEntityEvent((EntityDamageByEntityEvent)event);
        }
    }

    private static final void onEntityDamageEvent$lambda$0(LivingEntityWrapper $lmEntity, Ref.BooleanRef $wasDamagedByEntity) {
        List<NametagVisibilityEnum> nametagVisibilityEnums = $lmEntity.getNametagVisibilityEnum();
        long nametagVisibleTime = $lmEntity.getNametagCooldownTime();
        if (nametagVisibleTime > 0L && $wasDamagedByEntity.element && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.ATTACKED) && $lmEntity.getAssociatedPlayer() != null) {
            if ($lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                $lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
            }
            Set<Player> set = $lmEntity.getPlayersNeedingNametagCooldownUpdate();
            Intrinsics.checkNotNull(set);
            Player player = $lmEntity.getAssociatedPlayer();
            Intrinsics.checkNotNull(player);
            set.add(player);
        }
        $lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG, (Object)Instant.now().toEpochMilli());
        $lmEntity.getMain().getLevelManager().updateNametagWithDelay($lmEntity);
        $lmEntity.free();
    }

    private static final void onEntityDamageByEntityEvent$lambda$0(EntityDamageListener this$0, EntityDamageByEntityEvent $event) {
        this$0.processRangedDamage($event);
        this$0.processOtherRangedDamage($event);
    }

    private static final void processRangedDamage$lambda$0(LivingEntityWrapper $shooter, EntityDamageListener this$0, EntityDamageByEntityEvent $event) {
        MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, $shooter, null, 2, null);
        this$0.processRangedDamage2($shooter, $event);
        $shooter.free();
    }

    private static final String processRangedDamage2$lambda$0(EntityDamageByEntityEvent $event, float $newDamage) {
        return "damage: &b" + $event.getDamage() + "&7, new damage: &b" + $newDamage + "&7";
    }

    private static final String processOtherRangedDamage$lambda$0(double $oldDamage, EntityDamageByEntityEvent $event) {
        return "old damage: &b: " + $oldDamage + "&r, new damage: &b" + $event.getDamage() + "&r";
    }

    @NotNull
    public static final EntityDamageListener getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageListener$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageListener;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageListener;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDamageListener getInstance() {
            EntityDamageListener entityDamageListener = instance;
            if (entityDamageListener != null) {
                return entityDamageListener;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

