/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.AttributeNames;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.Cooldown;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageDebugListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "cooldownMap", "", "Ljava/util/UUID;", "Lio/github/arcaneplugins/levelledmobs/misc/Cooldown;", "onEntityDamageByEntity", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "checkEntity", "player", "Lorg/bukkit/entity/Player;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "send", "message", "", "usePrefix", "", "levelledmobs-plugin"})
public final class EntityDamageDebugListener
implements Listener {
    @NotNull
    private final Map<UUID, Cooldown> cooldownMap = new LinkedHashMap();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LevelledMobs.Companion.getInstance().getDebugManager().getDamageDebugOutputIsEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        Entity entity2 = event.getDamager();
        Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.Player");
        this.checkEntity((Player)entity2, lmEntity);
        lmEntity.free();
    }

    private final void checkEntity(Player player, LivingEntityWrapper lmEntity) {
        if (!lmEntity.isLevelled()) {
            return;
        }
        if (!player.hasPermission("levelledmobs.debug")) {
            return;
        }
        String entityId = String.valueOf(lmEntity.getLivingEntity().getEntityId());
        if (this.cooldownMap.containsKey(player.getUniqueId())) {
            Cooldown cooldown;
            Cooldown cooldown2 = cooldown = this.cooldownMap.get(player.getUniqueId());
            Intrinsics.checkNotNull(cooldown2);
            if (cooldown2.doesCooldownBelongToIdentifier(entityId) && !cooldown.hasCooldownExpired(2L)) {
                return;
            }
            this.cooldownMap.remove(player.getUniqueId());
        }
        this.send(player, "&8&m+---+&r Debug information for &b" + lmEntity.getTypeName() + "&r &8&m+---+&r");
        this.send(player, "&f&nGlobal Values:", false);
        this.send(player, "&8&m->&b Level: &7" + lmEntity.getGetMobLevel());
        this.send(player, "&8&m->&b Current Health: &7" + Utils.INSTANCE.round(lmEntity.getLivingEntity().getHealth()), false);
        if (lmEntity.getLivingEntity().getCustomName() != null) {
            this.send(player, "&8&m->&b Nametag: &7" + lmEntity.getLivingEntity().getCustomName(), false);
        }
        player.sendMessage(" ");
        this.send(player, "&f&nAttribute Values:", false);
        for (AttributeNames attributeName : AttributeNames.getEntries()) {
            AttributeInstance attributeInstance;
            Attribute attribute;
            if (Utils.INSTANCE.getAttribute(attributeName) == null || lmEntity.getLivingEntity().getAttribute(attribute) == null || Utils.INSTANCE.round(attributeInstance.getValue()) == 0.0) continue;
            StringBuilder sb = new StringBuilder("&8&m->&b ");
            sb.append(StringsKt.replace$default(attribute.toString(), "GENERIC_", "", false, 4, null)).append(": &7").append(Utils.INSTANCE.round(attributeInstance.getValue()));
            boolean hadItems = false;
            for (AttributeModifier mod : attributeInstance.getModifiers()) {
                StringBuilder stringBuilder = !hadItems ? sb.append(" (") : sb.append(", ");
                StringBuilder stringBuilder2 = mod.getOperation() == AttributeModifier.Operation.MULTIPLY_SCALAR_1 ? sb.append("* ") : sb.append("+ ");
                sb.append(Utils.INSTANCE.round(mod.getAmount(), 5));
                hadItems = true;
            }
            if (hadItems) {
                sb.append("), base: ");
                String remainingDigitsStr = String.valueOf(attributeInstance.getBaseValue());
                int remainingDigits = StringsKt.substringAfter$default(remainingDigitsStr, '.', null, 2, null).length() - 1;
                if (remainingDigits > 1) {
                    Object[] objectArray = new Object[]{Utils.INSTANCE.round(attributeInstance.getBaseValue()), 3};
                    v3 = StringsKt.append(sb, objectArray);
                } else {
                    v3 = sb.append(attributeInstance.getBaseValue());
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.send(player, string, false);
        }
        if (lmEntity.getLivingEntity() instanceof Creeper) {
            player.sendMessage(" ");
            this.send(player, "&f&nUnique Values:", false);
            LivingEntity livingEntity = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Creeper");
            this.send(player, "&8&m->&b Creeper Blast Radius: &7" + ((Creeper)livingEntity).getExplosionRadius(), false);
        }
        this.send(player, "&8(End of information.)", false);
        this.cooldownMap.put(player.getUniqueId(), new Cooldown(System.currentTimeMillis(), entityId));
    }

    private final void send(Player player, String message) {
        this.send(player, message, true);
    }

    private final void send(Player player, String message, boolean usePrefix) {
        if (usePrefix) {
            player.sendMessage(MessageUtils.INSTANCE.colorizeAll(LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + "&7 " + message));
        } else {
            player.sendMessage(MessageUtils.INSTANCE.colorizeAll(message));
        }
    }
}

