/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/ChunkLoadListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "ensureMobsAreLevelledOnChunkLoad", "", "load", "", "onChunkLoad", "event", "Lorg/bukkit/event/world/ChunkLoadEvent;", "checkEntity", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "levelledmobs-plugin"})
public final class ChunkLoadListener
implements Listener {
    private boolean ensureMobsAreLevelledOnChunkLoad = true;

    public final void load() {
        this.ensureMobsAreLevelledOnChunkLoad = LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("ensure-mobs-are-levelled-on-chunk-load", true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onChunkLoad(@NotNull ChunkLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.ensureMobsAreLevelledOnChunkLoad) {
            return;
        }
        Entity[] entityArray = event.getChunk().getEntities();
        Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
        for (Entity entity : entityArray) {
            Intrinsics.checkNotNull(entity);
            Entity entity2 = entity;
            if (!(entity2 instanceof LivingEntity)) continue;
            this.checkEntity((LivingEntity)entity2, event);
        }
    }

    private final void checkEntity(LivingEntity livingEntity, ChunkLoadEvent event) {
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        livingEntity.getScheduler().run((Plugin)LevelledMobs.Companion.getInstance(), arg_0 -> ChunkLoadListener.checkEntity$lambda$0(livingEntity, lmEntity, event, arg_0), null);
    }

    private static final void checkEntity$lambda$0$0(LivingEntityWrapper $lmEntity, ChunkLoadEvent $event) {
        if (LevelledMobs.Companion.getInstance().getLevelManager().getDoCheckMobHash() && Utils.INSTANCE.checkIfMobHashChanged($lmEntity)) {
            $lmEntity.setReEvaluateLevel(true);
            $lmEntity.setRulesForceAll(true);
            $lmEntity.setWasPreviouslyLevelled($lmEntity.isLevelled());
        } else if ($lmEntity.isLevelled()) {
            $lmEntity.free();
            return;
        }
        LevelledMobs.Companion.getInstance().getMobsQueueManager().addToQueue(new QueueItem($lmEntity, (Event)$event));
        $lmEntity.free();
    }

    private static final void checkEntity$lambda$0(LivingEntity $livingEntity, LivingEntityWrapper $lmEntity, ChunkLoadEvent $event, ScheduledTask task) {
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)$livingEntity, () -> ChunkLoadListener.checkEntity$lambda$0$0($lmEntity, $event));
        $lmEntity.buildCacheIfNeeded();
        $lmEntity.getInUseCount().getAndIncrement();
        wrapper.setRunDirectlyInBukkit(true);
        SchedulerWrapper.run$default(wrapper, false, 1, null);
    }
}

