/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/BlockPlaceListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onBlockPlaceEvent", "", "event", "Lorg/bukkit/event/block/BlockPlaceEvent;", "processMobSpawner", "invItem", "Lorg/bukkit/inventory/ItemStack;", "blockPlaced", "Lorg/bukkit/block/Block;", "levelledmobs-plugin"})
public final class BlockPlaceListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBlockPlaceEvent(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getBlockPlaced().getType() != Material.SPAWNER || event.getItemInHand().getType() != Material.SPAWNER) {
            return;
        }
        ItemStack itemStack = event.getItemInHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInHand(...)");
        Block block = event.getBlockPlaced();
        Intrinsics.checkNotNullExpressionValue(block, "getBlockPlaced(...)");
        this.processMobSpawner(itemStack, block);
    }

    private final void processMobSpawner(ItemStack invItem, Block blockPlaced) {
        ItemMeta itemMeta = invItem.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        if (!meta.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER)) {
            return;
        }
        BlockState blockState = blockPlaced.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.CreatureSpawner");
        CreatureSpawner cs = (CreatureSpawner)blockState;
        PersistentDataContainer persistentDataContainer = cs.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer targetPdc = persistentDataContainer;
        PersistentDataContainer persistentDataContainer2 = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer2, "getPersistentDataContainer(...)");
        PersistentDataContainer sourcePdc = persistentDataContainer2;
        NamespacedKey[] namespacedKeyArray = new NamespacedKey[]{NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), NamespacedKeys.INSTANCE.getKeySpawnerLore(), NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), NamespacedKeys.INSTANCE.getKeySpawnerDelay(), NamespacedKeys.INSTANCE.getKeySpawnerMaxNearbyEntities(), NamespacedKeys.INSTANCE.getKeySpawnerMinSpawnDelay(), NamespacedKeys.INSTANCE.getKeySpawnerMaxSpawnDelay(), NamespacedKeys.INSTANCE.getKeySpawnerRequiredPlayerRange(), NamespacedKeys.INSTANCE.getKeySpawnerSpawnCount(), NamespacedKeys.INSTANCE.getKeySpawnerSpawnRange()};
        List<NamespacedKey> keys = CollectionsKt.listOf(namespacedKeyArray);
        targetPdc.set(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER, (Object)1);
        int n = ((Collection)keys).size();
        block9: for (int i = 0; i < n; ++i) {
            NamespacedKey key = keys.get(i);
            if (i <= 3) {
                String valueStr;
                if (!sourcePdc.has(key, PersistentDataType.STRING) || (valueStr = (String)sourcePdc.get(key, PersistentDataType.STRING)) == null) continue;
                if (i == 1) {
                    EntityType entityType = EntityType.valueOf((String)valueStr);
                    cs.setSpawnedType(entityType);
                    continue;
                }
                targetPdc.set(key, PersistentDataType.STRING, (Object)valueStr);
                continue;
            }
            if (!sourcePdc.has(key, PersistentDataType.INTEGER)) continue;
            Integer valueInt = (Integer)sourcePdc.get(key, PersistentDataType.INTEGER);
            if (i < 6 && valueInt != null) {
                targetPdc.set(key, PersistentDataType.INTEGER, (Object)valueInt);
                continue;
            }
            if (valueInt == null) continue;
            switch (i) {
                case 6: {
                    cs.setDelay(valueInt.intValue());
                    continue block9;
                }
                case 7: {
                    cs.setMaxNearbyEntities(valueInt.intValue());
                    continue block9;
                }
                case 8: {
                    cs.setMaxSpawnDelay(RangesKt.coerceAtLeast(cs.getMaxSpawnDelay(), valueInt));
                    cs.setMinSpawnDelay(valueInt.intValue());
                    continue block9;
                }
                case 9: {
                    cs.setMinSpawnDelay(RangesKt.coerceAtMost(cs.getMinSpawnDelay(), valueInt));
                    cs.setMaxSpawnDelay(valueInt.intValue());
                    continue block9;
                }
                case 10: {
                    cs.setRequiredPlayerRange(valueInt.intValue());
                    continue block9;
                }
                case 11: {
                    cs.setSpawnCount(valueInt.intValue());
                    continue block9;
                }
                case 12: {
                    cs.setSpawnRange(valueInt.intValue());
                }
            }
        }
        cs.update();
    }
}

