/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.EquipmentClass;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\t\u00a8\u0006'"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/EquippedItemsInfo;", "", "<init>", "()V", "helmet", "Lorg/bukkit/inventory/ItemStack;", "getHelmet", "()Lorg/bukkit/inventory/ItemStack;", "setHelmet", "(Lorg/bukkit/inventory/ItemStack;)V", "chestplate", "getChestplate", "setChestplate", "leggings", "getLeggings", "setLeggings", "boots", "getBoots", "setBoots", "mainHand", "getMainHand", "setMainHand", "offhand", "getOffhand", "setOffhand", "saveEquipment", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "addEntityEquippedItems", "saveEquipmentToPDC", "saveItemToPDC", "item", "key", "Lorg/bukkit/NamespacedKey;", "isItemAllowedForSerialization", "", "itemStack", "Companion", "levelledmobs-plugin"})
public final class EquippedItemsInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ItemStack helmet;
    @Nullable
    private ItemStack chestplate;
    @Nullable
    private ItemStack leggings;
    @Nullable
    private ItemStack boots;
    @Nullable
    private ItemStack mainHand;
    @Nullable
    private ItemStack offhand;
    @NotNull
    private static final WeakHashMap<LivingEntity, EquippedItemsInfo> customEquippedItems = new WeakHashMap();
    @NotNull
    private static final Set<EquipmentClass> droppedEquipmentByClass = new LinkedHashSet();

    @Nullable
    public final ItemStack getHelmet() {
        return this.helmet;
    }

    public final void setHelmet(@Nullable ItemStack itemStack) {
        this.helmet = itemStack;
    }

    @Nullable
    public final ItemStack getChestplate() {
        return this.chestplate;
    }

    public final void setChestplate(@Nullable ItemStack itemStack) {
        this.chestplate = itemStack;
    }

    @Nullable
    public final ItemStack getLeggings() {
        return this.leggings;
    }

    public final void setLeggings(@Nullable ItemStack itemStack) {
        this.leggings = itemStack;
    }

    @Nullable
    public final ItemStack getBoots() {
        return this.boots;
    }

    public final void setBoots(@Nullable ItemStack itemStack) {
        this.boots = itemStack;
    }

    @Nullable
    public final ItemStack getMainHand() {
        return this.mainHand;
    }

    public final void setMainHand(@Nullable ItemStack itemStack) {
        this.mainHand = itemStack;
    }

    @Nullable
    public final ItemStack getOffhand() {
        return this.offhand;
    }

    public final void setOffhand(@Nullable ItemStack itemStack) {
        this.offhand = itemStack;
    }

    public final void saveEquipment(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            this.saveEquipmentToPDC(lmEntity);
        } else {
            this.addEntityEquippedItems(lmEntity);
        }
    }

    private final void addEntityEquippedItems(LivingEntityWrapper lmEntity) {
        ((Map)customEquippedItems).put(lmEntity.getLivingEntity(), this);
    }

    private final void saveEquipmentToPDC(LivingEntityWrapper lmEntity) {
        this.saveItemToPDC(this.mainHand, NamespacedKeys.INSTANCE.getEquipment0(), lmEntity);
        this.saveItemToPDC(this.offhand, NamespacedKeys.INSTANCE.getEquipment1(), lmEntity);
        this.saveItemToPDC(this.helmet, NamespacedKeys.INSTANCE.getEquipment2(), lmEntity);
        this.saveItemToPDC(this.chestplate, NamespacedKeys.INSTANCE.getEquipment3(), lmEntity);
        this.saveItemToPDC(this.leggings, NamespacedKeys.INSTANCE.getEquipment4(), lmEntity);
        this.saveItemToPDC(this.boots, NamespacedKeys.INSTANCE.getEquipment5(), lmEntity);
    }

    private final void saveItemToPDC(ItemStack item, NamespacedKey key, LivingEntityWrapper lmEntity) {
        if (this.isItemAllowedForSerialization(item)) {
            ItemStack itemStack = item;
            Intrinsics.checkNotNull(itemStack);
            byte[] byArray = itemStack.serializeAsBytes();
            Intrinsics.checkNotNullExpressionValue(byArray, "serializeAsBytes(...)");
            byte[] serialized = byArray;
            lmEntity.getPdc().set(key, PersistentDataType.BYTE_ARRAY, (Object)serialized);
        }
    }

    private final boolean isItemAllowedForSerialization(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.getType() != Material.AIR;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/EquippedItemsInfo$Companion;", "", "<init>", "()V", "customEquippedItems", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/LivingEntity;", "Lio/github/arcaneplugins/levelledmobs/customdrops/EquippedItemsInfo;", "droppedEquipmentByClass", "", "Lio/github/arcaneplugins/levelledmobs/enums/EquipmentClass;", "getDroppedEquipmentByClass", "()Ljava/util/Set;", "getEntityEquippedItems", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "loadFromPDC", "getItemFromPDC", "Lorg/bukkit/inventory/ItemStack;", "key", "Lorg/bukkit/NamespacedKey;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<EquipmentClass> getDroppedEquipmentByClass() {
            return droppedEquipmentByClass;
        }

        @Nullable
        public final EquippedItemsInfo getEntityEquippedItems(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            return LevelledMobs.Companion.getInstance().getVer().isRunningPaper() ? this.loadFromPDC(lmEntity) : (EquippedItemsInfo)customEquippedItems.get(lmEntity.getLivingEntity());
        }

        private final EquippedItemsInfo loadFromPDC(LivingEntityWrapper lmEntity) {
            EquippedItemsInfo equipment = new EquippedItemsInfo();
            equipment.setMainHand(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment0(), lmEntity));
            equipment.setOffhand(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment1(), lmEntity));
            equipment.setHelmet(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment2(), lmEntity));
            equipment.setChestplate(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment3(), lmEntity));
            equipment.setLeggings(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment4(), lmEntity));
            equipment.setBoots(this.getItemFromPDC(NamespacedKeys.INSTANCE.getEquipment5(), lmEntity));
            return equipment;
        }

        private final ItemStack getItemFromPDC(NamespacedKey key, LivingEntityWrapper lmEntity) {
            byte[] temp = (byte[])lmEntity.getPdc().get(key, PersistentDataType.BYTE_ARRAY);
            return temp != null ? ItemStack.deserializeBytes((byte[])temp) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

