/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat119;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat120;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat121;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropBase;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropInstance;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsDefaults;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsHandler;
import io.github.arcaneplugins.levelledmobs.customdrops.EnchantmentChances;
import io.github.arcaneplugins.levelledmobs.customdrops.GroupLimits;
import io.github.arcaneplugins.levelledmobs.customdrops.LMItemsParser;
import io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.functions.Function1;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.TypeIntrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.NBTManager;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.CustomUniversalGroups;
import io.github.arcaneplugins.levelledmobs.misc.YmlParsingHelper;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.MiscUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010'\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0012\u0010$\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020&H\u0002J\u0016\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+H\u0002J$\u0010,\u001a\u00020\u001e2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010.2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0001\u0018\u0001002\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J,\u00106\u001a\u0004\u0018\u0001072\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u000107H\u0002J\u0018\u0010;\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020&H\u0002J\u0018\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u00104\u001a\u000205H\u0002J(\u0010D\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010E2\u0006\u00104\u001a\u0002052\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010EH\u0002J\u001a\u0010F\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010<\u001a\u00020=H\u0002J,\u0010G\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001002\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010K\u001a\u00020\u001e2\u0006\u0010L\u001a\u00020C2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010N\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=2\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010O\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=2\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=H\u0002J\u001c\u0010R\u001a\u00020\f2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010SH\u0002J\u0010\u0010T\u001a\u00020\u001e2\b\u0010U\u001a\u0004\u0018\u00010VJ\u0010\u0010W\u001a\u00020\u00142\u0006\u0010X\u001a\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006Y"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser;", "", "handler", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler;", "<init>", "(Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler;)V", "value", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "defaults", "getDefaults", "()Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "hasMentionedNBTAPIMissing", "", "dropsUtilizeNBTAPI", "getDropsUtilizeNBTAPI", "()Z", "setDropsUtilizeNBTAPI", "(Z)V", "invalidExternalItems", "", "", "getInvalidExternalItems", "()Ljava/util/List;", "dropInstance", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropInstance;", "defaultName", "invalidEntityTypesToIgnore", "hadParsingError", "getHadParsingError", "buildInvalidEntityTypesToIgnore", "", "loadDrops", "customDropsCfg", "Lorg/bukkit/configuration/file/YamlConfiguration;", "hadError", "message", "processDefaults", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "parseCustomDrops", "config", "parseCustomDrops2", "itemConfigurations", "", "parseItem", "itemEntry", "", "parseExternalExtras", "", "parseCustomDropsAttributes", "dropBase", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropBase;", "ymlHelper", "Lio/github/arcaneplugins/levelledmobs/misc/YmlParsingHelper;", "parseSlidingChance", "Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "keyName", "formulaKey", "defaultValue", "parseCustomItem", "item", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropItem;", "parseGroupLimits", "base", "csParent", "parseCustomCommand", "customCommand", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomCommand;", "buildCachedModalListOfDamageCause", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "parseEnchantments", "parseEnchantmentChances", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "enchantmentsMap", "parseRangedVariables", "cc", "applyMetaAttributes", "parseItemFlags", "checkEquippedChance", "addMaterialToDrop", "materialName", "checkForMobOverride", "", "showCustomDropsDebugInfo", "sender", "Lorg/bukkit/command/CommandSender;", "showCustomDropsDebugInfo2", "baseItem", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomDropsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomDropsParser.kt\nio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1228:1\n1#2:1229\n*E\n"})
public final class CustomDropsParser {
    @NotNull
    private final CustomDropsHandler handler;
    @NotNull
    private CustomDropsDefaults defaults;
    private boolean hasMentionedNBTAPIMissing;
    private boolean dropsUtilizeNBTAPI;
    @NotNull
    private final List<String> invalidExternalItems;
    @NotNull
    private CustomDropInstance dropInstance;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<String> invalidEntityTypesToIgnore;
    private boolean hadParsingError;

    public CustomDropsParser(@NotNull CustomDropsHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.handler = handler;
        this.defaults = new CustomDropsDefaults();
        this.invalidExternalItems = new ArrayList();
        this.dropInstance = new CustomDropInstance(EntityType.AREA_EFFECT_CLOUD);
        this.defaultName = "default";
        this.invalidEntityTypesToIgnore = new ArrayList();
        this.defaults.setGroupId(this.defaultName);
        this.buildInvalidEntityTypesToIgnore();
    }

    @NotNull
    public final CustomDropsDefaults getDefaults() {
        return this.defaults;
    }

    public final boolean getDropsUtilizeNBTAPI() {
        return this.dropsUtilizeNBTAPI;
    }

    public final void setDropsUtilizeNBTAPI(boolean bl) {
        this.dropsUtilizeNBTAPI = bl;
    }

    @NotNull
    public final List<String> getInvalidExternalItems() {
        return this.invalidExternalItems;
    }

    public final boolean getHadParsingError() {
        return this.hadParsingError;
    }

    private final void buildInvalidEntityTypesToIgnore() {
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat119.INSTANCE.all19Mobs());
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat120.INSTANCE.all20Mobs());
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat121.INSTANCE.all21Mobs());
    }

    public final void loadDrops(@Nullable YamlConfiguration customDropsCfg) {
        this.dropsUtilizeNBTAPI = false;
        if (customDropsCfg == null) {
            return;
        }
        boolean isDropsEnabledForAnyRule = false;
        this.hadParsingError = false;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesManager().getRulesInEffect()) {
            if (ruleInfo.getCustomDropsUseForMobs() == null) continue;
            Boolean bl = ruleInfo.getCustomDropsUseForMobs();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) continue;
            isDropsEnabledForAnyRule = true;
            break;
        }
        this.handler.clearDrops();
        if (isDropsEnabledForAnyRule) {
            this.handler.clearGroupIdMappings();
            this.parseCustomDrops((ConfigurationSection)customDropsCfg);
        }
        DebugManager.Companion.log(DebugType.CUSTOM_DROPS, () -> CustomDropsParser.loadDrops$lambda$0(this));
    }

    private final void hadError(String message) {
        Log.INSTANCE.war(message);
        this.hadParsingError = true;
    }

    private final void processDefaults(ConfigurationSection cs) {
        if (cs == null) {
            this.hadError("Defaults section was null");
            return;
        }
        YmlParsingHelper ymlParser = new YmlParsingHelper(cs);
        CustomDropItem drop = new CustomDropItem(this.defaults);
        drop.setMaterial(Material.AIR);
        drop.setDefaultDrop(true);
        this.dropInstance = new CustomDropInstance(EntityType.AREA_EFFECT_CLOUD);
        this.dropInstance.getCustomItems().add(drop);
        this.parseCustomDropsAttributes(drop, ymlParser);
        this.defaults.setDefaultsFromDropItem(drop);
        this.defaults.setOverride(this.dropInstance.getGetOverrideStockDrops());
        this.defaults.setOverallChance(this.dropInstance.getOverallChance());
        this.defaults.getOverallPermissions().addAll((Collection<String>)this.dropInstance.getOverallPermissions());
        Map<String, CustomDropInstance> map = this.handler.getCustomDropIDs();
        String string = this.defaults.getGroupId();
        Intrinsics.checkNotNull(string);
        map.put(string, this.dropInstance);
    }

    private final void parseCustomDrops(ConfigurationSection config) {
        MemorySection ms;
        this.handler.setCustomItemGroups(new LinkedHashMap());
        this.processDefaults(YmlParsingHelper.Companion.objToCS(config, "defaults"));
        String dropTableKey = YmlParsingHelper.Companion.getKeyNameFromConfig(config, "drop-table");
        if (config.get(dropTableKey) != null && (ms = (MemorySection)config.get(dropTableKey)) != null) {
            Map map = ms.getValues(true);
            Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
            Map itemGroups = map;
            for (Map.Entry entry : itemGroups.entrySet()) {
                String itemGroupName = (String)entry.getKey();
                Object value = entry.getValue();
                this.dropInstance = new CustomDropInstance(EntityType.AREA_EFFECT_CLOUD);
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.collections.List<*>");
                this.parseCustomDrops2((List)value);
                if (!(!((Collection)this.dropInstance.getCustomItems()).isEmpty()) && !this.dropInstance.getGetOverrideStockDrops()) continue;
                this.handler.getCustomItemGroups().put(itemGroupName, this.dropInstance);
                this.handler.getCustomDropIDs().put(itemGroupName, this.dropInstance);
            }
        }
        for (String item : config.getKeys(false)) {
            EntityType entityType = EntityType.AREA_EFFECT_CLOUD;
            Intrinsics.checkNotNull(item);
            String[] stringArray = new String[]{";"};
            List mobTypeOrGroups = StringsKt.split$default((CharSequence)item, stringArray, false, 0, 6, null);
            for (String mobTypeOrGroupPre : mobTypeOrGroups) {
                Map<EntityType, CustomDropInstance> dropMap;
                String mobTypeOrGroup = ((Object)StringsKt.trim((CharSequence)mobTypeOrGroupPre)).toString();
                if (((CharSequence)mobTypeOrGroup).length() == 0) continue;
                String string = mobTypeOrGroup.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (StringsKt.startsWith$default(string, "file-version", false, 2, null)) continue;
                CustomUniversalGroups universalGroup = null;
                boolean isEntityTable = StringsKt.equals(mobTypeOrGroup, "drop-table", true);
                String string2 = mobTypeOrGroup.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                boolean isUniversalGroup = StringsKt.startsWith$default(string2, "all_", false, 2, null);
                if (isUniversalGroup) {
                    try {
                        String string3 = mobTypeOrGroup.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                        universalGroup = CustomUniversalGroups.valueOf(string3);
                    }
                    catch (Exception exception) {
                        this.hadError("invalid universal group in customdrops.yml: " + mobTypeOrGroup);
                        continue;
                    }
                    this.dropInstance = new CustomDropInstance(universalGroup);
                } else {
                    if (isEntityTable || StringsKt.equals(mobTypeOrGroup, "defaults", true)) continue;
                    boolean isBabyMob = false;
                    String string4 = mobTypeOrGroup.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                    if (StringsKt.startsWith$default(string4, "baby_", false, 2, null)) {
                        isBabyMob = true;
                        String string5 = mobTypeOrGroup.substring(5);
                        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                        mobTypeOrGroup = string5;
                    }
                    try {
                        String string6 = mobTypeOrGroup.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string6, "toUpperCase(...)");
                        entityType = EntityType.valueOf((String)string6);
                    }
                    catch (Exception exception) {
                        String string7 = mobTypeOrGroup.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string7, "toUpperCase(...)");
                        if (this.invalidEntityTypesToIgnore.contains(string7)) continue;
                        this.hadError("invalid mob type in customdrops.yml: " + mobTypeOrGroup);
                        continue;
                    }
                    this.dropInstance = new CustomDropInstance(entityType, isBabyMob);
                }
                this.dropInstance.setOverrideStockDrops(this.defaults.getOverride());
                this.dropInstance.setOverallChance(this.defaults.getOverallChance());
                if (!isEntityTable) {
                    if (config.getList(item) != null) {
                        this.parseCustomDrops2(config.getList(item));
                    } else if (config.get(item) instanceof MemorySection) {
                        ConfigurationSection csItem;
                        if (YmlParsingHelper.Companion.objToCS(config, item) == null) continue;
                        String useEntityDropId = YmlParsingHelper.Companion.getString(csItem, "usedroptable");
                        if (useEntityDropId != null && !this.handler.getCustomItemGroups().containsKey(useEntityDropId)) {
                            this.hadError("Did not find droptable id match for name: " + useEntityDropId);
                        } else if (useEntityDropId == null) {
                            this.hadError("Found a drop-table reference with no id!");
                        } else {
                            CustomDropInstance refDrop;
                            Intrinsics.checkNotNull(this.handler.getCustomItemGroups().get(useEntityDropId));
                            for (CustomDropBase itemDrop : refDrop.getCustomItems()) {
                                CustomDropBase customDropBase;
                                List<CustomDropBase> list = this.dropInstance.getCustomItems();
                                if (itemDrop instanceof CustomDropItem) {
                                    customDropBase = ((CustomDropItem)itemDrop).cloneItem();
                                } else {
                                    Intrinsics.checkNotNull(itemDrop, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand");
                                    customDropBase = ((CustomCommand)itemDrop).cloneItem();
                                }
                                Intrinsics.checkNotNull(customDropBase);
                                list.add(customDropBase);
                            }
                            if (refDrop.getUtilizesGroupIds()) {
                                this.dropInstance.setUtilizesGroupIds(true);
                            }
                            if (refDrop.getGetOverrideStockDrops()) {
                                this.dropInstance.setOverrideStockDrops(true);
                            }
                        }
                    }
                }
                if (!(!((Collection)this.dropInstance.getCustomItems()).isEmpty()) && !this.dropInstance.getGetOverrideStockDrops()) continue;
                if (isUniversalGroup) {
                    if (this.handler.getCustomDropsitemsGroups().containsKey(String.valueOf((Object)universalGroup))) {
                        CustomDropInstance csItem = this.handler.getCustomDropsitemsGroups().get(String.valueOf((Object)universalGroup));
                        if (csItem == null) continue;
                        csItem.combineDrop(this.dropInstance);
                        continue;
                    }
                    this.handler.addCustomDropGroup(String.valueOf((Object)universalGroup), this.dropInstance);
                    continue;
                }
                Map<EntityType, CustomDropInstance> map = dropMap = this.dropInstance.isBabyMob() ? this.handler.getCustomDropsitemsBabies() : this.handler.getCustomDropsitems();
                if (dropMap.containsKey(entityType)) {
                    CustomDropInstance customDropInstance = dropMap.get(entityType);
                    Intrinsics.checkNotNull(customDropInstance);
                    customDropInstance.combineDrop(this.dropInstance);
                    continue;
                }
                dropMap.put(entityType, this.dropInstance);
                this.handler.addCustomDropItem(entityType, this.dropInstance);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private final void parseCustomDrops2(List<?> itemConfigurations) {
        if (itemConfigurations == null) {
            return;
        }
        for (Object itemObject : itemConfigurations) {
            ConfigurationSection itemConfiguration;
            if (itemObject instanceof String) {
                CustomDropItem item = new CustomDropItem(this.defaults);
                if (StringsKt.equals("override", (String)itemObject, true)) {
                    this.dropInstance.setOverrideStockDrops(true);
                    continue;
                }
                this.addMaterialToDrop((String)itemObject, item);
                continue;
            }
            if (YmlParsingHelper.Companion.objToCS2(itemObject) == null) continue;
            Set itemsToCheck = itemConfiguration.getValues(false).entrySet();
            if (itemsToCheck.isEmpty()) {
                Object obj = itemObject;
                Intrinsics.checkNotNull(obj);
                if (Intrinsics.areEqual(obj.getClass(), LinkedHashMap.class)) {
                    LinkedHashMap materials = (LinkedHashMap)itemObject;
                    boolean needsContinue = false;
                    for (String materialName : materials.keySet()) {
                        CustomDropItem item;
                        if (!this.addMaterialToDrop(materialName, item = new CustomDropItem(this.defaults))) continue;
                        needsContinue = true;
                        break;
                    }
                    if (needsContinue) continue;
                }
            }
            for (Map.Entry<String, Object> itemEntry : itemsToCheck) {
                this.parseItem(itemEntry, itemConfiguration);
            }
        }
    }

    private final void parseItem(Map.Entry<String, Object> itemEntry, ConfigurationSection cs) {
        String materialName = itemEntry.getKey();
        if (this.checkForMobOverride(itemEntry)) {
            return;
        }
        this.dropInstance.setOverallChance(this.parseSlidingChance(new YmlParsingHelper(cs), "overall-chance", "overall-chance-formula", this.defaults.getOverallChance()));
        if (StringsKt.equals("overall-permission", materialName, true)) {
            if (itemEntry.getValue() instanceof String) {
                List<String> list = this.dropInstance.getOverallPermissions();
                String string = (String)itemEntry.getValue();
                Intrinsics.checkNotNull(string);
                list.add(string);
            } else if (itemEntry.getValue() instanceof ArrayList) {
                List<String> list = this.dropInstance.getOverallPermissions();
                Object object = itemEntry.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.ArrayList<kotlin.String>");
                list.addAll((ArrayList)object);
            }
            return;
        }
        if (StringsKt.equals("usedroptable", materialName, true)) {
            String useEntityDropId = itemEntry.getValue().toString();
            if (!this.handler.getCustomItemGroups().containsKey(useEntityDropId)) {
                this.hadError("Did not find droptable id match for name: " + useEntityDropId);
            } else {
                CustomDropInstance customDropInstance = this.handler.getCustomItemGroups().get(useEntityDropId);
                Intrinsics.checkNotNull(customDropInstance);
                CustomDropInstance refDrop = customDropInstance;
                for (CustomDropBase itemDrop : refDrop.getCustomItems()) {
                    this.dropInstance.getCustomItems().add(itemDrop);
                }
                if (refDrop.getUtilizesGroupIds()) {
                    this.dropInstance.setUtilizesGroupIds(true);
                }
                if (refDrop.getGetOverrideStockDrops()) {
                    this.dropInstance.setOverrideStockDrops(true);
                }
            }
            return;
        }
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS2(itemEntry.getValue());
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection cs2 = configurationSection;
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs2);
        CustomDropBase dropBase = null;
        if (StringsKt.equals("customCommand", materialName, true)) {
            dropBase = new CustomCommand(this.defaults);
        } else {
            CustomDropItem item = new CustomDropItem(this.defaults);
            item.setExternalType(ymlHelper.getString("type", this.defaults.getExternalType()));
            item.setExternalAmount(ymlHelper.getDouble2("external-amount", this.defaults.getExternalAmount()));
            item.setExternalExtras(this.parseExternalExtras(cs2));
            if (!this.addMaterialToDrop(materialName, item)) {
                return;
            }
            dropBase = item;
        }
        this.parseCustomDropsAttributes(dropBase, ymlHelper);
    }

    private final Map<String, Object> parseExternalExtras(ConfigurationSection cs) {
        Map map;
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, "extras");
        if (configurationSection == null) {
            return null;
        }
        ConfigurationSection cs2 = configurationSection;
        Map results = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        for (String name : cs2.getKeys(false)) {
            Object value = cs2.get(name);
            if (value == null) continue;
            results.put(name, value);
        }
        Map map2 = results;
        if (map2.isEmpty()) {
            boolean bl = false;
            map = null;
        } else {
            map = map2;
        }
        return map;
    }

    private final void parseCustomDropsAttributes(CustomDropBase dropBase, YmlParsingHelper ymlHelper) {
        block8: {
            block9: {
                dropBase.setChance(this.parseSlidingChance(ymlHelper, "chance", "chance-formula", this.defaults.getChance()));
                dropBase.setUseChunkKillMax(ymlHelper.getBoolean("use-chunk-kill-max", this.defaults.getUseChunkKillMax()));
                dropBase.getPermissions().addAll((Collection<String>)this.defaults.getPermissions());
                dropBase.getPermissions().addAll((Collection<String>)ymlHelper.getStringSet("permission"));
                dropBase.setMinLevel(ymlHelper.getInt("minlevel", this.defaults.getMinLevel()));
                dropBase.setMaxLevel(ymlHelper.getInt("maxlevel", this.defaults.getMaxLevel()));
                dropBase.setMinPlayerLevel(ymlHelper.getInt("min-player-level", this.defaults.getMinPlayerLevel()));
                dropBase.setMaxPlayerLevel(ymlHelper.getInt("max-player-level", this.defaults.getMaxPlayerLevel()));
                dropBase.setPlayerLevelVariable(ymlHelper.getString("player-level-variable", this.defaults.getPlayerLevelVariable()));
                dropBase.getPlayeerVariableMatches().addAll((Collection<String>)ymlHelper.getStringOrList("player-variable-match-value"));
                dropBase.setPlayerCausedOnly(ymlHelper.getBoolean("player-caused", this.defaults.getPlayerCausedOnly()));
                dropBase.setMaxDropGroup(ymlHelper.getInt("maxdropgroup", this.defaults.getMaxDropGroup()));
                if (!dropBase.isDefaultDrop()) {
                    dropBase.setGroupId(ymlHelper.getString("groupid"));
                }
                if (dropBase.getHasGroupId()) {
                    String string = dropBase.getGroupId();
                    Intrinsics.checkNotNull(string);
                    this.handler.setDropInstanceFromId(string, this.dropInstance);
                }
                this.dropInstance.setUtilizesGroupIds(dropBase.getHasGroupId());
                this.parseGroupLimits(dropBase, ymlHelper.getCs());
                CharSequence charSequence = ymlHelper.getString("amount");
                if (!(charSequence == null || charSequence.length() == 0) && !dropBase.setAmountRangeFromString(ymlHelper.getString("amount"))) {
                    this.hadError("Invalid number or number range for amount on " + this.dropInstance.getMobOrGroupName() + ", " + ymlHelper.getString("amount"));
                }
                this.dropInstance.setOverallChance(this.parseSlidingChance(ymlHelper, "overall-chance", "overall-chance-formula", this.dropInstance.getOverallChance()));
                charSequence = ymlHelper.getString("overall-chance");
                if (charSequence == null || charSequence.length() == 0) break block8;
                if (this.dropInstance.getOverallChance() == null) break block9;
                SlidingChance slidingChance = this.dropInstance.getOverallChance();
                Intrinsics.checkNotNull(slidingChance);
                if (!slidingChance.isDefault()) break block8;
            }
            this.dropInstance.setOverallChance(null);
        }
        if (ymlHelper.getCs().get(YmlParsingHelper.Companion.getKeyNameFromConfig(ymlHelper.getCs(), "overall-permission")) != null) {
            this.dropInstance.getOverallPermissions().addAll((Collection<String>)ymlHelper.getStringSet("overall-permission"));
        }
        dropBase.setCauseOfDeathReqs(this.buildCachedModalListOfDamageCause(ymlHelper, this.defaults.getCauseOfDeathReqs()));
        if (dropBase instanceof CustomCommand) {
            this.parseCustomCommand((CustomCommand)dropBase, ymlHelper);
            return;
        }
        Intrinsics.checkNotNull(dropBase, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem");
        this.parseCustomItem(ymlHelper, (CustomDropItem)dropBase);
    }

    private final SlidingChance parseSlidingChance(YmlParsingHelper ymlHelper, String keyName, String formulaKey, SlidingChance defaultValue) {
        Object chanceOptsMap = ymlHelper.getCs().get(keyName);
        ConfigurationSection chanceOpts = null;
        String formula = ymlHelper.getString(formulaKey);
        if (chanceOptsMap instanceof LinkedHashMap || chanceOptsMap instanceof MemorySection) {
            chanceOpts = YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), keyName);
        }
        if (chanceOpts == null) {
            Float parsedValue = ymlHelper.getFloat2(keyName, null);
            if (defaultValue == null && parsedValue == null) {
                return null;
            }
            SlidingChance result = new SlidingChance();
            if (parsedValue != null) {
                result.setChance(parsedValue.floatValue());
            } else {
                result.setFromInstance(defaultValue);
            }
            result.setDefaults(defaultValue);
            CharSequence charSequence = formula;
            if (charSequence == null || charSequence.length() == 0) {
                SlidingChance slidingChance = defaultValue;
                result.setFormula(slidingChance != null ? slidingChance.getFormula() : null);
            } else {
                result.setFormula(formula);
            }
            return result;
        }
        Map chanceRange = new LinkedHashMap();
        Map map = chanceOpts.getValues(false);
        Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
        Map values = map;
        for (String str : values.keySet()) {
            Object value = values.get(str);
            if (str == null || value == null) continue;
            MinAndMax mobLvl = MinAndMax.Companion.setAmountRangeFromString(str);
            MinAndMax assignment = MinAndMax.Companion.setAmountRangeFromString(value.toString());
            if (mobLvl == null || assignment == null) continue;
            mobLvl.setShowAsInt(true);
            chanceRange.put(mobLvl, assignment);
        }
        SlidingChance result = null;
        if (chanceRange.isEmpty()) {
            if (defaultValue == null) {
                return null;
            }
            result = new SlidingChance();
            result.setFromInstance(defaultValue);
        } else {
            result = new SlidingChance();
            result.setFromInstance(defaultValue);
            result.setChangeRange(chanceRange);
        }
        result.setDefaults(defaultValue);
        CharSequence charSequence = formula;
        if (charSequence == null || charSequence.length() == 0) {
            result.setFormula(null);
        } else {
            result.setFormula(formula);
        }
        return result;
    }

    private final void parseCustomItem(YmlParsingHelper ymlHelper, CustomDropItem item) {
        Object excludes;
        this.checkEquippedChance(item, ymlHelper);
        this.parseItemFlags(item, ymlHelper);
        item.setOnlyDropIfEquipped(ymlHelper.getBoolean("only-drop-if-equipped", this.defaults.getOnlyDropIfEquipped()));
        item.setEquipOnHelmet(ymlHelper.getBoolean("equip-on-helmet", this.defaults.getEquipOnHelmet()));
        item.setEquipOffhand(ymlHelper.getBoolean("equip-offhand", this.defaults.getEquipOffhand()));
        item.setPriority(ymlHelper.getInt("priority", this.defaults.getPriority()));
        item.setNoMultiplier(ymlHelper.getBoolean("nomultiplier", this.defaults.getNoMultiplier()));
        item.setNoSpawner(ymlHelper.getBoolean("nospawner", this.defaults.getNoSpawner()));
        item.setCustomModelDataId(ymlHelper.getInt("custommodeldata", this.defaults.getCustomModelData()));
        item.setExternalType(ymlHelper.getString("type", this.defaults.getExternalType()));
        item.setExternalAmount(ymlHelper.getDouble2("external-amount", this.defaults.getExternalAmount()));
        item.setMinItems(ymlHelper.getInt("min-items", 1));
        item.setMaxItems(ymlHelper.getInt("max-items", 1));
        item.setAllowedList(ymlHelper.getStringOrList("allowed-list"));
        item.setExcludedList(ymlHelper.getStringOrList("excluded-list"));
        item.setAmountFormula(ymlHelper.getString("amount-formula"));
        this.dropInstance.setOverrideStockDrops(ymlHelper.getBoolean2("override", this.defaults.getOverride()));
        CharSequence charSequence = ymlHelper.getString("damage");
        if (!(charSequence == null || charSequence.length() == 0) && !item.setDamageRangeFromString(ymlHelper.getString("damage"))) {
            this.hadError("Invalid number range for damage on " + this.dropInstance.getMobOrGroupName() + ", " + ymlHelper.getString("damage"));
        }
        item.setLore(ymlHelper.getStringOrList("lore"));
        item.setCustomName(ymlHelper.getString("name", item.getCustomName()));
        charSequence = ymlHelper.getString("excludemobs");
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = ymlHelper.getString("excludemobs");
            Intrinsics.checkNotNull(string);
            Object object = new String[]{";"};
            excludes = StringsKt.split$default((CharSequence)string, (String[])object, false, 0, 6, null);
            item.getExcludedMobs().clear();
            object = excludes.iterator();
            while (object.hasNext()) {
                String exclude = (String)object.next();
                item.getExcludedMobs().add(((Object)StringsKt.trim((CharSequence)exclude)).toString());
            }
        }
        this.parseEnchantments(ymlHelper.objToCS("enchantments"), item);
        item.setNbtData(ymlHelper.getString("nbt-data", this.defaults.getNbtData()));
        if (item.getMaterial() != Material.AIR && !((excludes = (CharSequence)item.getNbtData()) == null || excludes.length() == 0)) {
            if (ExternalCompatibilityManager.Companion.getHasNbtApiInstalled()) {
                String string = item.getNbtData();
                Intrinsics.checkNotNull(string);
                NBTApplyResult result = NBTManager.INSTANCE.applyNBTDataItem(item, string);
                if (result.getHadException()) {
                    this.hadError("custom drop " + item.getMaterial() + " for " + this.dropInstance.getMobOrGroupName() + " has invalid NBT data: " + result.getExceptionMessage());
                } else if (result.getItemStack() != null) {
                    item.setItemStack(result.getItemStack());
                    this.dropsUtilizeNBTAPI = true;
                    DebugManager.Companion.log(DebugType.NBT_APPLICATION, () -> CustomDropsParser.parseCustomItem$lambda$0(result));
                }
            } else if (!this.hasMentionedNBTAPIMissing) {
                this.hadError("NBT Data has been specified in customdrops.yml but required plugin NBTAPI is not installed!");
                this.hasMentionedNBTAPIMissing = true;
            }
        }
        this.applyMetaAttributes(item);
    }

    private final void parseGroupLimits(CustomDropBase base, ConfigurationSection csParent) {
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(csParent, "group-limits");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection cs = configurationSection;
        if (!base.getHasGroupId()) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        GroupLimits limits = new GroupLimits();
        limits.setCapPerItem(ymlHelper.getInt("cap-per-item"));
        limits.setCapTotal(ymlHelper.getInt("cap-total"));
        limits.setCapEquipped(ymlHelper.getInt("cap-equipped"));
        limits.setCapSelect(ymlHelper.getInt("cap-select"));
        limits.setRetries(ymlHelper.getInt("retries"));
        if (!limits.isEmpty() || base.isDefaultDrop()) {
            Map<String, GroupLimits> map = this.handler.getGroupLimitsMap();
            String string = base.getGroupId();
            Intrinsics.checkNotNull(string);
            map.put(string, limits);
        }
    }

    private final void parseCustomCommand(CustomCommand customCommand, YmlParsingHelper ymlHelper) {
        customCommand.getCommands().addAll((Collection<String>)ymlHelper.getStringOrList("command"));
        customCommand.setCommandName(ymlHelper.getString("name"));
        customCommand.setDelay(ymlHelper.getInt("delay", 0));
        customCommand.setRunOnSpawn(ymlHelper.getBoolean("run-on-spawn", false));
        customCommand.setRunOnDeath(ymlHelper.getBoolean("run-on-death", true));
        customCommand.setMobScale(ymlHelper.getDouble2("mob-scale", null));
        this.parseRangedVariables(customCommand, ymlHelper.getCs());
        if (customCommand.getCommands().isEmpty()) {
            this.hadError("no command was specified for custom command");
        } else {
            this.dropInstance.getCustomItems().add(customCommand);
        }
    }

    private final CachedModalList<String> buildCachedModalListOfDamageCause(YmlParsingHelper ymlHelper, CachedModalList<String> defaultValue) {
        String cause;
        CachedModalList<String> cachedModalList = new CachedModalList<String>();
        String useKeyName = ymlHelper.getKeyNameFromConfig("cause-of-death");
        Object simpleStringOrArray = ymlHelper.getCs().get(useKeyName);
        ConfigurationSection cs2 = null;
        List<Object> useList = null;
        if (simpleStringOrArray instanceof ArrayList) {
            useList = CollectionsKt.toMutableList((ArrayList)simpleStringOrArray);
        } else if (simpleStringOrArray instanceof String) {
            String[] stringArray = new String[]{simpleStringOrArray};
            useList = CollectionsKt.mutableListOf(stringArray);
        }
        if (useList == null) {
            cs2 = YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), useKeyName);
        }
        if (cs2 == null && useList == null) {
            return defaultValue;
        }
        cachedModalList.setDoMerge(YmlParsingHelper.Companion.getBoolean(cs2, "merge"));
        if (cs2 != null) {
            useList = YmlParsingHelper.Companion.getListFromConfigItem(cs2, "allowed-list");
        }
        List<Object> list = useList;
        Intrinsics.checkNotNull(list);
        for (String string : list) {
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) continue;
            if (Intrinsics.areEqual("*", ((Object)StringsKt.trim((CharSequence)string)).toString())) {
                cachedModalList.setIncludeAll(true);
                continue;
            }
            try {
                String string2;
                if (StringsKt.equals(((Object)StringsKt.trim((CharSequence)string)).toString(), "PLAYER_CAUSED", true)) {
                    string2 = "PLAYER_CAUSED";
                } else {
                    String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                    string2 = EntityDamageEvent.DamageCause.valueOf((String)string3).toString();
                }
                cause = string2;
                cachedModalList.getIncludedList().add(cause);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.hadError("Invalid damage cause: " + string);
            }
        }
        if (cs2 == null) {
            return cachedModalList;
        }
        for (String string : YmlParsingHelper.Companion.getListFromConfigItem(cs2, "excluded-list")) {
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) continue;
            if (Intrinsics.areEqual("*", ((Object)StringsKt.trim((CharSequence)string)).toString())) {
                cachedModalList.setExcludeAll(true);
                continue;
            }
            try {
                String string4;
                if (StringsKt.equals(((Object)StringsKt.trim((CharSequence)string)).toString(), "PLAYER_CAUSED", true)) {
                    string4 = "PLAYER_CAUSED";
                } else {
                    String string5 = ((Object)StringsKt.trim((CharSequence)string)).toString().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                    string4 = EntityDamageEvent.DamageCause.valueOf((String)string5).toString();
                }
                cause = string4;
                cachedModalList.getExcludedList().add(cause);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.hadError("Invalid damage cause: " + string);
            }
        }
        if (cachedModalList.isEmpty() && !cachedModalList.getIncludeAll() && !cachedModalList.getExcludeAll()) {
            return defaultValue;
        }
        return cachedModalList;
    }

    private final void parseEnchantments(ConfigurationSection cs, CustomDropItem item) {
        if (cs == null) {
            return;
        }
        Map map = cs.getValues(false);
        Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
        Map enchantMap = map;
        for (Map.Entry entry : enchantMap.entrySet()) {
            String enchantName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LinkedHashMap) {
                Intrinsics.checkNotNull(enchantName);
                Enchantment enchantment = Utils.INSTANCE.getEnchantment(enchantName);
                if (enchantment == null) {
                    this.hadError("Invalid enchantment: " + enchantName);
                    continue;
                }
                Map enchantments = TypeIntrinsics.asMutableMap(value);
                this.parseEnchantmentChances(enchantment, enchantments, item);
                continue;
            }
            int enchantLevel = 1;
            if (value != null && Utils.INSTANCE.isInteger(value.toString())) {
                enchantLevel = Integer.parseInt(value.toString());
            }
            Intrinsics.checkNotNull(enchantName);
            Enchantment enchantment = Utils.INSTANCE.getEnchantment(enchantName);
            if (enchantment != null) {
                if (item.getMaterial() == Material.ENCHANTED_BOOK) {
                    ItemStack itemStack = item.getItemStack();
                    ItemMeta itemMeta = itemStack != null ? itemStack.getItemMeta() : null;
                    Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                    meta.addStoredEnchant(enchantment, enchantLevel, true);
                    ItemStack itemStack2 = item.getItemStack();
                    Intrinsics.checkNotNull(itemStack2);
                    itemStack2.setItemMeta((ItemMeta)meta);
                    continue;
                }
                ItemStack itemStack = item.getItemStack();
                Intrinsics.checkNotNull(itemStack);
                itemStack.addUnsafeEnchantment(enchantment, enchantLevel);
                continue;
            }
            this.hadError("Invalid enchantment: " + enchantName);
        }
    }

    private final void parseEnchantmentChances(Enchantment enchantment, Map<Object, Object> enchantmentsMap, CustomDropItem item) {
        Map items = new LinkedHashMap();
        Integer defaultLevel = null;
        Boolean doShuttle = null;
        for (Map.Entry<Object, Object> object : enchantmentsMap.entrySet()) {
            Object key = object.getKey();
            Object value = object.getValue();
            if (StringsKt.equals("shuffle", key.toString(), true)) {
                if (!StringsKt.equals("false", value.toString(), true)) continue;
                doShuttle = false;
                continue;
            }
            boolean isDefault = StringsKt.equals(this.defaultName, key.toString(), true);
            int enchantmentLevel = 0;
            if (!isDefault) {
                if (!Utils.INSTANCE.isInteger(key.toString())) {
                    this.hadError("Enchantment: " + enchantment + ", invalid enchantment level " + key);
                    continue;
                }
                enchantmentLevel = Integer.parseInt(key.toString());
            }
            double chanceValue = 0.0;
            try {
                chanceValue = Double.parseDouble(value.toString());
            }
            catch (Exception exception) {
                this.hadError("Enchantment: " + enchantment + ", invalid chance specified: " + value);
                continue;
            }
            if (isDefault) {
                defaultLevel = (int)chanceValue;
                continue;
            }
            items.put(enchantmentLevel, Float.valueOf((float)chanceValue));
        }
        if (items.isEmpty()) {
            return;
        }
        if (item.getEnchantmentChances() == null) {
            item.setEnchantmentChances(new EnchantmentChances());
        }
        if (doShuttle != null || defaultLevel != null) {
            EnchantmentChances enchantmentChances = item.getEnchantmentChances();
            Intrinsics.checkNotNull(enchantmentChances);
            EnchantmentChances.ChanceOptions chanceOptions = enchantmentChances.getOptions().computeIfAbsent(enchantment, arg_0 -> CustomDropsParser.parseEnchantmentChances$lambda$1(CustomDropsParser::parseEnchantmentChances$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(chanceOptions, "computeIfAbsent(...)");
            EnchantmentChances.ChanceOptions opts = chanceOptions;
            if (defaultLevel != null) {
                opts.setDefaultLevel(defaultLevel);
            }
            if (doShuttle != null) {
                opts.setDoShuffle(false);
            }
        }
        EnchantmentChances enchantmentChances = item.getEnchantmentChances();
        Intrinsics.checkNotNull(enchantmentChances);
        enchantmentChances.getItems().put(enchantment, items);
    }

    private final void parseRangedVariables(CustomCommand cc, ConfigurationSection cs) {
        for (String key : cs.getKeys(false)) {
            String value;
            CharSequence charSequence;
            Intrinsics.checkNotNull(key);
            String string = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (!StringsKt.startsWith$default(string, "ranged", false, 2, null) || (charSequence = (CharSequence)(value = cs.getString(key))) == null || charSequence.length() == 0) continue;
            cc.getRangedEntries().put(key, value);
        }
    }

    private final void applyMetaAttributes(CustomDropItem item) {
        ItemStack itemStack = item.getItemStack();
        Intrinsics.checkNotNull(itemStack);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        boolean madeChanges = false;
        if (item.getCustomModelDataId() != this.defaults.getCustomModelData()) {
            meta.setCustomModelData(Integer.valueOf(item.getCustomModelDataId()));
            ItemStack itemStack2 = item.getItemStack();
            Intrinsics.checkNotNull(itemStack2);
            itemStack2.setItemMeta(meta);
            madeChanges = true;
        }
        if (item.getItemFlags() != null) {
            List<ItemFlag> list = item.getItemFlags();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                List<ItemFlag> list2 = item.getItemFlags();
                Intrinsics.checkNotNull(list2);
                for (ItemFlag flag : list2) {
                    ItemFlag[] itemFlagArray = new ItemFlag[]{flag};
                    meta.addItemFlags(itemFlagArray);
                }
                madeChanges = true;
            }
        }
        if (madeChanges) {
            ItemStack itemStack3 = item.getItemStack();
            Intrinsics.checkNotNull(itemStack3);
            itemStack3.setItemMeta(meta);
        }
    }

    private final void parseItemFlags(CustomDropItem item, YmlParsingHelper ymlHelper) {
        List list;
        CharSequence charSequence;
        item.setItemFlagsStrings(ymlHelper.getStringList("item_flags"));
        List<String> list2 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list2);
        if (list2.isEmpty() && this.defaults.getItemFlagsStrings() != null) {
            item.setItemFlagsStrings(this.defaults.getItemFlagsStrings());
        }
        String itemFlags = null;
        List<String> list3 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list3);
        if (list3.isEmpty()) {
            itemFlags = ymlHelper.getString("itemflags");
            charSequence = itemFlags;
            if (charSequence == null || charSequence.length() == 0) {
                itemFlags = ymlHelper.getString("item_flags");
            }
            if ((charSequence = (CharSequence)itemFlags) == null || charSequence.length() == 0) {
                itemFlags = ymlHelper.getString("item-flags");
            }
        }
        List<String> list4 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list4);
        if (list4.isEmpty() && ((charSequence = (CharSequence)itemFlags) == null || charSequence.length() == 0)) {
            return;
        }
        List results = new ArrayList();
        List<String> list5 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list5);
        if (list5.isEmpty()) {
            String string = itemFlags;
            Intrinsics.checkNotNull(string);
            String[] stringArray = new String[]{";"};
            List list6 = StringsKt.split$default((CharSequence)StringsKt.replace$default(string, ",", ";", false, 4, null), stringArray, false, 0, 6, null);
            Intrinsics.checkNotNull(list6, "null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            list = TypeIntrinsics.asMutableList(list6);
        } else {
            list = item.getItemFlagsStrings();
        }
        item.setItemFlagsStrings(list);
        List<String> list7 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list7);
        for (String flag : list7) {
            try {
                String string = ((Object)StringsKt.trim((CharSequence)flag)).toString().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                ItemFlag newFlag = ItemFlag.valueOf((String)string);
                results.add(newFlag);
            }
            catch (Exception exception) {
                this.hadError("Invalid itemflag: " + flag + ", item: " + item.getMaterial().name() + ", mobOrGroup: " + this.dropInstance.getMobOrGroupName());
            }
        }
        if (!((Collection)results).isEmpty()) {
            item.setItemFlags(results);
        }
    }

    private final void checkEquippedChance(CustomDropItem item, YmlParsingHelper ymlHelper) {
        String temp;
        CharSequence charSequence;
        block8: {
            block7: {
                item.setEquippedChance(this.parseSlidingChance(ymlHelper, "equipped", "equipped-formula", this.defaults.getEquippedChance()));
                if (this.defaults.getEquippedChance() == null) break block7;
                if (item.getEquippedChance() == null) break block8;
                SlidingChance slidingChance = item.getEquippedChance();
                Intrinsics.checkNotNull(slidingChance);
                if (slidingChance.isDefault()) break block8;
            }
            return;
        }
        if ((charSequence = (CharSequence)(temp = ymlHelper.getString("equipped"))) == null || charSequence.length() == 0) {
            return;
        }
        if (StringsKt.equals("false", temp, true)) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            slidingChance.setChance(0.0f);
        } else if (StringsKt.equals("true", temp, true)) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            slidingChance.setChance(1.0f);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean addMaterialToDrop(String materialName, CustomDropItem item) {
        block8: {
            String useMaterialName = materialName;
            useMaterialName = Utils.INSTANCE.replaceEx(useMaterialName, "mob_head", "player_head");
            if (StringsKt.contains$default((CharSequence)(useMaterialName = Utils.INSTANCE.replaceEx(useMaterialName, "mobhead", "player_head")), ":", false, 2, null)) {
                if (ExternalCompatibilityManager.Companion.getInstance().doesLMIMeetVersionRequirement()) {
                    LMItemsParser lMItemsParser = this.handler.getLmItemsParser();
                    Intrinsics.checkNotNull(lMItemsParser);
                    if (!lMItemsParser.parseExternalItemAttributes(useMaterialName, item)) {
                        return false;
                    }
                    break block8;
                } else {
                    if (ExternalCompatibilityManager.Companion.getHasLMItemsInstalled()) {
                        this.hadError("Custom drop '" + useMaterialName + "' requires plugin LM_Items but it is an old version");
                        return false;
                    }
                    this.hadError("Custom drop '" + useMaterialName + "' requires plugin LM_Items but it is not installed");
                    return false;
                }
            }
            Material material = null;
            if (StringsKt.equals("override", useMaterialName, true)) {
                this.dropInstance.setOverrideStockDrops(true);
                return true;
            }
            try {
                String string = useMaterialName.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                material = Material.valueOf((String)string);
            }
            catch (Exception exception) {
                this.hadError("Invalid material type specified in customdrops.yml for: " + this.dropInstance.getMobOrGroupName() + ", " + useMaterialName);
                return false;
            }
            item.setMaterial(material);
        }
        this.dropInstance.getCustomItems().add(item);
        return true;
    }

    private final boolean checkForMobOverride(Map.Entry<String, ? extends Object> itemEntry) {
        Object value;
        if (StringsKt.equals(itemEntry.getKey(), "override", true) && Intrinsics.areEqual((value = itemEntry.getValue()).getClass(), Boolean.TYPE)) {
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Boolean");
            this.dropInstance.setOverrideStockDrops((Boolean)value);
            return true;
        }
        return false;
    }

    public final void showCustomDropsDebugInfo(@Nullable CommandSender sender) {
        StringBuilder sbMain = new StringBuilder();
        int dropsCount = 0;
        int commandsCount = 0;
        for (CustomDropInstance cdi : this.handler.getCustomDropsitems().values()) {
            for (CustomDropBase customDropBase : cdi.getCustomItems()) {
                if (customDropBase instanceof CustomDropItem) {
                    ++dropsCount;
                    continue;
                }
                if (!(customDropBase instanceof CustomCommand)) continue;
                ++commandsCount;
            }
        }
        Map<String, CustomDropInstance> allGroups = this.handler.getCustomDropsitemsGroups();
        int itemsCount = allGroups.size() + this.handler.getCustomDropsitemsBabies().size();
        int customItemGroupCount = this.handler.getCustomItemGroups().size();
        sbMain.append("drop instances: " + this.handler.getCustomDropsitems().size() + ", custom groups: " + itemsCount + ", item groups: " + customItemGroupCount + ", items: " + dropsCount + ", commands: " + commandsCount);
        for (String msg : this.invalidExternalItems) {
            sbMain.append("\n&4").append(msg).append("&r");
        }
        SortedMap sortedMap = new TreeMap();
        for (EntityType entityType : this.handler.getCustomDropsitems().keySet()) {
            ((Map)sortedMap).put(entityType.toString(), entityType);
        }
        for (EntityType entityType : this.handler.getCustomDropsitemsBabies().keySet()) {
            ((Map)sortedMap).put(entityType + "_2", entityType);
        }
        for (String string : sortedMap.keySet()) {
            CustomDropInstance customDropInstance;
            Intrinsics.checkNotNull(string);
            boolean isBaby = StringsKt.endsWith$default(string, "_2", false, 2, null);
            String string2 = isBaby ? StringsKt.dropLast(string, 2) : string;
            Intrinsics.checkNotNull(string2);
            EntityType ent = EntityType.valueOf((String)string2);
            if (isBaby) {
                CustomDropInstance customDropInstance2 = this.handler.getCustomDropsitemsBabies().get(ent);
                Intrinsics.checkNotNull(customDropInstance2);
                customDropInstance = customDropInstance2;
            } else {
                CustomDropInstance customDropInstance3 = this.handler.getCustomDropsitems().get(ent);
                Intrinsics.checkNotNull(customDropInstance3);
                customDropInstance = customDropInstance3;
            }
            CustomDropInstance dropInstance = customDropInstance;
            String override = dropInstance.getGetOverrideStockDrops() ? " (override)" : "";
            String overallChance = dropInstance.getOverallChance() != null ? " (overall-chance: " + dropInstance.getOverallChance() + ")" : "";
            sbMain.append("\nmob: &b");
            if (isBaby) {
                sbMain.append("(baby) ");
            }
            sbMain.append(ent.name()).append("&r");
            sbMain.append(override).append(overallChance);
            if (!((Collection)dropInstance.getOverallPermissions()).isEmpty()) {
                sbMain.append(" (overall perms: ");
                sbMain.append(dropInstance.getOverallPermissions()).append(")");
            }
            for (CustomDropBase baseItem : dropInstance.getCustomItems()) {
                String result = this.showCustomDropsDebugInfo2(baseItem);
                if (!(((CharSequence)result).length() > 0)) continue;
                sbMain.append("\n").append(result);
            }
        }
        for (Map.Entry entry : allGroups.entrySet()) {
            String key = (String)entry.getKey();
            CustomDropInstance value = (CustomDropInstance)entry.getValue();
            String override = value.getGetOverrideStockDrops() ? " (override)" : "";
            String overallChance = value.getOverallChance() != null ? " (overall-chance: " + value.getOverallChance() + ")" : "";
            if (((CharSequence)sbMain).length() > 0) {
                sbMain.append("\n");
            }
            sbMain.append("group: ").append(key);
            sbMain.append(override).append(overallChance);
            for (CustomDropBase baseItem : value.getCustomItems()) {
                String result = this.showCustomDropsDebugInfo2(baseItem);
                if (!(((CharSequence)result).length() > 0)) continue;
                sbMain.append("\n").append(result);
            }
        }
        if (sender != null) {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sbMain.toString()));
        } else {
            Log.INSTANCE.inf(sbMain.toString());
        }
    }

    private final String showCustomDropsDebugInfo2(CustomDropBase baseItem) {
        CharSequence itemMaterial;
        CustomCommand command = baseItem instanceof CustomCommand ? (CustomCommand)baseItem : null;
        CustomDropItem item = baseItem instanceof CustomDropItem ? (CustomDropItem)baseItem : null;
        StringBuilder sb = new StringBuilder();
        if (item != null) {
            itemMaterial = item.getMaterial().toString();
            sb.append("  &b" + (String)itemMaterial + "&r, amount: &b" + item.getAmountAsString() + "&r, chance: &b" + baseItem.getChance() + "&r");
        } else if (baseItem instanceof CustomCommand) {
            sb.append("  COMMAND, chance: &b" + baseItem.getChance() + "&r, run-on-spawn: " + ((CustomCommand)baseItem).getRunOnSpawn() + ", run-on-death: " + ((CustomCommand)baseItem).getRunOnDeath());
        }
        if (baseItem.getMinLevel() > -1) {
            sb.append(", minL: &b");
            sb.append(baseItem.getMinLevel()).append("&r");
        }
        if (baseItem.getMaxLevel() > -1) {
            sb.append(", maxL: &b");
            sb.append(baseItem.getMaxLevel()).append("&r");
        }
        if (baseItem.getMinPlayerLevel() > -1) {
            sb.append(", minPL: &b");
            sb.append(baseItem.getMinPlayerLevel()).append("&r");
        }
        if (baseItem.getMaxPlayerLevel() > -1) {
            sb.append(", maxPL: &b");
            sb.append(baseItem.getMaxPlayerLevel()).append("&r");
        }
        if (!((Collection)baseItem.getPermissions()).isEmpty()) {
            sb.append(", perms: &b");
            sb.append(baseItem.getPermissions()).append("&r");
        }
        if (baseItem.getNoSpawner()) {
            sb.append(", nospn");
        }
        if (baseItem.getCauseOfDeathReqs() != null) {
            sb.append(", ").append(baseItem.getCauseOfDeathReqs());
        }
        if (baseItem.getHasGroupId()) {
            sb.append(", gId: &b");
            sb.append(baseItem.getGroupId()).append("&r");
            if (baseItem.getMaxDropGroup() > 0 && !this.handler.getGroupLimitsMap().containsKey(baseItem.getGroupId())) {
                sb.append(", maxDropGroup: &b");
                sb.append(baseItem.getMaxDropGroup()).append("&r");
            }
        }
        if (baseItem.getPriority() > 0) {
            sb.append(", pri: &b");
            sb.append(baseItem.getPriority()).append("&r");
        }
        if (command != null) {
            itemMaterial = command.getCommandName();
            if (!(itemMaterial == null || itemMaterial.length() == 0)) {
                sb.append(", name: &b");
                sb.append(command.getCommandName()).append("&r");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        if (item == null) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        if (item.getNoMultiplier()) {
            sb.append(", nomultp");
        }
        if (item.getLore() != null) {
            List<String> list = item.getLore();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                sb.append(", hasLore");
            }
        }
        if (item.getCustomName() != null) {
            String string = item.getCustomName();
            Intrinsics.checkNotNull(string);
            if (((CharSequence)string).length() > 0) {
                sb.append(", hasName");
            }
        }
        if (item.getDamage() != 0 || item.getHasDamageRange()) {
            sb.append(", dmg: &b");
            sb.append(item.getDamageAsString()).append("&r");
        }
        if (!((Collection)item.getExcludedMobs()).isEmpty()) {
            sb.append(", hasExcludes");
        }
        if (item.getEquippedChance() != null) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            if (!slidingChance.isDefault()) {
                sb.append(", equipChance: &b");
                sb.append(item.getEquippedChance()).append("&r");
            }
        }
        if (item.getOnlyDropIfEquipped()) {
            sb.append(", &bonlyDropIfEquipped&r");
        }
        if (item.getEquipOnHelmet()) {
            sb.append(", &bequipHelmet&r");
        }
        if (item.getItemFlags() != null) {
            List<ItemFlag> list = item.getItemFlags();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                sb.append(", itemflags: &b");
                List<ItemFlag> list2 = item.getItemFlags();
                Intrinsics.checkNotNull(list2);
                sb.append(list2.size()).append("&r");
            }
        }
        if (item.isExternalItem()) {
            sb.append(", ext: ");
            sb.append(item.getExternalPluginName());
            if (item.getExternalType() != null) {
                sb.append(", ex-type: ");
                sb.append(item.getExternalType());
            }
            if (item.getExternalItemId() != null) {
                sb.append(", ex-id: ");
                sb.append(item.getExternalItemId());
            }
            if (item.getExternalAmount() != null) {
                sb.append(", ex-amt: ");
                sb.append(item.getExternalAmount());
            }
            if (item.getExternalExtras() != null) {
                sb.append(", ex-xtras: ");
                Map<String, Object> map = item.getExternalExtras();
                Intrinsics.checkNotNull(map);
                sb.append(map.size());
            }
        }
        if (item.getEnchantmentChances() != null) {
            EnchantmentChances enchantmentChances = item.getEnchantmentChances();
            Intrinsics.checkNotNull(enchantmentChances);
            if (!enchantmentChances.isEmpty()) {
                StringBuilder enchantmentLevels = new StringBuilder();
                enchantmentLevels.append("encht-lvls: ");
                EnchantmentChances enchantmentChances2 = item.getEnchantmentChances();
                Intrinsics.checkNotNull(enchantmentChances2);
                for (Enchantment enchantment : enchantmentChances2.getItems().keySet()) {
                    EnchantmentChances.ChanceOptions opts;
                    if (enchantmentLevels.length() > 12) {
                        enchantmentLevels.append("; ");
                    }
                    enchantmentLevels.append("&b");
                    enchantmentLevels.append(enchantment.getKey().value());
                    enchantmentLevels.append("&r: ");
                    boolean isFirst = true;
                    EnchantmentChances enchantmentChances3 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances3);
                    Map<Integer, Float> map = enchantmentChances3.getItems().get(enchantment);
                    Set<Map.Entry<Integer, Float>> set = map != null ? map.entrySet() : null;
                    Intrinsics.checkNotNull(set);
                    for (Map.Entry<Object, Object> entry : set) {
                        int key = ((Number)entry.getKey()).intValue();
                        float value = ((Number)entry.getValue()).floatValue();
                        if (!isFirst) {
                            enchantmentLevels.append(", ");
                        }
                        enchantmentLevels.append(key + "-&b" + value + "&r");
                        isFirst = false;
                    }
                    EnchantmentChances enchantmentChances4 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances4);
                    if (!enchantmentChances4.getOptions().containsKey(enchantment)) continue;
                    EnchantmentChances enchantmentChances5 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances5);
                    EnchantmentChances.ChanceOptions chanceOptions = opts = enchantmentChances5.getOptions().get(enchantment);
                    Intrinsics.checkNotNull(chanceOptions);
                    if (chanceOptions.getDefaultLevel() != null) {
                        enchantmentLevels.append(", dflt: ").append(opts.getDefaultLevel());
                    }
                    if (opts.getDoShuffle()) continue;
                    enchantmentLevels.append(", no shfl");
                }
                sb.append("\n    ");
                sb.append((CharSequence)enchantmentLevels);
            }
        }
        if (item.getItemStack() != null) {
            ItemStack itemStack = item.getItemStack();
            Intrinsics.checkNotNull(itemStack);
            ItemStack itemStack2 = itemStack;
            ItemMeta meta = itemStack2.getItemMeta();
            StringBuilder sb2 = new StringBuilder();
            if (meta != null) {
                Set enchantments = meta instanceof EnchantmentStorageMeta ? ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet() : meta.getEnchants().entrySet();
                for (Map.Entry entry : enchantments) {
                    if (((CharSequence)sb2).length() > 0) {
                        sb2.append(", ");
                    }
                    String string = Intrinsics.areEqual(((Enchantment)entry.getKey()).getKey().getNamespace(), "minecraft") ? ((Enchantment)entry.getKey()).key().value() : ((Enchantment)entry.getKey()).key().toString();
                    Intrinsics.checkNotNull(string);
                    String showKey = string;
                    sb2.append("&b" + showKey + "&r (" + entry.getValue() + ")");
                }
            }
            if (((CharSequence)sb2).length() > 0) {
                sb.append("\n    ").append((CharSequence)sb2);
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String loadDrops$lambda$0(CustomDropsParser this$0) {
        return "Group Limits: " + this$0.handler.getGroupLimitsMap();
    }

    private static final String parseCustomItem$lambda$0(NBTApplyResult $result) {
        NBTApplyResult[] nBTApplyResultArray = new NBTApplyResult[]{$result};
        return "Applied NBT data, " + MiscUtils.INSTANCE.getNBTDebugMessage(CollectionsKt.mutableListOf(nBTApplyResultArray));
    }

    private static final EnchantmentChances.ChanceOptions parseEnchantmentChances$lambda$0(Enchantment enchantment) {
        Intrinsics.checkNotNullParameter(enchantment, "<unused var>");
        return new EnchantmentChances.ChanceOptions();
    }

    private static final EnchantmentChances.ChanceOptions parseEnchantmentChances$lambda$1(Function1 $tmp0, Object p0) {
        return (EnchantmentChances.ChanceOptions)$tmp0.invoke(p0);
    }
}

