/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.CommandBase;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SummonMobOptions;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin._Assertions;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.LivingEntityPlaceholder;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.RequestedLevel;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.result.MinAndMaxHolder;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002:;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010%\u001a\u0004\u0018\u00010\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020!H\u0002J2\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J'\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006<"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/CommandBase;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "processCmd", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "buildTabSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "summonMobs", "options", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonMobOptions;", "spawnMobs", "sender", "Lorg/bukkit/command/CommandSender;", "location", "Lorg/bukkit/Location;", "getSpawnLocation", "getBlockCandidates", "", "Lorg/bukkit/block/Block;", "minDistFromPlayer", "", "maxDistFromPlayer", "target", "Lorg/bukkit/entity/Player;", "checkBlockCandidates", "blockCandidates", "blocksNeeded", "world", "Lorg/bukkit/World;", "getLocationNearPlayer", "player", "useDistFromPlayer", "getRelativeLocation", "xStr", "yStr", "zStr", "processRelativeCoords", "", "input", "coordType", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$CoordType;", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$CoordType;)Ljava/lang/Double;", "addVarianceToLocation", "oldLocation", "getEntityNames", "SummonType", "CoordType", "levelledmobs-plugin"})
public final class SummonSubcommand
extends CommandBase {
    @NotNull
    public static final SummonSubcommand INSTANCE = new SummonSubcommand();
    @NotNull
    private static final String description = "Various commands for summoning mobs.";

    private SummonSubcommand() {
        super("levelledmobs.command.summon");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("summon").executes(SummonSubcommand::buildCommand$lambda$0)).then(((RequiredArgumentBuilder)this.createNumberArgument$levelledmobs_plugin("number").executes(SummonSubcommand::buildCommand$lambda$1)).then(((RequiredArgumentBuilder)this.createStringArgument$levelledmobs_plugin("mobtype").suggests(SummonSubcommand::buildCommand$lambda$2).executes(SummonSubcommand::buildCommand$lambda$3)).then(((RequiredArgumentBuilder)this.createNumberArgument$levelledmobs_plugin("moblevel").executes(SummonSubcommand::buildCommand$lambda$4)).then(((RequiredArgumentBuilder)this.createStringArgument$levelledmobs_plugin("designator").suggests(SummonSubcommand::buildCommand$lambda$5).executes(SummonSubcommand::buildCommand$lambda$6)).then(this.createGreedyStringArgument$levelledmobs_plugin("values").suggests(SummonSubcommand::buildCommand$lambda$7).executes(SummonSubcommand::buildCommand$lambda$8))))))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void processCmd(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(sender);
        Integer amount = this.getIntegerArgument$levelledmobs_plugin(ctx, "number");
        Integer mobLevel = this.getIntegerArgument$levelledmobs_plugin(ctx, "moblevel");
        String mobType = this.getStringArgument$levelledmobs_plugin(ctx, "mobtype");
        String designator = this.getStringArgument$levelledmobs_plugin(ctx, "designator");
        String values = this.getStringArgument$levelledmobs_plugin(ctx, "values");
        if (((CharSequence)designator).length() == 0) {
            designator = "here";
        }
        if (amount == null || mobLevel == null || ((CharSequence)mobType).length() == 0) {
            this.showMessage("command.levelledmobs.summon.usage");
            return;
        }
        EntityType entityType = null;
        try {
            String string = mobType.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            entityType = EntityType.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.showMessage("command.levelledmobs.summon.invalid-entity-type", "%entityType%", mobType);
            return;
        }
        RequestedLevel requestedLevel = new RequestedLevel();
        requestedLevel.setLevel(mobLevel);
        CommandSender commandSender2 = sender;
        Location location = commandSender2 instanceof Player ? ((Player)sender).getLocation() : (commandSender2 instanceof BlockCommandSender ? ((BlockCommandSender)sender).getBlock().getLocation() : null);
        String nbtData = null;
        List<String> miscArgs = this.splitStringWithQuotes(values, false);
        int n = miscArgs.size();
        for (int i = 2; i < n; ++i) {
            String arg = miscArgs.get(i);
            if (!StringsKt.startsWith$default((CharSequence)arg, '{', false, 2, null) || !StringsKt.endsWith$default((CharSequence)arg, '}', false, 2, null)) continue;
            nbtData = arg;
        }
        String string = designator.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "here": {
                if (location == null) {
                    this.showMessage("command.levelledmobs.summon.here.usage");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.HERE);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-location": {
                String xStr = "";
                String yStr = "";
                String zStr = "";
                World world = null;
                int n2 = miscArgs.size();
                block19: for (int i = 0; i < n2; ++i) {
                    String arg = miscArgs.get(i);
                    if (StringsKt.startsWith$default((CharSequence)arg, '{', false, 2, null)) continue;
                    switch (i) {
                        case 0: {
                            xStr = arg;
                            continue block19;
                        }
                        case 1: {
                            yStr = arg;
                            continue block19;
                        }
                        case 2: {
                            zStr = arg;
                            continue block19;
                        }
                        case 3: {
                            world = Bukkit.getWorld((String)arg);
                            if (world != null) continue block19;
                            this.showMessage("command.levelledmobs.summon.atLocation.invalid-world", "%world%", arg);
                            return;
                        }
                    }
                }
                if (world == null) {
                    this.showMessage("command.levelledmobs.summon.atLocation.usage-console");
                    return;
                }
                location = this.getRelativeLocation(sender, xStr, yStr, zStr, world);
                if (location == null) {
                    sender.sendMessage("Invalid location");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.AT_LOCATION);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-player": {
                boolean didSummon = false;
                int n3 = miscArgs.size();
                for (int i = 0; i < n3; ++i) {
                    String arg = miscArgs.get(i);
                    if (StringsKt.startsWith$default(arg, "{", false, 2, null)) continue;
                    boolean offline = false;
                    World world = null;
                    Player target = Bukkit.getPlayer((String)arg);
                    if (target == null) {
                        offline = true;
                    } else if (sender instanceof Player) {
                        if (!((Player)sender).canSee(target) && !((Player)sender).isOp()) {
                            offline = true;
                        }
                        location = target.getLocation();
                        world = location.getWorld();
                    } else {
                        location = target.getLocation();
                        world = target.getWorld();
                    }
                    if (offline || world == null) {
                        this.showMessage("common.player-offline", "%player%", arg);
                        return;
                    }
                    Location location2 = location;
                    Intrinsics.checkNotNull(location2);
                    LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location2);
                    SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                    options.setAmount(amount);
                    options.setRequestedLevel(requestedLevel);
                    options.setSummonType(SummonType.AT_PLAYER);
                    options.setPlayer(target);
                    options.setOverride(true);
                    options.setNbtData(nbtData);
                    this.summonMobs(options);
                    lmPlaceHolder.free();
                    didSummon = true;
                    break;
                }
                if (didSummon) break;
                this.showMessage("command.levelledmobs.summon.atPlayer.usage");
                break;
            }
            default: {
                this.showMessage("command.levelledmobs.summon.usage");
            }
        }
    }

    private final CompletableFuture<Suggestions> buildTabSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        String string = ctx.getInput();
        Intrinsics.checkNotNullExpressionValue(string, "getInput(...)");
        List<String> args = this.splitStringWithQuotes(string, true);
        StringBuilder prefix = new StringBuilder();
        List existingItems = new ArrayList();
        int n = args.size();
        for (int i = 6; i < n; ++i) {
            String string2 = args.get(i).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            existingItems.add(string2);
            prefix.append(args.get(i)).append(' ');
        }
        String string3 = args.get(5).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        switch (string3) {
            case "here": {
                CompletableFuture completableFuture = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
                return completableFuture;
            }
            case "at-player": {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player) {
                        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
                        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                        Player player = (Player)commandSender;
                        if (!player.canSee(onlinePlayer) && !player.isOp()) continue;
                        builder.suggest(onlinePlayer.getName());
                        continue;
                    }
                    builder.suggest(onlinePlayer.getName());
                }
                CompletableFuture completableFuture = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
                return completableFuture;
            }
            case "at-location": {
                n = args.size();
                boolean bl = 6 <= n ? n < 9 : false;
                if (bl) {
                    Utils.INSTANCE.getOneToNineSuggestions(builder);
                    break;
                }
                if (args.size() != 9) break;
                for (World world : Bukkit.getWorlds()) {
                    builder.suggest(prefix + world.getName());
                }
                CompletableFuture completableFuture = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
                return completableFuture;
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final void summonMobs(SummonMobOptions options) {
        CommandSender sender = options.getSender();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Player target = options.getPlayer();
        Ref.ObjectRef location = new Ref.ObjectRef();
        location.element = options.getLmPlaceholder().getLocation();
        if (CollectionsKt.contains((Iterable)main.getLevelManager().getForcedBlockedEntityTypes(), options.getLmPlaceholder().getEntityType())) {
            this.showMessage("command.levelledmobs.summon.not-levellable");
            return;
        }
        if (!sender.isOp() && !options.getOverride() && main.getLevelInterface().getLevellableState(options.getLmPlaceholder()) != LevellableState.ALLOWED) {
            this.showMessage("command.levelledmobs.summon.not-levellable");
            return;
        }
        if (options.getAmount() < 1) {
            this.showMessage("command.levelledmobs.summon.amount-limited.min");
        }
        int maxAmount = main.getHelperSettings().getInt("customize-summon-command-limit", 100);
        if (options.getAmount() > maxAmount) {
            options.setAmount(maxAmount);
            this.showMessage("command.levelledmobs.summon.amount-limited.max");
        }
        MinAndMaxHolder levels = main.getLevelManager().getMinAndMaxLevels(options.getLmPlaceholder());
        RequestedLevel requestedLevel = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel);
        if ((float)requestedLevel.getLevelMin() < levels.getMin() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel2 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel2);
            requestedLevel2.setMinAllowedLevel(levels.getMinAsInt());
            this.showMessage("command.levelledmobs.summon.level-limited.min");
        }
        RequestedLevel requestedLevel3 = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel3);
        if ((float)requestedLevel3.getLevelMax() > levels.getMax() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel4 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel4);
            requestedLevel4.setMaxAllowedLevel(levels.getMaxAsInt());
            this.showMessage("command.levelledmobs.summon.level-limited.max");
        }
        if (options.getSummonType() == SummonType.HERE) {
            location.element = this.addVarianceToLocation((Location)location.element);
        }
        if (options.getSummonType() == SummonType.HERE || options.getSummonType() == SummonType.AT_PLAYER) {
            int distFromPlayer = main.getHelperSettings().getInt("summon-command-spawn-distance-from-player", 5);
            if (distFromPlayer > 0 && target != null) {
                Location locationTemp = this.getSpawnLocation((Location)location.element, options);
                if (locationTemp == null) {
                    sender.sendMessage("Unable to find a suitable spawn location");
                    return;
                }
                location.element = locationTemp;
            } else if (target == null && sender instanceof BlockCommandSender) {
                location.element = new Location(((Location)location.element).getWorld(), (double)((Location)location.element).getBlockX(), (double)(((Location)location.element).getBlockY() + 2), (double)((Location)location.element).getBlockZ());
            }
        }
        CompletableFuture future = new CompletableFuture();
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)options.getPlayer(), () -> SummonSubcommand.summonMobs$lambda$0(sender, options, location, future));
        wrapper.setRunDirectlyInBukkit(true);
        wrapper.setRunDirectlyInFolia(sender instanceof Player);
        wrapper.setLocationForRegionScheduler((Location)location.element);
        SchedulerWrapper.run$default(wrapper, false, 1, null);
        future.get(100L, TimeUnit.MILLISECONDS);
        boolean printResults = main.getHelperSettings().getBoolean("print-lm-summon-results", true);
        SummonType summonType = options.getSummonType();
        switch (summonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[summonType.ordinal()]) {
            case 1: {
                if (!printResults) break;
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%"};
                List<String> list = CollectionsKt.mutableListOf(stringArray);
                stringArray = new String[]{String.valueOf(options.getAmount()), String.valueOf(options.getRequestedLevel()), options.getLmPlaceholder().getTypeName()};
                this.showMessage("command.levelledmobs.summon.here.success", list, CollectionsKt.mutableListOf(stringArray));
                break;
            }
            case 2: {
                String string;
                if (!printResults) break;
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%", "%x%", "%y%", "%z%", "%world%"};
                List<String> list = CollectionsKt.mutableListOf(stringArray);
                stringArray = new String[7];
                stringArray[0] = String.valueOf(options.getAmount());
                stringArray[1] = String.valueOf(options.getRequestedLevel());
                stringArray[2] = options.getLmPlaceholder().getTypeName();
                stringArray[3] = String.valueOf(((Location)location.element).getBlockX());
                stringArray[4] = String.valueOf(((Location)location.element).getBlockY());
                stringArray[5] = String.valueOf(((Location)location.element).getBlockZ());
                if (((Location)location.element).getWorld() == null) {
                    string = "(null)";
                } else {
                    String string2 = ((Location)location.element).getWorld().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                }
                stringArray[6] = string;
                this.showMessage("command.levelledmobs.summon.atLocation.success", list, CollectionsKt.mutableListOf(stringArray));
                break;
            }
            case 3: {
                if (!printResults) break;
                String playerName = main.getVer().isRunningPaper() ? PaperUtils.INSTANCE.getPlayerDisplayName(target) : SpigotUtils.INSTANCE.getPlayerDisplayName(target);
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%", "%targetUsername%", "%targetDisplayname%"};
                List<String> list = CollectionsKt.mutableListOf(stringArray);
                stringArray = new String[5];
                stringArray[0] = String.valueOf(options.getAmount());
                stringArray[1] = String.valueOf(options.getRequestedLevel());
                stringArray[2] = options.getLmPlaceholder().getTypeName();
                Object object = target;
                if (object == null || (object = object.getName()) == null) {
                    object = "(null)";
                }
                stringArray[3] = object;
                stringArray[4] = target == null ? "(null)" : playerName;
                this.showMessage("command.levelledmobs.summon.atPlayer.success", list, CollectionsKt.mutableListOf(stringArray));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected SummonType value of " + options.getSummonType() + "!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void spawnMobs(CommandSender sender, SummonMobOptions options, Location location) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        RequestedLevel requestedLevel = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel);
        RequestedLevel requestedLevel2 = requestedLevel;
        int n = options.getAmount();
        for (int i = 0; i < n; ++i) {
            Entity entity;
            boolean bl;
            int it = i;
            boolean bl2 = false;
            boolean bl3 = bl = location.getWorld() != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int useLevel = requestedLevel2.getHasLevelRange() ? ThreadLocalRandom.current().nextInt(requestedLevel2.getLevelRangeMin(), requestedLevel2.getLevelRangeMax() + 1) : requestedLevel2.getLevel();
            World world = location.getWorld();
            EntityType entityType = options.getLmPlaceholder().getEntityType();
            Intrinsics.checkNotNull(entityType);
            Intrinsics.checkNotNullExpressionValue(world.spawnEntity(location, entityType), "spawnEntity(...)");
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            lmEntity.setSummonedLevel(useLevel);
            lmEntity.setNewlySpawned(true);
            Object object = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
            synchronized (object) {
                boolean $i$a$-synchronized-SummonSubcommand$spawnMobs$1$32 = false;
                Object $i$a$-synchronized-SummonSubcommand$spawnMobs$1$32 = main.getLevelManager().getSummonedOrSpawnEggs().put(lmEntity.getLivingEntity(), null);
            }
            Object[] objectArray = (String[])options.getNbtData();
            if (!(objectArray == null || objectArray.length() == 0)) {
                objectArray = new String[1];
                Intrinsics.checkNotNull(options.getNbtData());
                lmEntity.setNbtData(CollectionsKt.mutableListOf(objectArray));
            }
            lmEntity.setSummonedSender(sender);
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            object = persistentDataContainer;
            synchronized (object) {
                boolean bl4 = false;
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER, (Object)1);
                Unit unit = Unit.INSTANCE;
            }
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            objectArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
            main.getLevelInterface().applyLevelToMob(lmEntity, useLevel, true, options.getOverride(), SetsKt.mutableSetOf(objectArray));
            lmEntity.free();
        }
    }

    private final Location getSpawnLocation(Location location, SummonMobOptions options) {
        if (location.getWorld() == null) {
            return null;
        }
        EntityType entityType = options.getLmPlaceholder().getEntityType();
        Intrinsics.checkNotNull(entityType);
        EntityType entityType2 = entityType;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Ref.ObjectRef maxDistFromPlayer = new Ref.ObjectRef();
        maxDistFromPlayer.element = main.getHelperSettings().getInt2("summon-command-spawn-max-distance-from-player", null);
        if (maxDistFromPlayer.element == null) {
            maxDistFromPlayer.element = main.getHelperSettings().getInt2("summon-command-spawn-distance-from-player", null);
        }
        if (maxDistFromPlayer.element == null) {
            maxDistFromPlayer.element = 5;
        }
        int minDistFromPlayer = (int)Math.min((double)main.getHelperSettings().getInt("summon-command-spawn-min-distance-from-player", 3), (double)((Number)maxDistFromPlayer.element).intValue());
        int blocksNeeded = entityType2 == EntityType.ENDERMAN || entityType2 == EntityType.RAVAGER ? 3 : 2;
        CompletableFuture completableFuture = new CompletableFuture();
        Player player = options.getPlayer();
        Intrinsics.checkNotNull(player);
        Player target = player;
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)target, () -> SummonSubcommand.getSpawnLocation$lambda$0(minDistFromPlayer, maxDistFromPlayer, target, location, completableFuture));
        wrapper.setRunDirectlyInBukkit(true);
        if (options.getSender() instanceof Player) {
            wrapper.setRunDirectlyInFolia(true);
        }
        SchedulerWrapper.run$default(wrapper, false, 1, null);
        List blockCandidates = (List)completableFuture.get(100L, TimeUnit.MILLISECONDS);
        if (blockCandidates.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull(blockCandidates);
        Collections.shuffle(blockCandidates);
        CompletableFuture futureCandidate = new CompletableFuture();
        wrapper = new SchedulerWrapper((Entity)target, () -> SummonSubcommand.getSpawnLocation$lambda$1(blockCandidates, blocksNeeded, location, futureCandidate));
        wrapper.setRunDirectlyInBukkit(true);
        if (options.getSender() instanceof Player) {
            wrapper.setRunDirectlyInFolia(true);
        }
        SchedulerWrapper.run$default(wrapper, false, 1, null);
        Location foundLocation = (Location)futureCandidate.get(500L, TimeUnit.MILLISECONDS);
        return foundLocation;
    }

    private final List<Block> getBlockCandidates(int minDistFromPlayer, int maxDistFromPlayer, Player target, Location location) {
        List blockCandidates = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            Block block;
            Location tempLocation;
            int y;
            int useDistance = minDistFromPlayer != maxDistFromPlayer ? ThreadLocalRandom.current().nextInt(minDistFromPlayer, maxDistFromPlayer) : maxDistFromPlayer;
            Location startingLocation = this.getLocationNearPlayer(target, location, useDistance);
            Intrinsics.checkNotNullExpressionValue(startingLocation.clone(), "clone(...)");
            boolean foundBlock = false;
            int maxYVariance = (int)Math.max((double)(maxDistFromPlayer - useDistance), 10.0);
            for (y = 0; y < maxYVariance; ++y) {
                Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, Math.min((double)y, 1.0), 0.0).getBlock(), "getBlock(...)");
                if (!block.getType().isSolid()) continue;
                blockCandidates.add(block);
                foundBlock = true;
                break;
            }
            if (!foundBlock) {
                Location location2 = startingLocation.clone();
                Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
                tempLocation = location2;
                y = 1;
                if (y <= maxYVariance) {
                    while (true) {
                        Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, -1.0, 0.0).getBlock(), "getBlock(...)");
                        if (block.getType().isSolid()) {
                            blockCandidates.add(block);
                            break;
                        }
                        if (y == maxYVariance) break;
                        ++y;
                    }
                }
            }
            if (blockCandidates.size() >= 10) break;
        }
        return blockCandidates;
    }

    private final Location checkBlockCandidates(List<Block> blockCandidates, int blocksNeeded, World world) {
        for (Block block : blockCandidates) {
            boolean notGoodSpot = false;
            int n = blocksNeeded + 1;
            for (int i = 1; i < n; ++i) {
                Block temp;
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(block.getX(), block.getY() + i, block.getZ()), "getBlockAt(...)");
                if (temp.isPassable()) continue;
                notGoodSpot = true;
                break;
            }
            if (notGoodSpot) continue;
            return block.getLocation().add(0.5, (double)(blocksNeeded - 1), 0.5);
        }
        return null;
    }

    private final Location getLocationNearPlayer(Player player, Location location, int useDistFromPlayer) {
        int newX = location.getBlockX();
        int newZ = location.getBlockZ();
        double rotation = (player.getLocation().getYaw() - (float)180) % (float)360;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        double d = rotation;
        if (RangesKt.rangeUntil(0.0, 22.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newZ -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(22.5, 67.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(67.5, 112.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(112.5, 157.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(157.5, 202.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(202.5, 247.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(247.5, 292.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(292.5, 337.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else {
            newZ -= useDistFromPlayer;
        }
        return new Location(location.getWorld(), (double)newX, (double)location.getBlockY(), (double)newZ);
    }

    private final Location getRelativeLocation(CommandSender sender, String xStr, String yStr, String zStr, World world) {
        Double d = this.processRelativeCoords(sender, xStr, CoordType.X);
        if (d == null) {
            return null;
        }
        double x = d;
        Double d2 = this.processRelativeCoords(sender, yStr, CoordType.Y);
        if (d2 == null) {
            return null;
        }
        double y = d2;
        Double d3 = this.processRelativeCoords(sender, zStr, CoordType.Z);
        if (d3 == null) {
            return null;
        }
        double z = d3;
        return new Location(world, x, y, z);
    }

    private final Double processRelativeCoords(CommandSender sender, String input, CoordType coordType) {
        double d;
        block18: {
            block17: {
                if (((CharSequence)input).length() == 0) {
                    return null;
                }
                if (input.charAt(0) != '~') {
                    Double d2;
                    try {
                        d2 = Double.parseDouble(input);
                    }
                    catch (NumberFormatException numberFormatException) {
                        d2 = null;
                    }
                    return d2;
                }
                if (!(sender instanceof Player)) break block17;
                switch (WhenMappings.$EnumSwitchMapping$1[coordType.ordinal()]) {
                    case 1: {
                        d = ((Player)sender).getLocation().getZ();
                        break block18;
                    }
                    case 2: {
                        d = ((Player)sender).getLocation().getY();
                        break block18;
                    }
                    case 3: {
                        d = ((Player)sender).getLocation().getZ();
                        break block18;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[coordType.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.command.BlockCommandSender");
                    d = ((BlockCommandSender)sender).getBlock().getX();
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.command.BlockCommandSender");
                    d = ((BlockCommandSender)sender).getBlock().getY();
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.command.BlockCommandSender");
                    d = ((BlockCommandSender)sender).getBlock().getZ();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        double result = d;
        if (input.length() > 1) {
            double addition = 0.0;
            try {
                String string = input.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                addition = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            result += addition;
        }
        return result;
    }

    private final Location addVarianceToLocation(Location oldLocation) {
        double min = 0.5;
        double max = 2.5;
        Random random1 = new Random();
        Random random2 = new Random();
        int n = 20;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            double x = oldLocation.getX() + min + (max - min) * random1.nextDouble();
            double z = oldLocation.getZ() + min + (max - min) * random2.nextDouble();
            Location newLocation = new Location(oldLocation.getWorld(), x, oldLocation.getY(), z);
            if (!newLocation.getBlock().isPassable() || !newLocation.add(0.0, 1.0, 0.0).getBlock().isPassable()) continue;
            return newLocation;
        }
        return oldLocation;
    }

    private final CompletableFuture<Suggestions> getEntityNames(SuggestionsBuilder builder) {
        for (EntityType entityType : EntriesMappings.entries$0) {
            String string = entityType.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            builder.suggest(string);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$1(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$2(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getEntityNames(builder);
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$4(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$5(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("here").suggest("at-player").suggest("at-location").buildFuture();
    }

    private static final int buildCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$7(CommandContext ctx, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(ctx);
        Intrinsics.checkNotNull(builder);
        return INSTANCE.buildTabSuggestions((CommandContext<CommandSourceStack>)ctx, builder);
    }

    private static final int buildCommand$lambda$8(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final void summonMobs$lambda$0(CommandSender $sender, SummonMobOptions $options, Ref.ObjectRef $location, CompletableFuture $future) {
        INSTANCE.spawnMobs($sender, $options, (Location)$location.element);
        $future.complete(true);
    }

    private static final void getSpawnLocation$lambda$0(int $minDistFromPlayer, Ref.ObjectRef $maxDistFromPlayer, Player $target, Location $location, CompletableFuture $completableFuture) {
        List<Block> blockCandidates = INSTANCE.getBlockCandidates($minDistFromPlayer, ((Number)$maxDistFromPlayer.element).intValue(), $target, $location);
        $completableFuture.complete(blockCandidates);
    }

    private static final void getSpawnLocation$lambda$1(List $blockCandidates, int $blocksNeeded, Location $location, CompletableFuture $futureCandidate) {
        Intrinsics.checkNotNull($blockCandidates);
        World world = $location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Location foundLocation = INSTANCE.checkBlockCandidates($blockCandidates, $blocksNeeded, world);
        $futureCandidate.complete(foundLocation);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$CoordType;", "", "<init>", "(Ljava/lang/String;I)V", "X", "Y", "Z", "levelledmobs-plugin"})
    private static final class CoordType
    extends Enum<CoordType> {
        public static final /* enum */ CoordType X = new CoordType();
        public static final /* enum */ CoordType Y = new CoordType();
        public static final /* enum */ CoordType Z = new CoordType();
        private static final /* synthetic */ CoordType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CoordType[] values() {
            return (CoordType[])$VALUES.clone();
        }

        public static CoordType valueOf(String value) {
            return Enum.valueOf(CoordType.class, value);
        }

        @NotNull
        public static EnumEntries<CoordType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = coordTypeArray = new CoordType[]{CoordType.X, CoordType.Y, CoordType.Z};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$SummonType;", "", "<init>", "(Ljava/lang/String;I)V", "HERE", "AT_PLAYER", "AT_LOCATION", "levelledmobs-plugin"})
    public static final class SummonType
    extends Enum<SummonType> {
        public static final /* enum */ SummonType HERE = new SummonType();
        public static final /* enum */ SummonType AT_PLAYER = new SummonType();
        public static final /* enum */ SummonType AT_LOCATION = new SummonType();
        private static final /* synthetic */ SummonType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SummonType[] values() {
            return (SummonType[])$VALUES.clone();
        }

        public static SummonType valueOf(String value) {
            return Enum.valueOf(SummonType.class, value);
        }

        @NotNull
        public static EnumEntries<SummonType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = summonTypeArray = new SummonType[]{SummonType.HERE, SummonType.AT_PLAYER, SummonType.AT_LOCATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SummonType.values().length];
            try {
                nArray[SummonType.HERE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_LOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_PLAYER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CoordType.values().length];
            try {
                nArray[CoordType.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoordType.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoordType.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

