/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerBaseClass;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerEggCommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "processResults", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "allEggOptions", "", "generateEgg", "info", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass$CustomSpawnerInfo;", "levelledmobs-plugin"})
public final class SpawnerEggCommand
extends SpawnerBaseClass {
    @NotNull
    public static final SpawnerEggCommand INSTANCE = new SpawnerEggCommand();
    @NotNull
    private static final String description = "Various commands for creating spawner egg.";
    @NotNull
    private static final List<String> allEggOptions;

    private SpawnerEggCommand() {
        super("levelledmobs.command.spawner-egg");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        String commandName = "spawner-egg";
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin(commandName).executes(SpawnerEggCommand::buildCommand$lambda$0)).build();
            Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
            return literalCommandNode;
        }
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin(commandName).executes(SpawnerEggCommand::buildCommand$lambda$1)).then(this.createGreedyStringArgument$levelledmobs_plugin("values").suggests(SpawnerEggCommand::buildCommand$lambda$2).executes(SpawnerEggCommand::buildCommand$lambda$3))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void processResults(CommandContext<CommandSourceStack> ctx) {
        int i;
        this.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        String string = ctx.getInput();
        Intrinsics.checkNotNullExpressionValue(string, "getInput(...)");
        List<String> args = this.splitStringWithQuotes(string, false);
        boolean hasGivePlayer = false;
        int n = args.size();
        for (int i2 = 2; i2 < n; ++i2) {
            if (!StringsKt.equals("/giveplayer", args.get(i2), true)) continue;
            hasGivePlayer = true;
            break;
        }
        if (!hasGivePlayer && !(this.getCommandSender() instanceof Player)) {
            this.showMessage("command.levelledmobs.spawn_egg.no-player");
            return;
        }
        this.setHadInvalidArg(false);
        SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo(true);
        if (this.getCommandSender() instanceof Player) {
            CommandSender commandSender = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender);
            info.setPlayer((Player)commandSender);
        }
        int n2 = args.size();
        for (i = 0; i < n2; ++i) {
            String arg = args.get(i);
            if (!StringsKt.equals("/nolore", arg, true)) continue;
            info.setNoLore(true);
            break;
        }
        n2 = allEggOptions.size() - 1;
        block24: for (i = 0; i < n2; ++i) {
            boolean mustBeANumber = i > 4;
            String command = allEggOptions.get(i);
            String foundValue = this.getArgValue(command, args, mustBeANumber);
            if (this.getHadInvalidArg()) {
                return;
            }
            CharSequence charSequence = foundValue;
            if (charSequence == null || charSequence.length() == 0) continue;
            switch (command) {
                case "/name": {
                    info.setCustomName(foundValue);
                    continue block24;
                }
                case "/customdropid": {
                    info.setCustomDropId(foundValue);
                    continue block24;
                }
                case "/lore": {
                    info.setCustomLore(foundValue);
                    continue block24;
                }
                case "/entity": {
                    try {
                        String string2 = foundValue.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                        info.setSpawnType(EntityType.valueOf((String)string2));
                        continue block24;
                    }
                    catch (Exception exception) {
                        CommandSender commandSender = this.getCommandSender();
                        Intrinsics.checkNotNull(commandSender);
                        commandSender.sendMessage("Invalid spawn type: " + foundValue);
                        return;
                    }
                }
                case "/minlevel": {
                    info.setMinLevel(Integer.parseInt(foundValue));
                    continue block24;
                }
                case "/maxlevel": {
                    info.setMaxLevel(Integer.parseInt(foundValue));
                    continue block24;
                }
                case "/giveplayer": {
                    if (((CharSequence)foundValue).length() == 0) {
                        this.showMessage("command.levelledmobs.spawn_egg.no-player-specified");
                        return;
                    }
                    try {
                        info.setPlayer(Bukkit.getPlayer((String)foundValue));
                    }
                    catch (Exception exception) {
                        this.showMessage("common.player-offline", "%player%", foundValue);
                        return;
                    }
                    if (info.getPlayer() != null) continue block24;
                    this.showMessage("common.player-offline", "%player%", foundValue);
                    return;
                }
            }
        }
        if (info.getMinLevel() == -1 || info.getMaxLevel() == -1 || info.getSpawnType() == EntityType.UNKNOWN) {
            this.showMessage("command.levelledmobs.spawn_egg.no-level-specified");
            return;
        }
        if (info.getPlayer() == null) {
            this.showMessage("command.levelledmobs.spawn_egg.no-player");
            return;
        }
        this.generateEgg(info);
    }

    private final void generateEgg(SpawnerBaseClass.CustomSpawnerInfo info) {
        String materialName;
        Material material;
        if (info.getCustomName() != null) {
            info.setCustomName(MessageUtils.INSTANCE.colorizeAll(info.getCustomName()));
        }
        if ((material = Material.getMaterial((String)(materialName = info.getSpawnType().name() + "_SPAWN_EGG"))) == null) {
            CommandSender commandSender = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender);
            commandSender.sendMessage("Invalid material: " + materialName);
            return;
        }
        ItemStack item = new ItemStack(material);
        this.setMetadata(item, info, "LM Spawn Egg");
        this.giveItemToPlayer$levelledmobs_plugin(item, info);
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        INSTANCE.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        INSTANCE.showMessage("command.levelledmobs.spawn_egg.no-paper");
        return 1;
    }

    private static final int buildCommand$lambda$1(CommandContext ctx) {
        INSTANCE.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        INSTANCE.showMessage("command.levelledmobs.spawn_egg.usage");
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$2(CommandContext ctx, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(ctx);
        Intrinsics.checkNotNull(builder);
        return INSTANCE.buildTabSuggestions(allEggOptions, (CommandContext<CommandSourceStack>)ctx, builder);
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    static {
        String[] stringArray = new String[]{"/name", "/customdropid", "/entity", "/giveplayer", "/lore", "/minlevel", "/maxlevel", "/nolore"};
        allEggOptions = CollectionsKt.mutableListOf(stringArray);
    }
}

