/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.annotations.DoNotMerge;
import io.github.arcaneplugins.levelledmobs.annotations.DoNotShow;
import io.github.arcaneplugins.levelledmobs.annotations.RuleFieldInfo;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.CommandBase;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.LmMobResult;
import io.github.arcaneplugins.levelledmobs.enums.RuleType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.io.CloseableKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.EffectiveInfo;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0016\u0010\u0018\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010\u001f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ \u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\"\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00069"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/CommandBase;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "showAllRules", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "getAllRuleNames", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "showTempDisabled", "sender", "Lorg/bukkit/command/CommandSender;", "forceRelevel", "resetRules", "difficulty", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand$ResetDifficulty;", "showHyperlink", "message", "url", "showRule", "showEffectiveRules", "getLmMob", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/LmMobResult;", "getMobBeingLookedAt", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "player", "Lorg/bukkit/entity/Player;", "findNearbyEntities", "", "createParticleEffect", "location", "Lorg/bukkit/Location;", "spawnParticles", "world", "Lorg/bukkit/World;", "createParticlesWithSpell", "yPos", "", "showEffectiveValues", "lmEntity", "showOnConsole", "mobHash", "getPlayerLevellingFormatting", "opts", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/PlayerLevellingStrategy;", "ResetDifficulty", "levelledmobs-plugin"})
public final class RulesSubcommand
extends CommandBase {
    @NotNull
    public static final RulesSubcommand INSTANCE = new RulesSubcommand();
    @NotNull
    private static final String description = "Used to view various rules.";

    private RulesSubcommand() {
        super("levelledmobs.command.rules");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("rules").executes(RulesSubcommand::buildCommand$lambda$0)).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("show-all").then(this.createStringArgument$levelledmobs_plugin("console").suggests(RulesSubcommand::buildCommand$lambda$1).executes(RulesSubcommand::buildCommand$lambda$2))).executes(RulesSubcommand::buildCommand$lambda$3))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("show-rule").then(this.createStringArgument$levelledmobs_plugin("rulename").suggests(RulesSubcommand::buildCommand$lambda$4).executes(RulesSubcommand::buildCommand$lambda$5))).executes(RulesSubcommand::buildCommand$lambda$6))).then((CommandNode)this.createTargetWithConsoleOption("show-effective", RulesSubcommand::buildCommand$lambda$7))).then(this.createLiteralCommand$levelledmobs_plugin("help-discord").executes(RulesSubcommand::buildCommand$lambda$8))).then(this.createLiteralCommand$levelledmobs_plugin("help-wiki").executes(RulesSubcommand::buildCommand$lambda$9))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("reset").then(((RequiredArgumentBuilder)this.createStringArgument$levelledmobs_plugin("difficulty").suggests(RulesSubcommand::buildCommand$lambda$10).executes(RulesSubcommand::buildCommand$lambda$11)).then(this.createStringArgument$levelledmobs_plugin("confirm").suggests(RulesSubcommand::buildCommand$lambda$12).executes(RulesSubcommand::buildCommand$lambda$13)))).executes(RulesSubcommand::buildCommand$lambda$14))).then(this.createLiteralCommand$levelledmobs_plugin("force-all").executes(RulesSubcommand::buildCommand$lambda$15))).then(this.createLiteralCommand$levelledmobs_plugin("show-temp-disabled").executes(RulesSubcommand::buildCommand$lambda$16))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void showAllRules(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(sender);
        if (sender instanceof Player) {
            this.showMessage("command.levelledmobs.rules.console-rules");
        }
        boolean showOnConsole = sender instanceof ConsoleCommandSender || this.getStringArgumentAsBool$levelledmobs_plugin(ctx, "console");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        StringBuilder sb = new StringBuilder();
        for (RuleInfo rpi : main.getRulesParsingManager().getRulePresets().values()) {
            String[] stringArray = new String[]{"ruleIsEnabled"};
            sb.append("\n&r--------------------------------- Preset rule ----------------------------------").append(rpi.formatRulesVisually(false, CollectionsKt.mutableListOf(stringArray)));
        }
        StringBuilder stringBuilder = sb.append("\n&r--------------------------------- Default values -------------------------------");
        RuleInfo ruleInfo = main.getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        stringBuilder.append(ruleInfo.formatRulesVisually());
        for (RuleInfo rpi : main.getRulesParsingManager().getCustomRules()) {
            sb.append("\n&r--------------------------------- Custom rule ----------------------------------").append(rpi.formatRulesVisually());
        }
        sb.append("\n&r--------------------------------------------------------------------------------------");
        if (showOnConsole) {
            Log.INSTANCE.inf(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        } else {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final CompletableFuture<Suggestions> getAllRuleNames(SuggestionsBuilder builder) {
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            builder.suggest(StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null));
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final void showTempDisabled(CommandSender sender) {
        LevelledMobs.Companion.getInstance().getRulesManager().showTempDisabledRules(sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forceRelevel() {
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            CommandSender commandSender = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender);
            commandSender.sendMessage("Sorry this command doesn't work in Folia");
            return;
        }
        int worldCount = 0;
        int entityCount = 0;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        CommandSender commandSender = this.getCommandSender();
        Intrinsics.checkNotNull(commandSender);
        main.reloadLM(commandSender);
        boolean isUsingPlayerLevelling = main.getRulesManager().isPlayerLevellingEnabled();
        for (World world : Bukkit.getWorlds()) {
            ++worldCount;
            for (Entity entity : world.getEntities()) {
                PersistentDataContainer persistentDataContainer;
                if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
                boolean doContinue = false;
                Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getPersistentDataContainer(), "getPersistentDataContainer(...)");
                synchronized (persistentDataContainer) {
                    boolean bl = false;
                    if (((LivingEntity)entity).getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER)) {
                        doContinue = true;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (doContinue) continue;
                ++entityCount;
                LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
                lmEntity.setReEvaluateLevel(true);
                lmEntity.setRulesForceAll(true);
                lmEntity.setWasPreviouslyLevelled(lmEntity.isLevelled());
                if (isUsingPlayerLevelling) {
                    EntitySpawnListener.Companion.updateMobForPlayerLevelling(lmEntity);
                }
                main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                lmEntity.free();
            }
        }
        String[] stringArray = new String[]{"%entitycount%", "%worldcount%"};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{String.valueOf(entityCount), String.valueOf(worldCount)};
        this.showMessage("command.levelledmobs.rules.rules-reprocessed", list, CollectionsKt.mutableListOf(stringArray));
    }

    private final void resetRules(CommandContext<CommandSourceStack> ctx) {
        ResetDifficulty difficulty;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(sender);
        String difficultyStr = this.getStringArgument$levelledmobs_plugin(ctx, "difficulty");
        boolean confirm = this.getStringArgumentAsBool$levelledmobs_plugin(ctx, "confirm");
        if (((CharSequence)difficultyStr).length() == 0) {
            this.showMessage("command.levelledmobs.rules.reset");
            return;
        }
        String string = difficultyStr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "vanilla": {
                ResetDifficulty resetDifficulty = ResetDifficulty.VANILLA;
                break;
            }
            case "bronze": {
                ResetDifficulty resetDifficulty = ResetDifficulty.BRONZE;
                break;
            }
            case "silver": {
                ResetDifficulty resetDifficulty = ResetDifficulty.SILVER;
                break;
            }
            case "gold": {
                ResetDifficulty resetDifficulty = ResetDifficulty.GOLD;
                break;
            }
            case "platinum": {
                ResetDifficulty resetDifficulty = ResetDifficulty.PLATINUM;
                break;
            }
            default: {
                ResetDifficulty resetDifficulty = difficulty = ResetDifficulty.UNSPECIFIED;
            }
        }
        if (difficulty == ResetDifficulty.UNSPECIFIED) {
            this.showMessage("command.levelledmobs.rules.invalid-difficulty", "%difficulty%", difficultyStr);
            return;
        }
        if (!confirm) {
            this.showMessage("command.levelledmobs.rules.reset-syntax", "%difficulty%", difficultyStr);
            return;
        }
        this.resetRules(sender, difficulty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetRules(@Nullable CommandSender sender, @NotNull ResetDifficulty difficulty) {
        Intrinsics.checkNotNullParameter((Object)difficulty, "difficulty");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        String prefix = main.getConfigUtils().getPrefix();
        if (sender != null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.resetting", "%difficulty%", difficulty.toString());
        }
        String filename = "rules.yml";
        String[] stringArray = new String[]{"    - challenge-silver", ""};
        String[] replaceWhat = stringArray;
        Object object = new String[]{"    #- challenge-silver", ""};
        String[] replaceWith = object;
        switch (WhenMappings.$EnumSwitchMapping$0[difficulty.ordinal()]) {
            case 1: {
                replaceWhat[1] = "#- challenge-vanilla";
                replaceWith[1] = "- challenge-vanilla";
                break;
            }
            case 2: {
                replaceWhat[1] = "#- challenge-bronze";
                replaceWith[1] = "- challenge-bronze";
                break;
            }
            case 3: {
                replaceWhat[1] = "#- challenge-gold";
                replaceWith[1] = "- challenge-gold";
                break;
            }
            case 4: {
                replaceWhat[1] = "#- challenge-platinum";
                replaceWith[1] = "- challenge-platinum";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        try {
            object = main.getResource(filename);
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl = false;
                if (stream == null) {
                    Log.INSTANCE.sev(prefix + " Input stream was null");
                    return;
                }
                byte[] byArray = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                Charset charset2 = charset;
                String rulesText = new String(byArray2, charset2);
                if (difficulty != ResetDifficulty.SILVER) {
                    rulesText = StringsKt.replace$default(StringsKt.replace$default(rulesText, replaceWhat[0], replaceWith[0], false, 4, null), replaceWhat[1], replaceWith[1], false, 4, null);
                }
                File rulesFile = new File(main.getDataFolder(), filename);
                File rulesBackupFile = new File(main.getDataFolder(), "rules.yml.backup");
                for (int i = 0; i < 10 && rulesBackupFile.exists(); ++i) {
                    rulesBackupFile = new File(main.getDataFolder(), "rules.yml.backup" + i);
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(rulesFile.toPath(), rulesBackupFile.toPath(), copyOptionArray);
                Path path = Files.writeString(rulesFile.toPath(), (CharSequence)rulesText, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        if (sender != null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.reset-complete");
            main.reloadLM(sender);
        }
    }

    private final void showHyperlink(CommandSender sender, String message, String url) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(url);
            return;
        }
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            PaperUtils.INSTANCE.sendHyperlink(sender, message, url);
        } else {
            SpigotUtils.INSTANCE.sendHyperlink(sender, message, url);
        }
    }

    private final void showRule(CommandContext<CommandSourceStack> ctx) {
        this.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        String ruleName = this.getStringArgument$levelledmobs_plugin(ctx, "rulename");
        CommandSender commandSender = this.getCommandSender();
        Intrinsics.checkNotNull(commandSender);
        boolean showOnConsole = commandSender instanceof ConsoleCommandSender || this.getStringArgumentAsBool$levelledmobs_plugin(ctx, "console");
        if (((CharSequence)ruleName).length() == 0) {
            this.showMessage("command.levelledmobs.rules.rule-name-missing");
            return;
        }
        RuleInfo rule = null;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            String checkName = StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null);
            if (!StringsKt.equals(ruleName, checkName, true)) continue;
            rule = ruleInfo;
            break;
        }
        if (rule == null) {
            this.showMessage("command.levelledmobs.rules.rule-name-invalid");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.showing-rules", "%rulename%", rule.getRuleName$levelledmobs_plugin()));
        String[] stringArray = new String[]{"id"};
        sb.append(rule.formatRulesVisually(false, CollectionsKt.mutableListOf(stringArray)));
        if (showOnConsole) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            CommandSender commandSender2 = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender2);
            commandSender2.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final void showEffectiveRules(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        LmMobResult lmMobResult = this.getLmMob(ctx);
        if (lmMobResult == null) {
            return;
        }
        LmMobResult lmMobResult2 = lmMobResult;
        LivingEntityWrapper lmEntity = lmMobResult2.getLmEntity();
        String entityName = lmEntity.getTypeName();
        if (ExternalCompatibilityManager.Companion.getHasMythicMobsInstalled() && ExternalCompatibilityManager.Companion.isMythicMob(lmEntity)) {
            entityName = ExternalCompatibilityManager.Companion.getMythicMobInternalName(lmEntity);
        }
        String mobLevel = lmEntity.isLevelled() ? String.valueOf(lmEntity.getGetMobLevel()) : "0";
        String[] stringArray = new String[]{"%mobname%", "%entitytype%", "%location%", "%world%", "%level%"};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{entityName, lmEntity.getNameIfBaby(), lmEntity.getLocationStr(), lmEntity.getWorldName(), mobLevel};
        List<String> messages = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.effective-rules", list, CollectionsKt.mutableListOf(stringArray));
        StringBuilder sb = new StringBuilder();
        sb.append(StringsKt.replace$default(CollectionsKt.joinToString$default(messages, "\n", null, null, 0, null, null, 62, null), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "", false, 4, null));
        if (lmMobResult2.getShowOnConsole()) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            sender.sendMessage(sb.toString());
        }
        if (!lmMobResult2.getShowOnConsole()) {
            sb.setLength(0);
        }
        Ref.ObjectRef mobHash = new Ref.ObjectRef();
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            mobHash.element = lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING);
        }
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> RulesSubcommand.showEffectiveRules$lambda$0(lmEntity, lmMobResult2, mobHash, sender));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(25L);
    }

    @Nullable
    public final LmMobResult getLmMob(@NotNull CommandContext<CommandSourceStack> ctx) {
        Player player;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            sender.sendMessage("Must be run by a player");
            return null;
        }
        boolean showOnConsole = false;
        boolean findNearbyEntities = true;
        String[] stringArray = new String[]{"option1", "option2"};
        for (String option : this.getOptionalResults$levelledmobs_plugin(ctx, CollectionsKt.mutableListOf(stringArray))) {
            if (StringsKt.equals("console", option, true)) {
                showOnConsole = true;
                continue;
            }
            if (!StringsKt.equals("looking-at", option, true)) continue;
            findNearbyEntities = false;
        }
        LivingEntityWrapper result = this.getMobBeingLookedAt(player, findNearbyEntities, (CommandSender)player);
        return result == null ? null : new LmMobResult(result, showOnConsole);
    }

    @Nullable
    public final LivingEntityWrapper getMobBeingLookedAt(@NotNull Player player, boolean findNearbyEntities, @NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(sender, "sender");
        LivingEntity livingEntity = null;
        LivingEntityWrapper lmEntity = null;
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getEyeLocation(...)");
        Location eye = location;
        SortedMap entities = new TreeMap();
        for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
            Vector toEntity;
            if (!(entity instanceof LivingEntity)) continue;
            if (findNearbyEntities) {
                double distance = ((LivingEntity)entity).getLocation().distanceSquared(player.getLocation());
                ((Map)entities).put(distance, entity);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getEyeLocation().toVector().subtract(eye.toVector()), "subtract(...)");
            double dot = toEntity.normalize().dot(eye.getDirection());
            if (!(dot >= 0.975)) continue;
            livingEntity = (LivingEntity)entity;
            break;
        }
        if (!findNearbyEntities && livingEntity == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.no-entities-visible");
        } else if (findNearbyEntities && entities.isEmpty()) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.no-entities-near");
        } else {
            if (findNearbyEntities) {
                livingEntity = (LivingEntity)entities.get(entities.firstKey());
            }
            LivingEntity livingEntity2 = livingEntity;
            Intrinsics.checkNotNull(livingEntity2);
            Location location2 = livingEntity2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            this.createParticleEffect(location2);
            lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        }
        return lmEntity;
    }

    private final void createParticleEffect(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> RulesSubcommand.createParticleEffect$lambda$0(location, world2));
        scheduler.setLocationForRegionScheduler(location);
        scheduler.runAsync();
    }

    private final void spawnParticles(Location location, World world) {
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        boolean useSpell = ver.getMinecraftVersion() >= 1.21 && ver.getRevision() >= 9 || ver.getMajorVersion() >= 22;
        try {
            for (int i = 1; i < 41; ++i) {
                SchedulerWrapper scheduler = new SchedulerWrapper(() -> RulesSubcommand.spawnParticles$lambda$0(i, useSpell, location, world));
                SchedulerWrapper.run$default(scheduler, false, 1, null);
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException i) {
        }
        catch (IllegalArgumentException e) {
            Log.INSTANCE.war("Unable to create particle effect, " + e.getMessage());
        }
    }

    private final void createParticlesWithSpell(Location location, double yPos) {
        Particle particle = Particle.EFFECT;
        Particle.Spell spell = new Particle.Spell(Color.PURPLE, 50.0f);
        location.getWorld().spawnParticle(particle, location, 20, 0.0, yPos, 0.0, 0.1, (Object)spell);
    }

    private final void showEffectiveValues(LivingEntityWrapper lmEntity, boolean showOnConsole, String mobHash) {
        Map values = new LinkedHashMap();
        List<RuleInfo> effectiveRules = lmEntity.getApplicableRules();
        StringBuilder sb = new StringBuilder();
        Map effectiveInfosAlreadyProcessed = new LinkedHashMap();
        if (effectiveRules.isEmpty()) {
            if (showOnConsole) {
                Log.INSTANCE.inf(sb + "\n" + StringsKt.replace$default(MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.no-effective-rules"), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "", false, 4, null));
            } else {
                this.showMessage("command.levelledmobs.rules.no-effective-rules");
            }
            return;
        }
        try {
            int n = ((Collection)effectiveRules).size();
            for (int i = 0; i < n; ++i) {
                Field[] fieldArray;
                RuleInfo pi = effectiveRules.get(i);
                Intrinsics.checkNotNullExpressionValue(pi.getClass().getDeclaredFields(), "getDeclaredFields(...)");
                for (Field f : fieldArray) {
                    Object value;
                    f.trySetAccessible();
                    if (f.isAnnotationPresent(DoNotMerge.class) || f.isAnnotationPresent(DoNotShow.class) || f.get(pi) == null || ((CharSequence)value.toString()).length() == 0) continue;
                    String ruleName = f.getName();
                    Object showValue = null;
                    RuleType ruleInfoType = RuleType.MISC;
                    RuleFieldInfo ruleTypeInfo = f.getAnnotation(RuleFieldInfo.class);
                    if (ruleTypeInfo != null) {
                        ruleInfoType = ruleTypeInfo.ruleType();
                        ruleName = ruleTypeInfo.value();
                    }
                    if (value instanceof Map && ((Map)value).isEmpty() || value instanceof List && ((List)value).isEmpty()) continue;
                    String string = ruleName;
                    Intrinsics.checkNotNull(string);
                    RuleInfo.RuleSortingInfo ruleInfo = new RuleInfo.RuleSortingInfo(ruleInfoType, string);
                    if (value instanceof PlayerLevellingStrategy) {
                        showValue = this.getPlayerLevellingFormatting((PlayerLevellingStrategy)value, lmEntity);
                    } else if (value instanceof EffectiveInfo) {
                        if (effectiveInfosAlreadyProcessed.containsKey(ruleName)) {
                            pi.getRuleSourceNames().put(f.getName(), pi.getRuleName$levelledmobs_plugin());
                            continue;
                        }
                        showValue = ((EffectiveInfo)value).getEffectiveInfo(lmEntity);
                        effectiveInfosAlreadyProcessed.put(pi.getRuleName$levelledmobs_plugin(), ruleInfo);
                    }
                    if (value instanceof Enum && (Intrinsics.areEqual("NONE", ((Enum)value).toString()) || Intrinsics.areEqual("NOT_SPECIFIED", ((Enum)value).toString()))) continue;
                    if (showValue == null) {
                        showValue = "&b" + value + "&r";
                    }
                    showValue = (String)showValue + ", &1source: " + (pi.getRuleSourceNames().containsKey(f.getName()) ? pi.getRuleSourceNames().get(f.getName()) : pi.getRuleName$levelledmobs_plugin());
                    showValue = (String)showValue + "&r";
                    values.put(ruleInfo, showValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mobHash != null) {
            RuleInfo.RuleSortingInfo mobHashInfo = new RuleInfo.RuleSortingInfo(RuleType.MISC, "mob hash");
            values.put(mobHashInfo, mobHash);
        }
        if (!((Collection)lmEntity.getMobExternalTypes()).isEmpty()) {
            RuleInfo.RuleSortingInfo externalMobTypeMisc = new RuleInfo.RuleSortingInfo(RuleType.MISC, "external plugin type");
            values.put(externalMobTypeMisc, lmEntity.getMobExternalTypes().toString());
        }
        RuleInfo.Companion.formatRule(sb, values);
        if (showOnConsole) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            CommandSender commandSender = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender);
            commandSender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final String getPlayerLevellingFormatting(PlayerLevellingStrategy opts, LivingEntityWrapper lmEntity) {
        UUID uuid;
        Player player;
        StringBuilder sb = new StringBuilder("value: ");
        String userId = null;
        String plValue = null;
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId())) {
            userId = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
        }
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingValue())) {
            plValue = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingValue(), PersistentDataType.STRING);
        }
        if (plValue != null) {
            sb.append(plValue);
        }
        boolean foundName = false;
        if (userId != null && (player = Bukkit.getPlayer((UUID)(uuid = UUID.fromString(userId)))) != null) {
            foundName = true;
            if (plValue != null) {
                sb.append(", ");
            }
            sb.append("plr: ").append(player.getName());
        }
        if (plValue != null || foundName) {
            sb.append(", ");
        }
        sb.append(opts);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        INSTANCE.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        INSTANCE.showMessage("command.levelledmobs.rules.incomplete-command");
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$1(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("console").buildFuture();
    }

    private static final int buildCommand$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showAllRules((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showAllRules((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getAllRuleNames(builder);
    }

    private static final int buildCommand$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showRule((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showRule((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final Unit buildCommand$lambda$7(CommandContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        INSTANCE.showEffectiveRules((CommandContext<CommandSourceStack>)ctx);
        return Unit.INSTANCE;
    }

    private static final int buildCommand$lambda$8(CommandContext ctx) {
        String message = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.discord-invite");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showHyperlink(commandSender, message, "https://discord.gg/arcaneplugins-752310043214479462");
        return 1;
    }

    private static final int buildCommand$lambda$9(CommandContext ctx) {
        String message = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.wiki-link");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showHyperlink(commandSender, message, "https://arcaneplugins.gitbook.io/levelledmobs-the-ultimate-mob-levelling-solution/");
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$10(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("vanilla").suggest("bronze").suggest("silver").suggest("gold").suggest("platinum").buildFuture();
    }

    private static final int buildCommand$lambda$11(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.resetRules((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$12(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("confirm").buildFuture();
    }

    private static final int buildCommand$lambda$13(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.resetRules((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$14(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.resetRules((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$15(CommandContext ctx) {
        INSTANCE.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        INSTANCE.forceRelevel();
        return 1;
    }

    private static final int buildCommand$lambda$16(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showTempDisabled(commandSender);
        return 1;
    }

    private static final void showEffectiveRules$lambda$0(LivingEntityWrapper $lmEntity, LmMobResult $lmMobResult, Ref.ObjectRef $mobHash, CommandSender $sender) {
        INSTANCE.showEffectiveValues($lmEntity, $lmMobResult.getShowOnConsole(), (String)$mobHash.element);
        $lmEntity.free();
        if ($lmMobResult.getShowOnConsole()) {
            $sender.sendMessage("Effective rules have been printed in the console");
        }
    }

    private static final void createParticleEffect$lambda$0(Location $location, World $world) {
        INSTANCE.spawnParticles($location, $world);
    }

    private static final void spawnParticles$lambda$0(int $i, boolean $useSpell, Location $location, World $world) {
        double yPos = (double)$i * 0.05;
        if ($useSpell) {
            INSTANCE.createParticlesWithSpell($location, yPos);
        } else {
            $world.spawnParticle(Particle.EFFECT, $location, 20, 0.0, 0.0, 0.0, 0.1);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand$ResetDifficulty;", "", "<init>", "(Ljava/lang/String;I)V", "VANILLA", "BRONZE", "SILVER", "GOLD", "PLATINUM", "UNSPECIFIED", "levelledmobs-plugin"})
    public static final class ResetDifficulty
    extends Enum<ResetDifficulty> {
        public static final /* enum */ ResetDifficulty VANILLA = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty BRONZE = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty SILVER = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty GOLD = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty PLATINUM = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty UNSPECIFIED = new ResetDifficulty();
        private static final /* synthetic */ ResetDifficulty[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResetDifficulty[] values() {
            return (ResetDifficulty[])$VALUES.clone();
        }

        public static ResetDifficulty valueOf(String value) {
            return Enum.valueOf(ResetDifficulty.class, value);
        }

        @NotNull
        public static EnumEntries<ResetDifficulty> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resetDifficultyArray = new ResetDifficulty[]{ResetDifficulty.VANILLA, ResetDifficulty.BRONZE, ResetDifficulty.SILVER, ResetDifficulty.GOLD, ResetDifficulty.PLATINUM, ResetDifficulty.UNSPECIFIED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetDifficulty.values().length];
            try {
                nArray[ResetDifficulty.VANILLA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.BRONZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.GOLD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.PLATINUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.SILVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.UNSPECIFIED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

