/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.CommandBase;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.KillSkipConditions;
import io.github.arcaneplugins.levelledmobs.misc.RequestedLevel;
import io.github.arcaneplugins.levelledmobs.util.MiscUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fH\u0002J(\u0010\u0011\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020&H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006*"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/CommandBase;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "processCmd", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "isAll", "", "processKillAll", "sender", "Lorg/bukkit/command/CommandSender;", "opts", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand$Options;", "processKillNear", "buildTabSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "getLevelFromCommand", "Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "args", "", "worlds", "Lorg/bukkit/World;", "useNoDrops", "rl", "skipKillingEntity", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "isMobConverting", "mob", "Options", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nKillSubcommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KillSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1915#2,2:450\n1915#2,2:452\n*S KotlinDebug\n*F\n+ 1 KillSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand\n*L\n278#1:450,2\n283#1:452,2\n*E\n"})
public final class KillSubcommand
extends CommandBase {
    @NotNull
    public static final KillSubcommand INSTANCE = new KillSubcommand();
    @NotNull
    private static final String description = "Various commands for killing LevelledMobs mobs.";

    private KillSubcommand() {
        super("levelledmobs.command.kill");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("kill").executes(KillSubcommand::buildCommand$lambda$0)).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("all").then(this.createGreedyStringArgument$levelledmobs_plugin("all").suggests(KillSubcommand::buildCommand$lambda$1).executes(KillSubcommand::buildCommand$lambda$2))).executes(KillSubcommand::buildCommand$lambda$3))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("near").then(this.createGreedyStringArgument$levelledmobs_plugin("near").suggests(KillSubcommand::buildCommand$lambda$4).executes(KillSubcommand::buildCommand$lambda$5))).executes(KillSubcommand::buildCommand$lambda$6))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void processCmd(CommandContext<CommandSourceStack> ctx, boolean isAll) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(sender);
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            sender.sendMessage("Sorry this command doesn't work in Folia");
            return;
        }
        String values = ctx.getInput();
        if (values == null) {
            if (sender instanceof Player) {
                if (isAll) {
                    World[] worldArray = new World[1];
                    Intrinsics.checkNotNullExpressionValue(((Player)sender).getWorld(), "getWorld(...)");
                    this.processKillAll(CollectionsKt.mutableListOf(worldArray), false, null);
                } else {
                    this.showMessage("command.levelledmobs.kill.near.usage");
                }
            } else {
                this.showMessage(isAll ? "command.levelledmobs.kill.all.usage-console" : "command.levelledmobs.kill.near.usage-console");
            }
            return;
        }
        List<String> args = this.splitStringWithQuotes(values, false);
        boolean useNoDrops = false;
        RequestedLevel rl = this.getLevelFromCommand(sender, args);
        List newArgs = new ArrayList();
        RequestedLevel requestedLevel = rl;
        if (requestedLevel != null ? requestedLevel.getHadInvalidArguments() : false) {
            return;
        }
        int rlFlag = -1;
        int n = args.size();
        for (int i = 3; i < n; ++i) {
            String checkArg = args.get(i);
            if (StringsKt.equals("/nodrops", checkArg, true)) {
                useNoDrops = true;
                continue;
            }
            if (StringsKt.equals("/levels", checkArg, true)) {
                rlFlag = i + 1;
                continue;
            }
            if (i == rlFlag) continue;
            newArgs.add(checkArg);
        }
        Options options = new Options(newArgs, useNoDrops, rl);
        if (isAll) {
            this.processKillAll(sender, options);
        } else {
            this.processKillNear(sender, options);
        }
    }

    private final void processKillAll(CommandSender sender, Options opts) {
        String useArg = "";
        int n = opts.getArgs().size();
        for (int i = 0; i < n; ++i) {
            if (StringsKt.startsWith$default(opts.getArgs().get(i), "/", false, 2, null)) continue;
            useArg = opts.getArgs().get(i);
        }
        if (((CharSequence)useArg).length() == 0) {
            if (sender instanceof Player) {
                World[] i = new World[1];
                Intrinsics.checkNotNullExpressionValue(((Player)sender).getWorld(), "getWorld(...)");
                this.processKillAll(CollectionsKt.mutableListOf(i), opts.getUseNoDrops(), opts.getRequestedLevel());
            } else {
                this.showMessage("command.levelledmobs.kill.all.usage-console");
            }
        } else {
            if (Intrinsics.areEqual(useArg, "*")) {
                List list = Bukkit.getWorlds();
                Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                this.processKillAll(list, opts.getUseNoDrops(), opts.getRequestedLevel());
                return;
            }
            World world = Bukkit.getWorld((String)useArg);
            if (world == null) {
                this.showMessage("command.levelledmobs.kill.all.invalid-world", "%world%", useArg);
                return;
            }
            World[] worldArray = new World[]{world};
            this.processKillAll(CollectionsKt.mutableListOf(worldArray), opts.getUseNoDrops(), opts.getRequestedLevel());
        }
    }

    private final void processKillNear(CommandSender sender, Options opts) {
        int minRadius;
        if (!(sender instanceof BlockCommandSender) && !(sender instanceof Player)) {
            this.showMessage("common.players-only");
            return;
        }
        if (opts.getArgs().isEmpty()) {
            this.showMessage("command.levelledmobs.kill.near.usage");
            return;
        }
        int radius = 0;
        try {
            radius = Integer.parseInt(opts.getArgs().get(0));
        }
        catch (NumberFormatException numberFormatException) {
            this.showMessage("command.levelledmobs.kill.near.invalid-radius", "%radius%", CollectionsKt.first(opts.getArgs()));
            return;
        }
        int maxRadius = 1000;
        if (radius > maxRadius) {
            radius = maxRadius;
            this.showMessage("command.levelledmobs.kill.near.invalid-radius-max", "%maxRadius%", String.valueOf(maxRadius));
        }
        if (radius < (minRadius = 1)) {
            radius = minRadius;
            this.showMessage("command.levelledmobs.kill.near.invalid-radius-min", "%minRadius%", String.valueOf(minRadius));
        }
        int killed = 0;
        int skipped = 0;
        Collection mobsToKill = null;
        if (sender instanceof BlockCommandSender) {
            Block block = ((BlockCommandSender)sender).getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            Block block2 = block;
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            double finalRadius = MiscUtils.INSTANCE.retrieveLoadedChunkRadius(location, radius);
            Collection collection = block2.getWorld().getNearbyEntities(block2.getLocation(), finalRadius, finalRadius, finalRadius);
            Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
            mobsToKill = collection;
        } else {
            Location location = ((Player)sender).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            double finalRadius = MiscUtils.INSTANCE.retrieveLoadedChunkRadius(location, radius);
            List list = ((Player)sender).getNearbyEntities(finalRadius, finalRadius, finalRadius);
            Intrinsics.checkNotNullExpressionValue(list, "getNearbyEntities(...)");
            mobsToKill = list;
        }
        for (Entity entity : mobsToKill) {
            if (!(entity instanceof LivingEntity) || !LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled((LivingEntity)entity)) continue;
            if (this.skipKillingEntity((LivingEntity)entity, opts.getRequestedLevel())) {
                ++skipped;
                continue;
            }
            ((LivingEntity)entity).setMetadata("noCommands", (MetadataValue)new FixedMetadataValue((Plugin)LevelledMobs.Companion.getInstance(), (Object)1));
            if (opts.getUseNoDrops()) {
                ((LivingEntity)entity).remove();
            } else {
                ((LivingEntity)entity).setHealth(0.0);
            }
            ++killed;
        }
        String[] stringArray = new String[]{"%killed%", "%skipped%", "%radius%"};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{String.valueOf(killed), String.valueOf(skipped), String.valueOf(radius)};
        this.showMessage("command.levelledmobs.kill.near.success", list, CollectionsKt.mutableListOf(stringArray));
    }

    /*
     * Unable to fully structure code
     */
    private final CompletableFuture<Suggestions> buildTabSuggestions(SuggestionsBuilder builder) {
        v0 = builder.getInput();
        Intrinsics.checkNotNullExpressionValue(v0, "getInput(...)");
        args = this.splitStringWithQuotes(v0, true);
        if (args.size() == 2) {
            v1 = builder.buildFuture();
            Intrinsics.checkNotNullExpressionValue(v1, "buildFuture(...)");
            return v1;
        }
        lastArg = args.get(args.size() - 1);
        prefix = new StringBuilder();
        existingItems = new ArrayList<E>();
        containsNoDrops = false;
        containsLevels = false;
        containsWorld = false;
        v2 = builder.getRemaining();
        Intrinsics.checkNotNullExpressionValue(v2, "getRemaining(...)");
        if (!(((CharSequence)v2).length() > 0)) ** GOTO lbl-1000
        v3 = builder.getRemaining();
        Intrinsics.checkNotNullExpressionValue(v3, "getRemaining(...)");
        if (!StringsKt.endsWith$default((CharSequence)v3, ' ', false, 2, null)) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = hasRemaining = false;
        }
        if (StringsKt.equals("/levels", lastArg, true)) {
            Utils.INSTANCE.getOneToNineSuggestions(builder);
            v5 = builder.buildFuture();
            Intrinsics.checkNotNullExpressionValue(v5, "buildFuture(...)");
            return v5;
        }
        var11_12 = args.size();
        for (i = 3; i < var11_12; ++i) {
            arg = args.get(i);
            v6 = arg.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(v6, "toLowerCase(...)");
            existingItems.add(v6);
            prefix.append(arg).append(' ');
            if (StringsKt.equals("/nodrops", arg, true)) {
                containsNoDrops = true;
                continue;
            }
            if (StringsKt.equals("/levels", arg, true)) {
                containsLevels = true;
                continue;
            }
            if (StringsKt.startsWith$default(arg, "/", false, 2, null) || hasRemaining || Utils.INSTANCE.isInteger(arg)) continue;
            containsWorld = true;
        }
        if (StringsKt.equals("all", args.get(2), true) && args.size() <= 7) {
            commandsList = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            var11_13 = new String[]{"/nodrops", "/levels"};
            commandsList.addAll((Collection)CollectionsKt.mutableListOf(var11_13));
            if (args.isEmpty()) {
                v7 = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(v7, "buildFuture(...)");
                return v7;
            }
            $this$forEach$iv = args;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                arg = (String)element$iv;
                $i$a$-forEach-KillSubcommand$buildTabSuggestions$1 = false;
                if (!commandsList.contains(arg)) continue;
                commandsList.remove(arg);
            }
            $this$forEach$iv = commandsList;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                command = (String)element$iv;
                $i$a$-forEach-KillSubcommand$buildTabSuggestions$2 = false;
                builder.suggest(prefix + command);
            }
            if (!containsWorld) {
                for (World world : Bukkit.getWorlds()) {
                    builder.suggest("*");
                    if (!LevelledMobs.Companion.getInstance().getRulesManager().getRuleIsWorldAllowedInAnyRule(world) || existingItems.contains(world.getName())) continue;
                    builder.suggest(prefix + world.getName());
                }
            }
            v8 = builder.buildFuture();
            Intrinsics.checkNotNullExpressionValue(v8, "buildFuture(...)");
            return v8;
        }
        if (StringsKt.equals("near", args.get(2), true)) {
            if (args.size() == 3) {
                Utils.INSTANCE.getOneToNineSuggestions(builder);
                v9 = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(v9, "buildFuture(...)");
                return v9;
            }
            if (StringsKt.equals("/levels", lastArg, true)) {
                builder.suggest("/levels");
                v10 = builder.buildFuture();
                Intrinsics.checkNotNullExpressionValue(v10, "buildFuture(...)");
                return v10;
            }
        }
        if (!containsNoDrops) {
            builder.suggest("/nodrops");
        }
        if (!containsLevels) {
            builder.suggest("/levels");
        }
        v11 = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(v11, "buildFuture(...)");
        return v11;
    }

    private final RequestedLevel getLevelFromCommand(CommandSender sender, List<String> args) {
        int rangeSpecifiedFlag = -1;
        int n = ((Collection)args).size();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals("/levels", args.get(i), true)) continue;
            rangeSpecifiedFlag = i + 1;
        }
        if (rangeSpecifiedFlag <= 0) {
            return null;
        }
        RequestedLevel rl = new RequestedLevel();
        if (args.size() <= rangeSpecifiedFlag) {
            sender.sendMessage("No value was specified for /levels");
            rl.setHadInvalidArguments(true);
            return rl;
        }
        String value = args.get(rangeSpecifiedFlag);
        if (!rl.setLevelFromString(value)) {
            sender.sendMessage("Invalid number or range specified for /levels");
            rl.setHadInvalidArguments(true);
        }
        return rl;
    }

    private final void processKillAll(List<World> worlds, boolean useNoDrops, RequestedLevel rl) {
        LevelledMobs.Companion.getInstance().getMobsQueueManager().clearQueue();
        int killed = 0;
        int skipped = 0;
        for (World world : worlds) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || !LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled((LivingEntity)entity)) continue;
                if (this.skipKillingEntity((LivingEntity)entity, rl)) {
                    ++skipped;
                    continue;
                }
                ((LivingEntity)entity).setMetadata("noCommands", (MetadataValue)new FixedMetadataValue((Plugin)LevelledMobs.Companion.getInstance(), (Object)1));
                if (useNoDrops) {
                    ((LivingEntity)entity).remove();
                } else {
                    ((LivingEntity)entity).setHealth(0.0);
                }
                ++killed;
            }
        }
        String[] stringArray = new String[]{"%killed%", "%skipped%", "%worlds%"};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{String.valueOf(killed), String.valueOf(skipped), String.valueOf(worlds.size())};
        this.showMessage("command.levelledmobs.kill.all.success", list, CollectionsKt.mutableListOf(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean skipKillingEntity(LivingEntity livingEntity, RequestedLevel rl) {
        int mobLevel;
        KillSkipConditions skc = MainCompanion.Companion.getInstance().getKillSkipConditions();
        if (livingEntity.getCustomName() != null && skc.isNametagged()) {
            return true;
        }
        if (rl != null && ((mobLevel = LevelledMobs.Companion.getInstance().getLevelInterface().getLevelOfMob(livingEntity)) < rl.getLevelMin() || mobLevel > rl.getLevelMax())) {
            return true;
        }
        if (livingEntity instanceof Tameable && skc.isTamed()) {
            return true;
        }
        if (livingEntity.isLeashed() && skc.isLeashed()) {
            return true;
        }
        if (livingEntity instanceof AbstractVillager && skc.isVillager()) {
            return true;
        }
        if (skc.getEntityTypes() != null) {
            CachedModalList<String> cachedModalList = skc.getEntityTypes();
            Intrinsics.checkNotNull(cachedModalList);
            if (!cachedModalList.isEmpty()) {
                CachedModalList<String> cachedModalList2 = skc.getEntityTypes();
                Intrinsics.checkNotNull(cachedModalList2);
                CachedModalList<String> et = cachedModalList2;
                if (et.getIncludeAll()) {
                    return false;
                }
                if (et.getExcludeAll()) {
                    return true;
                }
                LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
                try {
                    if (et.isIncludedInList(lmEntity.getNameIfBaby(), lmEntity) || et.getIncludedList().contains("baby_") && lmEntity.isBabyMob()) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    lmEntity.free();
                }
            }
        }
        return skc.isTransforming() && this.isMobConverting(livingEntity);
    }

    private final boolean isMobConverting(LivingEntity mob) {
        if (mob instanceof Hoglin && ((Hoglin)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Husk && ((Husk)mob).isConverting()) {
            return true;
        }
        if (mob instanceof PiglinAbstract && ((PiglinAbstract)mob).isConverting()) {
            return true;
        }
        if (mob instanceof PigZombie && ((PigZombie)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Skeleton && ((Skeleton)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Zombie && ((Zombie)mob).isConverting()) {
            return true;
        }
        return mob instanceof ZombieVillager && ((ZombieVillager)mob).isConverting();
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx, true);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$1(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.buildTabSuggestions(builder);
    }

    private static final int buildCommand$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx, true);
        return 1;
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx, true);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.buildTabSuggestions(builder);
    }

    private static final int buildCommand$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx, false);
        return 1;
    }

    private static final int buildCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processCmd((CommandContext<CommandSourceStack>)ctx, true);
        return 1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand$Options;", "", "args", "", "", "useNoDrops", "", "requestedLevel", "Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "<init>", "(Ljava/util/List;ZLio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;)V", "getArgs", "()Ljava/util/List;", "getUseNoDrops", "()Z", "getRequestedLevel", "()Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "levelledmobs-plugin"})
    private static final class Options {
        @NotNull
        private final List<String> args;
        private final boolean useNoDrops;
        @Nullable
        private final RequestedLevel requestedLevel;

        public Options(@NotNull List<String> args, boolean useNoDrops, @Nullable RequestedLevel requestedLevel) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.args = args;
            this.useNoDrops = useNoDrops;
            this.requestedLevel = requestedLevel;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        public final boolean getUseNoDrops() {
            return this.useNoDrops;
        }

        @Nullable
        public final RequestedLevel getRequestedLevel() {
            return this.requestedLevel;
        }
    }
}

