/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a8\u0006\u0010"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/MessagesHelper;", "", "<init>", "()V", "showMessage", "", "sender", "Lorg/bukkit/command/CommandSender;", "path", "", "replaceWhat", "replaceWith", "", "sendAllMessages", "messages", "getMessage", "levelledmobs-plugin"})
public final class MessagesHelper {
    @NotNull
    public static final MessagesHelper INSTANCE = new MessagesHelper();

    private MessagesHelper() {
    }

    public final void showMessage(@NotNull CommandSender sender, @NotNull String path) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(path, "path");
        List<String> list = LevelledMobs.Companion.getInstance().getMessagesCfg().getStringList(path);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List<String> messages = list;
        messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix());
        String label = sender instanceof ConsoleCommandSender ? "lm" : "/lm";
        messages = Utils.INSTANCE.replaceAllInList(messages, "%label%", label);
        messages = Utils.INSTANCE.colorizeAllInList(messages);
        this.sendAllMessages(sender, messages);
    }

    public final void showMessage(@NotNull CommandSender sender, @NotNull String path, @NotNull String replaceWhat, @NotNull String replaceWith) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceWith, "replaceWith");
        String[] stringArray = new String[]{replaceWhat};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{replaceWith};
        this.showMessage(sender, path, list, CollectionsKt.mutableListOf(stringArray));
    }

    public final void showMessage(@NotNull CommandSender sender, @NotNull String path, @NotNull List<String> replaceWhat, @NotNull List<String> replaceWith) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceWith, "replaceWith");
        List<String> messages = this.getMessage(path, replaceWhat, replaceWith);
        this.sendAllMessages(sender, messages);
    }

    private final void sendAllMessages(CommandSender sender, List<String> messages) {
        if (messages.size() == 1) {
            sender.sendMessage(CollectionsKt.first(messages));
        } else {
            StringBuilder sb = new StringBuilder();
            messages.forEach(arg_0 -> MessagesHelper.sendAllMessages$lambda$0(sb, arg_0));
            sender.sendMessage(sb.toString());
        }
    }

    @NotNull
    public final String getMessage(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter(path, "path");
        List<String> list = LevelledMobs.Companion.getInstance().getMessagesCfg().getStringList(path);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List<String> messages = list;
        messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix());
        messages = Utils.INSTANCE.replaceAllInList(messages, "%label%", "");
        messages = Utils.INSTANCE.colorizeAllInList(messages);
        if (messages.isEmpty()) {
            return "";
        }
        if (messages.size() == 1) {
            String string2 = CollectionsKt.first(messages);
            Intrinsics.checkNotNullExpressionValue(string2, "first(...)");
            string = string2;
        } else {
            string = CollectionsKt.joinToString$default(messages, "\n", null, null, 0, null, null, 62, null);
        }
        return string;
    }

    @NotNull
    public final List<String> getMessage(@NotNull String path, @NotNull String replaceWhat, @NotNull String replaceWith) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceWith, "replaceWith");
        String[] stringArray = new String[]{replaceWhat};
        List<String> list = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{replaceWith};
        return this.getMessage(path, list, CollectionsKt.mutableListOf(stringArray));
    }

    @NotNull
    public final List<String> getMessage(@NotNull String path, @NotNull List<String> replaceWhat, @NotNull List<String> replaceWith) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceWith, "replaceWith");
        if (replaceWhat.size() != replaceWith.size()) {
            throw new ArrayIndexOutOfBoundsException("replaceWhat must be the same size as replaceWith");
        }
        List<String> list = LevelledMobs.Companion.getInstance().getMessagesCfg().getStringList(path);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List<String> messages = list;
        messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix());
        messages = Utils.INSTANCE.replaceAllInList(messages, "%label%", "/lm");
        int n = ((Collection)replaceWhat).size();
        for (int i = 0; i < n; ++i) {
            messages = Utils.INSTANCE.replaceAllInList(messages, replaceWhat.get(i), replaceWith.get(i));
        }
        messages = Utils.INSTANCE.colorizeAllInList(messages);
        return messages;
    }

    private static final void sendAllMessages$lambda$0(StringBuilder $sb, String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        $sb.append(s).append('\n');
    }
}

