/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.nametag.Definitions;
import io.github.arcaneplugins.levelledmobs.result.MythicMobsMobInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/MythicMobUtils;", "", "<init>", "()V", "getMythicMobInfo", "Lio/github/arcaneplugins/levelledmobs/result/MythicMobsMobInfo;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "levelledmobs-plugin"})
public final class MythicMobUtils {
    @NotNull
    public static final MythicMobUtils INSTANCE = new MythicMobUtils();

    private MythicMobUtils() {
    }

    @Nullable
    public final MythicMobsMobInfo getMythicMobInfo(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Plugin mmMain = Bukkit.getPluginManager().getPlugin("MythicMobs");
        if (mmMain == null || !mmMain.isEnabled()) {
            return null;
        }
        Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();
        if (def.getFieldMMmobManager() == null) {
            Log.INSTANCE.war("Mythic Mobs is installed but fieldMMmobManager is null");
            return null;
        }
        try {
            Field field = def.getFieldMMmobManager();
            Intrinsics.checkNotNull(field);
            Object mobExecutorObj = field.get(mmMain);
            Method method = def.getMethodMMgetActiveMob();
            Intrinsics.checkNotNull(method);
            Object[] objectArray = new Object[]{lmEntity.getLivingEntity().getUniqueId()};
            Object object = method.invoke(mobExecutorObj, objectArray);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Optional<*>");
            Optional activeMobObj = (Optional)object;
            if (activeMobObj.isEmpty()) {
                return null;
            }
            Field field2 = def.getFieldMMtype();
            Intrinsics.checkNotNull(field2);
            Object mobTypeObj = field2.get(activeMobObj.get());
            MythicMobsMobInfo result = new MythicMobsMobInfo();
            Field field3 = def.getFieldMMpreventOtherDrops();
            Intrinsics.checkNotNull(field3);
            Object object2 = field3.get(mobTypeObj);
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Boolean");
            result.setPreventOtherDrops((Boolean)object2);
            Field field4 = def.getFieldMMpreventRandomEquipment();
            Intrinsics.checkNotNull(field4);
            Object object3 = field4.get(mobTypeObj);
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Boolean");
            result.setPreventRandomEquipment((Boolean)object3);
            Field field5 = def.getFieldMMinternalName();
            Intrinsics.checkNotNull(field5);
            Object object4 = field5.get(mobTypeObj);
            Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.String");
            result.setInternalName((String)object4);
            return result;
        }
        catch (InvocationTargetException e) {
            Log.INSTANCE.war("Error getting MythicMob info: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            Log.INSTANCE.war("Error getting MythicMob info: " + e.getMessage());
        }
        return null;
    }
}

