/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.nametag.Definitions;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.lang.reflect.Method;
import org.bukkit.entity.Entity;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/LibsDisguisesUtils;", "", "<init>", "()V", "hasLibsDisguises", "", "isMobUsingLibsDisguises", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "updateLibsDisguiseNametag", "", "nametag", "", "levelledmobs-plugin"})
public final class LibsDisguisesUtils {
    @NotNull
    public static final LibsDisguisesUtils INSTANCE = new LibsDisguisesUtils();
    private static boolean hasLibsDisguises = ExternalCompatibilityManager.Companion.getHasLibsDisguisesInstalled();

    private LibsDisguisesUtils() {
    }

    public final boolean isMobUsingLibsDisguises(@NotNull LivingEntityWrapper lmEntity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!hasLibsDisguises) {
            return false;
        }
        Class<?> clazzDisguise = Class.forName("me.libraryaddict.disguise.disguisetypes.Disguise");
        Class<?> clazzDisguiseAPI = Class.forName("me.libraryaddict.disguise.DisguiseAPI");
        Class[] classArray = new Class[]{Entity.class};
        Method methodGetDisguise = clazzDisguiseAPI.getMethod("getDisguise", classArray);
        Method methodIsDisguiseInUse = clazzDisguise.getMethod("isDisguiseInUse", new Class[0]);
        Object disguise = null;
        if (lmEntity.getLibsDisguiseCache() != null) {
            disguise = lmEntity.getLibsDisguiseCache();
        } else {
            Object[] objectArray = new Object[]{lmEntity.getLivingEntity()};
            disguise = methodGetDisguise.invoke(null, objectArray);
            lmEntity.setLibsDisguiseCache(disguise);
        }
        if (disguise != null) {
            Object object = methodIsDisguiseInUse.invoke(disguise, new Object[0]);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void updateLibsDisguiseNametag(@NotNull LivingEntityWrapper lmEntity, @Nullable String nametag) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!this.isMobUsingLibsDisguises(lmEntity)) {
            return;
        }
        Object disguise = lmEntity.getLibsDisguiseCache();
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LibsDisguisesUtils.updateLibsDisguiseNametag$lambda$0(disguise, nametag, lmEntity));
        lmEntity.getInUseCount().getAndIncrement();
        SchedulerWrapper.run$default(wrapper, false, 1, null);
    }

    private static final void updateLibsDisguiseNametag$lambda$0(Object $disguise, String $nametag, LivingEntityWrapper $lmEntity) {
        Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();
        Method method = def.getMethodLDGetWather();
        Intrinsics.checkNotNull(method);
        Object watcher = method.invoke($disguise, new Object[0]);
        Method method2 = def.getMethodLDSetCustomName();
        Intrinsics.checkNotNull(method2);
        Object[] objectArray = new Object[]{$nametag};
        method2.invoke(watcher, objectArray);
        $lmEntity.free();
    }
}

