/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000H\u0002J\u0016\u0010(\u001a\u00020&2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010)\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0012\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010,\u001a\u00020\u0000H\u0016J\n\u0010-\u001a\u00020\u0007H\u0096\u0080\u0004R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014\u00a8\u0006/"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "weightedRandomMap", "", "", "", "getWeightedRandomMap", "()Ljava/util/Map;", "randomArray", "", "minLevel", "maxLevel", "autoGenerate", "", "getAutoGenerate", "()Z", "setAutoGenerate", "(Z)V", "enabled", "getEnabled", "setEnabled", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "setStrategyType", "(Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;)V", "shouldMerge", "getShouldMerge", "setShouldMerge", "generateNumber", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "setValuesFromCache", "", "cachedWeightedRandom", "populateWeightedRandom", "getRandomLevel", "mergeRule", "levellingStrategy", "cloneItem", "toString", "Companion", "levelledmobs-plugin"})
public final class RandomLevellingStrategy
implements LevellingStrategy,
Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> weightedRandomMap = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private int[] randomArray = new int[0];
    private int minLevel;
    private int maxLevel;
    private boolean autoGenerate;
    private boolean enabled = true;
    @NotNull
    private StrategyType strategyType = StrategyType.RANDOM;
    private boolean shouldMerge;
    @NotNull
    private static final Map<String, RandomLevellingStrategy> cachedWeightedRandom = new LinkedHashMap();
    @NotNull
    private static final Object lockObj = new Object();

    @NotNull
    public final Map<String, Integer> getWeightedRandomMap() {
        return this.weightedRandomMap;
    }

    public final boolean getAutoGenerate() {
        return this.autoGenerate;
    }

    public final void setAutoGenerate(boolean bl) {
        this.autoGenerate = bl;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(@NotNull StrategyType strategyType) {
        Intrinsics.checkNotNullParameter((Object)strategyType, "<set-?>");
        this.strategyType = strategyType;
    }

    @Override
    public boolean getShouldMerge() {
        return this.shouldMerge;
    }

    @Override
    public void setShouldMerge(boolean bl) {
        this.shouldMerge = bl;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (this.weightedRandomMap.isEmpty()) {
            return this.getRandomLevel(minLevel, maxLevel);
        }
        if (this.randomArray.length == 0 || minLevel != this.minLevel || maxLevel != this.maxLevel) {
            String checkStr = minLevel + "-" + maxLevel + " " + this;
            RandomLevellingStrategy cachedWR = RandomLevellingStrategy.Companion.getCachedWR(checkStr);
            if (cachedWR != null) {
                this.setValuesFromCache(cachedWR);
            } else {
                this.populateWeightedRandom(minLevel, maxLevel);
                RandomLevellingStrategy.Companion.putCachedWR(checkStr, this);
            }
        }
        if (this.randomArray.length == 0) {
            return this.getRandomLevel(minLevel, maxLevel);
        }
        int useArrayNum = ThreadLocalRandom.current().nextInt(0, this.randomArray.length);
        return this.randomArray[useArrayNum];
    }

    private final void setValuesFromCache(RandomLevellingStrategy cachedWeightedRandom) {
        this.randomArray = cachedWeightedRandom.randomArray;
        this.minLevel = cachedWeightedRandom.minLevel;
        this.maxLevel = cachedWeightedRandom.maxLevel;
        this.setStrategyType(StrategyType.WEIGHTED_RANDOM);
    }

    public final void populateWeightedRandom(int minLevel, int maxLevel) {
        if (this.weightedRandomMap.isEmpty()) {
            this.autoGenerate = true;
            int i = minLevel;
            if (i <= maxLevel) {
                while (true) {
                    int value = maxLevel - i + 1;
                    this.weightedRandomMap.put(String.valueOf(i), value);
                    if (i != maxLevel) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.setStrategyType(StrategyType.WEIGHTED_RANDOM);
        }
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        int count = 0;
        List numbers = new ArrayList();
        List values = new ArrayList();
        for (Map.Entry<String, Integer> object2 : this.weightedRandomMap.entrySet()) {
            String range = object2.getKey();
            int value = ((Number)object2.getValue()).intValue();
            if (((CharSequence)range).length() == 0) continue;
            MinAndMax numRange = MinAndMax.Companion.setAmountRangeFromString(range);
            if (numRange == null) {
                Log.INSTANCE.war("Invalid number range for weighted random: " + range);
                continue;
            }
            float start = numRange.getMin() < 0.0f ? numRange.getMax() : numRange.getMin();
            float end = numRange.getMax() < 0.0f ? numRange.getMin() : numRange.getMax();
            numbers.add(new MinAndMax(start, end));
            values.add(value);
            count += ((int)end - (int)start + 1) * value;
        }
        this.randomArray = new int[count];
        int newCount = 0;
        Iterator iterator2 = ((Iterable)numbers).iterator();
        int n = 0;
        block2: while (iterator2.hasNext()) {
            int n2;
            int valuesCount = n++;
            MinAndMax nums = (MinAndMax)iterator2.next();
            int i = nums.getMinAsInt();
            if (i > (n2 = nums.getMaxAsInt())) continue;
            while (true) {
                int n3 = ((Number)values.get(valuesCount)).intValue();
                int n4 = 0;
                while (n4 < n3) {
                    int it = n4++;
                    boolean bl = false;
                    this.randomArray[newCount] = i;
                    ++newCount;
                }
                if (i == n2) continue block2;
                ++i;
            }
        }
    }

    private final int getRandomLevel(int minLevel, int maxLevel) {
        int useMinLevel = RangesKt.coerceAtLeast(minLevel, 0);
        int useMaxLevel = RangesKt.coerceAtLeast(maxLevel, useMinLevel);
        return ThreadLocalRandom.current().nextInt(useMinLevel, useMaxLevel + 1);
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (!(levellingStrategy instanceof RandomLevellingStrategy)) {
            return;
        }
        if (((RandomLevellingStrategy)levellingStrategy).getShouldMerge() && ((RandomLevellingStrategy)levellingStrategy).enabled) {
            this.weightedRandomMap.putAll(((RandomLevellingStrategy)levellingStrategy).weightedRandomMap);
        }
        this.setStrategyType(this.weightedRandomMap.isEmpty() ? StrategyType.RANDOM : StrategyType.WEIGHTED_RANDOM);
    }

    @Override
    @NotNull
    public RandomLevellingStrategy cloneItem() {
        RandomLevellingStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.RandomLevellingStrategy");
            copy = (RandomLevellingStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RandomLevellingStrategy randomLevellingStrategy = copy;
        Intrinsics.checkNotNull(randomLevellingStrategy);
        return randomLevellingStrategy;
    }

    @NotNull
    public String toString() {
        if (this.weightedRandomMap.isEmpty()) {
            return this.autoGenerate ? "Random Levelling (auto generate)" : "Random Levelling";
        }
        String mergeMessage = this.getShouldMerge() ? " (merge)" : "";
        return this.minLevel == 0 ? this.weightedRandomMap + mergeMessage : this.minLevel + "-" + this.maxLevel + ": " + this.weightedRandomMap + mergeMessage;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0006\u0010\u000f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy$Companion;", "", "<init>", "()V", "cachedWeightedRandom", "", "", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy;", "lockObj", "Ljava/lang/Object;", "getCachedWR", "checkStr", "putCachedWR", "", "weightedRandom", "clearCache", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final RandomLevellingStrategy getCachedWR(String checkStr) {
            Object object = lockObj;
            synchronized (object) {
                boolean bl = false;
                RandomLevellingStrategy randomLevellingStrategy = (RandomLevellingStrategy)cachedWeightedRandom.get(checkStr);
                return randomLevellingStrategy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void putCachedWR(String checkStr, RandomLevellingStrategy weightedRandom) {
            Object object = lockObj;
            synchronized (object) {
                boolean bl = false;
                cachedWeightedRandom.put(checkStr, weightedRandom);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearCache() {
            Object object = lockObj;
            synchronized (object) {
                boolean bl = false;
                cachedWeightedRandom.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

