/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.generator.structure.Structure;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B%\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0003\u0010\bJ\u001d\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010&J\"\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\n\u0010*\u001a\u00060+j\u0002`,H\u0002J\u0006\u0010-\u001a\u00020\u0017J\n\u0010.\u001a\u00020\u000eH\u0096\u0080\u0004J\b\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u00020(2\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u0000R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u0011\u0010/\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0019R\u0011\u00100\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0019\u00a8\u00065"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "T", "", "<init>", "()V", "includedList", "", "excludedList", "(Ljava/util/Set;Ljava/util/Set;)V", "getIncludedList", "()Ljava/util/Set;", "setIncludedList", "(Ljava/util/Set;)V", "includedGroups", "", "getIncludedGroups", "setIncludedGroups", "getExcludedList", "setExcludedList", "excludedGroups", "getExcludedGroups", "setExcludedGroups", "doMerge", "", "getDoMerge", "()Z", "setDoMerge", "(Z)V", "includeAll", "getIncludeAll", "setIncludeAll", "excludeAll", "getExcludeAll", "setExcludeAll", "isIncludedInList", "item", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "(Ljava/lang/Object;Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;)Z", "applySpecialFormatting", "", "input", "sb", "Ljava/lang/StringBuilder;", "Lio/github/arcaneplugins/levelledmobs/libs/kotlin/text/StringBuilder;", "isEmpty", "toString", "isWhitelist", "isBlacklist", "clone", "", "mergeCachedModal", "cachedModalList", "levelledmobs-plugin"})
public final class CachedModalList<T>
implements Cloneable {
    @NotNull
    private Set<T> includedList;
    @NotNull
    private Set<String> includedGroups;
    @NotNull
    private Set<T> excludedList;
    @NotNull
    private Set<String> excludedGroups;
    private boolean doMerge;
    private boolean includeAll;
    private boolean excludeAll;

    @NotNull
    public final Set<T> getIncludedList() {
        return this.includedList;
    }

    public final void setIncludedList(@NotNull Set<T> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.includedList = set;
    }

    @NotNull
    public final Set<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public final void setIncludedGroups(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.includedGroups = set;
    }

    @NotNull
    public final Set<T> getExcludedList() {
        return this.excludedList;
    }

    public final void setExcludedList(@NotNull Set<T> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.excludedList = set;
    }

    @NotNull
    public final Set<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public final void setExcludedGroups(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.excludedGroups = set;
    }

    public final boolean getDoMerge() {
        return this.doMerge;
    }

    public final void setDoMerge(boolean bl) {
        this.doMerge = bl;
    }

    public final boolean getIncludeAll() {
        return this.includeAll;
    }

    public final void setIncludeAll(boolean bl) {
        this.includeAll = bl;
    }

    public final boolean getExcludeAll() {
        return this.excludeAll;
    }

    public final void setExcludeAll(boolean bl) {
        this.excludeAll = bl;
    }

    public CachedModalList() {
        this.includedList = new LinkedHashSet();
        this.includedGroups = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        this.excludedList = new LinkedHashSet();
        this.excludedGroups = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    }

    public CachedModalList(@NotNull Set<T> includedList, @NotNull Set<T> excludedList) {
        Intrinsics.checkNotNullParameter(includedList, "includedList");
        Intrinsics.checkNotNullParameter(excludedList, "excludedList");
        this.includedList = new LinkedHashSet();
        this.includedGroups = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        this.excludedList = new LinkedHashSet();
        this.excludedGroups = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        this.includedList = includedList;
        this.excludedList = excludedList;
    }

    public final boolean isIncludedInList(T item, @Nullable LivingEntityWrapper lmEntity) {
        if (this.includeAll) {
            return true;
        }
        if (this.excludeAll) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (lmEntity != null) {
            for (String group : lmEntity.getApplicableGroups()) {
                if (!this.excludedGroups.contains(group)) continue;
                return false;
            }
            if (this.excludedList.contains(item)) {
                return false;
            }
            for (String group : lmEntity.getApplicableGroups()) {
                if (!this.includedGroups.contains(group)) continue;
                return true;
            }
        }
        if (this.excludedList.contains(item)) {
            return false;
        }
        return this.isBlacklist() || this.includedList.contains(item);
    }

    private final void applySpecialFormatting(Set<T> input, StringBuilder sb) {
        boolean isFirst = true;
        for (T item : input) {
            if (!isFirst) {
                sb.append(", ");
            }
            StringBuilder stringBuilder = item instanceof Structure ? sb.append(((Structure)item).key().value()) : sb.append(item);
            isFirst = false;
        }
    }

    public final boolean isEmpty() {
        return this.includedList.isEmpty() && this.includedGroups.isEmpty() && this.excludedList.isEmpty() && this.excludedGroups.isEmpty();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!((Collection)this.includedList).isEmpty()) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("lst: ");
            this.applySpecialFormatting(this.includedList, sb);
        }
        if (this.includeAll) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("all included");
        }
        if (!((Collection)this.includedGroups).isEmpty()) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("grps: ");
            sb.append(this.includedGroups);
        }
        if (this.excludeAll) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("all excluded");
        }
        if (!((Collection)this.excludedList).isEmpty()) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("ex-lst: ");
            this.applySpecialFormatting(this.excludedList, sb);
        }
        if (!((Collection)this.excludedGroups).isEmpty()) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("ex-grps: ");
            sb.append(this.excludedGroups);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final boolean isWhitelist() {
        return (!((Collection)this.includedList).isEmpty() || !((Collection)this.includedGroups).isEmpty()) && this.excludedList.isEmpty() && this.excludedGroups.isEmpty();
    }

    public final boolean isBlacklist() {
        return this.includedList.isEmpty() && this.includedGroups.isEmpty() && (!((Collection)this.excludedList).isEmpty() || !((Collection)this.excludedGroups).isEmpty());
    }

    @NotNull
    public Object clone() {
        CachedModalList copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.misc.CachedModalList<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
            copy = (CachedModalList)object;
            Set<T> set = this.includedList;
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type java.util.TreeSet<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
            Object object2 = ((TreeSet)set).clone();
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type java.util.TreeSet<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
            copy.includedList = (TreeSet)object2;
            Set<String> set2 = this.includedGroups;
            Intrinsics.checkNotNull(set2, "null cannot be cast to non-null type java.util.TreeSet<kotlin.String>");
            Object object3 = ((TreeSet)set2).clone();
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type java.util.TreeSet<kotlin.String>");
            copy.includedGroups = (TreeSet)object3;
            Set<T> set3 = this.excludedList;
            Intrinsics.checkNotNull(set3, "null cannot be cast to non-null type java.util.TreeSet<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
            Object object4 = ((TreeSet)set3).clone();
            Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type java.util.TreeSet<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
            copy.excludedList = (TreeSet)object4;
            Set<String> set4 = this.excludedGroups;
            Intrinsics.checkNotNull(set4, "null cannot be cast to non-null type java.util.TreeSet<kotlin.String>");
            Object object5 = ((TreeSet)set4).clone();
            Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type java.util.TreeSet<kotlin.String>");
            copy.excludedGroups = (TreeSet)object5;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        CachedModalList cachedModalList = copy;
        Intrinsics.checkNotNull(cachedModalList, "null cannot be cast to non-null type kotlin.Any");
        return cachedModalList;
    }

    public final void mergeCachedModal(@NotNull CachedModalList<?> cachedModalList) {
        Intrinsics.checkNotNullParameter(cachedModalList, "cachedModalList");
        Set<T> set = cachedModalList.includedList;
        Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.Collection<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
        this.includedList.addAll((Collection)set);
        Set<T> set2 = cachedModalList.excludedList;
        Intrinsics.checkNotNull(set2, "null cannot be cast to non-null type kotlin.collections.Collection<T of io.github.arcaneplugins.levelledmobs.misc.CachedModalList>");
        this.excludedList.addAll((Collection)set2);
        this.includedGroups.addAll((Collection<String>)cachedModalList.includedGroups);
        this.excludedGroups.addAll((Collection<String>)cachedModalList.excludedGroups);
        if (cachedModalList.includeAll) {
            this.includeAll = true;
        }
        if (cachedModalList.excludeAll) {
            this.excludeAll = true;
        }
    }
}

