/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/WorldGuardIntegration;", "", "<init>", "()V", "getWorldGuardRegionsForLocation", "", "", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "getWorldGuardRegionOwnersForLocation", "", "getRegionSet", "Lcom/sk89q/worldguard/protection/regions/ProtectedRegion;", "levelledmobs-plugin"})
public final class WorldGuardIntegration {
    @NotNull
    public static final WorldGuardIntegration INSTANCE = new WorldGuardIntegration();

    private WorldGuardIntegration() {
    }

    @NotNull
    public final Set<String> getWorldGuardRegionsForLocation(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        Set wgRegions = new LinkedHashSet();
        if (lmInterface.getWorld() == null) {
            return wgRegions;
        }
        Set<ProtectedRegion> set = this.getRegionSet(lmInterface);
        if (set == null) {
            return wgRegions;
        }
        Set<ProtectedRegion> regions = set;
        for (ProtectedRegion region : regions) {
            String string = region.getId();
            Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
            wgRegions.add(string);
        }
        return wgRegions;
    }

    @NotNull
    public final List<String> getWorldGuardRegionOwnersForLocation(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        List wgOwners = new ArrayList();
        if (lmInterface.getWorld() == null) {
            return wgOwners;
        }
        Set<ProtectedRegion> set = this.getRegionSet(lmInterface);
        if (set == null) {
            return wgOwners;
        }
        Set<ProtectedRegion> regions = set;
        for (ProtectedRegion region : regions) {
            if (region.getOwners().getPlayers() == null) continue;
            for (UUID id : region.getOwners().getUniqueIds()) {
                Object playerName;
                Player player = Bukkit.getPlayer((UUID)id);
                Object object = player;
                if (object == null || (object = object.getName()) == null) {
                    object = "unknown";
                }
                if (wgOwners.contains(playerName = object)) continue;
                wgOwners.add(playerName);
            }
        }
        return wgOwners;
    }

    private final Set<ProtectedRegion> getRegionSet(LivingEntityInterface lmInterface) {
        World world = BukkitAdapter.adapt((org.bukkit.World)lmInterface.getWorld());
        Location location = lmInterface.getLocation();
        Intrinsics.checkNotNull(location);
        int n = location.getBlockX();
        Location location2 = lmInterface.getLocation();
        Intrinsics.checkNotNull(location2);
        int n2 = location2.getBlockY();
        Location location3 = lmInterface.getLocation();
        Intrinsics.checkNotNull(location3);
        BlockVector3 position = BlockVector3.at((int)n, (int)n2, (int)location3.getBlockZ());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(world);
        if (regionManager == null) {
            return null;
        }
        RegionManager regions = regionManager;
        return regions.getApplicableRegions(position).getRegions();
    }
}

